/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.lexers;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Segment;
import jsyntaxpane.Lexer;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;

public abstract class DefaultJFlexLexer
implements Lexer {
    protected int tokenStart;
    protected int tokenLength;
    protected int offset;

    protected Token token(TokenType type, int tStart, int tLength, int newStart, int newLength) {
        this.tokenStart = newStart;
        this.tokenLength = newLength;
        return new Token(type, tStart + this.offset, tLength);
    }

    protected Token token(TokenType type, int start, int length) {
        return new Token(type, start + this.offset, length);
    }

    protected Token token(TokenType type) {
        return new Token(type, this.yychar() + this.offset, this.yylength());
    }

    protected Token token(TokenType type, int pairValue) {
        return new Token(type, this.yychar() + this.offset, this.yylength(), (byte)pairValue);
    }

    @Override
    public void parse(Segment segment, int ofst, List<Token> tokens) {
        try {
            CharArrayReader reader = new CharArrayReader(segment.array, segment.offset, segment.count);
            this.yyreset(reader);
            this.offset = ofst;
            Token t = this.yylex();
            while (t != null) {
                tokens.add(t);
                t = this.yylex();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DefaultJFlexLexer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public abstract void yyreset(Reader var1);

    public abstract Token yylex() throws IOException;

    public abstract char yycharat(int var1);

    public abstract int yylength();

    public abstract String yytext();

    public abstract int yychar();
}

