/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import org.python.core.CachedJarsPackageManager;
import org.python.core.Py;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyString;
import org.python.core.imp;

public abstract class PathPackageManager
extends CachedJarsPackageManager {
    public PyList searchPath = new PyList();

    protected boolean packageExists(PyList path, String pkg, String name) {
        String child = pkg.replace('.', File.separatorChar) + File.separator + name;
        for (int i = 0; i < path.__len__(); ++i) {
            String dir = imp.defaultEmptyPathDirectory(path.pyget(i).__str__().toString());
            File f = new File(dir, child);
            if (!f.isDirectory() || !imp.caseok(f, name, name.length())) continue;
            PackageExistsFileFilter m = new PackageExistsFileFilter();
            f.listFiles(m);
            boolean exists = m.packageExists();
            if (exists) {
                Py.writeComment("import", "java package as '" + f.getAbsolutePath() + "'");
            }
            return exists;
        }
        return false;
    }

    protected void doDir(PyList path, PyList ret, PyJavaPackage jpkg, boolean instantiate, boolean exclpkgs) {
        String child = jpkg.__name__.replace('.', File.separatorChar);
        for (int i = 0; i < path.__len__(); ++i) {
            File childFile;
            String[] list;
            String dir = path.pyget(i).__str__().toString();
            if (dir.length() == 0) {
                dir = null;
            }
            if ((list = (childFile = new File(dir, child)).list()) == null) continue;
            block3: for (int j = 0; j < list.length; ++j) {
                String jname = list[j];
                File cand = new File(childFile, jname);
                int jlen = jname.length();
                boolean pkgCand = false;
                if (cand.isDirectory()) {
                    if (!instantiate && exclpkgs) continue;
                    pkgCand = true;
                } else {
                    if (!jname.endsWith(".class")) continue;
                    jlen -= 6;
                }
                jname = jname.substring(0, jlen);
                PyString name = new PyString(jname);
                if (this.filterByName(jname, pkgCand) || jpkg.__dict__.has_key(name) || jpkg.clsSet.has_key(name) || ret.__contains__(name) || !Character.isJavaIdentifierStart(jname.charAt(0))) continue;
                for (int k = 1; k < jlen; ++k) {
                    if (!Character.isJavaIdentifierPart(jname.charAt(k))) continue block3;
                }
                if (!pkgCand) {
                    try {
                        int acc = PathPackageManager.checkAccess(new BufferedInputStream(new FileInputStream(cand)));
                        if (acc == -1) continue;
                        if (this.filterByAccess(jname, acc)) {
                        }
                    }
                    catch (IOException e) {}
                    continue;
                }
                if (instantiate) {
                    if (pkgCand) {
                        jpkg.addPackage(jname);
                    } else {
                        jpkg.addLazyClass(jname);
                    }
                }
                ret.append(name);
            }
        }
    }

    public void addDirectory(File dir) {
        try {
            if (dir.getPath().length() == 0) {
                this.searchPath.append(Py.EmptyString);
            } else {
                this.searchPath.append(new PyString(dir.getCanonicalPath()));
            }
        }
        catch (IOException e) {
            this.warning("skipping bad directory, '" + dir + "'");
        }
    }

    public void addClassPath(String path) {
        PyList paths = new PyString(path).split(File.pathSeparator);
        for (int i = 0; i < paths.__len__(); ++i) {
            String entry = paths.pyget(i).toString();
            if (entry.endsWith(".jar") || entry.endsWith(".zip")) {
                this.addJarToPackages(new File(entry), true);
                continue;
            }
            File dir = new File(entry);
            if (entry.length() != 0 && !dir.isDirectory()) continue;
            this.addDirectory(dir);
        }
    }

    public PyList doDir(PyJavaPackage jpkg, boolean instantiate, boolean exclpkgs) {
        PyList basic = this.basicDoDir(jpkg, instantiate, exclpkgs);
        PyList ret = new PyList();
        this.doDir(this.searchPath, ret, jpkg, instantiate, exclpkgs);
        return this.merge(basic, ret);
    }

    public boolean packageExists(String pkg, String name) {
        return this.packageExists(this.searchPath, pkg, name);
    }

    class PackageExistsFileFilter
    implements FilenameFilter {
        private boolean java;
        private boolean python;

        PackageExistsFileFilter() {
        }

        public boolean accept(File dir, String name) {
            if (name.endsWith(".py") || name.endsWith("$py.class") || name.endsWith("$_PyInner.class")) {
                this.python = true;
            } else if (name.endsWith(".class")) {
                this.java = true;
            }
            return false;
        }

        public boolean packageExists() {
            return !this.python || this.java;
        }
    }
}

