/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.python.core.ArgParser;
import org.python.core.MergeState;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyListDerived;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PySequenceList;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;

public class PyList
extends PySequenceList {
    public static final String exposed_name = "list";
    public static final Class exposed_base = PyObject.class;
    private static final PyType LISTTYPE = PyType.fromClass(PyList.class);

    public static void classDictInit(PyObject dict) throws PyIgnoreMethodTag {
    }

    public static void typeSetup(PyObject dict, PyType.Newstyle marker) {
        class Exposed___ne__
        extends PyBuiltinMethodNarrow {
            Exposed___ne__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___ne__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyList)this.self).seq___ne__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__ne__", (PyObject)new PyMethodDescr("__ne__", PyList.class, 1, 1, new Exposed___ne__(null, null)));
        class Exposed___eq__
        extends PyBuiltinMethodNarrow {
            Exposed___eq__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___eq__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyList)this.self).seq___eq__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__eq__", (PyObject)new PyMethodDescr("__eq__", PyList.class, 1, 1, new Exposed___eq__(null, null)));
        class Exposed___lt__
        extends PyBuiltinMethodNarrow {
            Exposed___lt__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___lt__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyList)this.self).seq___lt__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__lt__", (PyObject)new PyMethodDescr("__lt__", PyList.class, 1, 1, new Exposed___lt__(null, null)));
        class Exposed___le__
        extends PyBuiltinMethodNarrow {
            Exposed___le__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___le__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyList)this.self).seq___le__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__le__", (PyObject)new PyMethodDescr("__le__", PyList.class, 1, 1, new Exposed___le__(null, null)));
        class Exposed___gt__
        extends PyBuiltinMethodNarrow {
            Exposed___gt__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___gt__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyList)this.self).seq___gt__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__gt__", (PyObject)new PyMethodDescr("__gt__", PyList.class, 1, 1, new Exposed___gt__(null, null)));
        class Exposed___ge__
        extends PyBuiltinMethodNarrow {
            Exposed___ge__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___ge__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyList)this.self).seq___ge__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__ge__", (PyObject)new PyMethodDescr("__ge__", PyList.class, 1, 1, new Exposed___ge__(null, null)));
        class Exposed___getitem__
        extends PyBuiltinMethodNarrow {
            Exposed___getitem__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___getitem__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyList)this.self).seq___finditem__(arg0);
                if (ret == null) {
                    throw Py.IndexError("index out of range: " + arg0);
                }
                return ret;
            }
        }
        dict.__setitem__("__getitem__", (PyObject)new PyMethodDescr("__getitem__", PyList.class, 1, 1, new Exposed___getitem__(null, null)));
        class Exposed___contains__
        extends PyBuiltinMethodNarrow {
            Exposed___contains__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___contains__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                return Py.newBoolean(((PyList)this.self).object___contains__(arg0));
            }
        }
        dict.__setitem__("__contains__", (PyObject)new PyMethodDescr("__contains__", PyList.class, 1, 1, new Exposed___contains__(null, null)));
        class Exposed___delitem__
        extends PyBuiltinMethodNarrow {
            Exposed___delitem__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___delitem__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyList)this.self).seq___delitem__(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("__delitem__", (PyObject)new PyMethodDescr("__delitem__", PyList.class, 1, 1, new Exposed___delitem__(null, null)));
        class Exposed___setitem__
        extends PyBuiltinMethodNarrow {
            Exposed___setitem__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___setitem__(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                ((PyList)this.self).seq___setitem__(arg0, arg1);
                return Py.None;
            }
        }
        dict.__setitem__("__setitem__", (PyObject)new PyMethodDescr("__setitem__", PyList.class, 2, 2, new Exposed___setitem__(null, null)));
        class Exposed___nonzero__
        extends PyBuiltinMethodNarrow {
            Exposed___nonzero__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___nonzero__(self, this.info);
            }

            public PyObject __call__() {
                return Py.newBoolean(((PyList)this.self).seq___nonzero__());
            }
        }
        dict.__setitem__("__nonzero__", (PyObject)new PyMethodDescr("__nonzero__", PyList.class, 0, 0, new Exposed___nonzero__(null, null)));
        class Exposed___getslice__
        extends PyBuiltinMethodNarrow {
            Exposed___getslice__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___getslice__(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2) {
                return ((PyList)this.self).seq___getslice__(arg0, arg1, arg2);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                return ((PyList)this.self).seq___getslice__(arg0, arg1);
            }
        }
        dict.__setitem__("__getslice__", (PyObject)new PyMethodDescr("__getslice__", PyList.class, 2, 3, new Exposed___getslice__(null, null)));
        class Exposed___delslice__
        extends PyBuiltinMethodNarrow {
            Exposed___delslice__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___delslice__(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2) {
                ((PyList)this.self).seq___delslice__(arg0, arg1, arg2);
                return Py.None;
            }
        }
        dict.__setitem__("__delslice__", (PyObject)new PyMethodDescr("__delslice__", PyList.class, 3, 3, new Exposed___delslice__(null, null)));
        class Exposed___setslice__
        extends PyBuiltinMethodNarrow {
            Exposed___setslice__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___setslice__(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3) {
                ((PyList)this.self).seq___setslice__(arg0, arg1, arg2, arg3);
                return Py.None;
            }

            public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2) {
                ((PyList)this.self).seq___setslice__(arg0, arg1, arg2);
                return Py.None;
            }
        }
        dict.__setitem__("__setslice__", (PyObject)new PyMethodDescr("__setslice__", PyList.class, 3, 4, new Exposed___setslice__(null, null)));
        class Exposed___add__
        extends PyBuiltinMethodNarrow {
            Exposed___add__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___add__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyList)this.self).list___add__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__add__", (PyObject)new PyMethodDescr("__add__", PyList.class, 1, 1, new Exposed___add__(null, null)));
        class Exposed___radd__
        extends PyBuiltinMethodNarrow {
            Exposed___radd__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___radd__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyList)this.self).list___radd__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__radd__", (PyObject)new PyMethodDescr("__radd__", PyList.class, 1, 1, new Exposed___radd__(null, null)));
        class Exposed___mul__
        extends PyBuiltinMethodNarrow {
            Exposed___mul__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___mul__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyList)this.self).list___mul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__mul__", (PyObject)new PyMethodDescr("__mul__", PyList.class, 1, 1, new Exposed___mul__(null, null)));
        class Exposed___rmul__
        extends PyBuiltinMethodNarrow {
            Exposed___rmul__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rmul__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyList)this.self).list___rmul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rmul__", (PyObject)new PyMethodDescr("__rmul__", PyList.class, 1, 1, new Exposed___rmul__(null, null)));
        class Exposed_append
        extends PyBuiltinMethodNarrow {
            Exposed_append(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_append(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyList)this.self).list_append(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("append", (PyObject)new PyMethodDescr("append", PyList.class, 1, 1, new Exposed_append(null, null)));
        class Exposed_count
        extends PyBuiltinMethodNarrow {
            Exposed_count(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_count(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                return Py.newInteger(((PyList)this.self).list_count(arg0));
            }
        }
        dict.__setitem__("count", (PyObject)new PyMethodDescr("count", PyList.class, 1, 1, new Exposed_count(null, null)));
        class Exposed_extend
        extends PyBuiltinMethodNarrow {
            Exposed_extend(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_extend(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyList)this.self).list_extend(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("extend", (PyObject)new PyMethodDescr("extend", PyList.class, 1, 1, new Exposed_extend(null, null)));
        class Exposed_index
        extends PyBuiltinMethodNarrow {
            Exposed_index(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_index(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2) {
                try {
                    return Py.newInteger(((PyList)this.self).list_index(arg0, arg1.asInt(1), arg2.asInt(2)));
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 1: 
                        case 2: {
                            msg = "expected an integer";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                try {
                    return Py.newInteger(((PyList)this.self).list_index(arg0, arg1.asInt(1)));
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 1: {
                            msg = "expected an integer";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }

            public PyObject __call__(PyObject arg0) {
                return Py.newInteger(((PyList)this.self).list_index(arg0));
            }
        }
        dict.__setitem__("index", (PyObject)new PyMethodDescr("index", PyList.class, 1, 3, new Exposed_index(null, null)));
        class Exposed_insert
        extends PyBuiltinMethodNarrow {
            Exposed_insert(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_insert(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                try {
                    ((PyList)this.self).list_insert(arg0.asInt(0), arg1);
                    return Py.None;
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 0: {
                            msg = "expected an integer";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }
        }
        dict.__setitem__("insert", (PyObject)new PyMethodDescr("insert", PyList.class, 2, 2, new Exposed_insert(null, null)));
        class Exposed_pop
        extends PyBuiltinMethodNarrow {
            Exposed_pop(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_pop(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                try {
                    return ((PyList)this.self).list_pop(arg0.asInt(0));
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 0: {
                            msg = "expected an integer";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }

            public PyObject __call__() {
                return ((PyList)this.self).list_pop();
            }
        }
        dict.__setitem__("pop", (PyObject)new PyMethodDescr("pop", PyList.class, 0, 1, new Exposed_pop(null, null)));
        class Exposed_remove
        extends PyBuiltinMethodNarrow {
            Exposed_remove(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_remove(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyList)this.self).list_remove(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("remove", (PyObject)new PyMethodDescr("remove", PyList.class, 1, 1, new Exposed_remove(null, null)));
        class Exposed_reverse
        extends PyBuiltinMethodNarrow {
            Exposed_reverse(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_reverse(self, this.info);
            }

            public PyObject __call__() {
                ((PyList)this.self).list_reverse();
                return Py.None;
            }
        }
        dict.__setitem__("reverse", (PyObject)new PyMethodDescr("reverse", PyList.class, 0, 0, new Exposed_reverse(null, null)));
        class Exposed_sort
        extends PyBuiltinMethodNarrow {
            Exposed_sort(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_sort(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyList)this.self).list_sort(arg0);
                return Py.None;
            }

            public PyObject __call__() {
                ((PyList)this.self).list_sort();
                return Py.None;
            }
        }
        dict.__setitem__("sort", (PyObject)new PyMethodDescr("sort", PyList.class, 0, 1, new Exposed_sort(null, null)));
        class Exposed___len__
        extends PyBuiltinMethodNarrow {
            Exposed___len__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___len__(self, this.info);
            }

            public PyObject __call__() {
                return Py.newInteger(((PyList)this.self).list___len__());
            }
        }
        dict.__setitem__("__len__", (PyObject)new PyMethodDescr("__len__", PyList.class, 0, 0, new Exposed___len__(null, null)));
        class Exposed___iadd__
        extends PyBuiltinMethodNarrow {
            Exposed___iadd__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___iadd__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                return ((PyList)this.self).list___iadd__(arg0);
            }
        }
        dict.__setitem__("__iadd__", (PyObject)new PyMethodDescr("__iadd__", PyList.class, 1, 1, new Exposed___iadd__(null, null)));
        class Exposed___imul__
        extends PyBuiltinMethodNarrow {
            Exposed___imul__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___imul__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                return ((PyList)this.self).list___imul__(arg0);
            }
        }
        dict.__setitem__("__imul__", (PyObject)new PyMethodDescr("__imul__", PyList.class, 1, 1, new Exposed___imul__(null, null)));
        class Exposed___reduce__
        extends PyBuiltinMethodNarrow {
            Exposed___reduce__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___reduce__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyList)this.self).list___reduce__();
            }
        }
        dict.__setitem__("__reduce__", (PyObject)new PyMethodDescr("__reduce__", PyList.class, 0, 0, new Exposed___reduce__(null, null)));
        class Exposed___hash__
        extends PyBuiltinMethodNarrow {
            Exposed___hash__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___hash__(self, this.info);
            }

            public PyObject __call__() {
                return Py.newInteger(((PyList)this.self).list_hashCode());
            }
        }
        dict.__setitem__("__hash__", (PyObject)new PyMethodDescr("__hash__", PyList.class, 0, 0, new Exposed___hash__(null, null)));
        class Exposed___repr__
        extends PyBuiltinMethodNarrow {
            Exposed___repr__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___repr__(self, this.info);
            }

            public PyObject __call__() {
                return new PyString(((PyList)this.self).list_toString());
            }
        }
        dict.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", PyList.class, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___init__
        extends PyBuiltinMethod {
            Exposed___init__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___init__(self, this.info);
            }

            public PyObject __call__(PyObject[] args) {
                return this.__call__(args, Py.NoKeywords);
            }

            public PyObject __call__(PyObject[] args, String[] keywords) {
                ((PyList)this.self).list_init(args, keywords);
                return Py.None;
            }
        }
        dict.__setitem__("__init__", (PyObject)new PyMethodDescr("__init__", PyList.class, -1, -1, new Exposed___init__(null, null)));
        dict.__setitem__("__new__", (PyObject)new PyNewWrapper(PyList.class, "__new__", -1, -1){

            public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                PyList newobj;
                if (this.for_type == subtype) {
                    newobj = new PyList();
                    if (init) {
                        newobj.list_init(args, keywords);
                    }
                } else {
                    newobj = new PyListDerived(subtype);
                }
                return newobj;
            }
        });
    }

    public PyList() {
        this(LISTTYPE, Py.EmptyObjects);
    }

    public PyList(PyType type) {
        super(type);
    }

    public PyList(PyType type, PyObject[] elements) {
        super(type, elements);
    }

    public PyList(PyType type, Collection c) {
        super(type, c);
    }

    public PyList(Vector v) {
        super(LISTTYPE, v);
    }

    public PyList(PyObject[] elements) {
        this(LISTTYPE, elements);
    }

    public PyList(PyObject o) {
        this(LISTTYPE);
        PyObject iter = o.__iter__();
        PyObject item = null;
        while ((item = iter.__iternext__()) != null) {
            this.append(item);
        }
    }

    final void list_init(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser(exposed_name, args, kwds, new String[]{"sequence"}, 0);
        PyObject seq = ap.getPyObject(0, null);
        if (seq == null) {
            return;
        }
        if (seq instanceof PySequenceList) {
            PySequenceList p = (PySequenceList)seq.__getslice__(Py.None, Py.None, Py.One);
            this.list = p.list;
        } else {
            PyObject iter = seq.__iter__();
            PyObject item = null;
            while ((item = iter.__iternext__()) != null) {
                this.append(item);
            }
        }
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'list' object";
    }

    public int __len__() {
        return this.list___len__();
    }

    final int list___len__() {
        return this.size();
    }

    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyList.sliceLength(start, stop, step);
        PyObject[] newList = new PyObject[n];
        PyObject[] array = this.getArray();
        if (step == 1) {
            System.arraycopy(array, start, newList, 0, stop - start);
            return new PyList(newList);
        }
        int j = 0;
        int i = start;
        while (j < n) {
            newList[j] = array[i];
            ++j;
            i += step;
        }
        return new PyList(newList);
    }

    protected void del(int i) {
        this.remove(i);
    }

    protected void delRange(int start, int stop, int step) {
        block3: {
            block4: {
                block2: {
                    if (step != 1) break block2;
                    this.remove(start, stop);
                    break block3;
                }
                if (step <= 1) break block4;
                for (int i = start; i < stop; --stop, i += step) {
                    this.remove(i);
                    --i;
                }
                break block3;
            }
            if (step >= 0) break block3;
            for (int i = start; i >= 0 && i >= stop; i += step) {
                this.remove(i);
            }
        }
    }

    protected void set(int i, PyObject value) {
        this.list.pyset(i, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (stop < start) {
            stop = start;
        }
        if (step == 1) {
            if (value instanceof PySequence) {
                PySequence seq = (PySequence)value;
                PyObject[] otherArray = null;
                PyObject[] array = this.getArray();
                if (value instanceof PySequenceList) {
                    PySequenceList seqList = (PySequenceList)value;
                    otherArray = seqList.getArray();
                    if (otherArray == array) {
                        otherArray = (PyObject[])otherArray.clone();
                    }
                    this.list.replaceSubArray(start, stop, otherArray, 0, seqList.size());
                    return;
                } else {
                    int n = seq.__len__();
                    this.list.ensureCapacity(start + n);
                    for (int i = 0; i < n; ++i) {
                        this.list.add(i + start, seq.pyget(i));
                    }
                }
                return;
            } else {
                if (!(value instanceof List)) throw Py.TypeError("rhs of setslice must be a sequence or java.util.List");
                List other = (List)value.__tojava__(List.class);
                if (other == Py.NoConversion || other == null) return;
                int n = other.size();
                this.list.ensureCapacity(start + n);
                for (int i = 0; i < n; ++i) {
                    this.list.add(i + start, other.get(i));
                }
            }
            return;
        } else if (step > 1) {
            if (!(value instanceof PySequence)) throw Py.TypeError("setslice with java.util.List and step != 1 not supported yet.");
            PySequence seq = (PySequence)value;
            int n = seq.__len__();
            int i = 0;
            int j = 0;
            while (i < n) {
                this.list.pyset(j + start, seq.pyget(i));
                ++i;
                j += step;
            }
            return;
        } else {
            if (step >= 0) return;
            if (!(value instanceof PySequence)) throw Py.TypeError("setslice with java.util.List and step != 1 not supported yet.");
            PySequence seq = (PySequence)value;
            int n = seq.__len__();
            if (seq == this) {
                PyList newseq = new PyList();
                PyObject iter = seq.__iter__();
                PyObject item = null;
                while ((item = iter.__iternext__()) != null) {
                    newseq.append(item);
                }
                seq = newseq;
            }
            int i = 0;
            int j = this.list.size() - 1;
            while (i < n) {
                this.list.pyset(j, seq.pyget(i));
                ++i;
                j += step;
            }
        }
    }

    protected PyObject repeat(int count) {
        int l = this.size();
        PyObject[] newList = new PyObject[l * count];
        for (int i = 0; i < count; ++i) {
            System.arraycopy(this.getArray(), 0, newList, i * l, l);
        }
        return new PyList(newList);
    }

    public PyObject __imul__(PyObject o) {
        PyObject result = this.list___imul__(o);
        if (result == null && (result = o.__rmul__(this)) == null) {
            throw Py.TypeError(this._unsupportedop("*", o));
        }
        return result;
    }

    final PyObject list___imul__(PyObject o) {
        if (!(o instanceof PyInteger) && !(o instanceof PyLong)) {
            return null;
        }
        int l = this.size();
        int count = ((PyInteger)o.__int__()).getValue();
        int newSize = l * count;
        this.list.ensureCapacity(newSize);
        this.list.setSize(newSize);
        PyObject[] array = this.getArray();
        for (int i = 1; i < count; ++i) {
            System.arraycopy(array, 0, array, i * l, l);
        }
        return this;
    }

    final PyObject list___mul__(PyObject o) {
        if (!(o instanceof PyInteger) && !(o instanceof PyLong)) {
            return null;
        }
        int count = ((PyInteger)o.__int__()).getValue();
        return this.repeat(count);
    }

    final PyObject list___rmul__(PyObject o) {
        if (!(o instanceof PyInteger) && !(o instanceof PyLong)) {
            return null;
        }
        int count = ((PyInteger)o.__int__()).getValue();
        return this.repeat(count);
    }

    public PyObject __add__(PyObject o) {
        return this.list___add__(o);
    }

    final PyObject list___add__(PyObject o) {
        Object oList;
        PyList sum = null;
        if (o instanceof PyList) {
            PyList other = (PyList)o;
            int thisLen = this.size();
            int otherLen = other.size();
            PyObject[] newList = new PyObject[thisLen + otherLen];
            System.arraycopy(this.getArray(), 0, newList, 0, thisLen);
            System.arraycopy(other.getArray(), 0, newList, thisLen, otherLen);
            sum = new PyList(newList);
        } else if (!(o instanceof PySequenceList) && (oList = o.__tojava__(List.class)) != Py.NoConversion && oList != null) {
            List otherList = (List)oList;
            sum = new PyList();
            sum.list_extend(this);
            Iterator i = otherList.iterator();
            while (i.hasNext()) {
                sum.add(i.next());
            }
        }
        return sum;
    }

    public PyObject __radd__(PyObject o) {
        return this.list___radd__(o);
    }

    final PyObject list___radd__(PyObject o) {
        PyList sum = null;
        if (o instanceof PySequence) {
            return null;
        }
        Object oList = o.__tojava__(List.class);
        if (oList != Py.NoConversion && oList != null) {
            sum = new PyList();
            sum.addAll((Collection)((List)oList));
            sum.extend(this);
        }
        return sum;
    }

    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "can only concatenate list (not \"{2}\") to list";
        }
        return super.unsupportedopMessage(op, o2);
    }

    public String toString() {
        return this.list_toString();
    }

    final String list_toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "[...]";
        }
        StringBuffer buf = new StringBuffer("[");
        int length = this.size();
        PyObject[] array = this.getArray();
        for (int i = 0; i < length - 1; ++i) {
            buf.append(array[i].__repr__().toString());
            buf.append(", ");
        }
        if (length > 0) {
            buf.append(array[length - 1].__repr__().toString());
        }
        buf.append("]");
        ts.exitRepr(this);
        return buf.toString();
    }

    public void append(PyObject o) {
        this.list_append(o);
    }

    final void list_append(PyObject o) {
        this.pyadd(o);
    }

    public int count(PyObject o) {
        return this.list_count(o);
    }

    final int list_count(PyObject o) {
        int count = 0;
        PyObject[] array = this.getArray();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!array[i].equals(o)) continue;
            ++count;
        }
        return count;
    }

    public int index(PyObject o) {
        return this.list_index(o, 0, this.size());
    }

    public int index(PyObject o, int start) {
        return this.list_index(o, start, this.size());
    }

    public int index(PyObject o, int start, int stop) {
        return this.list_index(o, start, stop);
    }

    final int list_index(PyObject o, int start, int stop) {
        return this._index(o, "list.index(x): x not in list", start, stop);
    }

    final int list_index(PyObject o, int start) {
        return this._index(o, "list.index(x): x not in list", start, this.size());
    }

    final int list_index(PyObject o) {
        return this._index(o, "list.index(x): x not in list", 0, this.size());
    }

    private int _index(PyObject o, String message, int start, int stop) {
        int i;
        int validStop = this.calculateIndex(stop);
        int validStart = this.calculateIndex(start);
        PyObject[] array = this.getArray();
        for (i = validStart; i < validStop && !array[i].equals(o); ++i) {
        }
        if (i == validStop) {
            throw Py.ValueError(message);
        }
        return i;
    }

    private int calculateIndex(int index) {
        int length = this.size();
        if (index < 0) {
            index += length;
            if (index < 0) {
                index = 0;
            }
        } else if (index > length) {
            index = length;
        }
        return index;
    }

    public void insert(int index, PyObject o) {
        this.list_insert(index, o);
    }

    final void list_insert(int index, PyObject o) {
        if (index < 0) {
            index = Math.max(0, this.size() + index);
        }
        if (index > this.size()) {
            index = this.size();
        }
        this.list.pyadd(index, o);
    }

    public void remove(PyObject o) {
        this.list_remove(o);
    }

    final void list_remove(PyObject o) {
        this.del(this._index(o, "list.remove(x): x not in list", 0, this.size()));
    }

    public void reverse() {
        this.list_reverse();
    }

    final void list_reverse() {
        int n = this.size();
        PyObject[] array = this.getArray();
        int j = n - 1;
        int i = 0;
        while (i < n / 2) {
            PyObject tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
            ++i;
            --j;
        }
    }

    public PyObject pop() {
        return this.list_pop();
    }

    final PyObject list_pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n) {
        return this.list_pop(n);
    }

    final PyObject list_pop(int n) {
        int length = this.size();
        if (length == 0) {
            throw Py.IndexError("pop from empty list");
        }
        if (n < 0) {
            n += length;
        }
        if (n < 0 || n >= length) {
            throw Py.IndexError("pop index out of range");
        }
        PyObject v = this.pyget(n);
        this.setslice(n, n + 1, 1, Py.EmptyTuple);
        return v;
    }

    public void extend(PyObject o) {
        this.list_extend(o);
    }

    final void list_extend(PyObject o) {
        int length = this.size();
        this.setslice(length, length, 1, o);
    }

    public PyObject __iadd__(PyObject o) {
        return this.list___iadd__(o);
    }

    final PyObject list___iadd__(PyObject o) {
        this.extend(PyList.fastSequence(o, "argument to += must be a sequence"));
        return this;
    }

    public synchronized void sort(PyObject compare) {
        this.list_sort(compare);
    }

    final synchronized void list_sort(PyObject compare) {
        MergeState ms = new MergeState(this.getArray(), this.size(), compare);
        ms.sort();
    }

    public void sort() {
        this.list_sort();
    }

    final void list_sort() {
        this.list_sort(null);
    }

    public int hashCode() {
        return this.list_hashCode();
    }

    final int list_hashCode() {
        throw Py.TypeError("unhashable type");
    }

    public PyObject __reduce__() {
        return this.list___reduce__();
    }

    final PyObject list___reduce__() {
        PyTuple newargs = this.__getnewargs__();
        return new PyTuple(new PyObject[]{this.getType(), newargs});
    }

    public PyTuple __getnewargs__() {
        return new PyTuple(new PyObject[]{new PyTuple(this.list.getArray())});
    }
}

