/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageConverter.class);
    private static final ImageConverter INSTANCE = new ImageConverter();
    private static final int SCALE_12_TO_8_BITS = 16;

    private ImageConverter() {
    }

    public static ImageConverter getInstance() {
        return INSTANCE;
    }

    public String convert(String inputFilename, String outputFilename, int rows, int cols) throws IOException {
        File inputFile = new File(inputFilename);
        BufferedImage bi = this.readToRaster(inputFile.getAbsoluteFile(), rows, cols);
        this.writeRasterImage(outputFilename, bi);
        return outputFilename;
    }

    BufferedImage readToRaster(File inputFilename, int rows, int cols) throws MalformedURLException {
        return this.readToRaster(inputFilename.toURI().toURL(), rows, cols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage readToRaster(URL inputFile, int rows, int cols) {
        BufferedImage rv = new BufferedImage(rows, cols, 10);
        WritableRaster raster = rv.getRaster();
        int countBytes = -1;
        DataInputStream di = null;
        try {
            di = new DataInputStream(inputFile.openStream());
            for (int y = 0; y < cols; ++y) {
                for (int x = 0; x < rows; ++x) {
                    int firstByte = 0xFF & di.readByte();
                    int secondByte = 0xFF & di.readByte();
                    short anUnsignedShort = (short)(firstByte << 8 | secondByte);
                    countBytes += 2;
                    short value = anUnsignedShort;
                    raster.setSample(x, y, 0, value / 16);
                }
            }
        }
        catch (Exception e) {
            String m = "EOF at byte number: " + countBytes + "inputFile: " + inputFile.toString();
            LOGGER.error(m, (Throwable)e);
        }
        finally {
            if (di != null) {
                try {
                    di.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rv;
    }

    void writeRasterImage(String putputFilename, BufferedImage bi) {
        try {
            ImageIO.write((RenderedImage)bi, "PNG", new File(putputFilename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

