/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;
import org.apache.poi.hssf.record.formula.functions.LookupUtils;

public final class Lookup
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        switch (args.length) {
            case 3: {
                break;
            }
            case 2: {
                throw new RuntimeException("Two arg version of LOOKUP not supported yet");
            }
            default: {
                return ErrorEval.VALUE_INVALID;
            }
        }
        try {
            ValueEval lookupValue = OperandResolver.getSingleValue(args[0], srcCellRow, srcCellCol);
            AreaEval aeLookupVector = LookupUtils.resolveTableArrayArg(args[1]);
            AreaEval aeResultVector = LookupUtils.resolveTableArrayArg(args[2]);
            LookupUtils.ValueVector lookupVector = Lookup.createVector(aeLookupVector);
            LookupUtils.ValueVector resultVector = Lookup.createVector(aeResultVector);
            if (lookupVector.getSize() > resultVector.getSize()) {
                throw new RuntimeException("Lookup vector and result vector of differing sizes not supported yet");
            }
            int index = LookupUtils.lookupIndexOfValue(lookupValue, lookupVector, true);
            return resultVector.getItem(index);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private static LookupUtils.ValueVector createVector(AreaEval ae) {
        if (!ae.isRow() && !ae.isColumn()) {
            throw new RuntimeException("non-vector lookup or result areas not supported yet");
        }
        return new SimpleValueVector(ae.getValues());
    }

    private static final class SimpleValueVector
    implements LookupUtils.ValueVector {
        private final ValueEval[] _values;

        public SimpleValueVector(ValueEval[] values) {
            this._values = values;
        }

        public ValueEval getItem(int index) {
            return this._values[index];
        }

        public int getSize() {
            return this._values.length;
        }
    }
}

