/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

final class EvaluationCycleDetector {
    private final List _evaluationFrames = new ArrayList();

    public boolean startEvaluate(HSSFWorkbook workbook, HSSFSheet sheet, int srcRowNum, int srcColNum) {
        CellEvaluationFrame cef = new CellEvaluationFrame(workbook, sheet, srcRowNum, srcColNum);
        if (this._evaluationFrames.contains(cef)) {
            return false;
        }
        this._evaluationFrames.add(cef);
        return true;
    }

    public void endEvaluate(HSSFWorkbook workbook, HSSFSheet sheet, int srcRowNum, int srcColNum) {
        CellEvaluationFrame cefExpected;
        int nFrames = this._evaluationFrames.size();
        if (nFrames < 1) {
            throw new IllegalStateException("Call to endEvaluate without matching call to startEvaluate");
        }
        CellEvaluationFrame cefActual = new CellEvaluationFrame(workbook, sheet, srcRowNum, srcColNum);
        if (!cefActual.equals(cefExpected = (CellEvaluationFrame)this._evaluationFrames.get(--nFrames))) {
            throw new RuntimeException("Wrong cell specified. Corresponding startEvaluate() call was for cell {" + cefExpected.formatAsString() + "} this endEvaluate() call is for cell {" + cefActual.formatAsString() + "}");
        }
        this._evaluationFrames.remove(nFrames);
    }

    private static final class CellEvaluationFrame {
        private final HSSFWorkbook _workbook;
        private final HSSFSheet _sheet;
        private final int _srcRowNum;
        private final int _srcColNum;

        public CellEvaluationFrame(HSSFWorkbook workbook, HSSFSheet sheet, int srcRowNum, int srcColNum) {
            if (workbook == null) {
                throw new IllegalArgumentException("workbook must not be null");
            }
            if (sheet == null) {
                throw new IllegalArgumentException("sheet must not be null");
            }
            this._workbook = workbook;
            this._sheet = sheet;
            this._srcRowNum = srcRowNum;
            this._srcColNum = srcColNum;
        }

        public boolean equals(Object obj) {
            CellEvaluationFrame other = (CellEvaluationFrame)obj;
            if (this._workbook != other._workbook) {
                return false;
            }
            if (this._sheet != other._sheet) {
                return false;
            }
            if (this._srcRowNum != other._srcRowNum) {
                return false;
            }
            return this._srcColNum == other._srcColNum;
        }

        public String formatAsString() {
            return "R=" + this._srcRowNum + " C=" + this._srcColNum + " ShIx=" + this._workbook.getSheetIndex(this._sheet);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName()).append(" [");
            sb.append(this.formatAsString());
            sb.append("]");
            return sb.toString();
        }
    }
}

