/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.poi.hssf.model.FormulaParser;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ControlPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.MemErrPtg;
import org.apache.poi.hssf.record.formula.MissingArgPtg;
import org.apache.poi.hssf.record.formula.NamePtg;
import org.apache.poi.hssf.record.formula.NameXPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.RefPtg;
import org.apache.poi.hssf.record.formula.RefPtgBase;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.UnionPtg;
import org.apache.poi.hssf.record.formula.UnknownPtg;
import org.apache.poi.hssf.record.formula.eval.Area2DEval;
import org.apache.poi.hssf.record.formula.eval.Area3DEval;
import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.FunctionEval;
import org.apache.poi.hssf.record.formula.eval.NameEval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.eval.Ref2DEval;
import org.apache.poi.hssf.record.formula.eval.Ref3DEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.usermodel.EvaluationCycleDetector;
import org.apache.poi.hssf.usermodel.EvaluationCycleDetectorManager;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.OperationEvaluatorFactory;

public class HSSFFormulaEvaluator {
    private static final Class[] VALUE_CONTRUCTOR_CLASS_ARRAY = new Class[]{class$org$apache$poi$hssf$record$formula$Ptg == null ? (class$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.Ptg")) : class$org$apache$poi$hssf$record$formula$Ptg};
    private static final Class[] AREA3D_CONSTRUCTOR_CLASS_ARRAY = new Class[]{class$org$apache$poi$hssf$record$formula$Ptg == null ? (class$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.Ptg")) : class$org$apache$poi$hssf$record$formula$Ptg, array$Lorg$apache$poi$hssf$record$formula$eval$ValueEval == null ? (array$Lorg$apache$poi$hssf$record$formula$eval$ValueEval = HSSFFormulaEvaluator.class$("[Lorg.apache.poi.hssf.record.formula.eval.ValueEval;")) : array$Lorg$apache$poi$hssf$record$formula$eval$ValueEval};
    private static final Class[] REFERENCE_CONSTRUCTOR_CLASS_ARRAY = new Class[]{class$org$apache$poi$hssf$record$formula$Ptg == null ? (class$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.Ptg")) : class$org$apache$poi$hssf$record$formula$Ptg, class$org$apache$poi$hssf$record$formula$eval$ValueEval == null ? (class$org$apache$poi$hssf$record$formula$eval$ValueEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.ValueEval")) : class$org$apache$poi$hssf$record$formula$eval$ValueEval};
    private static final Class[] REF3D_CONSTRUCTOR_CLASS_ARRAY = new Class[]{class$org$apache$poi$hssf$record$formula$Ptg == null ? (class$org$apache$poi$hssf$record$formula$Ptg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.Ptg")) : class$org$apache$poi$hssf$record$formula$Ptg, class$org$apache$poi$hssf$record$formula$eval$ValueEval == null ? (class$org$apache$poi$hssf$record$formula$eval$ValueEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.ValueEval")) : class$org$apache$poi$hssf$record$formula$eval$ValueEval};
    private static final Map VALUE_EVALS_MAP = new HashMap();
    protected HSSFRow row;
    protected HSSFSheet sheet;
    protected HSSFWorkbook workbook;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$Ptg;
    static /* synthetic */ Class array$Lorg$apache$poi$hssf$record$formula$eval$ValueEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$ValueEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$BoolPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$BoolEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$IntPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$NumberEval;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$NumberPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$StringPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$eval$StringEval;

    public HSSFFormulaEvaluator(HSSFSheet sheet, HSSFWorkbook workbook) {
        this.sheet = sheet;
        this.workbook = workbook;
    }

    public void setCurrentRow(HSSFRow row) {
        this.row = row;
    }

    public static FormulaParser getUnderlyingParser(HSSFWorkbook workbook, String formula) {
        return new FormulaParser(formula, workbook);
    }

    public CellValue evaluate(HSSFCell cell) {
        CellValue retval = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case 3: {
                    retval = new CellValue(3);
                    break;
                }
                case 4: {
                    retval = new CellValue(4);
                    retval.setBooleanValue(cell.getBooleanCellValue());
                    break;
                }
                case 5: {
                    retval = new CellValue(5);
                    retval.setErrorValue(cell.getErrorCellValue());
                    break;
                }
                case 2: {
                    retval = HSSFFormulaEvaluator.getCellValueForEval(HSSFFormulaEvaluator.internalEvaluate(cell, this.row, this.sheet, this.workbook));
                    break;
                }
                case 0: {
                    retval = new CellValue(0);
                    retval.setNumberValue(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    retval = new CellValue(1);
                    retval.setRichTextStringValue(cell.getRichStringCellValue());
                }
            }
        }
        return retval;
    }

    public int evaluateFormulaCell(HSSFCell cell) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case 2: {
                    CellValue cv = HSSFFormulaEvaluator.getCellValueForEval(HSSFFormulaEvaluator.internalEvaluate(cell, this.row, this.sheet, this.workbook));
                    switch (cv.getCellType()) {
                        case 4: {
                            cell.setCellValue(cv.getBooleanValue());
                            break;
                        }
                        case 5: {
                            cell.setCellValue(cv.getErrorValue());
                            break;
                        }
                        case 0: {
                            cell.setCellValue(cv.getNumberValue());
                            break;
                        }
                        case 1: {
                            cell.setCellValue(cv.getRichTextStringValue());
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    return cv.getCellType();
                }
            }
        }
        return -1;
    }

    public HSSFCell evaluateInCell(HSSFCell cell) {
        if (cell != null) {
            block0 : switch (cell.getCellType()) {
                case 2: {
                    CellValue cv = HSSFFormulaEvaluator.getCellValueForEval(HSSFFormulaEvaluator.internalEvaluate(cell, this.row, this.sheet, this.workbook));
                    switch (cv.getCellType()) {
                        case 4: {
                            cell.setCellType(4);
                            cell.setCellValue(cv.getBooleanValue());
                            break block0;
                        }
                        case 5: {
                            cell.setCellErrorValue(cv.getErrorValue());
                            break block0;
                        }
                        case 0: {
                            cell.setCellType(0);
                            cell.setCellValue(cv.getNumberValue());
                            break block0;
                        }
                        case 1: {
                            cell.setCellType(1);
                            cell.setCellValue(cv.getRichTextStringValue());
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                }
            }
        }
        return cell;
    }

    public static void evaluateAllFormulaCells(HSSFWorkbook wb) {
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            HSSFSheet sheet = wb.getSheetAt(i);
            HSSFFormulaEvaluator evaluator = new HSSFFormulaEvaluator(sheet, wb);
            Iterator rit = sheet.rowIterator();
            while (rit.hasNext()) {
                HSSFRow r = (HSSFRow)rit.next();
                evaluator.setCurrentRow(r);
                Iterator cit = r.cellIterator();
                while (cit.hasNext()) {
                    HSSFCell c = (HSSFCell)cit.next();
                    if (c.getCellType() != 2) continue;
                    evaluator.evaluateFormulaCell(c);
                }
            }
        }
    }

    protected static CellValue getCellValueForEval(ValueEval eval) {
        CellValue retval = null;
        if (eval != null) {
            if (eval instanceof NumberEval) {
                NumberEval ne = (NumberEval)eval;
                retval = new CellValue(0);
                retval.setNumberValue(ne.getNumberValue());
            } else if (eval instanceof BoolEval) {
                BoolEval be = (BoolEval)eval;
                retval = new CellValue(4);
                retval.setBooleanValue(be.getBooleanValue());
            } else if (eval instanceof StringEval) {
                StringEval ne = (StringEval)eval;
                retval = new CellValue(1);
                retval.setStringValue(ne.getStringValue());
            } else if (eval instanceof BlankEval) {
                retval = new CellValue(3);
            } else if (eval instanceof ErrorEval) {
                retval = new CellValue(5);
                retval.setErrorValue((byte)((ErrorEval)eval).getErrorCode());
            } else {
                retval = new CellValue(5);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ValueEval internalEvaluate(HSSFCell srcCell, HSSFRow srcRow, HSSFSheet sheet, HSSFWorkbook workbook) {
        int srcRowNum = srcRow.getRowNum();
        short srcColNum = srcCell.getCellNum();
        EvaluationCycleDetector tracker = EvaluationCycleDetectorManager.getTracker();
        if (!tracker.startEvaluate(workbook, sheet, srcRowNum, srcColNum)) {
            return ErrorEval.CIRCULAR_REF_ERROR;
        }
        try {
            ValueEval valueEval = HSSFFormulaEvaluator.evaluateCell(workbook, sheet, srcRowNum, srcColNum, srcCell.getCellFormula());
            return valueEval;
        }
        finally {
            tracker.endEvaluate(workbook, sheet, srcRowNum, srcColNum);
        }
    }

    private static ValueEval evaluateCell(HSSFWorkbook workbook, HSSFSheet sheet, int srcRowNum, short srcColNum, String cellFormulaText) {
        Ptg[] ptgs = FormulaParser.parse(cellFormulaText, workbook);
        Stack<Eval> stack = new Stack<Eval>();
        int iSize = ptgs.length;
        for (int i = 0; i < iSize; ++i) {
            AreaEval ae;
            int rowIx;
            OperandPtg refPtg;
            Ptg ptg = ptgs[i];
            if (ptg instanceof ControlPtg || ptg instanceof MemErrPtg || ptg instanceof MissingArgPtg) continue;
            if (ptg instanceof NamePtg) {
                NamePtg namePtg = (NamePtg)ptg;
                stack.push(new NameEval(namePtg.getIndex()));
                continue;
            }
            if (ptg instanceof NameXPtg || ptg instanceof UnknownPtg) continue;
            if (ptg instanceof OperationPtg) {
                OperationPtg optg = (OperationPtg)ptg;
                if (optg instanceof UnionPtg) continue;
                OperationEval operation = OperationEvaluatorFactory.create(optg);
                int numops = operation.getNumberOfOperands();
                Eval[] ops = new Eval[numops];
                for (int j = numops - 1; j >= 0; --j) {
                    Eval p;
                    ops[j] = p = (Eval)stack.pop();
                }
                Eval opresult = HSSFFormulaEvaluator.invokeOperation(operation, ops, srcRowNum, srcColNum, workbook, sheet);
                stack.push(opresult);
                continue;
            }
            if (ptg instanceof RefPtg) {
                refPtg = (RefPtg)ptg;
                int colIx = ((RefPtgBase)refPtg).getColumn();
                rowIx = ((RefPtgBase)refPtg).getRow();
                HSSFRow row = sheet.getRow(rowIx);
                HSSFCell cell = row != null ? row.getCell(colIx) : null;
                stack.push(HSSFFormulaEvaluator.createRef2DEval((RefPtg)refPtg, cell, row, sheet, workbook));
                continue;
            }
            if (ptg instanceof Ref3DPtg) {
                refPtg = (Ref3DPtg)ptg;
                int colIx = ((Ref3DPtg)refPtg).getColumn();
                rowIx = ((Ref3DPtg)refPtg).getRow();
                Workbook wb = workbook.getWorkbook();
                HSSFSheet xsheet = workbook.getSheetAt(wb.getSheetIndexFromExternSheetIndex(((Ref3DPtg)refPtg).getExternSheetIndex()));
                HSSFRow row = xsheet.getRow(rowIx);
                HSSFCell cell = row != null ? row.getCell(colIx) : null;
                stack.push(HSSFFormulaEvaluator.createRef3DEval((Ref3DPtg)refPtg, cell, row, xsheet, workbook));
                continue;
            }
            if (ptg instanceof AreaPtg) {
                AreaPtg ap = (AreaPtg)ptg;
                ae = HSSFFormulaEvaluator.evaluateAreaPtg(sheet, workbook, ap);
                stack.push(ae);
                continue;
            }
            if (ptg instanceof Area3DPtg) {
                Area3DPtg a3dp = (Area3DPtg)ptg;
                ae = HSSFFormulaEvaluator.evaluateArea3dPtg(workbook, a3dp);
                stack.push(ae);
                continue;
            }
            Eval ptgEval = HSSFFormulaEvaluator.getEvalForPtg(ptg);
            stack.push(ptgEval);
        }
        ValueEval value = (ValueEval)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("evaluation stack not empty");
        }
        if ((value = HSSFFormulaEvaluator.dereferenceValue(value, srcRowNum, srcColNum)) instanceof BlankEval) {
            return NumberEval.ZERO;
        }
        return value;
    }

    private static ValueEval dereferenceValue(ValueEval evaluationResult, int srcRowNum, short srcColNum) {
        if (evaluationResult instanceof RefEval) {
            RefEval rv = (RefEval)evaluationResult;
            return rv.getInnerValueEval();
        }
        if (evaluationResult instanceof AreaEval) {
            AreaEval ae = (AreaEval)evaluationResult;
            if (ae.isRow()) {
                if (ae.isColumn()) {
                    return ae.getValues()[0];
                }
                return ae.getValueAt(ae.getFirstRow(), srcColNum);
            }
            if (ae.isColumn()) {
                return ae.getValueAt(srcRowNum, ae.getFirstColumn());
            }
            return ErrorEval.VALUE_INVALID;
        }
        return evaluationResult;
    }

    private static Eval invokeOperation(OperationEval operation, Eval[] ops, int srcRowNum, short srcColNum, HSSFWorkbook workbook, HSSFSheet sheet) {
        FunctionEval fe;
        if (operation instanceof FunctionEval && (fe = (FunctionEval)operation).isFreeRefFunction()) {
            return fe.getFreeRefFunction().evaluate(ops, srcRowNum, srcColNum, workbook, sheet);
        }
        return operation.evaluate(ops, srcRowNum, srcColNum);
    }

    public static AreaEval evaluateAreaPtg(HSSFSheet sheet, HSSFWorkbook workbook, AreaPtg ap) {
        int row0 = ap.getFirstRow();
        int col0 = ap.getFirstColumn();
        int row1 = ap.getLastRow();
        int col1 = ap.getLastColumn();
        if (row1 == -1 && row0 >= 0) {
            row1 = (short)sheet.getLastRowNum();
        }
        ValueEval[] values = HSSFFormulaEvaluator.evalArea(workbook, sheet, row0, col0, row1, col1);
        return new Area2DEval(ap, values);
    }

    public static AreaEval evaluateArea3dPtg(HSSFWorkbook workbook, Area3DPtg a3dp) {
        int row0 = a3dp.getFirstRow();
        int col0 = a3dp.getFirstColumn();
        int row1 = a3dp.getLastRow();
        int col1 = a3dp.getLastColumn();
        Workbook wb = workbook.getWorkbook();
        HSSFSheet xsheet = workbook.getSheetAt(wb.getSheetIndexFromExternSheetIndex(a3dp.getExternSheetIndex()));
        if (row1 == -1 && row0 >= 0) {
            row1 = (short)xsheet.getLastRowNum();
        }
        ValueEval[] values = HSSFFormulaEvaluator.evalArea(workbook, xsheet, row0, col0, row1, col1);
        return new Area3DEval(a3dp, values);
    }

    private static ValueEval[] evalArea(HSSFWorkbook workbook, HSSFSheet sheet, int row0, int col0, int row1, int col1) {
        ValueEval[] values = new ValueEval[(row1 - row0 + 1) * (col1 - col0 + 1)];
        for (int x = row0; sheet != null && x < row1 + 1; ++x) {
            HSSFRow row = sheet.getRow(x);
            for (int y = col0; y < col1 + 1; ++y) {
                ValueEval cellEval = row == null ? BlankEval.INSTANCE : HSSFFormulaEvaluator.getEvalForCell(row.getCell(y), row, sheet, workbook);
                values[(x - row0) * (col1 - col0 + 1) + (y - col0)] = cellEval;
            }
        }
        return values;
    }

    protected static Eval getEvalForPtg(Ptg ptg) {
        Eval retval = null;
        Class clazz = (Class)VALUE_EVALS_MAP.get(ptg.getClass());
        try {
            if (ptg instanceof Area3DPtg) {
                Constructor constructor = clazz.getConstructor(AREA3D_CONSTRUCTOR_CLASS_ARRAY);
                retval = (OperationEval)constructor.newInstance(ptg);
            } else if (ptg instanceof AreaPtg) {
                Constructor constructor = clazz.getConstructor(AREA3D_CONSTRUCTOR_CLASS_ARRAY);
                retval = (OperationEval)constructor.newInstance(ptg);
            } else if (ptg instanceof RefPtg) {
                Constructor constructor = clazz.getConstructor(REFERENCE_CONSTRUCTOR_CLASS_ARRAY);
                retval = (OperationEval)constructor.newInstance(ptg);
            } else if (ptg instanceof Ref3DPtg) {
                Constructor constructor = clazz.getConstructor(REF3D_CONSTRUCTOR_CLASS_ARRAY);
                retval = (OperationEval)constructor.newInstance(ptg);
            } else if (ptg instanceof IntPtg || ptg instanceof NumberPtg || ptg instanceof StringPtg || ptg instanceof BoolPtg) {
                Constructor constructor = clazz.getConstructor(VALUE_CONTRUCTOR_CLASS_ARRAY);
                retval = (ValueEval)constructor.newInstance(ptg);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal Error: ", e);
        }
        return retval;
    }

    protected static ValueEval getEvalForCell(HSSFCell cell, HSSFRow row, HSSFSheet sheet, HSSFWorkbook workbook) {
        if (cell == null) {
            return BlankEval.INSTANCE;
        }
        switch (cell.getCellType()) {
            case 0: {
                return new NumberEval(cell.getNumericCellValue());
            }
            case 1: {
                return new StringEval(cell.getRichStringCellValue().getString());
            }
            case 2: {
                return HSSFFormulaEvaluator.internalEvaluate(cell, row, sheet, workbook);
            }
            case 4: {
                return BoolEval.valueOf(cell.getBooleanCellValue());
            }
            case 3: {
                return BlankEval.INSTANCE;
            }
            case 5: {
                return ErrorEval.valueOf(cell.getErrorCellValue());
            }
        }
        throw new RuntimeException("Unexpected cell type (" + cell.getCellType() + ")");
    }

    private static Ref2DEval createRef2DEval(RefPtg ptg, HSSFCell cell, HSSFRow row, HSSFSheet sheet, HSSFWorkbook workbook) {
        if (cell == null) {
            return new Ref2DEval(ptg, BlankEval.INSTANCE);
        }
        switch (cell.getCellType()) {
            case 0: {
                return new Ref2DEval(ptg, new NumberEval(cell.getNumericCellValue()));
            }
            case 1: {
                return new Ref2DEval(ptg, new StringEval(cell.getRichStringCellValue().getString()));
            }
            case 2: {
                return new Ref2DEval(ptg, HSSFFormulaEvaluator.internalEvaluate(cell, row, sheet, workbook));
            }
            case 4: {
                return new Ref2DEval(ptg, BoolEval.valueOf(cell.getBooleanCellValue()));
            }
            case 3: {
                return new Ref2DEval(ptg, BlankEval.INSTANCE);
            }
            case 5: {
                return new Ref2DEval(ptg, ErrorEval.valueOf(cell.getErrorCellValue()));
            }
        }
        throw new RuntimeException("Unexpected cell type (" + cell.getCellType() + ")");
    }

    private static Ref3DEval createRef3DEval(Ref3DPtg ptg, HSSFCell cell, HSSFRow row, HSSFSheet sheet, HSSFWorkbook workbook) {
        if (cell == null) {
            return new Ref3DEval(ptg, BlankEval.INSTANCE);
        }
        switch (cell.getCellType()) {
            case 0: {
                return new Ref3DEval(ptg, new NumberEval(cell.getNumericCellValue()));
            }
            case 1: {
                return new Ref3DEval(ptg, new StringEval(cell.getRichStringCellValue().getString()));
            }
            case 2: {
                return new Ref3DEval(ptg, HSSFFormulaEvaluator.internalEvaluate(cell, row, sheet, workbook));
            }
            case 4: {
                return new Ref3DEval(ptg, BoolEval.valueOf(cell.getBooleanCellValue()));
            }
            case 3: {
                return new Ref3DEval(ptg, BlankEval.INSTANCE);
            }
            case 5: {
                return new Ref3DEval(ptg, ErrorEval.valueOf(cell.getErrorCellValue()));
            }
        }
        throw new RuntimeException("Unexpected cell type (" + cell.getCellType() + ")");
    }

    void inspectPtgs(String formula) {
        FormulaParser fp = new FormulaParser(formula, this.workbook);
        fp.parse();
        Ptg[] ptgs = fp.getRPNPtg();
        System.out.println("<ptg-group>");
        int iSize = ptgs.length;
        for (int i = 0; i < iSize; ++i) {
            System.out.println("<ptg>");
            System.out.println(ptgs[i]);
            if (ptgs[i] instanceof OperationPtg) {
                System.out.println("numoperands: " + ((OperationPtg)ptgs[i]).getNumberOfOperands());
            }
            System.out.println("</ptg>");
        }
        System.out.println("</ptg-group>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        VALUE_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$BoolPtg == null ? (class$org$apache$poi$hssf$record$formula$BoolPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.BoolPtg")) : class$org$apache$poi$hssf$record$formula$BoolPtg, class$org$apache$poi$hssf$record$formula$eval$BoolEval == null ? (class$org$apache$poi$hssf$record$formula$eval$BoolEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.BoolEval")) : class$org$apache$poi$hssf$record$formula$eval$BoolEval);
        VALUE_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$IntPtg == null ? (class$org$apache$poi$hssf$record$formula$IntPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.IntPtg")) : class$org$apache$poi$hssf$record$formula$IntPtg, class$org$apache$poi$hssf$record$formula$eval$NumberEval == null ? (class$org$apache$poi$hssf$record$formula$eval$NumberEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.NumberEval")) : class$org$apache$poi$hssf$record$formula$eval$NumberEval);
        VALUE_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$NumberPtg == null ? (class$org$apache$poi$hssf$record$formula$NumberPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.NumberPtg")) : class$org$apache$poi$hssf$record$formula$NumberPtg, class$org$apache$poi$hssf$record$formula$eval$NumberEval == null ? (class$org$apache$poi$hssf$record$formula$eval$NumberEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.NumberEval")) : class$org$apache$poi$hssf$record$formula$eval$NumberEval);
        VALUE_EVALS_MAP.put(class$org$apache$poi$hssf$record$formula$StringPtg == null ? (class$org$apache$poi$hssf$record$formula$StringPtg = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.StringPtg")) : class$org$apache$poi$hssf$record$formula$StringPtg, class$org$apache$poi$hssf$record$formula$eval$StringEval == null ? (class$org$apache$poi$hssf$record$formula$eval$StringEval = HSSFFormulaEvaluator.class$("org.apache.poi.hssf.record.formula.eval.StringEval")) : class$org$apache$poi$hssf$record$formula$eval$StringEval);
    }

    public static final class CellValue {
        private int cellType;
        private HSSFRichTextString richTextStringValue;
        private double numberValue;
        private boolean booleanValue;
        private byte errorValue;

        public CellValue(int cellType) {
            this.cellType = cellType;
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }

        public void setBooleanValue(boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        public double getNumberValue() {
            return this.numberValue;
        }

        public void setNumberValue(double numberValue) {
            this.numberValue = numberValue;
        }

        public String getStringValue() {
            return this.richTextStringValue.getString();
        }

        public void setStringValue(String stringValue) {
            this.richTextStringValue = new HSSFRichTextString(stringValue);
        }

        public int getCellType() {
            return this.cellType;
        }

        public byte getErrorValue() {
            return this.errorValue;
        }

        public void setErrorValue(byte errorValue) {
            this.errorValue = errorValue;
        }

        public HSSFRichTextString getRichTextStringValue() {
            return this.richTextStringValue;
        }

        public void setRichTextStringValue(HSSFRichTextString richTextStringValue) {
            this.richTextStringValue = richTextStringValue;
        }
    }
}

