/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.editor.VariableSizeUpdater;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class CodeAttributeComposer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
LineNumberInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private static final boolean DEBUG = false;
    private static final int MAXIMUM_LEVELS = 32;
    private static final int INVALID = -1;
    private boolean allowExternalExceptionHandlers;
    private int maximumCodeLength;
    private int codeLength;
    private int exceptionTableLength;
    private int level = -1;
    private byte[] code = new byte[1024];
    private int[] oldInstructionOffsets = new int[1024];
    private final int[] codeFragmentOffsets = new int[32];
    private final int[] codeFragmentLengths = new int[32];
    private final int[][] instructionOffsetMap = new int[32][1024];
    private ExceptionInfo[] exceptionTable = new ExceptionInfo[16];
    private int expectedStackMapFrameOffset;
    private final StackSizeUpdater stackSizeUpdater = new StackSizeUpdater();
    private final VariableSizeUpdater variableSizeUpdater = new VariableSizeUpdater();

    public CodeAttributeComposer() {
        this(false);
    }

    public CodeAttributeComposer(boolean bl) {
        this.allowExternalExceptionHandlers = bl;
    }

    public void reset() {
        this.maximumCodeLength = 0;
        this.codeLength = 0;
        this.exceptionTableLength = 0;
        this.level = -1;
    }

    public void beginCodeFragment(int n) {
        ++this.level;
        if (this.level >= 32) {
            throw new IllegalArgumentException("Maximum number of code fragment levels exceeded [" + this.level + "]");
        }
        this.maximumCodeLength += n;
        if (this.code.length < this.maximumCodeLength) {
            byte[] byArray = new byte[this.maximumCodeLength];
            System.arraycopy(this.code, 0, byArray, 0, this.codeLength);
            this.code = byArray;
            int[] nArray = new int[this.maximumCodeLength];
            System.arraycopy(this.oldInstructionOffsets, 0, nArray, 0, this.codeLength);
            this.oldInstructionOffsets = nArray;
        }
        if (this.instructionOffsetMap[this.level].length <= n) {
            this.instructionOffsetMap[this.level] = new int[n + 1];
        }
        for (int i = 0; i <= n; ++i) {
            this.instructionOffsetMap[this.level][i] = -1;
        }
        this.codeFragmentOffsets[this.level] = this.codeLength;
        this.codeFragmentLengths[this.level] = n;
    }

    public void appendInstruction(int n, Instruction instruction) {
        this.oldInstructionOffsets[this.codeLength] = n;
        instruction.write(this.code, this.codeLength);
        this.instructionOffsetMap[this.level][n] = this.codeLength;
        this.codeLength += instruction.length(this.codeLength);
    }

    public void appendLabel(int n) {
        this.instructionOffsetMap[this.level][n] = this.codeLength;
    }

    public void appendException(ExceptionInfo exceptionInfo) {
        this.visitExceptionInfo(null, null, null, exceptionInfo);
        if (exceptionInfo.u2startPC == exceptionInfo.u2endPC) {
            return;
        }
        if (this.exceptionTable.length <= this.exceptionTableLength) {
            ExceptionInfo[] exceptionInfoArray = new ExceptionInfo[this.exceptionTableLength + 1];
            System.arraycopy(this.exceptionTable, 0, exceptionInfoArray, 0, this.exceptionTableLength);
            this.exceptionTable = exceptionInfoArray;
        }
        this.exceptionTable[this.exceptionTableLength++] = exceptionInfo;
    }

    public void endCodeFragment() {
        Instruction instruction;
        if (this.level < 0) {
            throw new IllegalArgumentException("Code fragment not begun [" + this.level + "]");
        }
        for (int i = this.codeFragmentOffsets[this.level]; i < this.codeLength; i += instruction.length(i)) {
            instruction = InstructionFactory.create(this.code, i);
            if (this.oldInstructionOffsets[i] < 0) continue;
            instruction.accept(null, null, null, i, this);
            instruction.write(this.code, i);
            this.oldInstructionOffsets[i] = -1;
        }
        this.maximumCodeLength += this.codeLength - this.codeFragmentOffsets[this.level] - this.codeFragmentLengths[this.level];
        if (this.allowExternalExceptionHandlers) {
            for (int i = 0; i < this.exceptionTableLength; ++i) {
                ExceptionInfo exceptionInfo = this.exceptionTable[i];
                int n = -exceptionInfo.u2handlerPC;
                if (n <= 0) continue;
                if (this.instructionOffsetMap[this.level][n] < this.codeLength) {
                    exceptionInfo.u2handlerPC = this.remapInstructionOffset(n);
                    continue;
                }
                if (this.level != 0) continue;
                throw new IllegalStateException("Couldn't remap exception handler offset [" + n + "]");
            }
        }
        --this.level;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.level != -1) {
            throw new IllegalArgumentException("Code fragment not ended [" + this.level + "]");
        }
        ++this.level;
        if (codeAttribute.u4codeLength < this.codeLength) {
            codeAttribute.code = new byte[this.codeLength];
        }
        codeAttribute.u4codeLength = this.codeLength;
        System.arraycopy(this.code, 0, codeAttribute.code, 0, this.codeLength);
        if (codeAttribute.exceptionTable.length < this.exceptionTableLength) {
            codeAttribute.exceptionTable = new ExceptionInfo[this.exceptionTableLength];
        }
        codeAttribute.u2exceptionTableLength = this.exceptionTableLength;
        System.arraycopy(this.exceptionTable, 0, codeAttribute.exceptionTable, 0, this.exceptionTableLength);
        this.stackSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        this.variableSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.attributesAccept(clazz, method, this);
        --this.level;
    }

    @Override
    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.expectedStackMapFrameOffset = -1;
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.expectedStackMapFrameOffset = 0;
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
        lineNumberTableAttribute.u2lineNumberTableLength = this.removeEmptyLineNumbers(lineNumberTableAttribute.lineNumberTable, lineNumberTableAttribute.u2lineNumberTableLength, codeAttribute.u4codeLength);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTableAttribute.u2localVariableTableLength = this.removeEmptyLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength, codeAttribute.u2maxLocals);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.removeEmptyLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength, codeAttribute.u2maxLocals);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        branchInstruction.branchOffset = this.remapBranchOffset(n, branchInstruction.branchOffset);
    }

    @Override
    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
        switchInstruction.defaultOffset = this.remapBranchOffset(n, switchInstruction.defaultOffset);
        this.remapJumpOffsets(n, switchInstruction.jumpOffsets);
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        exceptionInfo.u2startPC = this.remapInstructionOffset(exceptionInfo.u2startPC);
        exceptionInfo.u2endPC = this.remapInstructionOffset(exceptionInfo.u2endPC);
        int n = exceptionInfo.u2handlerPC;
        exceptionInfo.u2handlerPC = this.allowExternalExceptionHandlers && this.instructionOffsetMap[this.level][n] >= this.codeLength ? -n : this.remapInstructionOffset(n);
    }

    @Override
    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, StackMapFrame stackMapFrame) {
        int n2;
        int n3 = n2 = this.remapInstructionOffset(n);
        if (this.expectedStackMapFrameOffset >= 0) {
            n3 -= this.expectedStackMapFrameOffset;
            this.expectedStackMapFrameOffset = n2 + 1;
        }
        stackMapFrame.u2offsetDelta = n3;
    }

    @Override
    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameOneFrame sameOneFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, n, sameOneFrame);
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, n, this);
    }

    @Override
    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, MoreZeroFrame moreZeroFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, n, moreZeroFrame);
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, n, this);
    }

    @Override
    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FullFrame fullFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, n, fullFrame);
        fullFrame.variablesAccept(clazz, method, codeAttribute, n, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, n, this);
    }

    @Override
    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
    }

    @Override
    public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, UninitializedType uninitializedType) {
        uninitializedType.u2newInstructionOffset = this.remapInstructionOffset(uninitializedType.u2newInstructionOffset);
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        lineNumberInfo.u2startPC = this.remapInstructionOffset(lineNumberInfo.u2startPC);
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        int n = this.remapInstructionOffset(localVariableInfo.u2startPC);
        int n2 = this.remapInstructionOffset(localVariableInfo.u2startPC + localVariableInfo.u2length);
        localVariableInfo.u2startPC = n;
        localVariableInfo.u2length = n2 - n;
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        int n = this.remapInstructionOffset(localVariableTypeInfo.u2startPC);
        int n2 = this.remapInstructionOffset(localVariableTypeInfo.u2startPC + localVariableTypeInfo.u2length);
        localVariableTypeInfo.u2startPC = n;
        localVariableTypeInfo.u2length = n2 - n;
    }

    private void remapJumpOffsets(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.remapBranchOffset(n, nArray[i]);
        }
    }

    private int remapBranchOffset(int n, int n2) {
        if (n < 0 || n > this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        int n3 = this.oldInstructionOffsets[n];
        return this.remapInstructionOffset(n3 + n2) - this.remapInstructionOffset(n3);
    }

    private int remapInstructionOffset(int n) {
        if (n < 0 || n > this.codeFragmentLengths[this.level]) {
            throw new IllegalArgumentException("Instruction offset [" + n + "] out of range in code fragment with length [" + this.codeFragmentLengths[this.level] + "] at level " + this.level);
        }
        int n2 = this.instructionOffsetMap[this.level][n];
        if (n2 == -1) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code fragment at level " + this.level);
        }
        return n2;
    }

    private int removeEmptyExceptions(ExceptionInfo[] exceptionInfoArray, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            ExceptionInfo exceptionInfo = exceptionInfoArray[n2];
            if (exceptionInfo.u2startPC >= exceptionInfo.u2endPC) continue;
            exceptionInfoArray[n3++] = exceptionInfo;
        }
        for (n2 = n3; n2 < n; ++n2) {
            exceptionInfoArray[n2] = null;
        }
        return n3;
    }

    private int removeEmptyLineNumbers(LineNumberInfo[] lineNumberInfoArray, int n, int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            LineNumberInfo lineNumberInfo = lineNumberInfoArray[n3];
            int n5 = lineNumberInfo.u2startPC;
            if (n5 >= n2 || n3 != 0 && n5 <= lineNumberInfoArray[n3 - 1].u2startPC) continue;
            lineNumberInfoArray[n4++] = lineNumberInfo;
        }
        for (n3 = n4; n3 < n; ++n3) {
            lineNumberInfoArray[n3] = null;
        }
        return n4;
    }

    private int removeEmptyLocalVariables(LocalVariableInfo[] localVariableInfoArray, int n, int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            LocalVariableInfo localVariableInfo = localVariableInfoArray[n3];
            if (localVariableInfo.u2length <= 0 || localVariableInfo.u2index >= n2) continue;
            localVariableInfoArray[n4++] = localVariableInfo;
        }
        for (n3 = n4; n3 < n; ++n3) {
            localVariableInfoArray[n3] = null;
        }
        return n4;
    }

    private int removeEmptyLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfoArray, int n, int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfoArray[n3];
            if (localVariableTypeInfo.u2length <= 0 || localVariableTypeInfo.u2index >= n2) continue;
            localVariableTypeInfoArray[n4++] = localVariableTypeInfo;
        }
        for (n3 = n4; n3 < n; ++n3) {
            localVariableTypeInfoArray[n3] = null;
        }
        return n4;
    }

    private void println(String string, String string2) {
        this.print(string, string2);
        System.out.println();
    }

    private void print(String string, String string2) {
        System.out.print(string);
        for (int i = 0; i < this.level; ++i) {
            System.out.print("  ");
        }
        System.out.print(string2);
    }

    public static void main(String[] stringArray) {
        CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
        codeAttributeComposer.beginCodeFragment(10);
        codeAttributeComposer.appendInstruction(0, new SimpleInstruction(3));
        codeAttributeComposer.appendInstruction(1, new VariableInstruction(54, 0));
        codeAttributeComposer.appendInstruction(2, new BranchInstruction(-89, 1));
        codeAttributeComposer.beginCodeFragment(10);
        codeAttributeComposer.appendInstruction(0, new VariableInstruction(-124, 0, 1));
        codeAttributeComposer.appendInstruction(1, new VariableInstruction(21, 0));
        codeAttributeComposer.appendInstruction(2, new SimpleInstruction(8));
        codeAttributeComposer.appendInstruction(3, new BranchInstruction(-95, -3));
        codeAttributeComposer.endCodeFragment();
        codeAttributeComposer.appendInstruction(3, new SimpleInstruction(-79));
        codeAttributeComposer.endCodeFragment();
    }
}

