/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.ComparableConstant;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class ConstantPoolSorter
extends SimplifiedVisitor
implements ClassVisitor {
    private int[] constantIndexMap = new int[256];
    private ComparableConstant[] comparableConstantPool = new ComparableConstant[256];
    private Constant[] newConstantPool = new Constant[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        int n;
        int n2;
        int n3 = programClass.u2constantPoolCount;
        if (this.constantIndexMap.length < n3) {
            this.constantIndexMap = new int[n3];
            this.comparableConstantPool = new ComparableConstant[n3];
            this.newConstantPool = new Constant[n3];
        }
        int n4 = 0;
        for (n2 = 1; n2 < n3; ++n2) {
            Constant constant = programClass.constantPool[n2];
            if (constant == null) continue;
            this.comparableConstantPool[n4++] = new ComparableConstant(programClass, n2, constant);
        }
        Arrays.sort(this.comparableConstantPool, 0, n4);
        n2 = 1;
        int n5 = 1;
        ComparableConstant comparableConstant = null;
        for (n = 0; n < n4; ++n) {
            ComparableConstant comparableConstant2 = this.comparableConstantPool[n];
            if (!comparableConstant2.equals(comparableConstant)) {
                n5 = n2;
                Constant constant = comparableConstant2.getConstant();
                this.newConstantPool[n2++] = constant;
                int n6 = constant.getTag();
                if (n6 == 5 || n6 == 6) {
                    this.newConstantPool[n2++] = null;
                }
                comparableConstant = comparableConstant2;
            }
            this.constantIndexMap[comparableConstant2.getIndex()] = n5;
        }
        System.arraycopy(this.newConstantPool, 0, programClass.constantPool, 0, n2);
        for (n = n2; n < n3; ++n) {
            programClass.constantPool[n] = null;
        }
        programClass.u2constantPoolCount = n2;
        this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
        this.constantPoolRemapper.visitProgramClass(programClass);
    }
}

