/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class ClassNameFilter
implements ClassVisitor {
    private final StringMatcher regularExpressionMatcher;
    private final ClassVisitor classVisitor;

    public ClassNameFilter(String string, ClassVisitor classVisitor) {
        this(new ListParser(new ClassNameParser()).parse(string), classVisitor);
    }

    public ClassNameFilter(StringMatcher stringMatcher, ClassVisitor classVisitor) {
        this.regularExpressionMatcher = stringMatcher;
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (this.accepted(programClass.getName())) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.accepted(libraryClass.getName())) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private boolean accepted(String string) {
        return this.regularExpressionMatcher.matches(string);
    }
}

