/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.MemberObfuscator;
import proguard.obfuscate.SpecialNameFactory;

public class MemberSpecialNameFilter
implements MemberVisitor {
    private final MemberVisitor memberVisitor;

    public MemberSpecialNameFilter(MemberVisitor memberVisitor) {
        this.memberVisitor = memberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (MemberSpecialNameFilter.isSpecialName(programField)) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (MemberSpecialNameFilter.isSpecialName(programMethod)) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (MemberSpecialNameFilter.isSpecialName(libraryField)) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (MemberSpecialNameFilter.isSpecialName(libraryMethod)) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }

    private static boolean isSpecialName(Member member) {
        return SpecialNameFactory.isSpecialName(MemberObfuscator.newMemberName(member));
    }
}

