/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.ListBody;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.ListLabel;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfDiv;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPHeaderCell;
import com.itextpdf.text.pdf.PdfPRow;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPTableBody;
import com.itextpdf.text.pdf.PdfPTableFooter;
import com.itextpdf.text.pdf.PdfPTableHeader;
import com.itextpdf.text.pdf.PdfRectangle;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfStructureTreeRoot;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import com.itextpdf.text.pdf.interfaces.IPdfStructureElement;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PdfStructureElement
extends PdfDictionary
implements IPdfStructureElement {
    private PdfStructureElement parent;
    private PdfStructureTreeRoot top;
    private PdfIndirectReference reference;
    private PdfName structureType;

    public PdfStructureElement(PdfStructureElement parent, PdfName structureType) {
        this.top = parent.top;
        this.init(parent, structureType);
        this.parent = parent;
        this.put(PdfName.P, parent.reference);
        this.put(PdfName.TYPE, PdfName.STRUCTELEM);
    }

    public PdfStructureElement(PdfStructureTreeRoot parent, PdfName structureType) {
        this.top = parent;
        this.init(parent, structureType);
        this.put(PdfName.P, parent.getReference());
        this.put(PdfName.TYPE, PdfName.STRUCTELEM);
    }

    protected PdfStructureElement(PdfDictionary parent, PdfName structureType) {
        if (parent instanceof PdfStructureElement) {
            this.top = ((PdfStructureElement)parent).top;
            this.init(parent, structureType);
            this.parent = (PdfStructureElement)parent;
            this.put(PdfName.P, ((PdfStructureElement)parent).reference);
            this.put(PdfName.TYPE, PdfName.STRUCTELEM);
        } else if (parent instanceof PdfStructureTreeRoot) {
            this.top = (PdfStructureTreeRoot)parent;
            this.init(parent, structureType);
            this.put(PdfName.P, ((PdfStructureTreeRoot)parent).getReference());
            this.put(PdfName.TYPE, PdfName.STRUCTELEM);
        }
    }

    public PdfName getStructureType() {
        return this.structureType;
    }

    private void init(PdfDictionary parent, PdfName structureType) {
        if (!Arrays.asList(this.top.getWriter().getStandardStructElems()).contains(structureType)) {
            PdfDictionary roleMap = this.top.getAsDict(PdfName.ROLEMAP);
            if (roleMap == null || !roleMap.contains(structureType)) {
                throw new ExceptionConverter(new DocumentException(MessageLocalization.getComposedMessage("unknown.structure.element.role.1", structureType.toString())));
            }
            this.structureType = roleMap.getAsName(structureType);
        } else {
            this.structureType = structureType;
        }
        PdfObject kido = parent.get(PdfName.K);
        PdfArray kids = null;
        if (kido == null) {
            kids = new PdfArray();
            parent.put(PdfName.K, kids);
        } else if (kido instanceof PdfArray) {
            kids = (PdfArray)kido;
        } else {
            kids = new PdfArray();
            kids.add(kido);
            parent.put(PdfName.K, kids);
        }
        if (kids.size() > 0) {
            PdfDictionary mcr;
            if (kids.getAsNumber(0) != null) {
                kids.remove(0);
            }
            if (kids.size() > 0 && (mcr = kids.getAsDict(0)) != null && PdfName.MCR.equals(mcr.getAsName(PdfName.TYPE))) {
                kids.remove(0);
            }
        }
        kids.add(this);
        this.put(PdfName.S, structureType);
        this.reference = this.top.getWriter().getPdfIndirectReference();
    }

    public PdfDictionary getParent() {
        return this.getParent(false);
    }

    public PdfDictionary getParent(boolean includeStructTreeRoot) {
        if (this.parent == null && includeStructTreeRoot) {
            return this.top;
        }
        return this.parent;
    }

    void setPageMark(int page, int mark) {
        if (mark >= 0) {
            this.put(PdfName.K, new PdfNumber(mark));
        }
        this.top.setPageMark(page, this.reference);
    }

    public PdfIndirectReference getReference() {
        return this.reference;
    }

    public PdfObject getAttribute(PdfName name) {
        PdfDictionary attr = this.getAsDict(PdfName.A);
        if (attr != null && attr.contains(name)) {
            return attr.get(name);
        }
        PdfDictionary parent = this.getParent();
        if (parent instanceof PdfStructureElement) {
            return ((PdfStructureElement)parent).getAttribute(name);
        }
        if (parent instanceof PdfStructureTreeRoot) {
            return ((PdfStructureTreeRoot)parent).getAttribute(name);
        }
        return new PdfNull();
    }

    public void setAttribute(PdfName name, PdfObject obj) {
        PdfDictionary attr = this.getAsDict(PdfName.A);
        if (attr == null) {
            attr = new PdfDictionary();
            this.put(PdfName.A, attr);
        }
        attr.put(name, obj);
    }

    public void writeAttributes(IAccessibleElement element) {
        if (this.top.getWriter().getPdfVersion().getVersion() < '7') {
            return;
        }
        if (element instanceof ListItem) {
            this.writeAttributes((ListItem)element);
        } else if (element instanceof Paragraph) {
            this.writeAttributes((Paragraph)element);
        } else if (element instanceof Chunk) {
            this.writeAttributes((Chunk)element);
        } else if (element instanceof Image) {
            this.writeAttributes((Image)element);
        } else if (element instanceof List) {
            this.writeAttributes((List)element);
        } else if (element instanceof ListLabel) {
            this.writeAttributes((ListLabel)element);
        } else if (element instanceof ListBody) {
            this.writeAttributes((ListBody)element);
        } else if (element instanceof PdfPTable) {
            this.writeAttributes((PdfPTable)element);
        } else if (element instanceof PdfPRow) {
            this.writeAttributes((PdfPRow)element);
        } else if (element instanceof PdfPHeaderCell) {
            this.writeAttributes((PdfPHeaderCell)element);
        } else if (element instanceof PdfPCell) {
            this.writeAttributes((PdfPCell)element);
        } else if (element instanceof PdfPTableHeader) {
            this.writeAttributes((PdfPTableHeader)element);
        } else if (element instanceof PdfPTableFooter) {
            this.writeAttributes((PdfPTableFooter)element);
        } else if (element instanceof PdfPTableBody) {
            this.writeAttributes((PdfPTableBody)element);
        } else if (element instanceof PdfDiv) {
            this.writeAttributes((PdfDiv)element);
        } else if (element instanceof Document) {
            this.writeAttributes((Document)element);
        }
        if (element.getAccessibleAttributes() != null) {
            for (PdfName key : element.getAccessibleAttributes().keySet()) {
                if (key.equals(PdfName.LANG) || key.equals(PdfName.ALT) || key.equals(PdfName.ACTUALTEXT) || key.equals(PdfName.E)) {
                    this.put(key, element.getAccessibleAttribute(key));
                    continue;
                }
                this.setAttribute(key, element.getAccessibleAttribute(key));
            }
        }
    }

    private void writeAttributes(Chunk chunk) {
        if (chunk != null) {
            if (chunk.getImage() != null) {
                this.writeAttributes(chunk.getImage());
            } else {
                HashMap<String, Object> attr = chunk.getAttributes();
                if (attr != null) {
                    if (attr.containsKey("UNDERLINE")) {
                        this.setAttribute(PdfName.TEXTDECORATIONTYPE, PdfName.UNDERLINE);
                    }
                    if (attr.containsKey("BACKGROUND")) {
                        Object[] back = (Object[])attr.get("BACKGROUND");
                        BaseColor color = (BaseColor)back[0];
                        this.setAttribute(PdfName.BACKGROUNDCOLOR, new PdfArray(new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f}));
                    }
                    IPdfStructureElement parent = (IPdfStructureElement)((Object)this.getParent(true));
                    PdfObject obj = parent.getAttribute(PdfName.COLOR);
                    if (chunk.getFont() != null && chunk.getFont().getColor() != null) {
                        BaseColor c = chunk.getFont().getColor();
                        this.setColorAttribute(c, obj, PdfName.COLOR);
                    }
                    PdfObject decorThickness = parent.getAttribute(PdfName.TEXTDECORATIONTHICKNESS);
                    PdfObject decorColor = parent.getAttribute(PdfName.TEXTDECORATIONCOLOR);
                    if (attr.containsKey("UNDERLINE")) {
                        Object[][] unders = (Object[][])attr.get("UNDERLINE");
                        Object[] arr = unders[unders.length - 1];
                        BaseColor color = (BaseColor)arr[0];
                        float[] floats = (float[])arr[1];
                        float thickness = floats[0];
                        if (decorThickness instanceof PdfNumber) {
                            float t = ((PdfNumber)decorThickness).floatValue();
                            if (Float.compare(thickness, t) != 0) {
                                this.setAttribute(PdfName.TEXTDECORATIONTHICKNESS, new PdfNumber(thickness));
                            }
                        } else {
                            this.setAttribute(PdfName.TEXTDECORATIONTHICKNESS, new PdfNumber(thickness));
                        }
                        if (color != null) {
                            this.setColorAttribute(color, decorColor, PdfName.TEXTDECORATIONCOLOR);
                        }
                    }
                    if (attr.containsKey("LINEHEIGHT")) {
                        float height = ((Float)attr.get("LINEHEIGHT")).floatValue();
                        PdfObject parentLH = parent.getAttribute(PdfName.LINEHEIGHT);
                        if (parentLH instanceof PdfNumber) {
                            float pLH = ((PdfNumber)parentLH).floatValue();
                            if (Float.compare(pLH, height) != 0) {
                                this.setAttribute(PdfName.LINEHEIGHT, new PdfNumber(height));
                            }
                        } else {
                            this.setAttribute(PdfName.LINEHEIGHT, new PdfNumber(height));
                        }
                    }
                }
            }
        }
    }

    private void writeAttributes(Image image) {
        if (image != null) {
            if (image.getWidth() > 0.0f) {
                this.setAttribute(PdfName.WIDTH, new PdfNumber(image.getWidth()));
            }
            if (image.getHeight() > 0.0f) {
                this.setAttribute(PdfName.HEIGHT, new PdfNumber(image.getHeight()));
            }
            PdfRectangle rect = new PdfRectangle(image, image.getRotation());
            this.setAttribute(PdfName.BBOX, rect);
            if (image.getBackgroundColor() != null) {
                BaseColor color = image.getBackgroundColor();
                this.setAttribute(PdfName.BACKGROUNDCOLOR, new PdfArray(new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f}));
            }
        }
    }

    private void writeAttributes(Paragraph paragraph) {
        if (paragraph != null) {
            if (Float.compare(paragraph.getSpacingBefore(), 0.0f) != 0) {
                this.setAttribute(PdfName.SPACEBEFORE, new PdfNumber(paragraph.getSpacingBefore()));
            }
            if (Float.compare(paragraph.getSpacingAfter(), 0.0f) != 0) {
                this.setAttribute(PdfName.SPACEAFTER, new PdfNumber(paragraph.getSpacingAfter()));
            }
            IPdfStructureElement parent = (IPdfStructureElement)((Object)this.getParent(true));
            PdfObject obj = parent.getAttribute(PdfName.COLOR);
            if (paragraph.getFont() != null && paragraph.getFont().getColor() != null) {
                BaseColor c = paragraph.getFont().getColor();
                this.setColorAttribute(c, obj, PdfName.COLOR);
            }
            obj = parent.getAttribute(PdfName.TEXTINDENT);
            if (Float.compare(paragraph.getFirstLineIndent(), 0.0f) != 0) {
                boolean writeIndent = true;
                if (obj instanceof PdfNumber && Float.compare(((PdfNumber)obj).floatValue(), new Float(paragraph.getFirstLineIndent()).floatValue()) == 0) {
                    writeIndent = false;
                }
                if (writeIndent) {
                    this.setAttribute(PdfName.TEXTINDENT, new PdfNumber(paragraph.getFirstLineIndent()));
                }
            }
            if ((obj = parent.getAttribute(PdfName.STARTINDENT)) instanceof PdfNumber) {
                float startIndent = ((PdfNumber)obj).floatValue();
                if (Float.compare(startIndent, paragraph.getIndentationLeft()) != 0) {
                    this.setAttribute(PdfName.STARTINDENT, new PdfNumber(paragraph.getIndentationLeft()));
                }
            } else if (Math.abs(paragraph.getIndentationLeft()) > Float.MIN_VALUE) {
                this.setAttribute(PdfName.STARTINDENT, new PdfNumber(paragraph.getIndentationLeft()));
            }
            obj = parent.getAttribute(PdfName.ENDINDENT);
            if (obj instanceof PdfNumber) {
                float endIndent = ((PdfNumber)obj).floatValue();
                if (Float.compare(endIndent, paragraph.getIndentationRight()) != 0) {
                    this.setAttribute(PdfName.ENDINDENT, new PdfNumber(paragraph.getIndentationRight()));
                }
            } else if (Float.compare(paragraph.getIndentationRight(), 0.0f) != 0) {
                this.setAttribute(PdfName.ENDINDENT, new PdfNumber(paragraph.getIndentationRight()));
            }
            this.setTextAlignAttribute(paragraph.getAlignment());
        }
    }

    private void writeAttributes(List list) {
        if (list != null) {
            PdfObject obj;
            this.setAttribute(PdfName.O, PdfName.LIST);
            if (list.isAutoindent()) {
                if (list.isNumbered()) {
                    if (list.isLettered()) {
                        if (list.isLowercase()) {
                            this.setAttribute(PdfName.LISTNUMBERING, PdfName.LOWERROMAN);
                        } else {
                            this.setAttribute(PdfName.LISTNUMBERING, PdfName.UPPERROMAN);
                        }
                    } else {
                        this.setAttribute(PdfName.LISTNUMBERING, PdfName.DECIMAL);
                    }
                } else if (list.isLettered()) {
                    if (list.isLowercase()) {
                        this.setAttribute(PdfName.LISTNUMBERING, PdfName.LOWERALPHA);
                    } else {
                        this.setAttribute(PdfName.LISTNUMBERING, PdfName.UPPERALPHA);
                    }
                }
            }
            if ((obj = this.parent.getAttribute(PdfName.STARTINDENT)) instanceof PdfNumber) {
                float startIndent = ((PdfNumber)obj).floatValue();
                if (Float.compare(startIndent, list.getIndentationLeft()) != 0) {
                    this.setAttribute(PdfName.STARTINDENT, new PdfNumber(list.getIndentationLeft()));
                }
            } else if (Math.abs(list.getIndentationLeft()) > Float.MIN_VALUE) {
                this.setAttribute(PdfName.STARTINDENT, new PdfNumber(list.getIndentationLeft()));
            }
            obj = this.parent.getAttribute(PdfName.ENDINDENT);
            if (obj instanceof PdfNumber) {
                float endIndent = ((PdfNumber)obj).floatValue();
                if (Float.compare(endIndent, list.getIndentationRight()) != 0) {
                    this.setAttribute(PdfName.ENDINDENT, new PdfNumber(list.getIndentationRight()));
                }
            } else if (Float.compare(list.getIndentationRight(), 0.0f) != 0) {
                this.setAttribute(PdfName.ENDINDENT, new PdfNumber(list.getIndentationRight()));
            }
        }
    }

    private void writeAttributes(ListItem listItem) {
        if (listItem != null) {
            PdfObject obj = this.parent.getAttribute(PdfName.STARTINDENT);
            if (obj instanceof PdfNumber) {
                float startIndent = ((PdfNumber)obj).floatValue();
                if (Float.compare(startIndent, listItem.getIndentationLeft()) != 0) {
                    this.setAttribute(PdfName.STARTINDENT, new PdfNumber(listItem.getIndentationLeft()));
                }
            } else if (Math.abs(listItem.getIndentationLeft()) > Float.MIN_VALUE) {
                this.setAttribute(PdfName.STARTINDENT, new PdfNumber(listItem.getIndentationLeft()));
            }
            obj = this.parent.getAttribute(PdfName.ENDINDENT);
            if (obj instanceof PdfNumber) {
                float endIndent = ((PdfNumber)obj).floatValue();
                if (Float.compare(endIndent, listItem.getIndentationRight()) != 0) {
                    this.setAttribute(PdfName.ENDINDENT, new PdfNumber(listItem.getIndentationRight()));
                }
            } else if (Float.compare(listItem.getIndentationRight(), 0.0f) != 0) {
                this.setAttribute(PdfName.ENDINDENT, new PdfNumber(listItem.getIndentationRight()));
            }
        }
    }

    private void writeAttributes(ListBody listBody) {
        if (listBody != null) {
            // empty if block
        }
    }

    private void writeAttributes(ListLabel listLabel) {
        if (listLabel != null) {
            PdfObject obj = this.parent.getAttribute(PdfName.STARTINDENT);
            if (obj instanceof PdfNumber) {
                float startIndent = ((PdfNumber)obj).floatValue();
                if (Float.compare(startIndent, listLabel.getIndentation()) != 0) {
                    this.setAttribute(PdfName.STARTINDENT, new PdfNumber(listLabel.getIndentation()));
                }
            } else if (Math.abs(listLabel.getIndentation()) > Float.MIN_VALUE) {
                this.setAttribute(PdfName.STARTINDENT, new PdfNumber(listLabel.getIndentation()));
            }
        }
    }

    private void writeAttributes(PdfPTable table) {
        if (table != null) {
            if (Float.compare(table.getSpacingBefore(), 0.0f) != 0) {
                this.setAttribute(PdfName.SPACEBEFORE, new PdfNumber(table.getSpacingBefore()));
            }
            if (Float.compare(table.getSpacingAfter(), 0.0f) != 0) {
                this.setAttribute(PdfName.SPACEAFTER, new PdfNumber(table.getSpacingAfter()));
            }
            if (table.getTotalHeight() > 0.0f) {
                this.setAttribute(PdfName.HEIGHT, new PdfNumber(table.getTotalHeight()));
            }
            if (table.getTotalWidth() > 0.0f) {
                this.setAttribute(PdfName.WIDTH, new PdfNumber(table.getTotalWidth()));
            }
        }
    }

    private void writeAttributes(PdfPRow row) {
        if (row != null) {
            this.setAttribute(PdfName.O, PdfName.TABLE);
        }
    }

    private void writeAttributes(PdfPCell cell) {
        if (cell != null) {
            this.setAttribute(PdfName.O, PdfName.TABLE);
            if (cell.getColspan() != 1) {
                this.setAttribute(PdfName.COLSPAN, new PdfNumber(cell.getColspan()));
            }
            if (cell.getRowspan() != 1) {
                this.setAttribute(PdfName.ROWSPAN, new PdfNumber(cell.getRowspan()));
            }
            if (cell.getHeaders() != null) {
                PdfArray headers = new PdfArray();
                ArrayList<PdfPHeaderCell> list = cell.getHeaders();
                for (PdfPHeaderCell header : list) {
                    if (header.getName() == null) continue;
                    headers.add(new PdfString(header.getName()));
                }
                if (!headers.isEmpty()) {
                    this.setAttribute(PdfName.HEADERS, headers);
                }
            }
            if (cell.getFixedHeight() > 0.0f) {
                this.setAttribute(PdfName.HEIGHT, new PdfNumber(cell.getFixedHeight()));
            }
            if (cell.getWidth() > 0.0f) {
                this.setAttribute(PdfName.WIDTH, new PdfNumber(cell.getWidth()));
            }
            if (cell.getBackgroundColor() != null) {
                BaseColor color = cell.getBackgroundColor();
                this.setAttribute(PdfName.BACKGROUNDCOLOR, new PdfArray(new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f}));
            }
        }
    }

    private void writeAttributes(PdfPHeaderCell headerCell) {
        if (headerCell != null) {
            if (headerCell.getScope() != 0) {
                switch (headerCell.getScope()) {
                    case 1: {
                        this.setAttribute(PdfName.SCOPE, PdfName.ROW);
                        break;
                    }
                    case 2: {
                        this.setAttribute(PdfName.SCOPE, PdfName.COLUMN);
                        break;
                    }
                    case 3: {
                        this.setAttribute(PdfName.SCOPE, PdfName.BOTH);
                    }
                }
            }
            if (headerCell.getName() != null) {
                this.setAttribute(PdfName.NAME, new PdfName(headerCell.getName()));
            }
            this.writeAttributes((PdfPCell)headerCell);
        }
    }

    private void writeAttributes(PdfPTableHeader header) {
        if (header != null) {
            this.setAttribute(PdfName.O, PdfName.TABLE);
        }
    }

    private void writeAttributes(PdfPTableBody body) {
        if (body != null) {
            // empty if block
        }
    }

    private void writeAttributes(PdfPTableFooter footer) {
        if (footer != null) {
            // empty if block
        }
    }

    private void writeAttributes(PdfDiv div) {
        if (div != null) {
            if (div.getBackgroundColor() != null) {
                this.setColorAttribute(div.getBackgroundColor(), null, PdfName.BACKGROUNDCOLOR);
            }
            this.setTextAlignAttribute(div.getTextAlignment());
        }
    }

    private void writeAttributes(Document document) {
        if (document != null) {
            // empty if block
        }
    }

    private boolean colorsEqual(PdfArray parentColor, float[] color) {
        if (Float.compare(color[0], parentColor.getAsNumber(0).floatValue()) != 0) {
            return false;
        }
        if (Float.compare(color[1], parentColor.getAsNumber(1).floatValue()) != 0) {
            return false;
        }
        return Float.compare(color[2], parentColor.getAsNumber(2).floatValue()) == 0;
    }

    private void setColorAttribute(BaseColor newColor, PdfObject oldColor, PdfName attributeName) {
        float[] colorArr = new float[]{(float)newColor.getRed() / 255.0f, (float)newColor.getGreen() / 255.0f, (float)newColor.getBlue() / 255.0f};
        if (oldColor != null && oldColor instanceof PdfArray) {
            PdfArray oldC = (PdfArray)oldColor;
            if (this.colorsEqual(oldC, colorArr)) {
                this.setAttribute(attributeName, new PdfArray(colorArr));
            } else {
                this.setAttribute(attributeName, new PdfArray(colorArr));
            }
        } else {
            this.setAttribute(attributeName, new PdfArray(colorArr));
        }
    }

    private void setTextAlignAttribute(int elementAlign) {
        PdfName align = null;
        switch (elementAlign) {
            case 0: {
                align = PdfName.START;
                break;
            }
            case 1: {
                align = PdfName.CENTER;
                break;
            }
            case 2: {
                align = PdfName.END;
                break;
            }
            case 3: {
                align = PdfName.JUSTIFY;
            }
        }
        PdfObject obj = this.parent.getAttribute(PdfName.TEXTALIGN);
        if (obj instanceof PdfName) {
            PdfName textAlign = (PdfName)obj;
            if (align != null && !textAlign.equals(align)) {
                this.setAttribute(PdfName.TEXTALIGN, align);
            }
        } else if (align != null && !PdfName.START.equals(align)) {
            this.setAttribute(PdfName.TEXTALIGN, align);
        }
    }

    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        PdfWriter.checkPdfIsoConformance(writer, 16, this);
        super.toPdf(writer, os);
    }
}

