/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.GeoLocation;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.GpsDirectory;
import java.text.DecimalFormat;

public class GpsDescriptor
extends TagDescriptor<GpsDirectory> {
    public GpsDescriptor(@NotNull GpsDirectory gpsDirectory) {
        super(gpsDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 0: {
                return this.getGpsVersionIdDescription();
            }
            case 6: {
                return this.getGpsAltitudeDescription();
            }
            case 5: {
                return this.getGpsAltitudeRefDescription();
            }
            case 9: {
                return this.getGpsStatusDescription();
            }
            case 10: {
                return this.getGpsMeasureModeDescription();
            }
            case 12: {
                return this.getGpsSpeedRefDescription();
            }
            case 14: 
            case 16: 
            case 23: {
                return this.getGpsDirectionReferenceDescription(n);
            }
            case 15: 
            case 17: 
            case 24: {
                return this.getGpsDirectionDescription(n);
            }
            case 25: {
                return this.getGpsDestinationReferenceDescription();
            }
            case 7: {
                return this.getGpsTimeStampDescription();
            }
            case 4: {
                return this.getGpsLongitudeDescription();
            }
            case 2: {
                return this.getGpsLatitudeDescription();
            }
            case 30: {
                return this.getGpsDifferentialDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    private String getGpsVersionIdDescription() {
        return GpsDescriptor.convertBytesToVersionString(((GpsDirectory)this._directory).getIntArray(0), 1);
    }

    @Nullable
    public String getGpsLatitudeDescription() {
        GeoLocation geoLocation = ((GpsDirectory)this._directory).getGeoLocation();
        if (geoLocation == null) {
            return null;
        }
        return GeoLocation.decimalToDegreesMinutesSecondsString(geoLocation.getLatitude());
    }

    @Nullable
    public String getGpsLongitudeDescription() {
        GeoLocation geoLocation = ((GpsDirectory)this._directory).getGeoLocation();
        if (geoLocation == null) {
            return null;
        }
        return GeoLocation.decimalToDegreesMinutesSecondsString(geoLocation.getLongitude());
    }

    @Nullable
    public String getGpsTimeStampDescription() {
        int[] nArray = ((GpsDirectory)this._directory).getIntArray(7);
        if (nArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(nArray[0]);
        stringBuilder.append(":");
        stringBuilder.append(nArray[1]);
        stringBuilder.append(":");
        stringBuilder.append(nArray[2]);
        stringBuilder.append(" UTC");
        return stringBuilder.toString();
    }

    @Nullable
    public String getGpsDestinationReferenceDescription() {
        String string = ((GpsDirectory)this._directory).getString(25);
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ("K".equalsIgnoreCase(string2)) {
            return "kilometers";
        }
        if ("M".equalsIgnoreCase(string2)) {
            return "miles";
        }
        if ("N".equalsIgnoreCase(string2)) {
            return "knots";
        }
        return "Unknown (" + string2 + ")";
    }

    @Nullable
    public String getGpsDirectionDescription(int n) {
        String string;
        Rational rational = ((GpsDirectory)this._directory).getRational(n);
        String string2 = string = rational != null ? new DecimalFormat("0.##").format(rational.doubleValue()) : ((GpsDirectory)this._directory).getString(n);
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        return string.trim() + " degrees";
    }

    @Nullable
    public String getGpsDirectionReferenceDescription(int n) {
        String string = ((GpsDirectory)this._directory).getString(n);
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ("T".equalsIgnoreCase(string2)) {
            return "True direction";
        }
        if ("M".equalsIgnoreCase(string2)) {
            return "Magnetic direction";
        }
        return "Unknown (" + string2 + ")";
    }

    @Nullable
    public String getGpsSpeedRefDescription() {
        String string = ((GpsDirectory)this._directory).getString(12);
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ("K".equalsIgnoreCase(string2)) {
            return "kph";
        }
        if ("M".equalsIgnoreCase(string2)) {
            return "mph";
        }
        if ("N".equalsIgnoreCase(string2)) {
            return "knots";
        }
        return "Unknown (" + string2 + ")";
    }

    @Nullable
    public String getGpsMeasureModeDescription() {
        String string = ((GpsDirectory)this._directory).getString(10);
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ("2".equalsIgnoreCase(string2)) {
            return "2-dimensional measurement";
        }
        if ("3".equalsIgnoreCase(string2)) {
            return "3-dimensional measurement";
        }
        return "Unknown (" + string2 + ")";
    }

    @Nullable
    public String getGpsStatusDescription() {
        String string = ((GpsDirectory)this._directory).getString(9);
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ("A".equalsIgnoreCase(string2)) {
            return "Active (Measurement in progress)";
        }
        if ("V".equalsIgnoreCase(string2)) {
            return "Void (Measurement Interoperability)";
        }
        return "Unknown (" + string2 + ")";
    }

    @Nullable
    public String getGpsAltitudeRefDescription() {
        Integer n = ((GpsDirectory)this._directory).getInteger(5);
        if (n == null) {
            return null;
        }
        if (n == 0) {
            return "Sea level";
        }
        if (n == 1) {
            return "Below sea level";
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getGpsAltitudeDescription() {
        Rational rational = ((GpsDirectory)this._directory).getRational(6);
        if (rational == null) {
            return null;
        }
        return rational.intValue() + " metres";
    }

    @Nullable
    public String getGpsDifferentialDescription() {
        Integer n = ((GpsDirectory)this._directory).getInteger(30);
        if (n == null) {
            return null;
        }
        if (n == 0) {
            return "No Correction";
        }
        if (n == 1) {
            return "Differential Corrected";
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getDegreesMinutesSecondsDescription() {
        GeoLocation geoLocation = ((GpsDirectory)this._directory).getGeoLocation();
        if (geoLocation == null) {
            return null;
        }
        return geoLocation.toDMSString();
    }
}

