/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.pds.tools.util;

import gov.nasa.arc.pds.tools.container.FileMirror;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Pattern;

public class FileUtils {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = ONE_KB * ONE_KB;
    public static final long ONE_GB = ONE_KB * ONE_MB;
    public static final long ONE_TB = ONE_KB * ONE_GB;
    public static final long ONE_PB = ONE_KB * ONE_TB;
    public static final String OPPOSITE_SEP_CHAR = File.separator.equals("/") ? "\\\\" : "/";
    public static final String REGEX_SAFE_SEP = File.separator.equals("/") ? "/" : "\\\\";

    public static boolean containsFile(File sourceFile, String searchName) {
        File testFile = new File(sourceFile, searchName);
        return FileUtils.exists(testFile);
    }

    public static List<File> getFiles(File sourceFile) {
        return FileUtils.getFiles(sourceFile, null, true);
    }

    public static List<File> getFiles(File sourceFile, String searchPattern) {
        return FileUtils.getFiles(sourceFile, searchPattern, true);
    }

    public static List<File> getFiles(File sourceFile, String regex, boolean recursive) {
        Pattern searchPattern = null;
        if (regex != null) {
            searchPattern = Pattern.compile(regex, 2);
        }
        return FileUtils.getFilesByPattern(sourceFile, searchPattern, recursive);
    }

    public static List<File> getFilesByPattern(File sourceFile, Pattern searchPattern, boolean recursive) {
        boolean doSearch;
        if (!sourceFile.exists()) {
            throw new RuntimeException("File \"" + sourceFile.toString() + "\" was not found.");
        }
        Stack<File> dirStack = new Stack<File>();
        ArrayList<File> foundFiles = new ArrayList<File>();
        boolean bl = doSearch = searchPattern != null;
        if (!FileUtils.isSourceControl(sourceFile)) {
            if (sourceFile.isDirectory()) {
                dirStack.push(sourceFile);
            }
            if (doSearch) {
                if (searchPattern.matcher(sourceFile.getName()).matches()) {
                    foundFiles.add(sourceFile);
                }
            } else {
                foundFiles.add(sourceFile);
            }
        }
        while (!dirStack.empty()) {
            File curDir = (File)dirStack.pop();
            File[] tempFiles = curDir.listFiles();
            if (tempFiles == null) continue;
            for (File curFile : tempFiles) {
                if (FileUtils.isSourceControl(curFile)) continue;
                if (recursive && curFile.isDirectory()) {
                    dirStack.push(curFile);
                }
                if (doSearch) {
                    if (!searchPattern.matcher(curFile.getName()).matches()) continue;
                    foundFiles.add(curFile);
                    continue;
                }
                foundFiles.add(curFile);
            }
        }
        return foundFiles;
    }

    public static File getTopFileByPattern(File sourceFile, String regex, Integer maxDepth) {
        Pattern searchPattern = Pattern.compile(regex, 2);
        return FileUtils.getTopFileByPattern(sourceFile, searchPattern, maxDepth);
    }

    public static File getTopFileByPattern(File sourceFile, Pattern searchPattern, Integer maxDepth) {
        Stack<File> dirStack = new Stack<File>();
        dirStack.push(sourceFile);
        int curDepth = 0;
        while (!(dirStack.empty() || maxDepth != null && curDepth >= maxDepth)) {
            ++curDepth;
            File curDir = (File)dirStack.pop();
            File[] tempFiles = curDir.listFiles();
            if (tempFiles == null) continue;
            for (File curFile : tempFiles) {
                if (searchPattern.matcher(curFile.getName()).matches()) {
                    return curFile;
                }
                if (!curFile.isDirectory()) continue;
                dirStack.push(curFile);
            }
        }
        return null;
    }

    public static List<File> getFiles(List<File> sourceList, String regex) {
        ArrayList<File> matchingFiles = new ArrayList<File>();
        Pattern searchPattern = Pattern.compile(regex, 2);
        for (File curFile : sourceList) {
            if (!searchPattern.matcher(curFile.getName()).matches()) continue;
            matchingFiles.add(curFile);
        }
        return matchingFiles;
    }

    public static Map<Integer, File> getFileMap(File sourceFile) {
        return FileUtils.getFileMap(sourceFile, null, true);
    }

    public static Map<Integer, File> getFileMap(File sourceFile, String searchPattern) {
        return FileUtils.getFileMap(sourceFile, searchPattern, true);
    }

    public static Map<Integer, File> getFileMap(File sourceFile, String regex, boolean recursive) {
        Pattern searchPattern = null;
        if (regex != null) {
            searchPattern = Pattern.compile(regex, 2);
        }
        return FileUtils.getFileMapByPattern(sourceFile, searchPattern, recursive, true);
    }

    public static Map<Integer, File> getFileMapByPattern(File sourceFile, Pattern searchPattern, boolean recursive, boolean excludeSourceControlFiles) {
        if (!sourceFile.exists()) {
            throw new RuntimeException("File \"" + sourceFile.toString() + "\" was not found.");
        }
        Stack<File> dirStack = new Stack<File>();
        HashMap<Integer, File> foundFiles = new HashMap<Integer, File>();
        boolean doSearch = searchPattern != null;
        FileUtils.conditionalAddFile(sourceFile, dirStack, foundFiles, searchPattern, doSearch, true, excludeSourceControlFiles);
        while (!dirStack.empty()) {
            File[] tempFiles;
            File curDir = dirStack.pop();
            for (File curFile : tempFiles = curDir.listFiles()) {
                FileUtils.conditionalAddFile(curFile, dirStack, foundFiles, searchPattern, doSearch, recursive, excludeSourceControlFiles);
            }
        }
        return foundFiles;
    }

    private static void conditionalAddFile(File curFile, Stack<File> dirStack, Map<Integer, File> foundFiles, Pattern searchPattern, boolean doSearch, boolean recursive, boolean excludeSourceControlFiles) {
        if (recursive && curFile.isDirectory() && (!excludeSourceControlFiles || !FileUtils.isSourceControl(curFile))) {
            dirStack.push(curFile);
        }
        if (doSearch) {
            boolean matches = searchPattern.matcher(curFile.getName()).matches();
            if (!(!matches || excludeSourceControlFiles && FileUtils.isSourceControl(curFile))) {
                foundFiles.put(curFile.hashCode(), curFile);
            }
        } else if (!excludeSourceControlFiles || !FileUtils.isSourceControl(curFile)) {
            foundFiles.put(curFile.hashCode(), curFile);
        }
    }

    public static Map<Integer, File> getFileMap(Map<Integer, File> sourceList, String regex) {
        HashMap<Integer, File> matchingFiles = new HashMap<Integer, File>();
        Pattern searchPattern = Pattern.compile(regex, 2);
        for (Map.Entry<Integer, File> entry : sourceList.entrySet()) {
            File file = entry.getValue();
            if (!searchPattern.matcher(file.getName()).matches()) continue;
            matchingFiles.put(file.hashCode(), file);
        }
        return matchingFiles;
    }

    public static String getContents(File file) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        byte[] buf = new byte[(int)file.length()];
        stream.read(buf);
        stream.close();
        String contents = new String(buf, "utf-8");
        return contents;
    }

    public static File getBaseFile(File file) {
        if (file.isFile()) {
            return file.getParentFile();
        }
        if (file.isDirectory() || FileUtils.getExtension(file).equals("")) {
            return file;
        }
        return file.getParentFile();
    }

    public static File getValidParent(File missingFile) {
        String curPath = missingFile.getAbsolutePath();
        while (curPath != null) {
            File curFile = new File(curPath);
            if (FileUtils.exists(curFile)) {
                return curFile;
            }
            curPath = curFile.getParent();
        }
        return null;
    }

    public static String getRelativePath(File baseDirectory, File targetFile) {
        if (baseDirectory == null) {
            return targetFile.toString();
        }
        if (baseDirectory.equals(targetFile)) {
            return "";
        }
        String basePath = baseDirectory.getAbsolutePath();
        String fullPath = targetFile.getAbsolutePath();
        return FileUtils.getRelativePath(basePath, fullPath);
    }

    public static String getRelativePath(URL baseDirectory, URL targetFile) {
        if (baseDirectory.equals(targetFile)) {
            return "";
        }
        String basePath = baseDirectory.toString();
        String fullPath = targetFile.toString();
        return FileUtils.getRelativePath(basePath, fullPath);
    }

    public static String getRelativePath(String basePath, String fullPath) {
        if (basePath.equals(fullPath)) {
            return "";
        }
        String normalBasePath = basePath.replaceAll(OPPOSITE_SEP_CHAR, REGEX_SAFE_SEP);
        String normalFullPath = fullPath.replaceAll(OPPOSITE_SEP_CHAR, REGEX_SAFE_SEP);
        if (normalFullPath.indexOf(normalBasePath) == -1) {
            throw new RuntimeException("target file '" + normalFullPath + "' is not a child of provided base directory '" + normalBasePath + "'.");
        }
        if (normalFullPath.equals(normalBasePath)) {
            return "";
        }
        return normalFullPath.substring(normalBasePath.length() + 1, normalFullPath.length());
    }

    public static String getExtension(String name) {
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex != -1) {
            return name.substring(dotIndex + 1, name.length());
        }
        return "";
    }

    public static String getExtension(File file) {
        String name = file.getName();
        return FileUtils.getExtension(name);
    }

    public static String getBaseName(File file) {
        String name = file.getName();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex != -1) {
            return name.substring(0, dotIndex);
        }
        return name;
    }

    public static boolean isParent(File parent, File searchFile) {
        if (parent.equals(searchFile)) {
            return true;
        }
        if (!parent.isDirectory()) {
            return false;
        }
        String parentPath = parent.getPath() + File.separator;
        String searchPath = searchFile.getParent() + File.separator;
        return searchPath.startsWith(parentPath);
    }

    public static boolean isParent(FileMirror parent, FileMirror searchFile) {
        if (parent.equals(searchFile)) {
            return true;
        }
        if (!parent.isDirectory().booleanValue()) {
            return false;
        }
        if (parent.getRelativePath().equals("")) {
            return true;
        }
        String parentPath = parent.getRelativePath() + File.separator;
        String searchPath = searchFile.getParent() + File.separator;
        return searchPath.startsWith(parentPath);
    }

    public static boolean hasParent(List<File> parents, File searchFile) {
        for (File parent : parents) {
            if (!FileUtils.isParent(parent, searchFile)) continue;
            return true;
        }
        return false;
    }

    public static String fromVaxPath(String vaxPath) {
        String returnString = vaxPath.replaceAll("(\\[.*)(\\.)(.*\\].*)", "$1" + FileUtils.getRegexSeparator() + "$3");
        returnString = returnString.replaceAll("\\[(.*)\\](.*)", "$1" + FileUtils.getRegexSeparator() + "$2");
        return returnString;
    }

    public static String getRegexSeparator() {
        if (File.separator.equals("\\")) {
            return "\\\\";
        }
        return File.separator;
    }

    public static File getSibling(String fileName, File knownFile) {
        File knownDir = FileUtils.getBaseFile(knownFile);
        File foundFile = new File(knownDir, fileName);
        return foundFile;
    }

    public static boolean exists(File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            String name = file.getName();
            String conName = file.getCanonicalFile().getName();
            if (name.equals(conName)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static Properties loadProperties(File file) {
        return FileUtils.loadProperties(new Properties(), file);
    }

    public static Properties loadProperties(Properties props, File file) {
        FileInputStream is = null;
        boolean success = false;
        try {
            is = new FileInputStream(file);
            props.load(is);
            is.close();
            success = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.close(is, success);
        }
        return props;
    }

    public static void close(Closeable closeMe, boolean reThrowExceptions) {
        block3: {
            if (closeMe != null) {
                try {
                    closeMe.close();
                }
                catch (Throwable t) {
                    if (!reThrowExceptions) break block3;
                    throw new RuntimeException(t);
                }
            }
        }
    }

    public static File getCaseUnknownFile(File rootFile, String searchName) {
        File file = new File(rootFile, searchName);
        if (!FileUtils.exists(file)) {
            file = FileUtils.getAlternateCaseFile(rootFile, searchName);
        }
        return file;
    }

    public static File getAlternateCaseFile(File rootFile, String searchName) {
        Character character = Character.valueOf(searchName.charAt(0));
        File file = null;
        file = Character.isLowerCase(character.charValue()) ? new File(rootFile, searchName.toUpperCase()) : new File(rootFile, searchName.toLowerCase());
        return file;
    }

    public static void deleteChildren(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File curFile : files = file.listFiles()) {
                curFile.delete();
            }
        }
    }

    public static boolean forceDeleteAll(File file) {
        boolean tempVal = true;
        if (file.isDirectory()) {
            File[] files;
            for (File curFil : files = file.listFiles()) {
                tempVal = tempVal && FileUtils.forceDeleteAll(curFil);
            }
        }
        if (file.exists()) {
            return file.delete() && tempVal;
        }
        return false;
    }

    public static boolean empty(File directory) {
        if (!directory.isDirectory()) {
            throw new RuntimeException("File \"" + directory.toString() + "\" is not a directory");
        }
        File[] files = directory.listFiles();
        if (files.length == 0) {
            return true;
        }
        return files.length == 1 && files[0].getName().equals(".svn");
    }

    public static boolean isSourceControl(File file) {
        return file.getName().equals(".svn");
    }

    public static String getSafeName(String string) {
        if (string == null) {
            return null;
        }
        String out = string.trim();
        out = out.replaceAll("/[^a-zA-Z0-9\\-_]/", "");
        return out;
    }
}

