/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.table;

import gov.nasa.pds.objectAccess.table.FieldAdapter;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitFieldAdapter
implements FieldAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitFieldAdapter.class);
    private static final String NOT_SUPPORTED = "Operation not supported yet.";
    private static final long LONG_ALL_BITS_ONE = -1L;
    private boolean isSigned;

    public BitFieldAdapter(boolean isSigned) {
        this.isSigned = isSigned;
    }

    @Override
    public String getString(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return Long.toString(this.getFieldValue(buf, offset, length, startBit, stopBit));
    }

    @Override
    public String getString(byte[] buf, int offset, int length, int startBit, int stopBit, Charset charset) {
        return Long.toString(this.getFieldValue(buf, offset, length, startBit, stopBit));
    }

    @Override
    public byte getByte(byte[] buf, int offset, int length, int startBit, int stopBit) {
        long value = this.getFieldValue(buf, offset, length, startBit, stopBit);
        if (value < -128L || value > 127L) {
            String msg = "Binary integer value out of range for byte (" + value + ")";
            LOGGER.error(msg);
            throw new NumberFormatException();
        }
        return (byte)value;
    }

    @Override
    public short getShort(byte[] buf, int offset, int length, int startBit, int stopBit) {
        long value = this.getFieldValue(buf, offset, length, startBit, stopBit);
        if (value < -32768L || value > 32767L) {
            String msg = "Binary integer value out of range for short (" + value + ")";
            LOGGER.error(msg);
            throw new NumberFormatException(msg);
        }
        return (short)value;
    }

    @Override
    public int getInt(byte[] buf, int offset, int length, int startBit, int stopBit) {
        long value = this.getFieldValue(buf, offset, length, startBit, stopBit);
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            String msg = "Binary integer value out of range for int (" + value + ")";
            LOGGER.error(msg);
            throw new NumberFormatException(msg);
        }
        return (int)value;
    }

    @Override
    public long getLong(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return this.getFieldValue(buf, offset, length, startBit, stopBit);
    }

    @Override
    public float getFloat(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return this.getFieldValue(buf, offset, length, startBit, stopBit);
    }

    @Override
    public double getDouble(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return this.getFieldValue(buf, offset, length, startBit, stopBit);
    }

    @Override
    public void setString(String value, int offset, int length, ByteBuffer buf, boolean isRightJustifed) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setString(String value, int offset, int length, ByteBuffer buffer, boolean isRightJustifed, Charset charset) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setInt(int value, int offset, int length, ByteBuffer buffer, boolean isRightJustifed) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setDouble(double value, int offset, int length, ByteBuffer buffer, boolean isRightJustifed) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setFloat(float value, int offset, int length, ByteBuffer buffer, boolean isRightJustifed) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setShort(short value, int offset, int length, ByteBuffer buffer, boolean isRightJustifed) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setByte(byte value, int offset, int length, ByteBuffer buffer, boolean isRightJustifed) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setLong(long value, int offset, int length, ByteBuffer buffer, boolean isRightJustifed) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    private long getFieldValue(byte[] b, int offset, int length, int startBit, int stopBit) {
        if (startBit < 0) {
            String msg = "Start bit is negative (" + startBit + ")";
            LOGGER.error(msg);
            throw new ArrayIndexOutOfBoundsException(msg);
        }
        if (stopBit >= length * 8) {
            String msg = "Stop bit past end of packed field (" + stopBit + " > " + (length * 8 - 1) + ")";
            LOGGER.error(msg);
            throw new ArrayIndexOutOfBoundsException(msg);
        }
        if (stopBit - startBit + 1 > 64) {
            String msg = "Bit field is wider than long (" + (stopBit - startBit + 1) + " > " + 64 + ")";
            LOGGER.error(msg);
            throw new IllegalArgumentException(msg);
        }
        int stopByte = stopBit / 8;
        int startByte = startBit / 8;
        if (stopByte - startByte + 1 > 8) {
            String msg = "Bit field spans bytes that are wider than a long (" + (stopByte - startByte + 1) + " > " + 8 + ")";
            LOGGER.error(msg);
            throw new NumberFormatException(msg);
        }
        long bytesValue = BitFieldAdapter.getBytesAsLong(b, offset, startByte, stopByte);
        int extraRightBits = (stopByte + 1) * 8 - stopBit - 1;
        long shiftedValue = bytesValue >> extraRightBits;
        return BitFieldAdapter.rightmostBits(shiftedValue, stopBit - startBit + 1, this.isSigned);
    }

    static long rightmostBits(long value, int nBits, boolean isSigned) {
        long signBit;
        long mask = 0L;
        if (nBits > 0) {
            mask = -1L >>> 64 - nBits;
        }
        long maskedValue = value & mask;
        if (isSigned && nBits < 64 && (maskedValue & (signBit = 1L << nBits - 1)) != 0L) {
            maskedValue |= -1L << nBits;
        }
        return maskedValue;
    }

    static long getBytesAsLong(byte[] source, int off, int startByte, int stopByte) {
        long value = 0L;
        for (int i = off + startByte; i <= off + stopByte; ++i) {
            value = value << 8 | (long)(source[i] & 0xFF);
        }
        return value;
    }

    @Override
    public BigInteger getBigInteger(byte[] buf, int offset, int length, int startBit, int stopBit) {
        String stringValue = Long.toString(this.getLong(buf, offset, length, startBit, stopBit));
        return new BigInteger(stringValue);
    }

    @Override
    public void setBigInteger(BigInteger value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        String stringValue = value.toString();
        this.setLong(Long.parseLong(stringValue), offset, length, buffer, isRightJustified);
    }
}

