/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.anttasks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateJnlpFileTask
extends Task {
    private File destFile;
    private File destDir;
    private File template;
    private File properties;
    private Path lazyJars;
    public static final String EXTERNAL_JARS_PROP = "jar.files.to.include.through.external.jnlp";
    public static final String EXTERNAL_JNLPS_PROP = "external.jnlp.component.names";
    public static final String EXTERNAL_PROP_DELIMITER = ";";
    private static final String EXT_RESOURCE_PROPNAME_PREFIX = "jnlp.ext.resource.";
    private static String[] EXT_RESOURCE_SUFFIXES = new String[]{"href", "name", "version"};
    private static String[] EXT_RESOURCE_SUFFIXES_REQUIRED = new String[]{"href"};
    private static final String APPLET_PARAM_PROPNAME_PREFIX = "jnlp.applet.param.";
    private static String[] APPLET_PARAM_SUFFIXES = new String[]{"name", "value"};
    private static final String DEFAULT_JNLP_CODEBASE = "${jnlp.codebase}";
    private static final String DEFAULT_JNLP_FILENAME = "launch.jnlp";
    private static final String DEFAULT_APPLICATION_TITLE = "${APPLICATION.TITLE}";
    private static final String DEFAULT_APPLICATION_VENDOR = "${APPLICATION.VENDOR}";
    private static final String DEFAULT_APPLICATION_HOMEPAGE = "${APPLICATION.HOMEPAGE}";
    private static final String DEFAULT_APPLICATION_DESC = "${APPLICATION.DESC}";
    private static final String DEFAULT_APPLICATION_DESC_SHORT = "${APPLICATION.DESC.SHORT}";
    private static final String DEFAULT_JNLP_ICON = "${JNLP.ICONS}";
    private static final String DEFAULT_JNLP_OFFLINE = "${JNLP.OFFLINE.ALLOWED}";
    private static final String JNLP_UPDATE = "${JNLP.UPDATE}";
    private static final String DEFAULT_JNLP_SECURITY = "${JNLP.SECURITY}";
    private static final String DEFAULT_JNLP_RESOURCES_RUNTIME = "${JNLP.RESOURCES.RUNTIME}";
    private static final String DEFAULT_JNLP_RESOURCES_MAIN_JAR = "${JNLP.RESOURCES.MAIN.JAR}";
    private static final String DEFAULT_JNLP_RESOURCES_JARS = "${JNLP.RESOURCES.JARS}";
    private static final String DEFAULT_JNLP_RESOURCES_EXTENSIONS = "${JNLP.RESOURCES.EXTENSIONS}";
    private static final String DEFAULT_JNLP_MAIN_CLASS = "${jnlp.main.class}";
    private static final String DEFAULT_JNLP_APPLICATION_ARGS = "${JNLP.APPLICATION.ARGS}";
    private static final String DEFAULT_JNLP_APPLET_PARAMS = "${JNLP.APPLET.PARAMS}";
    private static final String DEFAULT_JNLP_APPLET_WIDTH = "${jnlp.applet.width}";
    private static final String DEFAULT_JNLP_APPLET_HEIGHT = "${jnlp.applet.height}";
    private static final String JNLP_LAZY_FORMAT = "jnlp.lazy.jar.%s";
    private static final String DESC_APPLICATION = "application-desc";
    private static final String DESC_APPLET = "applet-desc";
    private static final String DESC_COMPONENT = "component-desc";
    private static final String DESC_INSTALLER = "installer-desc";

    public void setDestfile(File file) {
        this.destFile = file;
    }

    public void setDestDir(File dir) {
        this.destDir = dir;
    }

    public void setTemplate(File file) {
        this.template = file;
    }

    public void setLazyJars(Path lazyJars) {
        this.lazyJars = lazyJars;
    }

    public void setProperties(File file) {
        this.properties = file;
    }

    private Document loadTemplate(File tempFile) throws IOException {
        Document docDom = null;
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            docDom = docBuilder.parse(tempFile);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(GenerateJnlpFileTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(GenerateJnlpFileTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        return docDom;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        Document docDom = null;
        if (this.template != null) {
            try {
                docDom = this.loadTemplate(this.template);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex, this.getLocation());
            }
        }
        if (docDom == null) {
            throw new BuildException("Template file is either missing or broken XML document, cannot generate JNLP file.", this.getLocation());
        }
        this.processDocument(docDom);
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("media-type", "text/xml");
            tr.transform(new DOMSource(docDom), new StreamResult(new FileOutputStream(this.destFile)));
        }
        catch (TransformerConfigurationException ex) {
            throw new BuildException((Throwable)ex, this.getLocation());
        }
        catch (TransformerException ex) {
            throw new BuildException((Throwable)ex, this.getLocation());
        }
        catch (FileNotFoundException ex) {
            throw new BuildException((Throwable)ex, this.getLocation());
        }
    }

    private void checkParameters() {
        if (this.destFile == null) {
            throw new BuildException("Destination file is not set, jnlp file cannot be created.");
        }
        if (this.destDir == null) {
            throw new BuildException("Destination directory is not set, jnlp file cannot be created.");
        }
        if (this.template == null) {
            throw new BuildException("Template file is not set, jnlp file cannot be created.");
        }
    }

    private void processDocument(Document docDom) {
        this.processJnlpElem(docDom);
    }

    private void processJnlpElem(Document docDom) {
        Node jnlpElem = docDom.getElementsByTagName("jnlp").item(0);
        assert (jnlpElem != null);
        String specAttr = ((Element)jnlpElem).getAttribute("spec");
        String specProp = this.getProject().getProperty("jnlp.spec");
        this.log("jnlp.spec = " + specProp, 3);
        if (specProp != null && !specAttr.equals(specProp)) {
            ((Element)jnlpElem).setAttribute("spec", specProp);
        }
        String codebaseAttr = ((Element)jnlpElem).getAttribute("codebase");
        String codebaseTypeProp = this.getProject().getProperty("jnlp.codebase.type");
        String codebaseProp = null;
        if (codebaseTypeProp.equals("local")) {
            codebaseProp = this.getProject().getProperty("jnlp.local.codebase.url");
        } else if (codebaseTypeProp.equals("web")) {
            codebaseProp = this.getProject().getProperty("jnlp.codebase.url");
        } else if (codebaseTypeProp.equals("user")) {
            codebaseProp = this.getProject().getProperty("jnlp.codebase.user");
        }
        this.log("jnlp.codebase.url = " + codebaseProp, 3);
        if (codebaseAttr.equals(DEFAULT_JNLP_CODEBASE)) {
            if (codebaseTypeProp.equals("no.codebase")) {
                ((Element)jnlpElem).removeAttribute("codebase");
            } else if (codebaseProp != null) {
                ((Element)jnlpElem).setAttribute("codebase", codebaseProp);
            }
        }
        String hrefAttr = ((Element)jnlpElem).getAttribute("href");
        String jnlpFileNameProp = this.getProject().getProperty("jnlp.file.name");
        this.log("jnlp.file.name = " + jnlpFileNameProp, 3);
        if (jnlpFileNameProp != null && hrefAttr.equals(DEFAULT_JNLP_FILENAME)) {
            ((Element)jnlpElem).setAttribute("href", jnlpFileNameProp);
        }
        this.processInformationElem(docDom);
        this.processBackgroundElem(docDom, jnlpElem);
        this.processSecurityElem(docDom, jnlpElem);
        this.processResourcesElem(docDom);
        this.processDescriptorElem(docDom);
    }

    private void processInformationElem(Document docDom) {
        NodeList nodeList = docDom.getElementsByTagName("information");
        int listLen = nodeList.getLength();
        for (int j = 0; j < listLen; ++j) {
            Node informationElem = nodeList.item(j);
            assert (informationElem != null);
            NodeList childNodes = informationElem.getChildNodes();
            int len = childNodes.getLength();
            block5: for (int i = 0; i < len; ++i) {
                Node node = childNodes.item(i);
                if (node == null) continue;
                String elemName = node.getNodeName();
                String elemText = node.getTextContent();
                switch (node.getNodeType()) {
                    case 1: {
                        String descShortPropVal;
                        String titleProp;
                        if (elemName.equals("title")) {
                            titleProp = this.getProperty("application.title", "Application Title");
                            this.log("application.title = " + titleProp, 3);
                            if (!elemText.equals(DEFAULT_APPLICATION_TITLE)) continue block5;
                            node.setTextContent(titleProp);
                            continue block5;
                        }
                        if (elemName.equals("vendor")) {
                            String vendorProp = this.getProperty("application.vendor", "Application Vendor");
                            this.log("application.vendor = " + vendorProp, 3);
                            if (!elemText.equals(DEFAULT_APPLICATION_VENDOR)) continue block5;
                            node.setTextContent(vendorProp);
                            continue block5;
                        }
                        if (elemName.equals("homepage")) {
                            String hrefAttr = ((Element)node).getAttribute("href");
                            String hrefProp = this.getProperty("application.homepage", null);
                            this.log("application.homepage = " + hrefProp, 3);
                            if (!hrefAttr.equals(DEFAULT_APPLICATION_HOMEPAGE)) continue block5;
                            if (hrefProp != null) {
                                ((Element)node).setAttribute("href", hrefProp);
                                continue block5;
                            }
                            ((Element)node).setAttribute("href", "");
                            continue block5;
                        }
                        if (!elemName.equals("description")) continue block5;
                        titleProp = this.getProperty("application.title", null);
                        String descProp = this.getProperty("application.desc", null);
                        String descShortProp = this.getProperty("application.desc.short", null);
                        String descPropVal = descProp != null && !descProp.equals("") ? descProp : titleProp;
                        String string = descShortPropVal = descShortProp != null && !descShortProp.equals("") ? descShortProp : titleProp;
                        if (elemText.equals(DEFAULT_APPLICATION_DESC)) {
                            node.setTextContent(descPropVal);
                            continue block5;
                        }
                        if (!elemText.equals(DEFAULT_APPLICATION_DESC_SHORT)) continue block5;
                        node.setTextContent(descShortPropVal);
                        continue block5;
                    }
                    case 8: {
                        String nodeValue = node.getNodeValue();
                        if (nodeValue.equals(DEFAULT_JNLP_ICON)) {
                            String iconProp;
                            informationElem.removeChild(node);
                            String splashProp = this.getProperty("application.splash", null);
                            if (splashProp != null && this.fileExists(splashProp)) {
                                this.copyFile(new File(splashProp), this.destDir);
                                String fileName = this.stripFilename(splashProp);
                                informationElem.appendChild(this.createIconElement(docDom, fileName, "splash"));
                            }
                            if ((iconProp = this.getProperty("jnlp.icon", null)) == null || !this.fileExists(iconProp)) continue block5;
                            this.copyFile(new File(iconProp), this.destDir);
                            String fileName = this.stripFilename(iconProp);
                            informationElem.appendChild(this.createIconElement(docDom, fileName, "default"));
                            continue block5;
                        }
                        if (!nodeValue.equals(DEFAULT_JNLP_OFFLINE)) continue block5;
                        informationElem.removeChild(node);
                        String offlineProp = this.getProperty("jnlp.offline-allowed", null);
                        if (!offlineProp.equalsIgnoreCase("true")) continue block5;
                        informationElem.appendChild(docDom.createElement("offline-allowed"));
                        continue block5;
                    }
                }
            }
        }
    }

    private void processBackgroundElem(Document docDom, Node parent) {
        assert (docDom != null);
        assert (parent != null);
        NodeList childNodes = parent.getChildNodes();
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = childNodes.item(i);
            if (node == null || node.getNodeType() != 8 || !node.getNodeValue().equals(JNLP_UPDATE)) continue;
            String offlineProp = this.getProperty("jnlp.offline-allowed", null);
            Element updateElm = docDom.createElement("update");
            String updateVal = offlineProp.equalsIgnoreCase("true") ? "background" : "always";
            updateElm.setAttribute("check", updateVal);
            parent.replaceChild(updateElm, node);
        }
    }

    private Element createIconElement(Document doc, String href, String kind) {
        Element iconElem = doc.createElement("icon");
        iconElem.setAttribute("href", href);
        iconElem.setAttribute("kind", kind);
        return iconElem;
    }

    private boolean fileExists(String path) {
        assert (path != null);
        return new File(path).exists();
    }

    private String getProperty(String propName, String defaultVal) {
        String propVal = this.getProject().getProperty(propName);
        if (propVal == null) {
            this.log("Property " + propName + " is not defined, using default value: " + defaultVal, 3);
            return defaultVal;
        }
        return propVal.trim();
    }

    private void copyFile(File src, File dest) {
        Copy copyTask = (Copy)this.getProject().createTask("copy");
        copyTask.setFile(src);
        copyTask.setTodir(dest);
        copyTask.setFailOnError(false);
        copyTask.init();
        copyTask.setLocation(this.getLocation());
        copyTask.execute();
    }

    private void processSecurityElem(Document docDom, Node parent) {
        NodeList childNodes = parent.getChildNodes();
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = childNodes.item(i);
            if (node == null || node.getNodeType() != 8 || !node.getNodeValue().equals(DEFAULT_JNLP_SECURITY)) continue;
            String securityProp = this.getProperty("jnlp.signed", null);
            if (securityProp != null && securityProp.equalsIgnoreCase("true")) {
                parent.replaceChild(this.createSecurityElement(docDom), node);
                continue;
            }
            parent.removeChild(node);
        }
    }

    private Element createSecurityElement(Document doc) {
        Element secElem = doc.createElement("security");
        Element allPermElem = doc.createElement("all-permissions");
        secElem.appendChild(allPermElem);
        return secElem;
    }

    private void processResourcesElem(Document docDom) {
        NodeList nodeList = docDom.getElementsByTagName("resources");
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node resourceElem = nodeList.item(i);
            NodeList childNodes = resourceElem.getChildNodes();
            int lenChild = childNodes.getLength();
            for (int j = 0; j < lenChild; ++j) {
                Node node = childNodes.item(j);
                if (node == null || node.getNodeType() != 8) continue;
                String nodeValue = node.getNodeValue();
                if (nodeValue.equals(DEFAULT_JNLP_RESOURCES_RUNTIME)) {
                    resourceElem.replaceChild(this.createJ2seElement(docDom), node);
                    continue;
                }
                if (nodeValue.equals(DEFAULT_JNLP_RESOURCES_MAIN_JAR)) {
                    String fileName = this.stripFilename(this.getProject().getProperty("dist.jar"));
                    resourceElem.replaceChild(this.createJarElement(docDom, fileName, true, true), node);
                    continue;
                }
                if (nodeValue.equals(DEFAULT_JNLP_RESOURCES_JARS)) {
                    resourceElem.removeChild(node);
                    String cpProp = this.getProperty("run.classpath", null);
                    this.log("run.classpath = " + cpProp, 3);
                    List<? extends File> runCpResolved = GenerateJnlpFileTask.resolveCp(this.getProject(), cpProp);
                    Set<? extends File> lazyJarsSet = GenerateJnlpFileTask.getLazyJarsSet(this.getProject(), runCpResolved, this.lazyJars);
                    Set<? extends String> extJarsSet = GenerateJnlpFileTask.getExternalJarsProp(this.getProject());
                    for (File file : runCpResolved) {
                        String fileName;
                        if (GenerateJnlpFileTask.isExternalJar(file, extJarsSet) || !(fileName = file.getName()).endsWith("jar") || fileName.equals("javaws.jar")) continue;
                        boolean eager = !lazyJarsSet.contains(file);
                        resourceElem.appendChild(this.createJarElement(docDom, "lib/" + fileName, false, eager));
                    }
                    continue;
                }
                if (!nodeValue.equals(DEFAULT_JNLP_RESOURCES_EXTENSIONS)) continue;
                resourceElem.removeChild(node);
                List<Map<String, String>> extResProps = this.readMultiProperties(EXT_RESOURCE_PROPNAME_PREFIX, EXT_RESOURCE_SUFFIXES);
                extResProps.addAll(GenerateJnlpFileTask.getExternalJnlpsProp(this.getProject()));
                for (Map<String, String> map : extResProps) {
                    List<String> requiredKeys = Arrays.asList(EXT_RESOURCE_SUFFIXES_REQUIRED);
                    Set<String> keys = map.keySet();
                    if (!keys.containsAll(requiredKeys)) continue;
                    resourceElem.appendChild(this.createPropElement(docDom, "extension", map));
                }
            }
        }
    }

    private Element createJ2seElement(Document doc) {
        String maxHeapProp;
        String initHeapProp;
        Element j2seElem = doc.createElement("j2se");
        String javacTargetProp = this.getProperty("javac.target", null);
        j2seElem.setAttribute("version", javacTargetProp + "+");
        String runArgsProp = this.getProperty("run.jvmargs", null);
        if (runArgsProp != null && !runArgsProp.equals("")) {
            j2seElem.setAttribute("java-vm-args", runArgsProp);
        }
        if ((initHeapProp = this.getProperty("jnlp.initial-heap-size", null)) != null && !initHeapProp.equals("")) {
            j2seElem.setAttribute("initial-heap-size", initHeapProp);
        }
        if ((maxHeapProp = this.getProperty("jnlp.max-heap-size", null)) != null && !maxHeapProp.equals("")) {
            j2seElem.setAttribute("max-heap-size", maxHeapProp);
        }
        return j2seElem;
    }

    private Element createJarElement(Document doc, String href, boolean main, boolean eager) {
        assert (href != null);
        Element jarElem = doc.createElement("jar");
        jarElem.setAttribute("href", href);
        if (main) {
            jarElem.setAttribute("main", "true");
        }
        if (!eager) {
            jarElem.setAttribute("download", "lazy");
        }
        return jarElem;
    }

    private void processDescriptorElem(Document docDom) {
        Node childNode;
        int i;
        int len;
        NodeList childNodes;
        String[] elemNames = new String[]{DESC_APPLICATION, DESC_APPLET, DESC_COMPONENT, DESC_INSTALLER};
        String descName = null;
        Element descElem = null;
        for (String elemName : elemNames) {
            Node node = docDom.getElementsByTagName(elemName).item(0);
            if (node == null) continue;
            descName = elemName;
            descElem = (Element)node;
            break;
        }
        if (DESC_APPLICATION.equals(descName)) {
            if (DEFAULT_JNLP_MAIN_CLASS.equals(descElem.getAttribute("main-class"))) {
                descElem.setAttribute("main-class", this.getProject().getProperty("main.class"));
            }
            childNodes = descElem.getChildNodes();
            len = childNodes.getLength();
            for (i = 0; i < len; ++i) {
                childNode = childNodes.item(i);
                if (childNode == null || childNode.getNodeType() != 8 || !childNode.getNodeValue().equals(DEFAULT_JNLP_APPLICATION_ARGS)) continue;
                descElem.removeChild(childNode);
                String appArgsProp = this.getProject().getProperty("application.args");
                if (appArgsProp == null) continue;
                for (String arg : Commandline.translateCommandline((String)appArgsProp)) {
                    Element argElem = docDom.createElement("argument");
                    argElem.setTextContent(arg);
                    descElem.appendChild(argElem);
                }
            }
        } else if (DESC_APPLET.equals(descName)) {
            if (DEFAULT_JNLP_MAIN_CLASS.equals(descElem.getAttribute("main-class"))) {
                descElem.setAttribute("main-class", this.getProject().getProperty("jnlp.applet.class"));
            }
            if (DEFAULT_APPLICATION_TITLE.equals(descElem.getAttribute("name"))) {
                descElem.setAttribute("name", this.getProperty("application.title", "Application Title"));
            }
            if (DEFAULT_JNLP_APPLET_WIDTH.equals(descElem.getAttribute("width"))) {
                descElem.setAttribute("width", this.getProperty("jnlp.applet.width", "300"));
            }
            if (DEFAULT_JNLP_APPLET_HEIGHT.equals(descElem.getAttribute("height"))) {
                descElem.setAttribute("height", this.getProperty("jnlp.applet.height", "300"));
            }
            childNodes = descElem.getChildNodes();
            len = childNodes.getLength();
            for (i = 0; i < len; ++i) {
                childNode = childNodes.item(i);
                if (childNode == null || childNode.getNodeType() != 8 || !childNode.getNodeValue().equals(DEFAULT_JNLP_APPLET_PARAMS)) continue;
                descElem.removeChild(childNode);
                List<Map<String, String>> appletParamProps = this.readMultiProperties(APPLET_PARAM_PROPNAME_PREFIX, APPLET_PARAM_SUFFIXES);
                for (Map<String, String> map : appletParamProps) {
                    if (map.size() != APPLET_PARAM_SUFFIXES.length) continue;
                    descElem.appendChild(this.createPropElement(docDom, "param", map));
                }
            }
        } else if (DESC_COMPONENT.equals(descName) || DESC_INSTALLER.equals(descName)) {
            // empty if block
        }
    }

    private Element createPropElement(Document doc, String elemName, Map<String, String> props) {
        Element propElem = doc.createElement(elemName);
        for (String propName : props.keySet()) {
            String propValue = props.get(propName);
            propElem.setAttribute(propName, propValue);
        }
        return propElem;
    }

    private List<Map<String, String>> readMultiProperties(String propPrefix, String[] propSuffixes) {
        ArrayList<Map<String, String>> listToReturn = new ArrayList<Map<String, String>>();
        int index = 0;
        while (true) {
            HashMap<String, String> map = new HashMap<String, String>();
            int numProps = 0;
            for (String propSuffix : propSuffixes) {
                String propValue = this.getProject().getProperty(propPrefix + index + "." + propSuffix);
                if (propValue == null) continue;
                map.put(propSuffix, propValue);
                ++numProps;
            }
            if (numProps == 0) break;
            listToReturn.add(map);
            ++index;
        }
        return listToReturn;
    }

    private String stripFilename(String path) {
        int sepIndex = path.lastIndexOf(47) == -1 ? path.lastIndexOf(92) : path.lastIndexOf(47);
        return path.substring(sepIndex + 1);
    }

    private static Set<? extends File> getLazyJarsSet(Project prj, List<? extends File> runCp, Path value) {
        HashSet<File> result = new HashSet<File>();
        if (value != null) {
            for (String pathElement : value.list()) {
                result.add(prj.resolveFile(pathElement));
            }
        }
        for (File file : runCp) {
            if (!Project.toBoolean((String)prj.getProperty(String.format(JNLP_LAZY_FORMAT, file.getName())))) continue;
            result.add(file);
        }
        return result;
    }

    private static List<? extends File> resolveCp(Project prj, String path) {
        PathTokenizer ptok = new PathTokenizer(path);
        ArrayList<File> result = new ArrayList<File>();
        while (ptok.hasMoreTokens()) {
            result.add(prj.resolveFile(ptok.nextToken()));
        }
        return result;
    }

    private static Set<? extends String> getExternalJarsProp(Project prj) {
        HashSet<String> result = new HashSet<String>();
        String extJarsProp = prj.getProperty(EXTERNAL_JARS_PROP);
        if (extJarsProp != null) {
            for (String extJar : extJarsProp.split(EXTERNAL_PROP_DELIMITER)) {
                if (extJar.isEmpty()) continue;
                File f = new File(extJar);
                result.add(f.toString());
            }
        }
        return result;
    }

    private static Set<Map<String, String>> getExternalJnlpsProp(Project prj) {
        HashSet<Map<String, String>> result = new HashSet<Map<String, String>>();
        String extJnlpsProp = prj.getProperty(EXTERNAL_JNLPS_PROP);
        if (extJnlpsProp != null) {
            for (String extJnlp : extJnlpsProp.split(EXTERNAL_PROP_DELIMITER)) {
                if (extJnlp.isEmpty()) continue;
                HashMap<String, String> m = new HashMap<String, String>();
                m.put(EXT_RESOURCE_SUFFIXES[0], extJnlp);
                result.add(m);
            }
        }
        return result;
    }

    private static boolean isExternalJar(File file, Set<? extends String> extJars) {
        if (file != null && extJars != null) {
            String fileStr = file.toString();
            for (String string : extJars) {
                if (!fileStr.contains(string)) continue;
                return true;
            }
        }
        return false;
    }
}

