/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.unix.UnixSpecialDirs;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.File;
import java.io.IOException;

public class CreateDesktopLinkAction
extends SystemInstallAction {
    private File file;
    private String name = "";
    private boolean allUsers = true;
    private ExternalFile winIconFile;
    private ExternalFile unixIconFile;
    private String arguments = "";
    private String description = "";
    private File startIn;
    private boolean runAsAdministrator = false;
    private boolean macSingleBundleTarget = true;

    public File getStartIn() {
        return CreateDesktopLinkAction.replaceVariables(this.startIn);
    }

    public void setStartIn(File startIn) {
        this.startIn = startIn;
    }

    public boolean isRunAsAdministrator() {
        return this.runAsAdministrator;
    }

    public void setRunAsAdministrator(boolean runAsAdministrator) {
        this.runAsAdministrator = runAsAdministrator;
    }

    public File getFile() {
        return CreateDesktopLinkAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return CreateDesktopLinkAction.replaceVariables(this.name, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExternalFile getWinIconFile() {
        return this.winIconFile;
    }

    public void setWinIconFile(ExternalFile winIconFile) {
        this.winIconFile = winIconFile;
    }

    public ExternalFile getUnixIconFile() {
        return this.unixIconFile;
    }

    public void setUnixIconFile(ExternalFile unixIconFile) {
        this.unixIconFile = unixIconFile;
    }

    public String getArguments() {
        return CreateDesktopLinkAction.replaceVariables(this.arguments);
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getDescription() {
        return CreateDesktopLinkAction.replaceVariables(this.description, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMacSingleBundleTarget() {
        return this.macSingleBundleTarget;
    }

    public void setMacSingleBundleTarget(boolean macSingleBundleTarget) {
        this.macSingleBundleTarget = macSingleBundleTarget;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean allUsers) {
        this.allUsers = allUsers;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        if (InstallerUtil.isWindows()) {
            return this.installWindows(context);
        }
        if (InstallerUtil.isMacOS()) {
            return this.installMacos(context);
        }
        return this.installUnix(context);
    }

    private boolean installUnix(InstallerContext context) throws UserCanceledException {
        File desktopDir = UnixSpecialDirs.getDirectory("XDG_DESKTOP_DIR");
        if (desktopDir == null || !desktopDir.isDirectory()) {
            desktopDir = new File(Util.getUserHome(), "Desktop");
        }
        if (desktopDir.isDirectory()) {
            try {
                File destinationFile = context.getDestinationFile(this.getFile());
                if (MenuHelper.installUnixDesktopFile(context.getInstallationDirectory(), desktopDir, destinationFile, this.getName(), null, this.getArguments(), context.getExternalFile(this.getUnixIconFile(), true), this.getDescription(), MenuHelper.getUnixWindowClass(context, MenuHelper.getLauncherWithUnixPath(context, destinationFile))) == null) {
                    Logger.getInstance().log(this, "Destination file does not exist", false);
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
                return false;
            }
        }
        Logger.getInstance().log(this, "Desktop directory " + desktopDir + " does not exist", false);
        return false;
    }

    private boolean installMacos(InstallerContext context) {
        File executableFile;
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        if (config.getMacSpecificConfig().isSingleBundle() && this.isMacSingleBundleTarget()) {
            executableFile = context.getDestinationFile(config.getMacSpecificConfig().getSingleBundleName());
        } else if (this.getFile() != null && this.getFile().getPath().trim().length() > 0) {
            File appFile;
            executableFile = context.getDestinationFile(this.getFile());
            if (!executableFile.exists() && (appFile = new File(executableFile, ".app")).exists()) {
                executableFile = appFile;
            }
        } else {
            return false;
        }
        if (executableFile != null && executableFile.exists()) {
            return this.createLink(executableFile, this.getName());
        }
        Logger.getInstance().log(this, "Destination file " + executableFile + " does not exist", false);
        return false;
    }

    private boolean createLink(final File executableFile, final String name) {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                File linkFile = new File(new File(Util.getUserHome(), "Desktop"), name);
                if (context instanceof InstallerContext) {
                    BackupFileForRollbackAction backupAction = new BackupFileForRollbackAction(linkFile, true, true);
                    backupAction.install((InstallerContext)context);
                    CreateDesktopLinkAction.this.addRollbackAction(backupAction);
                }
                if (!UnixFileSystem.createLink(executableFile.getAbsolutePath(), linkFile)) {
                    return false;
                }
                FileInstaller.getInstance().registerUninstallFile(linkFile);
                return true;
            }
        });
    }

    private boolean installWindows(InstallerContext context) throws UserCanceledException {
        File destFile = context.getDestinationFile(this.getFile());
        if (destFile != null) {
            if (!destFile.exists()) {
                destFile = context.getDestinationFile(this.getFile() + ".exe");
            }
            if (destFile.exists()) {
                boolean allUsers = this.allUsers;
                Object varValue = InstallerVariables.getVariable("sys.programGroupAllUsers");
                if (varValue instanceof Boolean) {
                    allUsers = (Boolean)varValue;
                }
                File iconFile = context.getExternalFile(this.winIconFile, true);
                if (allUsers && !InstallerUtil.checkWritable(FolderInfo.getSpecialFolder(1, true))) {
                    allUsers = false;
                }
                File desktopDir = FolderInfo.getSpecialFolder(1, allUsers);
                File usedStartIn = context.getDestinationFile(this.getStartIn());
                if (usedStartIn != null && !usedStartIn.isDirectory()) {
                    usedStartIn = null;
                }
                try {
                    MenuHelper.installWindowsMenu(allUsers ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED, new File(desktopDir, this.getName()), destFile, iconFile, this.getArguments(), this.isRunAsAdministrator(), this.getDescription(), usedStartIn);
                    return true;
                }
                catch (IOException e) {
                    Logger.getInstance().log(e);
                    return false;
                }
            }
            Logger.getInstance().log(this, "Destination file does not exist", false);
            return false;
        }
        Logger.getInstance().log(this, "Destination file does not exist", false);
        return false;
    }
}

