/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SetRegistryValueAction
extends SystemInstallOrUninstallAction {
    private RegistryRoot registryRoot;
    private String keyName = "";
    private String valueName = "";
    private String value = "";
    private boolean createKey = true;
    private transient Object externalValue = null;

    public SetRegistryValueAction() {
    }

    public SetRegistryValueAction(RegistryRoot registryRoot, String keyName, String valueName, Object value, boolean createKey) {
        this.registryRoot = registryRoot;
        this.keyName = keyName;
        this.valueName = valueName;
        this.externalValue = value;
        if (this.externalValue == null) {
            this.value = null;
        }
        this.createKey = createKey;
    }

    @Override
    public boolean execute(Context context) {
        Object value;
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        PerformedAction performedAction = new PerformedAction();
        this.addRollbackAction(performedAction);
        if (this.isCreateKey() && !this.doCreateKey(performedAction)) {
            Logger.getInstance().error(this, "could not create key " + (Object)((Object)this.registryRoot) + " " + this.keyName);
            return false;
        }
        performedAction.oldValue = WinRegistry.getValue(this.getRegistryRoot(), this.getKeyName(), this.getValueName());
        Object object = value = this.externalValue != null ? this.externalValue : this.getValue();
        if (value instanceof String && performedAction.oldValue instanceof WinRegistry.ExpandString) {
            value = new WinRegistry.ExpandString((String)value);
        }
        if (value == null) {
            performedAction.newValueSet = true;
            WinRegistry.deleteValue(this.getRegistryRoot(), this.getKeyName(), this.getValueName());
        } else {
            performedAction.newValueSet = WinRegistry.setValue(this.getRegistryRoot(), this.getKeyName(), this.getValueName(), value);
            if (!performedAction.newValueSet) {
                Logger.getInstance().error(this, "could not set value " + (Object)((Object)this.registryRoot) + " " + this.keyName + " " + this.getValueName() + ": " + value);
            }
        }
        return performedAction.newValueSet;
    }

    private boolean doCreateKey(PerformedAction performedAction) {
        String usedKeyName = this.getKeyName();
        String curKeyName = null;
        StringTokenizer tokenizer = new StringTokenizer(usedKeyName, "\\");
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            curKeyName = curKeyName == null ? "" : curKeyName + "\\";
            curKeyName = curKeyName + nextToken;
            if (WinRegistry.keyExists(this.getRegistryRoot(), curKeyName)) continue;
            if (!WinRegistry.createKey(this.getRegistryRoot(), curKeyName)) {
                return false;
            }
            performedAction.createdKeys.add(curKeyName);
        }
        return true;
    }

    public RegistryRoot getRegistryRoot() {
        return this.registryRoot;
    }

    public void setRegistryRoot(RegistryRoot registryRoot) {
        this.registryRoot = registryRoot;
    }

    public String getKeyName() {
        return SetRegistryValueAction.replaceVariables(this.keyName);
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getValueName() {
        return SetRegistryValueAction.replaceVariables(this.valueName);
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public String getValue() {
        return SetRegistryValueAction.replaceVariables(this.value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isCreateKey() {
        return this.createKey;
    }

    public void setCreateKey(boolean createKey) {
        this.createKey = createKey;
    }

    private class PerformedAction
    extends SetRegistryValueAction {
        List<String> createdKeys = new ArrayList<String>();
        boolean newValueSet = false;
        Object oldValue;

        PerformedAction() {
            SetRegistryValueAction.this.registryRoot = SetRegistryValueAction.this.getRegistryRoot();
            SetRegistryValueAction.this.keyName = SetRegistryValueAction.this.getKeyName();
            SetRegistryValueAction.this.valueName = SetRegistryValueAction.this.getValueName();
        }

        @Override
        public boolean install(InstallerContext context) throws UserCanceledException {
            return false;
        }

        @Override
        public void rollback(InstallerContext context) {
            if (this.newValueSet) {
                if (this.oldValue == null) {
                    WinRegistry.deleteValue(SetRegistryValueAction.this.registryRoot, SetRegistryValueAction.this.keyName, SetRegistryValueAction.this.valueName);
                } else {
                    WinRegistry.setValue(SetRegistryValueAction.this.registryRoot, SetRegistryValueAction.this.keyName, SetRegistryValueAction.this.valueName, this.oldValue);
                }
            }
            for (int i = this.createdKeys.size() - 1; i >= 0; --i) {
                String keyName = this.createdKeys.get(i);
                WinRegistry.getSubKeyNames(SetRegistryValueAction.this.registryRoot, keyName);
                WinRegistry.deleteKey(SetRegistryValueAction.this.registryRoot, keyName, true);
            }
        }
    }
}

