/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.runtime.installer.platform.win32.Common;
import com.install4j.runtime.launcher.util.LauncherUtil;

public class Win32Services {
    public static final int DEFAULT_MINIMUM_STOP_TIMEOUT = 30000;
    public static final int SERVICE_NO_CHANGE = -1;
    public static final int SERVICE_AUTO_START = 2;
    public static final int SERVICE_DEMAND_START = 3;
    public static final int SERVICE_DISABLED = 4;
    public static final int SERVICE_NON_INTERACTIVE_PROCESS = 16;
    public static final int SERVICE_INTERACTIVE_PROCESS = 272;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_SERVICE_ALREADY_RUNNING = 1056;
    public static final int ERROR_INVALID_SERVICE_ACCOUNT = 1057;
    public static final int ERROR_SERVICE_DOES_NOT_EXIST = 1060;
    public static final int ERROR_SERVICE_NOT_ACTIVE = 1062;
    public static final int ERROR_SERVICE_LOGON_FAILED = 1069;
    public static final int ERROR_SERVICE_MARKED_FOR_DELETE = 1072;
    public static final int ERROR_SERVICE_EXISTS = 1073;
    private static final int SERVICE_RUNNING = 4;

    private static native int installService0(String var0, String var1, String var2);

    private static native int changeServiceConfig0(String var0, String var1, String var2, int var3, int var4, String var5, String var6, String var7, String var8);

    private static native int setRestartServiceConfig0(String var0, boolean var1, int var2);

    private static native int setDelayedAutoStart0(String var0, boolean var1);

    private static native int stopService0(String var0, int var1);

    private static native int startService0(String var0, String[] var1);

    private static native int uninstallService0(String var0);

    private static native int queryStatus0(String var0);

    private static native int getStartType0(String var0);

    private static native String getServiceBinary0(String var0);

    public static void setDelayedAutoStart(String serviceName, boolean value) throws ServiceException {
        if (!LauncherUtil.isWindows()) {
            return;
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int ret = Win32Services.setDelayedAutoStart0(serviceName, value);
        if (ret != 0) {
            throw new ServiceException(ret);
        }
    }

    public static boolean isRunning(String serviceName) throws ServiceException {
        if (!LauncherUtil.isWindows()) {
            return false;
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int ret = Win32Services.queryStatus0(serviceName);
        if (ret <= 0) {
            return -ret == 4;
        }
        throw new ServiceException(ret);
    }

    public static int getStartType(String serviceName) throws ServiceException {
        if (!LauncherUtil.isWindows()) {
            return 4;
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int ret = Win32Services.getStartType0(serviceName);
        if (ret <= 0) {
            return -ret;
        }
        throw new ServiceException(ret);
    }

    public static String getServiceBinary(String serviceName) throws ServiceException {
        if (!LauncherUtil.isWindows()) {
            return null;
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        String ret = Win32Services.getServiceBinary0(serviceName);
        if (ret.startsWith(" ")) {
            throw new ServiceException(Integer.parseInt(ret.substring(1)));
        }
        return ret;
    }

    public static void installService(String serviceName, String displayName, String pathName) throws ServiceException {
        if (!LauncherUtil.isWindows()) {
            return;
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        if (pathName == null) {
            throw new IllegalArgumentException("pathName required");
        }
        int ret = Win32Services.installService0(serviceName, displayName, pathName);
        if (ret != 0) {
            throw new ServiceException(ret);
        }
    }

    public static void changeServiceConfig(String serviceName, String displayName, String pathName, boolean interactive, int startType, String dependencies, String accountName, String password, String description) throws ServiceException {
        int ret;
        if (!LauncherUtil.isWindows()) {
            return;
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        if (dependencies != null) {
            dependencies = dependencies.replaceAll(",\\s+", ",").trim();
        }
        if ((ret = Win32Services.changeServiceConfig0(serviceName, displayName, pathName, interactive ? 272 : 16, startType, dependencies, accountName, password, description)) != 0) {
            throw new ServiceException(ret);
        }
    }

    public static void setRestartServiceConfig(String serviceName, boolean on, int restartMillis) throws ServiceException {
        if (!LauncherUtil.isWindows()) {
            return;
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int ret = Win32Services.setRestartServiceConfig0(serviceName, on, restartMillis);
        if (ret != 0) {
            throw new ServiceException(ret);
        }
    }

    public static void stopService(String serviceName) throws ServiceException {
        Win32Services.stopService(serviceName, 30000);
    }

    public static void stopService(String serviceName, int minimumTimeout) throws ServiceException {
        if (!LauncherUtil.isWindows()) {
            return;
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int ret = Win32Services.stopService0(serviceName, minimumTimeout);
        if (ret != 0) {
            throw new ServiceException(ret);
        }
    }

    public static void startService(String serviceName) throws ServiceException {
        Win32Services.startService(serviceName, null);
    }

    public static void startService(String serviceName, String ... parameters) throws ServiceException {
        if (!LauncherUtil.isWindows()) {
            return;
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int ret = Win32Services.startService0(serviceName, parameters);
        if (ret != 0) {
            throw new ServiceException(ret);
        }
    }

    public static void uninstallService(String serviceName) throws ServiceException {
        if (!LauncherUtil.isWindows()) {
            return;
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int ret = Win32Services.uninstallService0(serviceName);
        if (ret != 0 && ret != 1072) {
            throw new ServiceException(ret);
        }
    }

    static {
        Common.init();
    }

    public static class ServiceException
    extends Exception {
        private int errorCode;

        public ServiceException(int errorCode) {
            this.errorCode = errorCode;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        @Override
        public String toString() {
            return "ServiceException{errorCode=" + this.errorCode + '}';
        }
    }
}

