/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util.internal;

import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.launcher.util.LauncherUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class ReflectionUtil {
    private static Unsafe theUnsafe;
    private static long overrideFieldOffset;

    public static void setAccessible(AccessibleObject accessibleObject) {
        if (accessibleObject == null) {
            throw new NullPointerException();
        }
        if (LauncherUtil.isJava9Plus()) {
            if (!ReflectionUtil.setUnsafeAccessible(accessibleObject)) {
                accessibleObject.setAccessible(true);
            }
        } else {
            accessibleObject.setAccessible(true);
        }
    }

    private static Unsafe initUnsafe() {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static synchronized boolean setUnsafeAccessible(AccessibleObject accessibleObject) {
        if (theUnsafe == null) {
            VersionSpecificHelper.addReads("jdk.unsupported");
            theUnsafe = ReflectionUtil.initUnsafe();
        }
        if (theUnsafe != null) {
            try {
                if (overrideFieldOffset == -1L) {
                    Field overrideField = AccessibleObject.class.getDeclaredField("override");
                    overrideFieldOffset = theUnsafe.objectFieldOffset(overrideField);
                }
                theUnsafe.putBoolean(accessibleObject, overrideFieldOffset, true);
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    static {
        overrideFieldOffset = -1L;
    }
}

