/*
 * Decompiled with CFR 0.152.
 */
package jxxload_help;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PathVFS {
    private Vector vfs = new Vector();
    private Hashtable once = new Hashtable();
    private static final Object PRESENT = new Object();

    public void addVFS(String fname) {
        if (fname.length() == 0) {
            if (!this.once.containsKey("")) {
                this.once.put("", PRESENT);
                this.vfs.addElement(new DirVFS(""));
            }
            return;
        }
        try {
            File file = new File(fname);
            String canon = file.getCanonicalPath().toString();
            if (!this.once.containsKey(canon)) {
                this.once.put(canon, PRESENT);
                if (file.isDirectory()) {
                    this.vfs.addElement(new DirVFS(fname));
                } else if (file.exists() && (fname.endsWith(".jar") || fname.endsWith(".zip"))) {
                    this.vfs.addElement(new JarVFS(fname));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public InputStream open(String id) {
        Enumeration enumm = this.vfs.elements();
        while (enumm.hasMoreElements()) {
            VFS v = (VFS)enumm.nextElement();
            InputStream stream = v.open(id);
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    public static class DirVFS
    implements VFS {
        private String prefix;

        public DirVFS(String dir) {
            this.prefix = dir.length() == 0 ? null : dir;
        }

        public InputStream open(String id) {
            File file = new File(this.prefix, id.replace('/', File.separatorChar));
            if (file.isFile()) {
                try {
                    return new BufferedInputStream(new FileInputStream(file));
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }
    }

    public static class JarVFS
    implements VFS {
        private ZipFile zipfile;

        public JarVFS(String fname) throws IOException {
            this.zipfile = new ZipFile(fname);
        }

        public InputStream open(String id) {
            ZipEntry ent = this.zipfile.getEntry(id);
            if (ent == null) {
                return null;
            }
            try {
                return this.zipfile.getInputStream(ent);
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public static interface VFS {
        public InputStream open(String var1);
    }
}

