/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.python.core.Py;
import org.python.core.PyDescriptor;
import org.python.core.PyObject;
import org.python.core.PyType;

public class PyGetSetDescr
extends PyDescriptor {
    private Method get_meth;
    private Method set_meth;
    private Method del_meth;
    private Class getset_type;

    public PyGetSetDescr(PyType dtype, String name, Class c, String get, String set) {
        this(dtype, name, c, get, set, null);
    }

    public PyGetSetDescr(String name, Class c, String get, String set) {
        this(PyType.fromClass(c), name, c, get, set, null);
    }

    public PyGetSetDescr(PyType dtype, String name, Class c, String get, String set, String del) {
        this.name = name;
        this.dtype = dtype;
        try {
            this.get_meth = c.getMethod(get, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw Py.SystemError("method " + get + " doesn't exist: " + c.getName());
        }
        if (Modifier.isStatic(this.get_meth.getModifiers())) {
            throw Py.SystemError("static " + get + " not supported: " + c.getName());
        }
        this.getset_type = this.get_meth.getReturnType();
        if (set != null) {
            try {
                this.set_meth = c.getMethod(set, this.getset_type);
            }
            catch (NoSuchMethodException e) {
                throw Py.SystemError("method " + set + " doesn't exist: " + c.getName());
            }
            if (Modifier.isStatic(this.set_meth.getModifiers())) {
                throw Py.SystemError("static " + set + " not supported: " + c.getName());
            }
        }
        if (del != null) {
            try {
                this.del_meth = c.getMethod(del, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw Py.SystemError("method " + set + " doesn't exist: " + c.getName());
            }
            if (Modifier.isStatic(this.del_meth.getModifiers())) {
                throw Py.SystemError("static " + del + " not supported: " + c.getName());
            }
        }
    }

    public PyGetSetDescr(String name, Class c, String get, String set, String del) {
        this(PyType.fromClass(c), name, c, get, set, del);
    }

    public String toString() {
        return "<attribute '" + this.name + "' of '" + this.dtype.fastGetName() + "' objects>";
    }

    public PyObject __get__(PyObject obj, PyObject type) {
        try {
            if (obj != null) {
                PyType objtype = obj.getType();
                if (objtype != this.dtype && !objtype.isSubType(this.dtype)) {
                    throw this.get_wrongtype(objtype);
                }
                Object v = this.get_meth.invoke((Object)obj, new Object[0]);
                if (v == null) {
                    obj.noAttributeError(this.name);
                }
                return Py.java2py(v);
            }
            return this;
        }
        catch (IllegalArgumentException e) {
            throw Py.JavaError(e);
        }
        catch (IllegalAccessException e) {
            throw Py.JavaError(e);
        }
        catch (InvocationTargetException e) {
            throw Py.JavaError(e);
        }
    }

    public void __set__(PyObject obj, PyObject value) {
        try {
            PyType objtype = obj.getType();
            if (objtype != this.dtype && !objtype.isSubType(this.dtype)) {
                throw this.get_wrongtype(objtype);
            }
            Object converted = value.__tojava__(this.getset_type);
            if (converted == Py.NoConversion) {
                throw Py.TypeError("");
            }
            this.set_meth.invoke((Object)obj, converted);
        }
        catch (IllegalArgumentException e) {
            throw Py.JavaError(e);
        }
        catch (IllegalAccessException e) {
            throw Py.JavaError(e);
        }
        catch (InvocationTargetException e) {
            throw Py.JavaError(e);
        }
    }

    public void __delete__(PyObject obj) {
        try {
            if (obj != null) {
                PyType objtype = obj.getType();
                if (objtype != this.dtype && !objtype.isSubType(this.dtype)) {
                    throw this.get_wrongtype(objtype);
                }
                this.del_meth.invoke((Object)obj, new Object[0]);
            }
        }
        catch (IllegalArgumentException e) {
            throw Py.JavaError(e);
        }
        catch (IllegalAccessException e) {
            throw Py.JavaError(e);
        }
        catch (InvocationTargetException e) {
            throw Py.JavaError(e);
        }
    }

    public boolean implementsDescrSet() {
        return this.set_meth != null;
    }

    public boolean implementsDescrDelete() {
        return this.del_meth != null;
    }

    public boolean isDataDescr() {
        return true;
    }
}

