/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.python.core.CollectionIter;
import org.python.core.CollectionProxy;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PySequenceIter;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.ThreadState;
import org.python.core.imp;

public class PyInstance
extends PyObject {
    public transient PyClass instclass;
    Object javaProxy;
    public PyObject __dict__;
    private static Hashtable primitiveMap;
    private CollectionProxy collectionProxy = null;
    private static CollectionIter[] iterFactories;

    public PyObject fastGetClass() {
        return this.instclass;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        PyClass pyc;
        in.defaultReadObject();
        String module = in.readUTF();
        String name = in.readUTF();
        PyObject mod = imp.importName(module.intern(), false);
        this.instclass = pyc = (PyClass)mod.__getattr__(name.intern());
        if (this.javaProxy != null) {
            ((PyProxy)this.javaProxy)._setPySystemState(Py.getSystemState());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        PyObject name = this.instclass.__findattr__("__module__");
        if (!(name instanceof PyString) || name == Py.None || name == null) {
            throw Py.ValueError("Can't find module for class: " + this.instclass.__name__);
        }
        out.writeUTF(name.toString());
        name = this.instclass.__findattr__("__name__");
        if (!(name instanceof PyString) || name == Py.None || name == null) {
            throw Py.ValueError("Can't find module for class with no name");
        }
        out.writeUTF(name.toString());
    }

    public PyInstance(PyClass iclass, PyObject dict) {
        this.instclass = iclass;
        this.__dict__ = dict;
    }

    public PyInstance(PyClass iclass) {
        this(iclass, new PyStringMap());
    }

    public PyInstance() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeProxy() {
        PyProxy proxy;
        Class c = this.instclass.proxyClass;
        ThreadState ts = Py.getThreadState();
        try {
            ts.pushInitializingProxy(this);
            try {
                proxy = (PyProxy)c.newInstance();
            }
            catch (InstantiationException e) {
                Class sup = c.getSuperclass();
                String msg = "Default constructor failed for Java superclass";
                if (sup != null) {
                    msg = msg + " " + sup.getName();
                }
                throw Py.TypeError(msg);
            }
            catch (NoSuchMethodError nsme) {
                throw Py.TypeError("constructor requires arguments");
            }
            catch (Exception exc) {
                throw Py.JavaError(exc);
            }
        }
        finally {
            ts.popInitializingProxy();
        }
        if (this.javaProxy != null && this.javaProxy != proxy) {
            throw Py.TypeError("Proxy instance already initialized");
        }
        PyInstance proxyInstance = proxy._getPyInstance();
        if (proxyInstance != null && proxyInstance != this) {
            throw Py.TypeError("Proxy initialization conflict");
        }
        this.javaProxy = proxy;
    }

    public Object __tojava__(Class c) {
        if ((c == Object.class || c == Serializable.class) && this.javaProxy != null) {
            return this.javaProxy;
        }
        if (c.isInstance(this)) {
            return this;
        }
        if (c.isPrimitive()) {
            Class tmp;
            if (primitiveMap == null) {
                primitiveMap = new Hashtable();
                primitiveMap.put(Character.TYPE, Character.class);
                primitiveMap.put(Boolean.TYPE, Boolean.class);
                primitiveMap.put(Byte.TYPE, Byte.class);
                primitiveMap.put(Short.TYPE, Short.class);
                primitiveMap.put(Integer.TYPE, Integer.class);
                primitiveMap.put(Long.TYPE, Long.class);
                primitiveMap.put(Float.TYPE, Float.class);
                primitiveMap.put(Double.TYPE, Double.class);
            }
            if ((tmp = (Class)primitiveMap.get(c)) != null) {
                c = tmp;
            }
        }
        if (this.javaProxy == null && this.instclass.proxyClass != null) {
            this.makeProxy();
        }
        if (c.isInstance(this.javaProxy)) {
            return this.javaProxy;
        }
        if (this.instclass.__tojava__ != null) {
            PyObject ret = this.instclass.__tojava__.__call__(this, PyJavaClass.lookup(c));
            if (ret == Py.None) {
                return Py.NoConversion;
            }
            if (ret != this) {
                return ret.__tojava__(c);
            }
        }
        return Py.NoConversion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void __init__(PyObject[] args, String[] keywords) {
        PyObject init = this.instclass.lookup("__init__", true);
        PyObject ret = null;
        if (init != null) {
            ret = init.__call__((PyObject)this, args, keywords);
        }
        if (ret == null) {
            if (args.length != 0) {
                init = this.instclass.lookup("__init__", false);
                if (init == null) throw Py.TypeError("this constructor takes no arguments");
                ret = init.__call__((PyObject)this, args, keywords);
            }
        } else if (ret != Py.None) {
            throw Py.TypeError("constructor has no return value");
        }
        if (this.javaProxy != null || this.instclass.proxyClass == null) return;
        this.makeProxy();
    }

    public PyObject __jfindattr__(String name) {
        return this.__findattr__(name, true);
    }

    public PyObject __findattr__(String name) {
        return this.__findattr__(name, false);
    }

    public PyObject __findattr__(String name, boolean stopAtJava) {
        PyObject result = this.ifindlocal(name);
        if (result != null) {
            return result;
        }
        PyObject[] result2 = this.instclass.lookupGivingClass(name, stopAtJava);
        if (result2[0] != null) {
            return result2[0].__get__(this, this.instclass);
        }
        return this.ifindfunction(name);
    }

    protected PyObject ifindlocal(String name) {
        if (name == "__dict__") {
            return this.__dict__;
        }
        if (name == "__class__") {
            return this.instclass;
        }
        if (this.__dict__ == null) {
            return null;
        }
        return this.__dict__.__finditem__(name);
    }

    protected PyObject ifindclass(String name, boolean stopAtJava) {
        return this.instclass.lookup(name, stopAtJava);
    }

    protected PyObject ifindfunction(String name) {
        PyObject getter = this.instclass.__getattr__;
        if (getter == null) {
            return null;
        }
        try {
            return getter.__call__(this, new PyString(name));
        }
        catch (PyException exc) {
            if (Py.matchException(exc, Py.AttributeError)) {
                return null;
            }
            throw exc;
        }
    }

    public PyObject invoke(String name) {
        PyObject f = this.ifindlocal(name);
        if (f == null && (f = this.ifindclass(name, false)) != null) {
            if (f instanceof PyFunction) {
                return f.__call__(this);
            }
            f = f.__get__(this, this.instclass);
        }
        if (f == null) {
            f = this.ifindfunction(name);
        }
        if (f == null) {
            throw Py.AttributeError(name);
        }
        return f.__call__();
    }

    public PyObject invoke(String name, PyObject arg1) {
        PyObject f = this.ifindlocal(name);
        if (f == null && (f = this.ifindclass(name, false)) != null) {
            if (f instanceof PyFunction) {
                return f.__call__(this, arg1);
            }
            f = f.__get__(this, this.instclass);
        }
        if (f == null) {
            f = this.ifindfunction(name);
        }
        if (f == null) {
            throw Py.AttributeError(name);
        }
        return f.__call__(arg1);
    }

    public PyObject invoke(String name, PyObject arg1, PyObject arg2) {
        PyObject f = this.ifindlocal(name);
        if (f == null && (f = this.ifindclass(name, false)) != null) {
            if (f instanceof PyFunction) {
                return f.__call__((PyObject)this, arg1, arg2);
            }
            f = f.__get__(this, this.instclass);
        }
        if (f == null) {
            f = this.ifindfunction(name);
        }
        if (f == null) {
            throw Py.AttributeError(name);
        }
        return f.__call__(arg1, arg2);
    }

    public void __setattr__(String name, PyObject value) {
        if (name == "__class__") {
            if (!(value instanceof PyClass)) {
                throw Py.TypeError("__class__ must be set to a class");
            }
            this.instclass = (PyClass)value;
            return;
        }
        if (name == "__dict__") {
            this.__dict__ = value;
            return;
        }
        PyObject setter = this.instclass.__setattr__;
        if (setter != null) {
            setter.__call__((PyObject)this, new PyString(name), value);
        } else if (this.instclass.getProxyClass() != null) {
            PyObject field = this.instclass.lookup(name, false);
            if (field == null) {
                this.noField(name, value);
            } else if (!field.jtryset(this, value)) {
                this.unassignableField(name, value);
            }
        } else {
            this.__dict__.__setitem__(name, value);
        }
    }

    protected void noField(String name, PyObject value) {
        this.__dict__.__setitem__(name, value);
    }

    protected void unassignableField(String name, PyObject value) {
        this.__dict__.__setitem__(name, value);
    }

    public void __delattr__(String name) {
        block4: {
            PyObject deller = this.instclass.__delattr__;
            if (deller != null) {
                deller.__call__(this, new PyString(name));
            } else {
                try {
                    this.__dict__.__delitem__(name);
                }
                catch (PyException exc) {
                    if (!Py.matchException(exc, Py.KeyError)) break block4;
                    throw Py.AttributeError("class " + this.instclass.__name__ + " has no attribute '" + name + "'");
                }
            }
        }
    }

    public PyObject invoke_ex(String name, PyObject[] args, String[] keywords) {
        PyObject meth = this.__findattr__(name);
        if (meth == null) {
            return null;
        }
        return meth.__call__(args, keywords);
    }

    public PyObject invoke_ex(String name) {
        PyObject meth = this.__findattr__(name);
        if (meth == null) {
            return null;
        }
        return meth.__call__();
    }

    public PyObject invoke_ex(String name, PyObject arg1) {
        PyObject meth = this.__findattr__(name);
        if (meth == null) {
            return null;
        }
        return meth.__call__(arg1);
    }

    public PyObject invoke_ex(String name, PyObject arg1, PyObject arg2) {
        PyObject meth = this.__findattr__(name);
        if (meth == null) {
            return null;
        }
        return meth.__call__(arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyObject __call__(PyObject[] args, String[] keywords) {
        ThreadState ts = Py.getThreadState();
        if (ts.recursion_depth++ > ts.systemState.getrecursionlimit()) {
            throw Py.RuntimeError("maximum __call__ recursion depth exceeded");
        }
        try {
            PyObject pyObject = this.invoke("__call__", args, keywords);
            return pyObject;
        }
        finally {
            --ts.recursion_depth;
        }
    }

    public PyString __repr__() {
        PyObject ret = this.invoke_ex("__repr__");
        if (ret == null) {
            PyObject mod = this.instclass.__dict__.__finditem__("__module__");
            String smod = mod == Py.None ? "" : (mod == null || !(mod instanceof PyString) ? "<unknown>." : ((PyString)mod).toString() + '.');
            return new PyString("<" + smod + this.instclass.__name__ + " instance " + Py.idstr(this) + ">");
        }
        if (!(ret instanceof PyString)) {
            throw Py.TypeError("__repr__ method must return a string");
        }
        return (PyString)ret;
    }

    public PyString __str__() {
        PyObject ret = this.invoke_ex("__str__");
        if (ret == null) {
            return this.__repr__();
        }
        if (!(ret instanceof PyString)) {
            throw Py.TypeError("__str__ method must return a string");
        }
        return (PyString)ret;
    }

    public PyUnicode __unicode__() {
        PyObject ret = this.invoke_ex("__unicode__");
        if (ret == null) {
            return super.__unicode__();
        }
        if (ret instanceof PyUnicode) {
            return (PyUnicode)ret;
        }
        if (ret instanceof PyString) {
            return new PyUnicode((PyString)ret);
        }
        throw Py.TypeError("__unicode__ must return unicode or str");
    }

    public int hashCode() {
        PyObject ret = this.invoke_ex("__hash__");
        if (ret == null) {
            if (this.__findattr__("__eq__") != null || this.__findattr__("__cmp__") != null) {
                throw Py.TypeError("unhashable instance");
            }
            return super.hashCode();
        }
        if (ret instanceof PyInteger) {
            return ((PyInteger)ret).getValue();
        }
        throw Py.TypeError("__hash__() must return int");
    }

    public int __cmp__(PyObject other) {
        PyObject w;
        PyObject v;
        PyObject[] coerced = this._coerce(other);
        PyObject ret = null;
        if (coerced != null) {
            v = coerced[0];
            w = coerced[1];
            if (!(v instanceof PyInstance) && !(w instanceof PyInstance)) {
                return v._cmp(w);
            }
        } else {
            v = this;
            w = other;
        }
        if (v instanceof PyInstance && (ret = ((PyInstance)v).invoke_ex("__cmp__", w)) != null) {
            if (ret instanceof PyInteger) {
                int result = ((PyInteger)ret).getValue();
                return result < 0 ? -1 : (result > 0 ? 1 : 0);
            }
            throw Py.TypeError("__cmp__() must return int");
        }
        if (w instanceof PyInstance && (ret = ((PyInstance)w).invoke_ex("__cmp__", v)) != null) {
            if (ret instanceof PyInteger) {
                int result = ((PyInteger)ret).getValue();
                return -(result < 0 ? -1 : (result > 0 ? 1 : 0));
            }
            throw Py.TypeError("__cmp__() must return int");
        }
        return -2;
    }

    private PyObject invoke_ex_richcmp(String name, PyObject o) {
        PyObject ret = this.invoke_ex(name, o);
        if (ret == Py.NotImplemented) {
            return null;
        }
        return ret;
    }

    public PyObject __lt__(PyObject o) {
        return this.invoke_ex_richcmp("__lt__", o);
    }

    public PyObject __le__(PyObject o) {
        return this.invoke_ex_richcmp("__le__", o);
    }

    public PyObject __gt__(PyObject o) {
        return this.invoke_ex_richcmp("__gt__", o);
    }

    public PyObject __ge__(PyObject o) {
        return this.invoke_ex_richcmp("__ge__", o);
    }

    public PyObject __eq__(PyObject o) {
        return this.invoke_ex_richcmp("__eq__", o);
    }

    public PyObject __ne__(PyObject o) {
        return this.invoke_ex_richcmp("__ne__", o);
    }

    public boolean __nonzero__() {
        PyObject meth = null;
        try {
            meth = this.__findattr__("__nonzero__");
        }
        catch (PyException exc) {
            // empty catch block
        }
        if (meth == null) {
            CollectionProxy proxy = this.getCollection();
            if (proxy != CollectionProxy.NoProxy) {
                return proxy.__len__() != 0;
            }
            try {
                meth = this.__findattr__("__len__");
            }
            catch (PyException pyException) {
                // empty catch block
            }
            if (meth == null) {
                return true;
            }
        }
        PyObject ret = meth.__call__();
        return ret.__nonzero__();
    }

    private CollectionProxy getCollection() {
        if (this.collectionProxy == null) {
            this.collectionProxy = CollectionProxy.findCollection(this.javaProxy);
        }
        return this.collectionProxy;
    }

    public int __len__() {
        CollectionProxy proxy = this.getCollection();
        if (proxy != CollectionProxy.NoProxy) {
            return proxy.__len__();
        }
        PyObject ret = this.invoke("__len__");
        if (ret instanceof PyInteger) {
            return ((PyInteger)ret).getValue();
        }
        throw Py.TypeError("__len__() should return an int");
    }

    public PyObject __finditem__(int key) {
        CollectionProxy proxy = this.getCollection();
        if (proxy != CollectionProxy.NoProxy) {
            return proxy.__finditem__(key);
        }
        return this.__finditem__(new PyInteger(key));
    }

    private PyObject trySlice(PyObject key, String name, PyObject extraArg) {
        PyObject func;
        if (!(key instanceof PySlice)) {
            return null;
        }
        PySlice slice = (PySlice)key;
        if (slice.step != Py.None && slice.step != Py.One) {
            if (slice.step instanceof PyInteger) {
                if (((PyInteger)slice.step).getValue() != 1) {
                    return null;
                }
            } else {
                return null;
            }
        }
        try {
            func = this.__findattr__(name);
        }
        catch (PyException e) {
            return null;
        }
        if (func == null) {
            return null;
        }
        PyObject start = slice.start;
        PyObject stop = slice.stop;
        if (start == Py.None) {
            start = Py.Zero;
        }
        if (stop == Py.None) {
            stop = new PyInteger(PySystemState.maxint);
        }
        if (extraArg == null) {
            return func.__call__(start, stop);
        }
        return func.__call__(start, stop, extraArg);
    }

    public PyObject __finditem__(PyObject key) {
        CollectionProxy proxy = this.getCollection();
        if (proxy != CollectionProxy.NoProxy) {
            return proxy.__finditem__(key);
        }
        try {
            PyObject ret = this.trySlice(key, "__getslice__", null);
            if (ret != null) {
                return ret;
            }
            return this.invoke("__getitem__", key);
        }
        catch (PyException e) {
            if (Py.matchException(e, Py.IndexError)) {
                return null;
            }
            throw e;
        }
    }

    public PyObject __getitem__(PyObject key) {
        CollectionProxy proxy = this.getCollection();
        if (proxy != CollectionProxy.NoProxy) {
            PyObject ret = proxy.__finditem__(key);
            if (ret == null) {
                throw Py.KeyError(key.toString());
            }
            return ret;
        }
        PyObject ret = this.trySlice(key, "__getslice__", null);
        if (ret != null) {
            return ret;
        }
        return this.invoke("__getitem__", key);
    }

    public void __setitem__(PyObject key, PyObject value) {
        CollectionProxy proxy = this.getCollection();
        if (proxy != CollectionProxy.NoProxy) {
            proxy.__setitem__(key, value);
            return;
        }
        if (this.trySlice(key, "__setslice__", value) != null) {
            return;
        }
        this.invoke("__setitem__", key, value);
    }

    public void __delitem__(PyObject key) {
        CollectionProxy proxy = this.getCollection();
        if (proxy != CollectionProxy.NoProxy) {
            proxy.__delitem__(key);
            return;
        }
        if (this.trySlice(key, "__delslice__", null) != null) {
            return;
        }
        this.invoke("__delitem__", key);
    }

    public PyObject __iter__() {
        PyObject iter = this.getCollectionIter();
        if (iter != null) {
            return iter;
        }
        PyObject func = this.__findattr__("__iter__");
        if (func != null) {
            return func.__call__();
        }
        func = this.__findattr__("__getitem__");
        if (func == null) {
            return super.__iter__();
        }
        return new PySequenceIter(this);
    }

    public PyObject __iternext__() {
        PyObject func = this.__findattr__("next");
        if (func != null) {
            try {
                return func.__call__();
            }
            catch (PyException exc) {
                if (Py.matchException(exc, Py.StopIteration)) {
                    return null;
                }
                throw exc;
            }
        }
        throw Py.TypeError("instance has no next() method");
    }

    private PyObject getCollectionIter() {
        if (iterFactories == null) {
            PyInstance.initializeIterators();
        }
        int i = 0;
        while (iterFactories[i] != null) {
            PyObject iter = iterFactories[i].findCollection(this.javaProxy);
            if (iter != null) {
                return iter;
            }
            ++i;
        }
        return null;
    }

    private static synchronized void initializeIterators() {
        if (iterFactories != null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer().append("org.python.core.CollectionIter,org.python.core.CollectionIter2,");
        Py.getSystemState();
        String factories = stringBuffer.append(PySystemState.registry.getProperty("python.collections", "")).toString();
        int i = 0;
        StringTokenizer st = new StringTokenizer(factories, ",");
        iterFactories = new CollectionIter[st.countTokens() + 1];
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            try {
                Class<?> factoryClass = Class.forName(s);
                CollectionIter factory = (CollectionIter)factoryClass.newInstance();
                PyInstance.iterFactories[i++] = factory;
            }
            catch (Throwable t) {}
        }
    }

    public boolean __contains__(PyObject o) {
        PyObject func = this.__findattr__("__contains__");
        if (func == null) {
            return super.__contains__(o);
        }
        PyObject ret = func.__call__(o);
        return ret.__nonzero__();
    }

    public Object __coerce_ex__(PyObject o) {
        PyObject ret = this.invoke_ex("__coerce__", o);
        if (ret == null || ret == Py.None) {
            return ret;
        }
        if (!(ret instanceof PyTuple)) {
            throw Py.TypeError("coercion should return None or 2-tuple");
        }
        return ((PyTuple)ret).getArray();
    }

    public PyString __hex__() {
        PyObject ret = this.invoke("__hex__");
        if (ret instanceof PyString) {
            return (PyString)ret;
        }
        throw Py.TypeError("__hex__() should return a string");
    }

    public PyString __oct__() {
        PyObject ret = this.invoke("__oct__");
        if (ret instanceof PyString) {
            return (PyString)ret;
        }
        throw Py.TypeError("__oct__() should return a string");
    }

    public PyObject __int__() {
        PyObject ret = this.invoke("__int__");
        if (ret instanceof PyInteger) {
            return (PyInteger)ret;
        }
        throw Py.TypeError("__int__() should return a int");
    }

    public PyFloat __float__() {
        PyObject ret = this.invoke("__float__");
        if (ret instanceof PyFloat) {
            return (PyFloat)ret;
        }
        throw Py.TypeError("__float__() should return a float");
    }

    public PyLong __long__() {
        PyObject ret = this.invoke("__long__");
        if (ret instanceof PyLong) {
            return (PyLong)ret;
        }
        throw Py.TypeError("__long__() should return a long");
    }

    public PyComplex __complex__() {
        PyObject ret = this.invoke("__complex__");
        if (ret instanceof PyComplex) {
            return (PyComplex)ret;
        }
        throw Py.TypeError("__complex__() should return a complex");
    }

    public PyObject __pos__() {
        return this.invoke("__pos__");
    }

    public PyObject __neg__() {
        return this.invoke("__neg__");
    }

    public PyObject __abs__() {
        return this.invoke("__abs__");
    }

    public PyObject __invert__() {
        return this.invoke("__invert__");
    }

    public PyObject __add__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__add__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__add__", o2);
        }
        return o1._add(o2);
    }

    public PyObject __radd__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__radd__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__radd__", o2);
        }
        return o2._add(o1);
    }

    public PyObject __iadd__(PyObject o) {
        PyObject ret = this.invoke_ex("__iadd__", o);
        if (ret != null) {
            return ret;
        }
        return super.__iadd__(o);
    }

    public PyObject __sub__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__sub__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__sub__", o2);
        }
        return o1._sub(o2);
    }

    public PyObject __rsub__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rsub__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rsub__", o2);
        }
        return o2._sub(o1);
    }

    public PyObject __isub__(PyObject o) {
        PyObject ret = this.invoke_ex("__isub__", o);
        if (ret != null) {
            return ret;
        }
        return super.__isub__(o);
    }

    public PyObject __mul__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__mul__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__mul__", o2);
        }
        return o1._mul(o2);
    }

    public PyObject __rmul__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rmul__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rmul__", o2);
        }
        return o2._mul(o1);
    }

    public PyObject __imul__(PyObject o) {
        PyObject ret = this.invoke_ex("__imul__", o);
        if (ret != null) {
            return ret;
        }
        return super.__imul__(o);
    }

    public PyObject __div__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__div__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__div__", o2);
        }
        return o1._div(o2);
    }

    public PyObject __rdiv__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rdiv__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rdiv__", o2);
        }
        return o2._div(o1);
    }

    public PyObject __idiv__(PyObject o) {
        PyObject ret = this.invoke_ex("__idiv__", o);
        if (ret != null) {
            return ret;
        }
        return super.__idiv__(o);
    }

    public PyObject __floordiv__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__floordiv__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__floordiv__", o2);
        }
        return o1._floordiv(o2);
    }

    public PyObject __rfloordiv__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rfloordiv__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rfloordiv__", o2);
        }
        return o2._floordiv(o1);
    }

    public PyObject __ifloordiv__(PyObject o) {
        PyObject ret = this.invoke_ex("__ifloordiv__", o);
        if (ret != null) {
            return ret;
        }
        return super.__ifloordiv__(o);
    }

    public PyObject __truediv__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__truediv__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__truediv__", o2);
        }
        return o1._truediv(o2);
    }

    public PyObject __rtruediv__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rtruediv__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rtruediv__", o2);
        }
        return o2._truediv(o1);
    }

    public PyObject __itruediv__(PyObject o) {
        PyObject ret = this.invoke_ex("__itruediv__", o);
        if (ret != null) {
            return ret;
        }
        return super.__itruediv__(o);
    }

    public PyObject __mod__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__mod__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__mod__", o2);
        }
        return o1._mod(o2);
    }

    public PyObject __rmod__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rmod__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rmod__", o2);
        }
        return o2._mod(o1);
    }

    public PyObject __imod__(PyObject o) {
        PyObject ret = this.invoke_ex("__imod__", o);
        if (ret != null) {
            return ret;
        }
        return super.__imod__(o);
    }

    public PyObject __divmod__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__divmod__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__divmod__", o2);
        }
        return o1._divmod(o2);
    }

    public PyObject __rdivmod__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rdivmod__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rdivmod__", o2);
        }
        return o2._divmod(o1);
    }

    public PyObject __pow__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__pow__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__pow__", o2);
        }
        return o1._pow(o2);
    }

    public PyObject __rpow__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rpow__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rpow__", o2);
        }
        return o2._pow(o1);
    }

    public PyObject __ipow__(PyObject o) {
        PyObject ret = this.invoke_ex("__ipow__", o);
        if (ret != null) {
            return ret;
        }
        return super.__ipow__(o);
    }

    public PyObject __lshift__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__lshift__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__lshift__", o2);
        }
        return o1._lshift(o2);
    }

    public PyObject __rlshift__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rlshift__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rlshift__", o2);
        }
        return o2._lshift(o1);
    }

    public PyObject __ilshift__(PyObject o) {
        PyObject ret = this.invoke_ex("__ilshift__", o);
        if (ret != null) {
            return ret;
        }
        return super.__ilshift__(o);
    }

    public PyObject __rshift__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rshift__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rshift__", o2);
        }
        return o1._rshift(o2);
    }

    public PyObject __rrshift__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rrshift__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rrshift__", o2);
        }
        return o2._rshift(o1);
    }

    public PyObject __irshift__(PyObject o) {
        PyObject ret = this.invoke_ex("__irshift__", o);
        if (ret != null) {
            return ret;
        }
        return super.__irshift__(o);
    }

    public PyObject __and__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__and__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__and__", o2);
        }
        return o1._and(o2);
    }

    public PyObject __rand__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rand__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rand__", o2);
        }
        return o2._and(o1);
    }

    public PyObject __iand__(PyObject o) {
        PyObject ret = this.invoke_ex("__iand__", o);
        if (ret != null) {
            return ret;
        }
        return super.__iand__(o);
    }

    public PyObject __or__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__or__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__or__", o2);
        }
        return o1._or(o2);
    }

    public PyObject __ror__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__ror__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__ror__", o2);
        }
        return o2._or(o1);
    }

    public PyObject __ior__(PyObject o) {
        PyObject ret = this.invoke_ex("__ior__", o);
        if (ret != null) {
            return ret;
        }
        return super.__ior__(o);
    }

    public PyObject __xor__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__xor__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__xor__", o2);
        }
        return o1._xor(o2);
    }

    public PyObject __rxor__(PyObject o) {
        Object ctmp = this.__coerce_ex__(o);
        if (ctmp == null || ctmp == Py.None) {
            return this.invoke_ex("__rxor__", o);
        }
        PyObject o1 = ((PyObject[])ctmp)[0];
        PyObject o2 = ((PyObject[])ctmp)[1];
        if (this == o1) {
            return this.invoke_ex("__rxor__", o2);
        }
        return o2._xor(o1);
    }

    public PyObject __ixor__(PyObject o) {
        PyObject ret = this.invoke_ex("__ixor__", o);
        if (ret != null) {
            return ret;
        }
        return super.__ixor__(o);
    }

    static {
        iterFactories = null;
    }
}

