/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyException;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequenceIter;
import org.python.core.PySlice;
import org.python.core.PyTuple;
import org.python.core.PyType;

public abstract class PySequence
extends PyObject {
    public PySequence() {
    }

    protected PySequence(PyType type) {
        super(type);
    }

    protected abstract PyObject pyget(int var1);

    protected abstract PyObject getslice(int var1, int var2, int var3);

    protected abstract PyObject repeat(int var1);

    protected void set(int index, PyObject value) {
        throw Py.TypeError("can't assign to immutable object");
    }

    protected void setslice(int start, int stop, int step, PyObject value) {
        throw Py.TypeError("can't assign to immutable object");
    }

    protected void del(int i) throws PyException {
        throw Py.TypeError("can't remove from immutable object");
    }

    protected void delRange(int start, int stop, int step) {
        throw Py.TypeError("can't remove from immutable object");
    }

    public boolean __nonzero__() {
        return this.seq___nonzero__();
    }

    final boolean seq___nonzero__() {
        return this.__len__() != 0;
    }

    public PyObject __iter__() {
        return this.seq___iter__();
    }

    final PyObject seq___iter__() {
        return new PySequenceIter(this);
    }

    public synchronized PyObject __eq__(PyObject o) {
        return this.seq___eq__(o);
    }

    final synchronized PyObject seq___eq__(PyObject o) {
        int ol;
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o.__len__())) {
            return Py.Zero;
        }
        int i = PySequence.cmp(this, tl, o, ol);
        return i < 0 ? Py.One : Py.Zero;
    }

    public synchronized PyObject __ne__(PyObject o) {
        return this.seq___ne__(o);
    }

    final synchronized PyObject seq___ne__(PyObject o) {
        int ol;
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o.__len__())) {
            return Py.One;
        }
        int i = PySequence.cmp(this, tl, o, ol);
        return i < 0 ? Py.Zero : Py.One;
    }

    public synchronized PyObject __lt__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -1 ? Py.One : Py.Zero;
        }
        return this.__finditem__(i)._lt(o.__finditem__(i));
    }

    final synchronized PyObject seq___lt__(PyObject o) {
        return this.__lt__(o);
    }

    public synchronized PyObject __le__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -1 || i == -2 ? Py.One : Py.Zero;
        }
        return this.__finditem__(i)._le(o.__finditem__(i));
    }

    final synchronized PyObject seq___le__(PyObject o) {
        return this.__le__(o);
    }

    public synchronized PyObject __gt__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -3 ? Py.One : Py.Zero;
        }
        return this.__finditem__(i)._gt(o.__finditem__(i));
    }

    final synchronized PyObject seq___gt__(PyObject o) {
        return this.__gt__(o);
    }

    public synchronized PyObject __ge__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -3 || i == -2 ? Py.One : Py.Zero;
        }
        return this.__finditem__(i)._ge(o.__finditem__(i));
    }

    final synchronized PyObject seq___ge__(PyObject o) {
        return this.__ge__(o);
    }

    protected static int cmp(PyObject o1, int ol1, PyObject o2, int ol2) {
        if (ol1 < 0) {
            ol1 = o1.__len__();
        }
        if (ol2 < 0) {
            ol2 = o2.__len__();
        }
        for (int i = 0; i < ol1 && i < ol2; ++i) {
            if (o1.__getitem__(i)._eq(o2.__getitem__(i)).__nonzero__()) continue;
            return i;
        }
        if (ol1 == ol2) {
            return -2;
        }
        return ol1 < ol2 ? -1 : -3;
    }

    protected static PyObject fastSequence(PyObject seq, String msg) {
        if (seq instanceof PyList || seq instanceof PyTuple) {
            return seq;
        }
        PyList list = new PyList();
        PyObject iter = Py.iter(seq, msg);
        PyObject item = null;
        while ((item = iter.__iternext__()) != null) {
            list.append(item);
        }
        return list;
    }

    protected static final int sliceLength(int start, int stop, int step) {
        int ret = step > 0 ? (stop - start + step - 1) / step : (stop - start + step + 1) / step;
        if (ret < 0) {
            return 0;
        }
        return ret;
    }

    private static final int getIndex(PyObject index, int defaultValue) {
        block6: {
            if (index == Py.None || index == null) {
                return defaultValue;
            }
            if (index instanceof PyLong) {
                try {
                    index = (PyInteger)index.__int__();
                }
                catch (PyException exc) {
                    if (!Py.matchException(exc, Py.OverflowError)) break block6;
                    if (new PyLong(0L).__cmp__(index) < 0) {
                        return Integer.MAX_VALUE;
                    }
                    return 0;
                }
            }
        }
        if (!(index instanceof PyInteger)) {
            throw Py.TypeError("slice index must be int");
        }
        return ((PyInteger)index).getValue();
    }

    protected int fixindex(int index) {
        int l = this.__len__();
        if (index < 0) {
            index += l;
        }
        if (index < 0 || index >= l) {
            return -1;
        }
        return index;
    }

    public synchronized PyObject __finditem__(int index) {
        if ((index = this.fixindex(index)) == -1) {
            return null;
        }
        return this.pyget(index);
    }

    public PyObject __finditem__(PyObject index) {
        return this.seq___finditem__(index);
    }

    final PyObject seq___finditem__(PyObject index) {
        if (index instanceof PyInteger) {
            return this.__finditem__(((PyInteger)index).getValue());
        }
        if (index instanceof PySlice) {
            PySlice s = (PySlice)index;
            return this.__getslice__(s.start, s.stop, s.step);
        }
        if (index instanceof PyLong) {
            return this.__finditem__(((PyInteger)index.__int__()).getValue());
        }
        throw Py.TypeError("sequence subscript must be integer or slice");
    }

    public PyObject __getitem__(PyObject index) {
        return this.seq___getitem__(index);
    }

    final PyObject seq___getitem__(PyObject index) {
        PyObject ret = this.__finditem__(index);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + index);
        }
        return ret;
    }

    public boolean isMappingType() throws PyIgnoreMethodTag {
        return false;
    }

    public boolean isNumberType() throws PyIgnoreMethodTag {
        return false;
    }

    protected static final int getStep(PyObject s_step) {
        int step = PySequence.getIndex(s_step, 1);
        if (step == 0) {
            throw Py.TypeError("slice step of zero not allowed");
        }
        return step;
    }

    protected static final int getStart(PyObject s_start, int step, int length) {
        int start;
        if (step < 0) {
            start = PySequence.getIndex(s_start, length - 1);
            if (start < 0) {
                start += length;
            }
            if (start < 0) {
                start = -1;
            }
            if (start >= length) {
                start = length - 1;
            }
        } else {
            start = PySequence.getIndex(s_start, 0);
            if (start < 0) {
                start += length;
            }
            if (start < 0) {
                start = 0;
            }
            if (start >= length) {
                start = length;
            }
        }
        return start;
    }

    protected static final int getStop(PyObject s_stop, int start, int step, int length) {
        int stop;
        if (step < 0) {
            stop = PySequence.getIndex(s_stop, -1);
            if (stop < -1) {
                stop = length + stop;
            }
            if (stop < -1) {
                stop = -1;
            }
        } else {
            stop = PySequence.getIndex(s_stop, length);
            if (stop < 0) {
                stop = length + stop;
            }
            if (stop < 0) {
                stop = 0;
            }
        }
        if (stop > length) {
            stop = length;
        }
        return stop;
    }

    public synchronized PyObject __getslice__(PyObject s_start, PyObject s_stop, PyObject s_step) {
        return this.seq___getslice__(s_start, s_stop, s_step);
    }

    final synchronized PyObject seq___getslice__(PyObject s_start, PyObject s_stop) {
        return this.seq___getslice__(s_start, s_stop, null);
    }

    final synchronized PyObject seq___getslice__(PyObject s_start, PyObject s_stop, PyObject s_step) {
        int length = this.__len__();
        int step = PySequence.getStep(s_step);
        int start = PySequence.getStart(s_start, step, length);
        int stop = PySequence.getStop(s_stop, start, step, length);
        return this.getslice(start, stop, step);
    }

    public synchronized void __setslice__(PyObject s_start, PyObject s_stop, PyObject s_step, PyObject value) {
        this.seq___setslice__(s_start, s_stop, s_step, value);
    }

    final synchronized void seq___setslice__(PyObject s_start, PyObject s_stop, PyObject value) {
        this.seq___setslice__(s_start, s_stop, null, value);
    }

    final synchronized void seq___setslice__(PyObject s_start, PyObject s_stop, PyObject s_step, PyObject value) {
        int length = this.__len__();
        int step = PySequence.getStep(s_step);
        int start = PySequence.getStart(s_start, step, length);
        int stop = PySequence.getStop(s_stop, start, step, length);
        this.setslice(start, stop, step, value);
    }

    public synchronized void __delslice__(PyObject s_start, PyObject s_stop, PyObject s_step) {
        this.seq___delslice__(s_start, s_stop, s_step);
    }

    final synchronized void seq___delslice__(PyObject s_start, PyObject s_stop, PyObject s_step) {
        int length = this.__len__();
        int step = PySequence.getStep(s_step);
        int start = PySequence.getStart(s_start, step, length);
        int stop = PySequence.getStop(s_stop, start, step, length);
        this.delRange(start, stop, step);
    }

    public synchronized void __setitem__(int index, PyObject value) {
        int i = this.fixindex(index);
        if (i == -1) {
            throw Py.IndexError("index out of range: " + i);
        }
        this.set(i, value);
    }

    public void __setitem__(PyObject index, PyObject value) {
        this.seq___setitem__(index, value);
    }

    final void seq___setitem__(PyObject index, PyObject value) {
        if (index instanceof PyInteger) {
            this.__setitem__(((PyInteger)index).getValue(), value);
        } else if (index instanceof PySlice) {
            PySlice s = (PySlice)index;
            this.__setslice__(s.start, s.stop, s.step, value);
        } else if (index instanceof PyLong) {
            this.__setitem__(((PyInteger)index.__int__()).getValue(), value);
        } else {
            throw Py.TypeError("sequence subscript must be integer or slice");
        }
    }

    public synchronized void __delitem__(PyObject index) {
        this.seq___delitem__(index);
    }

    final synchronized void seq___delitem__(PyObject index) {
        if (index instanceof PyInteger) {
            int i = this.fixindex(((PyInteger)index).getValue());
            if (i == -1) {
                throw Py.IndexError("index out of range: " + i);
            }
            this.del(i);
        } else if (index instanceof PySlice) {
            PySlice s = (PySlice)index;
            this.__delslice__(s.start, s.stop, s.step);
        } else if (index instanceof PyLong) {
            int i = this.fixindex(((PyInteger)index.__int__()).getValue());
            if (i == -1) {
                throw Py.IndexError("index out of range: " + i);
            }
            this.del(i);
        } else {
            throw Py.TypeError("sequence subscript must be integer or slice");
        }
    }

    public synchronized Object __tojava__(Class c) throws PyIgnoreMethodTag {
        if (c.isArray()) {
            Class<?> component = c.getComponentType();
            try {
                int n = this.__len__();
                PyArray array = new PyArray(component, n);
                for (int i = 0; i < n; ++i) {
                    PyObject o = this.pyget(i);
                    array.set(i, o);
                }
                return array.getArray();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.__tojava__(c);
    }

    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("*")) {
            return "can''t multiply sequence by non-int of type ''{2}''";
        }
        return null;
    }

    protected String runsupportedopMessage(String op, PyObject o2) {
        if (op.equals("*")) {
            return "can''t multiply sequence by non-int of type ''{1}''";
        }
        return null;
    }
}

