/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.adapter;

import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaInstance;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.adapter.ClassAdapter;
import org.python.core.adapter.ExtensiblePyObjectAdapter;
import org.python.core.adapter.PyObjectAdapter;

public class ClassicPyObjectAdapter
extends ExtensiblePyObjectAdapter {
    static /* synthetic */ Class class$org$python$core$PyObject;

    public ClassicPyObjectAdapter() {
        this.addPreClass(new PyObjectAdapter(){

            public PyObject adapt(Object o) {
                return (PyObject)o;
            }

            public boolean canAdapt(Object o) {
                return o instanceof PyObject;
            }
        });
        this.addPreClass(new PyObjectAdapter(){

            public PyObject adapt(Object o) {
                return ((PyProxy)o)._getPyInstance();
            }

            public boolean canAdapt(Object o) {
                return o instanceof PyProxy;
            }
        });
        this.addPreClass(new PyObjectAdapter(){

            public boolean canAdapt(Object o) {
                return o == null;
            }

            public PyObject adapt(Object o) {
                return Py.None;
            }
        });
        this.add(new ClassAdapter(String.class){

            public PyObject adapt(Object o) {
                return new PyString((String)o);
            }
        });
        this.add(new ClassAdapter(Character.class){

            public PyObject adapt(Object o) {
                return Py.makeCharacter((Character)o);
            }
        });
        this.add(new ClassAdapter(Class.class){

            public PyObject adapt(Object o) {
                Class cls;
                if ((class$org$python$core$PyObject == null ? (class$org$python$core$PyObject = ClassicPyObjectAdapter.class$("org.python.core.PyObject")) : class$org$python$core$PyObject).isAssignableFrom(cls = (Class)o)) {
                    return PyType.fromClass(cls);
                }
                return PyJavaClass.lookup(cls);
            }
        });
        this.add(new NumberToPyFloat(Double.class));
        this.add(new NumberToPyFloat(Float.class));
        this.add(new NumberToPyInteger(Integer.class));
        this.add(new NumberToPyInteger(Byte.class));
        this.add(new NumberToPyInteger(Short.class));
        this.add(new ClassAdapter(Long.class){

            public PyObject adapt(Object o) {
                return new PyLong(((Number)o).longValue());
            }
        });
        this.add(new ClassAdapter(Boolean.class){

            public PyObject adapt(Object o) {
                return (Boolean)o != false ? Py.One : Py.Zero;
            }
        });
        this.addPostClass(new PyObjectAdapter(){

            public PyObject adapt(Object o) {
                return new PyArray(o.getClass().getComponentType(), o);
            }

            public boolean canAdapt(Object o) {
                return o.getClass().isArray();
            }
        });
    }

    public boolean canAdapt(Object o) {
        return true;
    }

    public PyObject adapt(Object o) {
        PyObject result = super.adapt(o);
        if (result != null) {
            return result;
        }
        return new PyJavaInstance(o);
    }

    private static class NumberToPyFloat
    extends ClassAdapter {
        public NumberToPyFloat(Class c) {
            super(c);
        }

        public PyObject adapt(Object o) {
            return new PyFloat(((Number)o).doubleValue());
        }
    }

    private static class NumberToPyInteger
    extends ClassAdapter {
        public NumberToPyInteger(Class c) {
            super(c);
        }

        public PyObject adapt(Object o) {
            return new PyInteger(((Number)o).intValue());
        }
    }
}

