/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.sql;

import dods.dap.DAS;
import dods.dap.DODSException;
import dods.dap.Server.FunctionLibrary;
import dods.dap.parser.ParseException;
import dods.servers.sql.GuardedSQLDataset;
import dods.servers.sql.SqlClauseFac;
import dods.servers.sql.sqlCEEval;
import dods.servers.sql.sqlDDS;
import dods.servers.sql.sqlResponse;
import dods.servlet.DODSServlet;
import dods.servlet.GuardedDataset;
import dods.servlet.ReqState;
import dods.util.Debug;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class dodsSQLServlet
extends DODSServlet {
    private static final boolean _Debug = false;
    private Connection currentConnection = null;
    private Statement currentStatement = null;

    protected abstract GuardedSQLDataset getSQLDataset(ReqState var1) throws DODSException, IOException, ParseException;

    protected GuardedDataset getDataset(ReqState rs) throws DODSException, IOException, ParseException {
        return this.getSQLDataset(rs);
    }

    public abstract String getServerVersion();

    public void init() throws ServletException {
        super.init();
        String jdbcDriver = "openlink.jdbc2.Driver";
        String tmp = this.getInitParameter("JDBCdriver");
        if (tmp != null) {
            jdbcDriver = tmp;
        }
        try {
            Class.forName(jdbcDriver);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("\n Cannot Load JDBC Driver Class: " + e.getMessage() + "\n Is the driver name spelled correctly?" + "\n Is the .class file or the jar file" + "\n containing the driver on the CLASSPATH ??\n\n");
        }
        System.out.println("Using JDBC Driver:    " + jdbcDriver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doGetDODS(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        block28: {
            BufferedOutputStream eOut;
            ServletOutputStream sOut;
            block27: {
                if (Debug.isSet("showResponse")) {
                    System.out.println("DRDS   Sending DODS Data For: " + rs.getDataSet() + "    CE: '" + rs.getConstraintExpression() + "'");
                }
                response.setContentType("application/octet-stream");
                response.setHeader("XDODS-Server", this.getServerVersion());
                response.setHeader("Content-Description", "dods_data");
                sOut = response.getOutputStream();
                FilterOutputStream bOut = null;
                eOut = null;
                if (rs.getAcceptsCompressed()) {
                    response.setHeader("Content-Encoding", "deflate");
                    bOut = new DeflaterOutputStream((OutputStream)sOut);
                } else {
                    bOut = new BufferedOutputStream((OutputStream)sOut);
                }
                GuardedSQLDataset sqlDS = null;
                sqlDS = this.getSQLDataset(rs);
                sqlDDS myDDS = sqlDS.getSQLDDS();
                DAS myDAS = sqlDS.getDAS();
                FunctionLibrary flib = new FunctionLibrary();
                flib.setPrefix("dods.servers.sql.SSF");
                SqlClauseFac scf = new SqlClauseFac(flib);
                sqlCEEval ce = new sqlCEEval(myDDS, scf);
                ce.parseConstraint(rs.getConstraintExpression());
                boolean useDSName = false;
                String tmp = this.getInitParameter("UseDatasetName");
                if (tmp != null && (tmp.equals("") || tmp.equalsIgnoreCase("true"))) {
                    useDSName = true;
                }
                System.out.println("UseDataSetName is: " + useDSName);
                String query = ce.getSQLQuery(myDAS, useDSName);
                if (Debug.isSet("showRequest")) {
                    System.out.println("Query String: \"" + query + "\"");
                }
                this.connect2DB();
                ResultSet resSet = this.currentStatement.executeQuery(query);
                if (resSet.next()) {
                    int maxRows = 10;
                    tmp = rs.getInitParameter("JDBCMaxResponseLength");
                    if (tmp != null) {
                        maxRows = Integer.decode(tmp);
                    }
                    sqlResponse res = new sqlResponse(resSet, maxRows);
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter(bOut));
                    myDDS.printConstrained(pw);
                    if (Debug.isSet("showResponse")) {
                        System.out.println("SQL query response recieved.\nSending Data...");
                    }
                    pw.flush();
                    ((OutputStream)bOut).write("\nData:\n".getBytes());
                    ((OutputStream)bOut).flush();
                    DataOutputStream sink = new DataOutputStream(bOut);
                    ce.send(myDDS.getName(), sink, res);
                    sink.flush();
                    if (rs.getAcceptsCompressed()) {
                        ((DeflaterOutputStream)bOut).finish();
                    }
                    if (Debug.isSet("showResponse")) {
                        System.out.println("Done!");
                    }
                    break block27;
                }
                eOut = new BufferedOutputStream((OutputStream)sOut);
                response.setHeader("Content-Description", "dods_error");
                response.setHeader("Content-Encoding", "");
                DODSException de = new DODSException("Your Query Produced No Matching Results.");
                de.print(eOut);
                de.print(System.out);
            }
            Object var22_28 = null;
            try {
                this.currentStatement.close();
                this.currentConnection.close();
                if (Debug.isSet("JDBC")) {
                    System.out.println("Closed Database connection.");
                }
                break block28;
            }
            catch (SQLException e) {
                DODSException de22 = new DODSException(e.toString());
                de22.print(eOut);
                de22.print(System.out);
            }
            break block28;
            {
                catch (DODSException de) {
                    eOut = new BufferedOutputStream((OutputStream)sOut);
                    response.setHeader("Content-Description", "dods_error");
                    response.setHeader("Content-Encoding", "");
                    de.print(eOut);
                    de.print(System.out);
                    Object var22_29 = null;
                    try {
                        this.currentStatement.close();
                        this.currentConnection.close();
                        if (Debug.isSet("JDBC")) {
                            System.out.println("Closed Database connection.");
                        }
                        break block28;
                    }
                    catch (SQLException e) {
                        DODSException de22 = new DODSException(e.toString());
                        de22.print(eOut);
                        de22.print(System.out);
                    }
                    break block28;
                }
                catch (SQLException sqle) {
                    eOut = new BufferedOutputStream((OutputStream)sOut);
                    response.setHeader("Content-Description", "dods_error");
                    response.setHeader("Content-Encoding", "");
                    DODSException de = new DODSException(sqle.toString());
                    de.print(eOut);
                    de.print(System.out);
                    Object var22_30 = null;
                    try {
                        this.currentStatement.close();
                        this.currentConnection.close();
                        if (Debug.isSet("JDBC")) {
                            System.out.println("Closed Database connection.");
                        }
                        break block28;
                    }
                    catch (SQLException e) {
                        DODSException de22 = new DODSException(e.toString());
                        de22.print(eOut);
                        de22.print(System.out);
                    }
                    break block28;
                }
                catch (ParseException pe) {
                    eOut = new BufferedOutputStream((OutputStream)sOut);
                    response.setHeader("Content-Description", "dods_error");
                    response.setHeader("Content-Encoding", "");
                    String msg = pe.getMessage().replace('\"', '\'');
                    DODSException de2 = new DODSException(5, msg);
                    de2.print(eOut);
                    de2.print(System.out);
                    Object var22_31 = null;
                    try {
                        this.currentStatement.close();
                        this.currentConnection.close();
                        if (Debug.isSet("JDBC")) {
                            System.out.println("Closed Database connection.");
                        }
                        break block28;
                    }
                    catch (SQLException e) {
                        DODSException de22 = new DODSException(e.toString());
                        de22.print(eOut);
                        de22.print(System.out);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var22_32 = null;
                try {
                    this.currentStatement.close();
                    this.currentConnection.close();
                    if (Debug.isSet("JDBC")) {
                        System.out.println("Closed Database connection.");
                    }
                }
                catch (SQLException e) {
                    DODSException de22 = new DODSException(e.toString());
                    de22.print(eOut);
                    de22.print(System.out);
                }
                throw throwable;
            }
        }
        response.setStatus(200);
    }

    private void connect2DB() throws SQLException {
        String jdbcDriver = "";
        String connectionURL = "jdbc:openlink://cupcake.oce.orst.edu/DSN=oplEOSDB";
        String uname = "";
        String password = "";
        String tmp = null;
        tmp = this.getInitParameter("JDBCdriver");
        if (tmp != null) {
            jdbcDriver = tmp;
        }
        if ((tmp = this.getInitParameter("JDBCconnectionURL")) != null) {
            connectionURL = tmp;
        }
        if ((tmp = this.getInitParameter("JDBCusername")) != null) {
            uname = tmp;
        }
        if ((tmp = this.getInitParameter("JDBCpassword")) != null) {
            password = tmp;
        }
        if (Debug.isSet("JDBC")) {
            System.out.println("Using JDBC Driver:    " + jdbcDriver);
        }
        if (Debug.isSet("JDBC")) {
            System.out.println("Using Connection URL: " + connectionURL);
        }
        this.currentConnection = DriverManager.getConnection(connectionURL, uname, password);
        this.currentStatement = this.currentConnection.createStatement();
        if (Debug.isSet("JDBC")) {
            System.out.println("Opened Database connection.");
        }
    }

    public void processResult(ResultSet result, PrintStream dOut) throws SQLException, IOException {
        ResultSetMetaData meta = result.getMetaData();
        int count = meta.getColumnCount();
        this.printColumnNames(meta, dOut);
        int limit = 0;
        while (limit++ < 10) {
            for (int c = 1; c <= count; ++c) {
                String tmp = result.getString(c);
                if (tmp == null) {
                    dOut.println("null ");
                    System.out.print("null ");
                }
                dOut.print(tmp + "   ");
                System.out.print(tmp + "   ");
            }
            dOut.println("");
            System.out.println("");
            result.next();
        }
        dOut.println("limit: " + limit);
    }

    public void printColumnNames(ResultSetMetaData m, PrintStream dOut) throws SQLException {
        int count = m.getColumnCount();
        String metaStuff = "";
        for (int c = 1; c <= count; ++c) {
            String name = m.getColumnName(c);
            String type = m.getColumnTypeName(c);
            name = name == null ? "NULL  " : name + "(" + type + ")  ";
            metaStuff = metaStuff + name;
        }
        dOut.println(metaStuff);
        for (int i = 0; i < metaStuff.length(); ++i) {
            dOut.print("-");
        }
        dOut.println("");
    }
}

