/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import org.jdom2.Element;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;
import ucar.nc2.write.CDLWriter;

@Deprecated
public class NCdumpW {
    private static String usage = "usage: NCdumpW <filename> [-cdl | -ncml] [-c | -vall] [-v varName1;varName2;..] [-v varName(0:1,:,12)]\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean print(String command, Writer out, CancelTask ct) throws IOException {
        StringTokenizer stoke = new StringTokenizer(command);
        if (!stoke.hasMoreTokens()) {
            out.write(usage);
            return false;
        }
        String filename = stoke.nextToken();
        try {
            boolean bl;
            block12: {
                NetcdfFile nc = NetcdfDataset.openFile(filename, ct);
                try {
                    int pos = command.indexOf(filename);
                    command = command.substring(pos + filename.length());
                    bl = NCdumpW.print(nc, command, out, ct);
                    if (nc == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (nc != null) {
                            try {
                                nc.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        out.write("file not found= ");
                        out.write(filename);
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                nc.close();
            }
            return bl;
        }
        finally {
            out.close();
        }
    }

    public static boolean print(NetcdfFile nc, String command, Writer out, CancelTask ct) throws IOException {
        WantValues showValues = WantValues.none;
        boolean ncml = false;
        boolean strict = false;
        String varNames = null;
        String trueDataset = null;
        String fakeDataset = null;
        if (command != null) {
            StringTokenizer stoke = new StringTokenizer(command);
            while (stoke.hasMoreTokens()) {
                String toke = stoke.nextToken();
                if (toke.equalsIgnoreCase("-help")) {
                    out.write(usage);
                    out.write(10);
                    return true;
                }
                if (toke.equalsIgnoreCase("-vall")) {
                    showValues = WantValues.all;
                }
                if (toke.equalsIgnoreCase("-c") && showValues == WantValues.none) {
                    showValues = WantValues.coordsOnly;
                }
                if (toke.equalsIgnoreCase("-ncml")) {
                    ncml = true;
                }
                if (toke.equalsIgnoreCase("-cdl") || toke.equalsIgnoreCase("-strict")) {
                    strict = true;
                }
                if (toke.equalsIgnoreCase("-v") && stoke.hasMoreTokens()) {
                    varNames = stoke.nextToken();
                }
                if (!toke.equalsIgnoreCase("-datasetname") || !stoke.hasMoreTokens()) continue;
                fakeDataset = stoke.nextToken();
                if (fakeDataset.isEmpty()) {
                    fakeDataset = null;
                }
                if (fakeDataset == null) continue;
                trueDataset = nc.getLocation();
                nc.setLocation(fakeDataset);
            }
        }
        boolean ok = NCdumpW.print(nc, out, showValues, ncml, strict, varNames, ct);
        if (trueDataset != null && fakeDataset != null) {
            nc.setLocation(trueDataset);
        }
        return ok;
    }

    public static boolean print(String filename, Writer out, boolean showAll, boolean showCoords, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        boolean bl;
        block8: {
            NetcdfFile nc = NetcdfDataset.openFile(filename, ct);
            try {
                bl = NCdumpW.print(nc, out, showAll, showCoords, ncml, strict, varNames, ct);
                if (nc == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (nc != null) {
                        try {
                            nc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    out.write("file not found= ");
                    out.write(filename);
                    out.flush();
                    return false;
                }
            }
            nc.close();
        }
        return bl;
    }

    public static boolean print(NetcdfFile nc, Writer out, boolean showAll, boolean showCoords, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        WantValues showValues = WantValues.none;
        if (showAll) {
            showValues = WantValues.all;
        } else if (showCoords) {
            showValues = WantValues.coordsOnly;
        }
        return NCdumpW.print(nc, out, showValues, ncml, strict, varNames, ct);
    }

    public static boolean print(NetcdfFile nc, Writer out, WantValues showValues, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        block16: {
            boolean headerOnly = showValues == WantValues.none && varNames == null;
            try {
                if (ncml) {
                    NCdumpW.writeNcML(nc, out, showValues, null);
                    break block16;
                }
                if (headerOnly) {
                    CDLWriter.writeCDL(nc, out, strict);
                    break block16;
                }
                PrintWriter ps = new PrintWriter(out);
                nc.toStringStart(ps, strict);
                Indent indent = new Indent(2);
                indent.incr();
                ps.printf("%n%sdata:%n", indent);
                indent.incr();
                if (showValues == WantValues.all) {
                    for (Variable v : nc.getVariables()) {
                        NCdumpW.printArray(v.read(), v.getFullName(), ps, indent, ct);
                        if (ct == null || !ct.isCancel()) continue;
                        return false;
                    }
                } else if (showValues == WantValues.coordsOnly) {
                    for (Variable v : nc.getVariables()) {
                        if (v.isCoordinateVariable()) {
                            NCdumpW.printArray(v.read(), v.getFullName(), ps, indent, ct);
                        }
                        if (ct == null || !ct.isCancel()) continue;
                        return false;
                    }
                }
                if (showValues != WantValues.all && varNames != null) {
                    StringTokenizer stoke = new StringTokenizer(varNames, ";");
                    while (stoke.hasMoreTokens()) {
                        String varSubset = stoke.nextToken();
                        if (varSubset.indexOf(40) >= 0) {
                            Array data = nc.readSection(varSubset);
                            NCdumpW.printArray(data, varSubset, ps, indent, ct);
                        } else {
                            Variable v = nc.findVariable(varSubset);
                            if (v == null) {
                                ps.print(" cant find variable: " + varSubset + "\n   " + usage);
                                continue;
                            }
                            if (showValues != WantValues.coordsOnly || v.isCoordinateVariable()) {
                                NCdumpW.printArray(v.read(), v.getFullName(), ps, indent, ct);
                            }
                        }
                        if (ct == null || !ct.isCancel()) continue;
                        return false;
                    }
                }
                indent.decr();
                indent.decr();
                nc.toStringEnd(ps);
            }
            catch (Exception e) {
                e.printStackTrace();
                out.write(e.getMessage());
                out.flush();
                return false;
            }
        }
        out.flush();
        return true;
    }

    public static String printVariableData(Variable v, CancelTask ct) throws IOException {
        Array data = v.read();
        StringWriter writer = new StringWriter(10000);
        NCdumpW.printArray(data, v.getFullName(), new PrintWriter(writer), new Indent(2), ct);
        return writer.toString();
    }

    public static String printVariableDataSection(Variable v, String sectionSpec, CancelTask ct) throws IOException, InvalidRangeException {
        Array data = v.read(sectionSpec);
        StringWriter writer = new StringWriter(20000);
        NCdumpW.printArray(data, v.getFullName(), new PrintWriter(writer), new Indent(2), ct);
        return writer.toString();
    }

    @Deprecated
    public static String toString(Array array, String name, CancelTask ct) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        NCdumpW.printArray(array, name, null, pw, new Indent(2), ct, true);
        return sw.toString();
    }

    private static void printArray(Array array, String name, PrintWriter out, Indent indent, CancelTask ct) {
        NCdumpW.printArray(array, name, null, out, indent, ct, true);
        out.flush();
    }

    private static void printArray(Array array, String name, String units, PrintWriter out, Indent ilev, CancelTask ct, boolean printSeq) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        if (name != null) {
            out.print(ilev + name + " = ");
        }
        ilev.incr();
        if (array == null) {
            out.println("null array for " + name);
            ilev.decr();
            return;
        }
        if (array instanceof ArrayChar && array.getRank() > 0) {
            NCdumpW.printStringArray(out, (ArrayChar)array, ilev, ct);
        } else if (array.getElementType() == String.class) {
            NCdumpW.printStringArray(out, array, ilev, ct);
        } else if (array instanceof ArraySequence) {
            if (printSeq) {
                NCdumpW.printSequence(out, (ArraySequence)array, ilev, ct);
            }
        } else if (array instanceof ArrayStructure) {
            NCdumpW.printStructureDataArray(out, (ArrayStructure)array, ilev, ct);
        } else if (array.getElementType() == ByteBuffer.class) {
            array.resetLocalIterator();
            while (array.hasNext()) {
                NCdumpW.printByteBuffer(out, (ByteBuffer)array.next(), ilev);
                out.println(array.hasNext() ? "," : ";");
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
        } else if (array instanceof ArrayObject) {
            NCdumpW.printVariableArray(out, (ArrayObject)array, ilev, ct);
        } else {
            NCdumpW.printArray(array, out, ilev, ct);
        }
        if (units != null) {
            out.print(" " + units);
        }
        out.print("\n");
        ilev.decr();
        out.flush();
    }

    private static void printArray(Array ma, PrintWriter out, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            Object value = ma.getObject(ima);
            if (ma.isUnsigned()) {
                assert (value instanceof Number) : "A data type being unsigned implies that it is numeric.";
                value = DataType.widenNumberIfNegative((Number)value);
            }
            out.print(value);
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        if (rank == 1 && ma.getElementType() != StructureData.class) {
            for (int ii = 0; ii < last; ++ii) {
                Object value = ma.getObject(ima.set(ii));
                if (ma.isUnsigned()) {
                    assert (value instanceof Number) : "A data type being unsigned implies that it is numeric.";
                    value = DataType.widenNumberIfNegative((Number)value);
                }
                if (ii > 0) {
                    out.print(", ");
                }
                out.print(value);
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
            out.print("}");
            return;
        }
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            Array slice = ma.slice(0, ii);
            if (ii > 0) {
                out.print(",");
            }
            NCdumpW.printArray(slice, out, indent, ct);
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    static void printStringArray(PrintWriter out, ArrayChar ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        if (rank == 1) {
            out.print("  \"" + ma.getString() + "\"");
            return;
        }
        if (rank == 2) {
            boolean first = true;
            ArrayChar.StringIterator iter = ma.getStringIterator();
            while (iter.hasNext()) {
                if (!first) {
                    out.print(", ");
                }
                out.print("\"" + iter.next() + "\"");
                first = false;
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            ArrayChar slice = (ArrayChar)ma.slice(0, ii);
            if (ii > 0) {
                out.print(",");
            }
            NCdumpW.printStringArray(out, slice, indent, ct);
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    private static void printByteBuffer(PrintWriter out, ByteBuffer bb, Indent indent) {
        out.print(indent + "0x");
        int last = bb.limit() - 1;
        if (last < 0) {
            out.printf("00", new Object[0]);
        } else {
            for (int i = bb.position(); i <= last; ++i) {
                out.printf("%02x", bb.get(i));
            }
        }
    }

    static void printStringArray(PrintWriter out, Array ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            out.print("  \"" + ma.getObject(ima) + "\"");
            return;
        }
        if (rank == 1) {
            boolean first = true;
            int i = 0;
            while ((long)i < ma.getSize()) {
                if (!first) {
                    out.print(", ");
                }
                out.print("  \"" + ma.getObject(ima.set(i)) + "\"");
                first = false;
                ++i;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            ArrayObject slice = (ArrayObject)ma.slice(0, ii);
            if (ii > 0) {
                out.print(",");
            }
            NCdumpW.printStringArray(out, slice, indent, ct);
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    private static void printStructureDataArray(PrintWriter out, ArrayStructure array, Indent indent, CancelTask ct) {
        try (StructureDataIterator sdataIter = array.getStructureDataIterator();){
            int count = 0;
            while (sdataIter.hasNext()) {
                StructureData sdata = sdataIter.next();
                out.println("\n" + indent + "{");
                NCdumpW.printStructureData(out, sdata, indent, ct);
                out.print(indent + "} " + sdata.getName() + "(" + count + ")");
                if (ct != null && ct.isCancel()) {
                    return;
                }
                ++count;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void printVariableArray(PrintWriter out, ArrayObject array, Indent indent, CancelTask ct) {
        out.print("\n" + indent + "{");
        indent.incr();
        IndexIterator iter = array.getIndexIterator();
        boolean first = true;
        while (iter.hasNext()) {
            Array data = (Array)iter.next();
            if (!first) {
                out.print(", ");
            }
            NCdumpW.printArray(data, out, indent, ct);
            first = false;
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    private static void printSequence(PrintWriter out, ArraySequence seq, Indent indent, CancelTask ct) {
        try (StructureDataIterator iter = seq.getStructureDataIterator();){
            while (iter.hasNext()) {
                StructureData sdata = iter.next();
                out.println("\n" + indent + "{");
                NCdumpW.printStructureData(out, sdata, indent, ct);
                out.print(indent + "} " + sdata.getName());
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void printStructureData(PrintWriter out, StructureData sdata) {
        NCdumpW.printStructureData(out, sdata, new Indent(2), null);
        out.flush();
    }

    private static void printStructureData(PrintWriter out, StructureData sdata, Indent indent, CancelTask ct) {
        indent.incr();
        for (StructureMembers.Member m3 : sdata.getMembers()) {
            Array sdataArray = sdata.getArray(m3);
            NCdumpW.printArray(sdataArray, m3.getName(), m3.getUnitsString(), out, indent, ct, true);
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
    }

    public static String toString(StructureData sdata) {
        CharArrayWriter carray = new CharArrayWriter(1000);
        PrintWriter pw = new PrintWriter(carray);
        for (StructureMembers.Member m3 : sdata.getMembers()) {
            Array memData = sdata.getArray(m3);
            if (memData instanceof ArrayChar) {
                pw.print(((ArrayChar)memData).getString());
            } else {
                NCdumpW.printArray(memData, pw);
            }
            pw.print(',');
        }
        return carray.toString();
    }

    public static void printArrayPlain(Array ma, PrintWriter out) {
        ma.resetLocalIterator();
        while (ma.hasNext()) {
            out.print(ma.next());
            out.print(' ');
        }
    }

    public static void printArray(Array array, PrintWriter pw) {
        NCdumpW.printArray(array, null, null, pw, new Indent(2), null, true);
    }

    public static String toString(Array ma) {
        return NCdumpW.toString(ma, "", null);
    }

    @Deprecated
    public static void writeNcML(NetcdfFile ncfile, Writer writer, WantValues showValues, String url) throws IOException {
        Predicate<Variable> writeVarsPred;
        Preconditions.checkNotNull(ncfile);
        Preconditions.checkNotNull(writer);
        Preconditions.checkNotNull(showValues);
        switch (showValues) {
            case none: {
                writeVarsPred = NcMLWriter.writeNoVariablesPredicate;
                break;
            }
            case coordsOnly: {
                writeVarsPred = NcMLWriter.writeCoordinateVariablesPredicate;
                break;
            }
            case all: {
                writeVarsPred = NcMLWriter.writeAllVariablesPredicate;
                break;
            }
            default: {
                String message = String.format("CAN'T HAPPEN: showValues (%s) != null and checked all possible enum values.", new Object[]{showValues});
                throw new AssertionError((Object)message);
            }
        }
        NcMLWriter ncmlWriter = new NcMLWriter();
        ncmlWriter.setWriteVariablesPredicate(writeVarsPred);
        Element netcdfElement = ncmlWriter.makeNetcdfElement(ncfile, url);
        ncmlWriter.writeToWriter(netcdfElement, writer);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(usage);
            return;
        }
        String filename = args[0];
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
             NetcdfFile nc = NetcdfDataset.openFile(filename, null);){
            StringBuilder command = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                command.append(args[i]);
                command.append(" ");
            }
            NCdumpW.print(nc, command.toString(), writer, null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Deprecated
    public static enum WantValues {
        none,
        coordsOnly,
        all;

    }
}

