/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.unidata.util.StringUtil2;

public class Grib1ParamTableReader {
    private static final Logger logger = LoggerFactory.getLogger(Grib1ParamTableReader.class);
    private static final boolean debug = false;
    private int center_id;
    private int subcenter_id;
    private int version;
    private final String name;
    private String path;
    private String desc;
    private Map<Integer, Grib1Parameter> parameters;
    private boolean useName;
    private static final Pattern nclPattern = Pattern.compile("\\{(\\d*),\\s*\"([^\"]*)\",\\s*\"([^\"]*)\",\\s*\"([^\"]*)\".*");

    public Grib1ParamTableReader(String path) {
        this.path = StringUtil2.replace(path, "\\", "/");
        File f = new File(path);
        this.name = f.getName();
        this.parameters = this.readParameterTable();
    }

    Grib1ParamTableReader(int center_id, int subcenter_id, int version, String path) {
        this.center_id = center_id;
        this.subcenter_id = subcenter_id;
        this.version = version;
        this.path = StringUtil2.replace(path, "\\", "/");
        File f = new File(path);
        this.name = f.getName();
    }

    Grib1ParamTableReader(Element paramTableElem) {
        this.name = paramTableElem.getChildText("title");
        DssParser p = new DssParser(Catalog.ncmlNS);
        this.parameters = p.parseXml(paramTableElem);
    }

    public int getCenter_id() {
        return this.center_id;
    }

    public int getSubcenter_id() {
        return this.subcenter_id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean useParamName() {
        return this.useName;
    }

    public int getKey() {
        return Grib1ParamTables.makeKey(this.center_id, this.subcenter_id, this.version);
    }

    public String getPath() {
        return this.path;
    }

    public Map<Integer, Grib1Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.readParameterTable();
        }
        return this.parameters;
    }

    public void setParameters(Map<Integer, Grib1Parameter> params) {
        this.parameters = params;
    }

    public Grib1Parameter getParameter(int id) {
        if (this.parameters == null) {
            this.parameters = this.readParameterTable();
        }
        return this.parameters.get(id);
    }

    public Grib1Parameter getLocalParameter(int id) {
        if (this.parameters == null) {
            this.parameters = this.readParameterTable();
        }
        return this.parameters.get(id);
    }

    public String toString() {
        return "Grib1ParamTable{center_id=" + this.center_id + ", subcenter_id=" + this.subcenter_id + ", version=" + this.version + ", name='" + this.name + '\'' + ", path='" + this.path + '\'' + '}';
    }

    private synchronized Map<Integer, Grib1Parameter> readParameterTable() {
        if (this.path == null) {
            throw new IllegalStateException(this.name);
        }
        try {
            if (this.name.startsWith("table_2_") || this.name.startsWith("local_table_2_")) {
                return this.readParameterTableEcmwf();
            }
            if (this.name.startsWith("US058")) {
                return this.readParameterTableXml(new FnmocParser());
            }
            if (this.name.endsWith(".tab")) {
                return this.readParameterTableTab();
            }
            if (this.name.endsWith(".wrf")) {
                return this.readParameterTableSplit("\\|", new int[]{0, 3, 1, 2});
            }
            if (this.name.endsWith(".h")) {
                return this.readParameterTableNcl();
            }
            if (this.name.endsWith(".dss")) {
                return this.readParameterTableSplit("\t", new int[]{0, -1, 1, 2});
            }
            if (this.name.endsWith(".xml")) {
                return this.readParameterTableXml(new DssParser(Namespace.NO_NAMESPACE));
            }
            if (this.name.startsWith("2.98")) {
                return this.readParameterTableEcmwfEcCodes();
            }
            throw new RuntimeException("Grib1ParamTableReader: Dont know how to read " + this.name + " file=" + this.path);
        }
        catch (IOException ioError) {
            logger.warn("An error occurred in Grib1ParamTable while trying to open the parameter table {}:{}", (Object)this.path, (Object)ioError.getMessage());
            throw new RuntimeException(ioError);
        }
    }

    private Map<Integer, Grib1Parameter> readParameterTableNcl() throws IOException {
        HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
        try (InputStream is = GribResourceReader.getInputStream(this.path);){
            Map<Integer, Grib1Parameter> map;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null && !line.startsWith("TBLE2")) {
                    if (line.contains("Center:")) {
                        this.center_id = this.extract(line, "Center:");
                        continue;
                    }
                    if (line.contains("Subcenter:")) {
                        this.subcenter_id = this.extract(line, "Subcenter:");
                        continue;
                    }
                    if (!line.contains("version:")) continue;
                    this.version = this.extract(line, "version:");
                }
                while ((line = br.readLine()) != null) {
                    int p1;
                    Matcher m3;
                    if (line.isEmpty() || line.startsWith("#") || !(m3 = nclPattern.matcher(line)).matches()) continue;
                    try {
                        p1 = Integer.parseInt(m3.group(1));
                    }
                    catch (Exception e) {
                        logger.warn("Cant parse " + m3.group(1) + " in file " + this.path);
                        continue;
                    }
                    Grib1Parameter parameter = new Grib1Parameter(this, p1, m3.group(4), m3.group(2), m3.group(3));
                    result.put(parameter.getNumber(), parameter);
                    logger.debug(" {}", (Object)parameter);
                }
                map = Collections.unmodifiableMap(result);
            }
            return map;
        }
    }

    private int extract(String line, String key) {
        int pos = line.indexOf(key);
        if (pos < 0) {
            return -1;
        }
        String want = line.substring(pos + key.length());
        try {
            return Integer.parseInt(want.trim());
        }
        catch (NumberFormatException e) {
            logger.warn("BAD {} ({})", (Object)line, (Object)this.path);
            return -1;
        }
    }

    private Map<Integer, Grib1Parameter> readParameterTableEcmwf() throws IOException {
        HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
        try (InputStream is = GribResourceReader.getInputStream(this.path);){
            Map<Integer, Grib1Parameter> map;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line = br.readLine();
                if (line == null) {
                    throw new FileNotFoundException(this.path + " is empty");
                }
                if (!line.startsWith("...")) {
                    this.desc = line;
                }
                while (line != null && !line.startsWith("...")) {
                    line = br.readLine();
                }
                while ((line = br.readLine()) != null) {
                    int p1;
                    String notes;
                    if (line.isEmpty() || line.startsWith("#")) continue;
                    if (line.startsWith("...") && (line = br.readLine()) == null) break;
                    String num = line.trim();
                    line = br.readLine();
                    String name = line != null ? line.trim() : null;
                    line = br.readLine();
                    String desc = line != null ? line.trim() : null;
                    line = br.readLine();
                    String units1 = line != null ? line.trim() : null;
                    line = br.readLine();
                    String string = notes = line == null || line.startsWith("...") ? null : line.trim();
                    if ("undefined".equalsIgnoreCase(desc)) continue;
                    try {
                        p1 = Integer.parseInt(num);
                    }
                    catch (Exception e) {
                        logger.warn("Cant parse " + num + " in file " + this.path);
                        continue;
                    }
                    Grib1Parameter parameter = new Grib1Parameter(this, p1, name, desc, units1);
                    result.put(parameter.getNumber(), parameter);
                    logger.debug("readParameterTableEcmwf {} ({})", (Object)parameter, (Object)notes);
                }
                map = Collections.unmodifiableMap(result);
            }
            return map;
        }
    }

    private Map<Integer, Grib1Parameter> readParameterTableEcmwfEcCodes() throws IOException {
        HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
        try (InputStream is = GribResourceReader.getInputStream(this.path);){
            Map<Integer, Grib1Parameter> map;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line = br.readLine();
                if (line == null) {
                    throw new FileNotFoundException(this.path + " is empty");
                }
                String[] splitPath = this.path.split("/");
                String tableNum = splitPath[splitPath.length - 1].replace(".table", "");
                this.desc = "ECMWF GRIB API TABLE " + tableNum;
                while (line != null && !line.startsWith("#")) {
                    line = br.readLine();
                }
                while ((line = br.readLine()) != null) {
                    int p1;
                    int lastUnitIndex;
                    if (line.isEmpty() || line.startsWith("#")) continue;
                    String[] tmpUnitArray = line.split("\\(");
                    String tmpUnit = tmpUnitArray[tmpUnitArray.length - 1];
                    while ((lastUnitIndex = tmpUnit.lastIndexOf(")")) > 0) {
                        tmpUnit = tmpUnit.substring(0, lastUnitIndex).trim();
                    }
                    String unit = tmpUnit.trim();
                    String[] lineArray = line.trim().split("\\s+");
                    String num = lineArray[0];
                    String name = lineArray[1].trim();
                    int startDesc = line.indexOf("[");
                    int endDesc = line.indexOf("]");
                    String desc = line.substring(startDesc, endDesc).trim();
                    try {
                        p1 = Integer.parseInt(num);
                    }
                    catch (Exception e) {
                        logger.warn("Cant parse " + num + " in file " + this.path);
                        continue;
                    }
                    Grib1Parameter parameter = new Grib1Parameter(this, p1, name, desc, unit);
                    result.put(parameter.getNumber(), parameter);
                    logger.debug(" {}", (Object)parameter);
                }
                map = Collections.unmodifiableMap(result);
            }
            return map;
        }
    }

    private Map<Integer, Grib1Parameter> readParameterTableXml(XmlTableParser parser) throws IOException {
        Map<Integer, Grib1Parameter> map;
        block8: {
            InputStream is = GribResourceReader.getInputStream(this.path);
            try {
                SAXBuilder builder = new SAXBuilder();
                builder.setExpandEntities(false);
                Document doc = builder.build(is);
                Element root = doc.getRootElement();
                map = parser.parseXml(root);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | JDOMException e) {
                    throw new IOException(e);
                }
            }
            is.close();
        }
        return map;
    }

    private Map<Integer, Grib1Parameter> readParameterTableSplit(String regexp, int[] order) throws IOException {
        HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
        try (InputStream is = GribResourceReader.getInputStream(this.path);){
            Map<Integer, Grib1Parameter> map;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.isEmpty() || line.startsWith("#")) continue;
                    String[] flds = line.split(regexp);
                    int p1 = Integer.parseInt(flds[order[0]].trim());
                    String name = order[1] >= 0 ? flds[order[1]].trim() : null;
                    String desc = flds[order[2]].trim();
                    String units = flds.length > order[3] ? flds[order[3]].trim() : "";
                    Grib1Parameter parameter = new Grib1Parameter(this, p1, name, desc, units);
                    result.put(parameter.getNumber(), parameter);
                    logger.debug(" {}", (Object)parameter);
                }
                map = Collections.unmodifiableMap(result);
            }
            return map;
        }
    }

    private Map<Integer, Grib1Parameter> readParameterTableTab() throws IOException {
        try (InputStream is = GribResourceReader.getInputStream(this.path);){
            HashMap<Integer, Grib1Parameter> params;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                br.readLine();
                params = new HashMap<Integer, Grib1Parameter>();
                while ((line = br.readLine()) != null) {
                    String units;
                    String desc;
                    if (line.isEmpty() || line.startsWith("#")) continue;
                    String[] tableDefArr = line.split(":");
                    int p1 = Integer.parseInt(tableDefArr[0].trim());
                    String name = tableDefArr[1].trim();
                    if (tableDefArr[2].indexOf(91) == -1) {
                        desc = tableDefArr[2].trim();
                        units = "";
                    } else {
                        String[] arr2 = tableDefArr[2].split("\\[");
                        desc = arr2[0].trim();
                        units = arr2[1].substring(0, arr2[1].lastIndexOf(93)).trim();
                    }
                    Grib1Parameter parameter = new Grib1Parameter(this, p1, name, desc, units);
                    if (!parameter.getDescription().equalsIgnoreCase("undefined")) {
                        params.put(parameter.getNumber(), parameter);
                    }
                    logger.debug(parameter.getNumber() + " " + parameter.getDescription() + " " + parameter.getUnit());
                }
            }
            Map<Integer, Grib1Parameter> map = Collections.unmodifiableMap(params);
            return map;
        }
    }

    private class FnmocParser
    implements XmlTableParser {
        private FnmocParser() {
        }

        public HashMap<Integer, Grib1Parameter> parseXml(Element root) {
            HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
            Element fnmocTable = root.getChild("fnmocTable");
            List<Element> params = fnmocTable.getChildren("entry");
            for (Element elem1 : params) {
                int code;
                try {
                    code = Integer.parseInt(elem1.getChildText("grib1Id"));
                }
                catch (NumberFormatException e) {
                    logger.warn("BAD number= {}", (Object)elem1.getChildText("grib1Id"));
                    continue;
                }
                String desc = elem1.getChildText("description");
                if (desc == null) continue;
                desc = StringUtil2.collapseWhitespace(desc);
                String units = elem1.getChildText("unitsFNMOC");
                if (units == null) {
                    units = "";
                }
                String name = elem1.getChildText("name");
                Grib1Parameter parameter = new Grib1Parameter(Grib1ParamTableReader.this, code, name, desc, units, null);
                result.put(parameter.getNumber(), parameter);
                logger.debug(" {}", (Object)parameter);
            }
            Grib1ParamTableReader.this.useName = true;
            return result;
        }
    }

    private class DssParser
    implements XmlTableParser {
        private final Namespace ns;

        DssParser(Namespace ns) {
            this.ns = ns;
        }

        @Override
        public Map<Integer, Grib1Parameter> parseXml(Element root) {
            HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
            List<Element> params = root.getChildren("parameter", this.ns);
            for (Element elem1 : params) {
                String name;
                int code = Integer.parseInt(elem1.getAttributeValue("code"));
                String desc = elem1.getChildText("description", this.ns);
                if (desc == null) continue;
                String units = elem1.getChildText("units", this.ns);
                if (units == null) {
                    units = "";
                }
                if ((name = elem1.getChildText("name", this.ns)) == null) {
                    name = elem1.getChildText("shortName", this.ns);
                }
                String cf = elem1.getChildText("CF", this.ns);
                Grib1Parameter parameter = new Grib1Parameter(Grib1ParamTableReader.this, code, name, desc, units, cf);
                result.put(parameter.getNumber(), parameter);
                logger.debug(" {}", (Object)parameter);
            }
            return Collections.unmodifiableMap(result);
        }
    }

    private static interface XmlTableParser {
        public Map<Integer, Grib1Parameter> parseXml(Element var1);
    }
}

