/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.TableLookup;
import ucar.nc2.iosp.bufr.tables.NcepMnemonic;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;
import ucar.nc2.iosp.bufr.tables.WmoXmlReader;
import ucar.nc2.util.TableParser;
import ucar.nc2.wmo.Util;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class BufrTables {
    private static final Logger log = LoggerFactory.getLogger(BufrTables.class);
    static final String RESOURCE_PATH = "/resources/bufrTables/";
    private static final String canonicalLookup = "resource:/resources/bufrTables/local/tablelookup.csv";
    private static final int latestVersion = 19;
    private static final boolean showTables = false;
    private static final boolean showReadErrs = true;
    private static List<TableConfig> tables;
    private static final Map<String, TableB> tablesB;
    private static final Map<String, TableD> tablesD;
    private static List<String> lookups;
    private static TableB latestWmoB;
    private static TableD latestWmoD;
    private static final Pattern threeInts;
    private static final Pattern negOne;

    public static synchronized void addLookupFile(String filename) throws FileNotFoundException {
        File f;
        if (lookups == null) {
            lookups = new ArrayList<String>();
        }
        if (!(f = new File(filename)).exists()) {
            throw new FileNotFoundException(filename + " not found");
        }
        lookups.add(filename);
    }

    private static synchronized void readLookupTable() {
        tables = new ArrayList<TableConfig>();
        if (lookups != null) {
            lookups.add(canonicalLookup);
            for (String fname : lookups) {
                BufrTables.readLookupTable(fname);
            }
        } else {
            BufrTables.readLookupTable(canonicalLookup);
        }
    }

    private static void readLookupTable(String filename) {
        try (InputStream ios = BufrTables.openStream(filename);){
            String line;
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
            int count = 0;
            while ((line = dataIS.readLine()) != null) {
                if (line.startsWith("#")) continue;
                ++count;
                String[] flds = line.split(",");
                if (flds.length < 8) {
                    System.out.printf("%d BAD line == %s%n", count, line);
                    continue;
                }
                int fldidx = 0;
                try {
                    TableConfig table = new TableConfig();
                    table.name = flds[fldidx++].trim();
                    table.center = Integer.parseInt(flds[fldidx++].trim());
                    table.subcenter = Integer.parseInt(flds[fldidx++].trim());
                    table.master = Integer.parseInt(flds[fldidx++].trim());
                    table.local = Integer.parseInt(flds[fldidx++].trim());
                    table.cat = Integer.parseInt(flds[fldidx++].trim());
                    table.tableBname = flds[fldidx++].trim();
                    table.tableBformat = BufrTables.getFormat(flds[fldidx++].trim(), line);
                    if (table.tableBformat == null) continue;
                    table.tableDname = flds[fldidx++].trim();
                    table.tableDformat = BufrTables.getFormat(flds[fldidx++].trim(), line);
                    if (fldidx < flds.length) {
                        String modes;
                        if ((modes = flds[fldidx++].trim()).equalsIgnoreCase("wmoLocal")) {
                            table.mode = Mode.wmoLocal;
                        } else if (modes.equalsIgnoreCase("localWmo")) {
                            table.mode = Mode.localOverride;
                        }
                    }
                    tables.add(table);
                }
                catch (Exception e) {
                    System.out.printf("%d %d BAD line == %s (%s)%n", count, fldidx, line, e.getMessage());
                }
            }
        }
        catch (IOException ioe) {
            String mess = "Need BUFR tables in path; looking for " + filename;
            throw new RuntimeException(mess, ioe);
        }
    }

    private static Format getFormat(String formatS, String line) {
        if (formatS.isEmpty()) {
            return null;
        }
        try {
            return Format.valueOf(formatS);
        }
        catch (Exception e) {
            log.warn("BAD format = {} line == {}%n", (Object)formatS, (Object)line);
            return null;
        }
    }

    public static List<TableConfig> getTables() {
        if (tables == null) {
            BufrTables.readLookupTable();
        }
        return tables;
    }

    public static TableConfig[] getTableConfigsAsArray() {
        if (tables == null) {
            BufrTables.readLookupTable();
        }
        TableConfig[] result = new TableConfig[tables.size()];
        return tables.toArray(result);
    }

    private static TableConfig matchTableConfig(int center, int subcenter, int master, int local, int cat) {
        if (tables == null) {
            BufrTables.readLookupTable();
        }
        for (TableConfig tc : tables) {
            if (!tc.matches(center, subcenter, master, local, cat)) continue;
            return tc;
        }
        return null;
    }

    public static Tables getLocalTables(int center, int subcenter, int master, int local, int cat) throws IOException {
        TableConfig tc = BufrTables.matchTableConfig(center, subcenter, master, local, cat);
        if (tc == null) {
            return null;
        }
        if (tc.tableBformat == Format.ncep_nm) {
            TableB b = tablesB.get(tc.tableBname);
            TableD d = tablesD.get(tc.tableBname);
            if (b != null && d != null) {
                return new Tables(b, d, tc.mode);
            }
            b = new TableB(tc.tableBname, tc.tableBname);
            d = new TableD(tc.tableBname, tc.tableBname);
            Tables t = new Tables(b, d, tc.mode);
            try (InputStream ios = BufrTables.openStream(tc.tableBname);){
                NcepMnemonic.read(ios, t);
            }
            tablesB.put(tc.tableBname, t.b);
            tablesD.put(tc.tableBname, t.d);
            return t;
        }
        Tables tables = new Tables();
        tables.b = BufrTables.readTableB(tc.tableBname, tc.tableBformat, false);
        tables.d = BufrTables.readTableD(tc.tableDname, tc.tableDformat, false);
        tables.mode = tc.mode;
        return tables;
    }

    public static synchronized TableB getWmoTableBlatest() {
        if (latestWmoB == null) {
            try {
                latestWmoB = BufrTables.getWmoTableB(19);
            }
            catch (IOException ioe) {
                log.error("Cant open latest WMO ", ioe);
                throw new RuntimeException(ioe);
            }
        }
        return latestWmoB;
    }

    public static TableB getWmoTableB(int masterTableVersion) throws IOException {
        TableConfig tc = BufrTables.matchTableConfig(0, 0, masterTableVersion, 0, -1);
        if (tc != null) {
            return BufrTables.readTableB(tc.tableBname, tc.tableBformat, false);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static TableB readTableB(String location, Format format, boolean force) throws IOException {
        if (!force && (tb = BufrTables.tablesB.get(location)) != null) {
            return tb;
        }
        b = new TableB(location, location);
        ios = BufrTables.openStream(location);
        try {
            switch (1.$SwitchMap$ucar$nc2$iosp$bufr$tables$BufrTables$Format[format.ordinal()]) {
                case 1: {
                    BufrTables.readCypherTableB(ios, b);
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                case 2: {
                    BufrTables.readEcmwfTableB(ios, b);
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 3: {
                    b = BufrTables.readEmbeddedTableB(location);
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 4: {
                    BufrTables.readNcepTableB(ios, b);
                    ** break;
lbl25:
                    // 1 sources

                    break;
                }
                case 5: {
                    t = new Tables(b, null, null);
                    NcepMnemonic.read(ios, t);
                    ** break;
lbl31:
                    // 1 sources

                    break;
                }
                case 6: {
                    BufrTables.readMelbufrTableB(ios, b);
                    ** break;
lbl36:
                    // 1 sources

                    break;
                }
                case 7: {
                    BufrTables.readMeltabTableB(ios, b);
                    ** break;
lbl41:
                    // 1 sources

                    break;
                }
                case 8: {
                    BufrTables.readOperaTableB(ios, b);
                    ** break;
lbl45:
                    // 1 sources

                    break;
                }
                case 9: {
                    BufrTables.readBmetTableB(ios, b);
                    ** break;
lbl49:
                    // 1 sources

                    break;
                }
                case 10: {
                    BufrTables.readWmoCsvTableB(ios, b);
                    ** break;
lbl53:
                    // 1 sources

                    break;
                }
                case 11: {
                    WmoXmlReader.readWmoXmlTableB(ios, b);
                    break;
                }
                ** default:
lbl58:
                // 1 sources

                break;
            }
        }
        finally {
            if (ios != null) {
                ios.close();
            }
        }
        if (b != null) {
            BufrTables.tablesB.put(location, b);
        }
        return b;
    }

    private static void readWmoCsvTableB(InputStream ios, TableB b) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        int count = 0;
        while ((line = dataIS.readLine()) != null) {
            String[] flds;
            if (line.startsWith("#") || ++count == 1) continue;
            int pos1 = line.indexOf(34);
            if (pos1 >= 0) {
                int pos2 = line.indexOf(34, pos1 + 1);
                StringBuilder sb = new StringBuilder(line);
                for (int i = pos1; i < pos2; ++i) {
                    if (sb.charAt(i) != ',') continue;
                    sb.setCharAt(i, ' ');
                }
                line = sb.toString();
            }
            if ((flds = line.split(",")).length < 7) {
                System.out.printf("%d BAD split == %s%n", count, line);
                continue;
            }
            int fldidx = 1;
            try {
                int xy = Integer.parseInt(flds[fldidx++].trim());
                String name = StringUtil2.remove(flds[fldidx++], 34);
                String units = StringUtil2.filter(flds[fldidx++], " %+-_/()*");
                int scale = Integer.parseInt(BufrTables.clean(flds[fldidx++].trim()));
                int refVal = Integer.parseInt(BufrTables.clean(flds[fldidx++].trim()));
                int width = Integer.parseInt(BufrTables.clean(flds[fldidx++].trim()));
                int x = xy / 1000;
                int y = xy % 1000;
                b.addDescriptor((short)x, (short)y, scale, refVal, width, name, units, null);
            }
            catch (Exception e) {
                System.out.printf("%d %d BAD line == %s%n", count, fldidx, line);
            }
        }
    }

    private static String clean(String s2) {
        return StringUtil2.remove(s2, 32);
    }

    private static TableB readEmbeddedTableB(String location) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(location, "r");){
            MessageScanner scan = new MessageScanner(raf);
            TableLookup lookup = scan.getTableLookup();
            if (lookup != null) {
                TableB tableB = lookup.getLocalTableB();
                return tableB;
            }
            TableB tableB = null;
            return tableB;
        }
    }

    private static TableD readEmbeddedTableD(String location) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(location, "r");){
            MessageScanner scan = new MessageScanner(raf);
            TableLookup lookup = scan.getTableLookup();
            if (lookup != null) {
                TableD tableD = lookup.getLocalTableD();
                return tableD;
            }
            TableD tableD = null;
            return tableD;
        }
    }

    private static TableB readMelbufrTableB(InputStream ios, TableB b) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#") || line.isEmpty()) continue;
            try {
                String[] split = line.split(";");
                short x = Short.parseShort(split[1].trim());
                short y = Short.parseShort(split[2].trim());
                int scale = Integer.parseInt(split[3].trim());
                int refVal = Integer.parseInt(split[4].trim());
                int width = Integer.parseInt(split[5].trim());
                b.addDescriptor(x, y, scale, refVal, width, split[7], split[6], null);
            }
            catch (Exception e) {
                log.error("Bad table B entry: table=" + b.getName() + " entry=<" + line + ">", (Object)e.getMessage());
            }
        }
        return b;
    }

    private static TableB readCypherTableB(InputStream ios, TableB b) throws IOException {
        String line;
        boolean startMode = false;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        while ((line = dataIS.readLine()) != null) {
            if (line.isEmpty() || line.startsWith("<")) continue;
            if (line.startsWith("#")) {
                startMode = true;
                continue;
            }
            if (!startMode) continue;
            try {
                String xys = line.substring(0, 8).trim();
                int xy = Integer.parseInt(xys);
                short x = (short)(xy / 1000);
                short y = (short)(xy % 1000);
                String name = Util.cleanName(line.substring(8));
                String units = "";
                line = dataIS.readLine();
                if (line != null) {
                    units = WmoXmlReader.cleanUnit(line);
                }
                int scale = 0;
                int refVal = 0;
                int width = 0;
                line = dataIS.readLine();
                if (line != null) {
                    line = StringUtil2.remove(line, 42);
                    String[] split = StringUtil2.splitString(line);
                    scale = Integer.parseInt(split[0].trim());
                    refVal = Integer.parseInt(split[1].trim());
                    width = Integer.parseInt(split[2].trim());
                }
                b.addDescriptor(x, y, scale, refVal, width, name, units, null);
                startMode = false;
            }
            catch (Exception e) {
                log.error("Bad table B entry: table=" + b.getName() + " entry=<" + line + ">", (Object)e.getMessage());
            }
        }
        return b;
    }

    private static TableB readMeltabTableB(InputStream ios, TableB b) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#") || line.isEmpty()) continue;
            try {
                String[] split = line.split("\t");
                short x = Short.parseShort(split[1].trim());
                short y = Short.parseShort(split[2].trim());
                int scale = Integer.parseInt(split[3].trim());
                int refVal = Integer.parseInt(split[4].trim());
                int width = Integer.parseInt(split[5].trim());
                b.addDescriptor(x, y, scale, refVal, width, split[7], split[6], null);
            }
            catch (Exception e) {
                log.error("Bad table " + b.getName() + " entry=<" + line + ">", e);
            }
        }
        return b;
    }

    private static TableB readNcepTableB(InputStream ios, TableB b) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        dataIS.readLine();
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#") || line.isEmpty()) continue;
            try {
                String[] flds = line.split("[\\|;]");
                if (flds[0].equals("END")) break;
                if (flds.length < 8) {
                    log.error("Bad line in table " + b.getName() + " entry=<" + line + ">");
                    continue;
                }
                String fxys = flds[0];
                int scale = Integer.parseInt(BufrTables.clean(flds[1]));
                int refVal = Integer.parseInt(BufrTables.clean(flds[2]));
                int width = Integer.parseInt(BufrTables.clean(flds[3]));
                String units = StringUtil2.remove(flds[4], 34);
                String name = StringUtil2.remove(flds[5], 34);
                String desc = StringUtil2.remove(flds[7], 34);
                String[] xyflds = fxys.split("-");
                short x = Short.parseShort(BufrTables.clean(xyflds[1]));
                short y = Short.parseShort(BufrTables.clean(xyflds[2]));
                b.addDescriptor(x, y, scale, refVal, width, name, units, desc);
            }
            catch (Exception e) {
                log.error("Bad table " + b.getName() + " entry=<" + line + ">", e);
            }
        }
        return b;
    }

    private static void readOperaTableB(InputStream ios, TableB b) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        int count = 0;
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#")) continue;
            ++count;
            String[] flds = line.split(";");
            if (flds.length < 8) {
                System.out.printf("%d BAD split == %s%n", count, line);
                continue;
            }
            int fldidx = 1;
            try {
                int x = Integer.parseInt(flds[fldidx++].trim());
                int y = Integer.parseInt(flds[fldidx++].trim());
                String name = StringUtil2.remove(flds[fldidx++], 34);
                String units = StringUtil2.filter(flds[fldidx++], " %+-_/()*");
                int scale = Integer.parseInt(BufrTables.clean(flds[fldidx++].trim()));
                int refVal = Integer.parseInt(BufrTables.clean(flds[fldidx++].trim()));
                int width = Integer.parseInt(BufrTables.clean(flds[fldidx++].trim()));
                b.addDescriptor((short)x, (short)y, scale, refVal, width, name, units, null);
            }
            catch (Exception e) {
                System.out.printf("%d %d BAD line == %s%n", count, fldidx, line);
            }
        }
    }

    private static TableB readEcmwfTableB(InputStream ios, TableB b) throws IOException {
        List<TableParser.Record> recs = TableParser.readTable(ios, "4i,7i,72,97,102i,114i,119i", 50000);
        for (TableParser.Record record : recs) {
            if (record.nfields() < 7) continue;
            int x = (Integer)record.get(0);
            int y = (Integer)record.get(1);
            String name = (String)record.get(2);
            String units = (String)record.get(3);
            int scale = (Integer)record.get(4);
            int ref = (Integer)record.get(5);
            int width = (Integer)record.get(6);
            b.addDescriptor((short)x, (short)y, scale, ref, width, name, units, null);
        }
        return b;
    }

    private static void readBmetTableB(InputStream ios, TableB b) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            doc = builder.build(ios);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        Element root = doc.getRootElement();
        List<Element> featList = root.getChildren("featureCatalogue");
        for (Element featureCat : featList) {
            List<Element> features = featureCat.getChildren("feature");
            for (Element feature : features) {
                String name = feature.getChild("annotation").getChildTextNormalize("documentation");
                int f = Integer.parseInt(feature.getChildText("F"));
                int x = Integer.parseInt(feature.getChildText("X"));
                int y = Integer.parseInt(feature.getChildText("Y"));
                int fxy = (f << 16) + (x << 8) + y;
                Element bufrElem = feature.getChild("BUFR");
                String units = bufrElem.getChildTextNormalize("BUFR_units");
                int scale = 0;
                int reference = 0;
                int width = 0;
                String s2 = null;
                try {
                    s2 = bufrElem.getChildTextNormalize("BUFR_scale");
                    scale = Integer.parseInt(BufrTables.clean(s2));
                }
                catch (NumberFormatException e) {
                    log.warn(" key {} name '{}' has bad scale='{}'%n", fxy, name, s2);
                }
                try {
                    s2 = bufrElem.getChildTextNormalize("BUFR_reference");
                    reference = Integer.parseInt(BufrTables.clean(s2));
                }
                catch (NumberFormatException e) {
                    log.warn(" key {} name '{}' has bad reference='{}' %n", fxy, name, s2);
                }
                try {
                    s2 = bufrElem.getChildTextNormalize("BUFR_width");
                    width = Integer.parseInt(BufrTables.clean(s2));
                }
                catch (NumberFormatException e) {
                    log.warn(" key {} name '{}' has bad width='{}' %n", fxy, name, s2);
                }
                b.addDescriptor((short)x, (short)y, scale, reference, width, name, units, null);
            }
        }
    }

    public static synchronized TableD getWmoTableDlatest() {
        if (latestWmoD == null) {
            try {
                latestWmoD = BufrTables.getWmoTableD(19);
            }
            catch (IOException ioe) {
                log.error("Cant open latest WMO ", ioe);
                throw new RuntimeException(ioe);
            }
        }
        return latestWmoD;
    }

    public static TableD getWmoTableD(int masterTableVersion) throws IOException {
        TableConfig tc = BufrTables.matchTableConfig(0, 0, masterTableVersion, 0, -1);
        if (tc != null) {
            return BufrTables.readTableD(tc.tableDname, tc.tableDformat, false);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static TableD readTableD(String location, Format format, boolean force) throws IOException {
        if (location == null) {
            return null;
        }
        if (location.trim().isEmpty()) {
            return null;
        }
        if (!force && (tb = BufrTables.tablesD.get(location)) != null) {
            return tb;
        }
        d = new TableD(location, location);
        ios = BufrTables.openStream(location);
        try {
            switch (1.$SwitchMap$ucar$nc2$iosp$bufr$tables$BufrTables$Format[format.ordinal()]) {
                case 1: {
                    BufrTables.readCypherTableD(ios, d);
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                case 3: {
                    d = BufrTables.readEmbeddedTableD(location);
                    ** break;
lbl18:
                    // 1 sources

                    break;
                }
                case 4: {
                    BufrTables.readNcepTableD(ios, d);
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                case 5: {
                    t = new Tables(null, d, null);
                    NcepMnemonic.read(ios, t);
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                case 2: {
                    BufrTables.readEcmwfTableD(ios, d);
                    ** break;
lbl32:
                    // 1 sources

                    break;
                }
                case 6: {
                    BufrTables.readMelbufrTableD(ios, d);
                    ** break;
lbl36:
                    // 1 sources

                    break;
                }
                case 8: {
                    BufrTables.readOperaTableD(ios, d);
                    ** break;
lbl40:
                    // 1 sources

                    break;
                }
                case 10: {
                    BufrTables.readWmoCsvTableD(ios, d);
                    ** break;
lbl44:
                    // 1 sources

                    break;
                }
                case 11: {
                    WmoXmlReader.readWmoXmlTableD(ios, d);
                    ** break;
lbl48:
                    // 1 sources

                    break;
                }
                default: {
                    BufrTables.log.warn("Unknown format= {}", (Object)format);
                    var6_7 = null;
                    return var6_7;
                }
            }
        }
        finally {
            if (ios != null) {
                ios.close();
            }
        }
        if (d != null) {
            BufrTables.tablesD.put(location, d);
        }
        return d;
    }

    private static void readCypherTableD(InputStream ios, TableD t) throws IOException {
        String line;
        TableD.Descriptor currDesc = null;
        boolean startMode = false;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        while ((line = dataIS.readLine()) != null) {
            String[] flds;
            if (line.isEmpty() || line.startsWith("<")) continue;
            if (line.startsWith("#")) {
                startMode = true;
                continue;
            }
            if (startMode) {
                try {
                    flds = StringUtil2.splitString(line);
                    int fxy = Integer.parseInt(flds[0]);
                    int y = fxy % 1000;
                    int x = (fxy /= 1000) % 100;
                    int f1 = fxy / 100;
                    if (f1 != 3) {
                        log.error("Bad table " + t.getName() + " entry=<" + line + ">");
                    } else {
                        currDesc = t.addDescriptor((short)x, (short)y, "", new ArrayList<Short>());
                    }
                    startMode = false;
                    continue;
                }
                catch (Exception e) {
                    log.warn("Bad table " + t.getName() + " line=<" + line + ">", (Object)e.getMessage());
                }
            }
            if (currDesc != null) {
                try {
                    flds = StringUtil2.splitString(line);
                    String fxys = BufrTables.cleanNumber(flds[0]);
                    int fxy = Integer.parseInt(fxys);
                    int y1 = fxy % 1000;
                    int x1 = (fxy /= 1000) % 100;
                    int f1 = fxy / 100;
                    int fxy1 = (f1 << 14) + (x1 << 8) + y1;
                    currDesc.addFeature((short)fxy1);
                }
                catch (Exception e) {
                    log.warn("Bad table " + t.getName() + " line=<" + line + ">", (Object)e.getMessage());
                }
                continue;
            }
            log.warn("Bad table " + t.getName() + " line=<" + line + "> trying to add feature without descriptor.");
        }
    }

    static String cleanNumber(String s2) {
        int pos = s2.indexOf("(");
        if (pos > 0) {
            return s2.substring(0, pos);
        }
        return s2;
    }

    private static void readOperaTableD(InputStream ios, TableD t) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        TableD.Descriptor currDesc = null;
        String name = null;
        while ((line = dataIS.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            if (line.startsWith("#")) {
                name = line.substring(2).trim();
                continue;
            }
            try {
                String[] flds = line.split(";");
                if (!flds[0].trim().isEmpty()) {
                    int x = Integer.parseInt(flds[1].trim());
                    int y = Integer.parseInt(flds[2].trim());
                    currDesc = t.addDescriptor((short)x, (short)y, name, new ArrayList<Short>());
                }
                if (currDesc != null) {
                    int f1 = Integer.parseInt(flds[3].trim());
                    int x1 = Integer.parseInt(flds[4].trim());
                    int y1 = Integer.parseInt(flds[5].trim());
                    int fxy = (f1 << 14) + (x1 << 8) + y1;
                    currDesc.addFeature((short)fxy);
                    continue;
                }
                throw new Exception("Trying to add feature to null descriptor");
            }
            catch (Exception e) {
                log.error("Bad table " + t.getName() + " entry=<" + line + ">", e);
            }
        }
    }

    private static void readWmoCsvTableD(InputStream ios, TableD tableD) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        int count = 0;
        int currSeqno = -1;
        TableD.Descriptor currDesc = null;
        while ((line = dataIS.readLine()) != null) {
            String[] flds;
            if (line.startsWith("#") || ++count == 1) continue;
            int pos1 = line.indexOf(34);
            if (pos1 >= 0) {
                int pos2 = line.indexOf(34, pos1 + 1);
                StringBuilder sb = new StringBuilder(line);
                for (int i = pos1; i < pos2; ++i) {
                    if (sb.charAt(i) != ',') continue;
                    sb.setCharAt(i, ' ');
                }
                line = sb.toString();
            }
            if ((flds = line.split(",")).length < 5) {
                System.out.printf("%d INCOMPLETE line == %s%n", count, line);
                continue;
            }
            int fldidx = 2;
            try {
                int seq = Integer.parseInt(flds[fldidx++]);
                String seqName = flds[fldidx++];
                String featno = flds[fldidx++].trim();
                if (featno.isEmpty()) {
                    System.out.printf("%d no FXY2 specified; line == %s%n", count, line);
                    continue;
                }
                if (currSeqno != seq) {
                    int y = seq % 1000;
                    int w = seq / 1000;
                    int x = w % 100;
                    seqName = StringUtil2.remove(seqName, 34);
                    currDesc = tableD.addDescriptor((short)x, (short)y, seqName, new ArrayList<Short>());
                    currSeqno = seq;
                }
                int fno = Integer.parseInt(featno);
                int y = fno % 1000;
                int w = fno / 1000;
                int x = w % 100;
                int f = w / 100;
                int fxy = (f << 14) + (x << 8) + y;
                if (currDesc != null) {
                    currDesc.addFeature((short)fxy);
                    continue;
                }
                log.error("Trying to add feature to null desc!");
            }
            catch (Exception e) {
                System.out.printf("%d %d BAD line == %s : %s%n", count, fldidx, line, e.getMessage());
            }
        }
    }

    private static void readMelbufrTableD(InputStream ios, TableD t) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        int count = 0;
        while ((line = dataIS.readLine()) != null) {
            String[] split;
            ++count;
            if (line.startsWith("#") || line.isEmpty() || (split = (line = line.trim()).split("[ \t]+")).length < 3) continue;
            if (split[0].equals("END")) break;
            try {
                short seqF = Short.parseShort(split[0]);
                short seqX = Short.parseShort(split[1]);
                short seqY = Short.parseShort(split[2]);
                assert (seqF == 3);
                String seqName = "";
                if (split.length > 3) {
                    StringBuilder sb = new StringBuilder(40);
                    for (int i = 3; i < split.length; ++i) {
                        sb.append(split[i]).append(" ");
                    }
                    seqName = sb.toString();
                    seqName = StringUtil2.remove(seqName, "()");
                }
                ArrayList<Short> seq = new ArrayList<Short>();
                while ((line = dataIS.readLine()) != null) {
                    ++count;
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    Matcher m3 = threeInts.matcher(line);
                    if (m3.find()) {
                        short f = Short.parseShort(m3.group(1));
                        short x = Short.parseShort(m3.group(2));
                        short y = Short.parseShort(m3.group(3));
                        seq.add(Descriptor.getFxy(f, x, y));
                        continue;
                    }
                    m3 = negOne.matcher(line);
                    if (!m3.find()) continue;
                    t.addDescriptor(seqX, seqY, seqName, seq);
                }
            }
            catch (Exception e) {
                log.warn("TableD " + t.getName() + " Failed on line " + count + " = " + line + "\n " + e);
            }
        }
    }

    private static void readNcepTableD(InputStream ios, TableD t) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        dataIS.readLine();
        TableD.Descriptor currDesc = null;
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            try {
                String[] xyflds;
                String[] flds = line.split("[\\|;]");
                if (flds[0].equals("END")) break;
                String fxys = flds[0].trim();
                if (!fxys.isEmpty()) {
                    xyflds = fxys.split("-");
                    short x = Short.parseShort(BufrTables.clean(xyflds[1]));
                    short y = Short.parseShort(BufrTables.clean(xyflds[2]));
                    String seqName = flds.length > 3 ? flds[3].trim() : "";
                    currDesc = t.addDescriptor(x, y, seqName, new ArrayList<Short>());
                    continue;
                }
                if (currDesc == null) continue;
                fxys = StringUtil2.remove(flds[1], 62);
                xyflds = fxys.split("-");
                short f = Short.parseShort(BufrTables.clean(xyflds[0]));
                short x = Short.parseShort(BufrTables.clean(xyflds[1]));
                short y = Short.parseShort(BufrTables.clean(xyflds[2]));
                int fxy = (f << 14) + (x << 8) + y;
                currDesc.addFeature((short)fxy);
            }
            catch (Exception e) {
                log.error("Bad table " + t.getName() + " entry=<" + line + ">", e);
            }
        }
    }

    private static void readEcmwfTableD(InputStream ios, TableD t) throws IOException {
        String line;
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        TableD.Descriptor currDesc = null;
        int n = 0;
        while ((line = dataIS.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
            try {
                String fxys;
                if (line.length() > 6) {
                    String[] flds = new String[]{line.substring(0, 6), line.substring(6, 9), line.substring(9)};
                    fxys = flds[0].trim();
                    int fxy = Integer.parseInt(fxys);
                    int y = fxy % 1000;
                    int x = (fxy /= 1000) % 100;
                    currDesc = t.addDescriptor((short)x, (short)y, "", new ArrayList<Short>());
                    n = Integer.parseInt(flds[1].trim());
                    fxys = flds[2].trim();
                } else {
                    fxys = line;
                }
                int fxy = Integer.parseInt(fxys);
                int y = fxy % 1000;
                int x = (fxy /= 1000) % 100;
                fxy /= 100;
                fxy = (fxy << 14) + (x << 8) + y;
                if (currDesc != null) {
                    currDesc.addFeature((short)fxy);
                }
                --n;
            }
            catch (Exception e) {
                log.error("Bad table " + t.getName() + " entry=<" + line + ">", e);
            }
        }
    }

    static InputStream openStream(String location) throws IOException {
        InputStream ios;
        if (location.startsWith("resource:")) {
            InputStream ios2 = BufrTables.class.getResourceAsStream(location = location.substring(9));
            if (ios2 == null) {
                throw new RuntimeException("resource not found=<" + location + ">");
            }
            return ios2;
        }
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        return ios;
    }

    static {
        tablesB = new ConcurrentHashMap<String, TableB>();
        tablesD = new ConcurrentHashMap<String, TableD>();
        threeInts = Pattern.compile("^\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)");
        negOne = Pattern.compile("^\\s*-1");
    }

    public static class Tables {
        public TableB b;
        public TableD d;
        public Mode mode;

        Tables() {
        }

        Tables(TableB b, TableD d, Mode mode) {
            this.b = b;
            this.d = d;
            this.mode = mode == null ? Mode.wmoOnly : mode;
        }
    }

    public static class TableConfig {
        String name;
        int center;
        int subcenter;
        int master;
        int local;
        int cat;
        String tableBname;
        String tableDname;
        Format tableBformat;
        Format tableDformat;
        Mode mode = Mode.localOverride;

        boolean matches(int center, int subcenter, int master, int local, int cat) {
            if (this.center >= 0 && center >= 0 && center != this.center) {
                return false;
            }
            if (this.subcenter >= 0 && subcenter >= 0 && subcenter != this.subcenter) {
                return false;
            }
            if (this.master >= 0 && master >= 0 && master != this.master) {
                return false;
            }
            if (this.local >= 0 && local >= 0 && local != this.local) {
                return false;
            }
            return this.cat < 0 || cat < 0 || cat == this.cat;
        }

        public String getName() {
            return this.name;
        }

        public Format getTableBformat() {
            return this.tableBformat;
        }

        public Format getTableDformat() {
            return this.tableDformat;
        }

        public Mode getMode() {
            return this.mode;
        }

        public String getTableDname() {
            return this.tableDname;
        }

        public String getTableBname() {
            return this.tableBname;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Format {
        ecmwf,
        mel_bufr,
        mel_tabs,
        ncep,
        ncep_nm,
        opera,
        ukmet,
        wmo_csv,
        wmo_xml,
        cypher,
        embed;

    }

    public static enum Mode {
        wmoOnly,
        wmoLocal,
        localOverride;

    }
}

