/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Vector;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherDgRecord;
import org.apache.poi.ddf.EscherDggRecord;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hslf.model.Background;
import org.apache.poi.hslf.model.MasterSheet;
import org.apache.poi.hslf.model.Notes;
import org.apache.poi.hslf.model.Placeholder;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.model.SlideMaster;
import org.apache.poi.hslf.model.TextBox;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.model.TitleMaster;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.hslf.record.SlideAtom;
import org.apache.poi.hslf.record.SlideListWithText;

public class Slide
extends Sheet {
    private int _slideNo;
    private SlideListWithText.SlideAtomsSet _atomSet;
    private TextRun[] _runs;
    private Notes _notes;

    public Slide(org.apache.poi.hslf.record.Slide slide, Notes notes, SlideListWithText.SlideAtomsSet atomSet, int slideIdentifier, int slideNumber) {
        super(slide, slideIdentifier);
        this._notes = notes;
        this._atomSet = atomSet;
        this._slideNo = slideNumber;
        TextRun[] _otherRuns = Slide.findTextRuns(this.getPPDrawing());
        Vector textRuns = new Vector();
        if (this._atomSet != null) {
            Slide.findTextRuns(this._atomSet.getSlideRecords(), textRuns);
        }
        this._runs = new TextRun[textRuns.size() + _otherRuns.length];
        int i = 0;
        for (i = 0; i < textRuns.size(); ++i) {
            this._runs[i] = (TextRun)textRuns.get(i);
            this._runs[i].setSheet(this);
        }
        for (int k = 0; k < _otherRuns.length; ++k) {
            this._runs[i] = _otherRuns[k];
            this._runs[i].setSheet(this);
            ++i;
        }
    }

    public Slide(int sheetNumber, int sheetRefId, int slideNumber) {
        super(new org.apache.poi.hslf.record.Slide(), sheetNumber);
        this._slideNo = slideNumber;
        this.getSheetContainer().setSheetId(sheetRefId);
    }

    public void setNotes(Notes notes) {
        this._notes = notes;
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        if (notes == null) {
            sa.setNotesID(0);
        } else {
            sa.setNotesID(notes._getSheetNumber());
        }
    }

    public void setSlideNumber(int newSlideNumber) {
        this._slideNo = newSlideNumber;
    }

    public void onCreate() {
        EscherDggRecord dgg = this.getSlideShow().getDocumentRecord().getPPDrawingGroup().getEscherDggRecord();
        EscherContainerRecord dgContainer = (EscherContainerRecord)this.getSheetContainer().getPPDrawing().getEscherRecords()[0];
        EscherDgRecord dg = (EscherDgRecord)Shape.getEscherChild(dgContainer, -4088);
        int dgId = dgg.getMaxDrawingGroupId() + 1;
        dg.setOptions((short)(dgId << 4));
        dgg.setDrawingsSaved(dgg.getDrawingsSaved() + 1);
        dgg.setMaxDrawingGroupId(dgId);
        Iterator it = dgContainer.getChildContainers().iterator();
        while (it.hasNext()) {
            EscherContainerRecord c = (EscherContainerRecord)it.next();
            EscherSpRecord spr = null;
            switch (c.getRecordId()) {
                case -4093: {
                    EscherContainerRecord dc = (EscherContainerRecord)c.getChildRecords().get(0);
                    spr = dc.getChildById((short)-4086);
                    break;
                }
                case -4092: {
                    spr = c.getChildById((short)-4086);
                }
            }
            if (spr == null) continue;
            spr.setShapeId(this.allocateShapeId());
        }
        dg.setNumShapes(1);
    }

    public TextBox addTitle() {
        Placeholder pl = new Placeholder();
        pl.setShapeType(1);
        pl.getTextRun().setRunType(0);
        pl.setText("Click to edit title");
        pl.setAnchor(new Rectangle(54, 48, 612, 90));
        this.addShape(pl);
        return pl;
    }

    public String getTitle() {
        TextRun[] txt = this.getTextRuns();
        for (int i = 0; i < txt.length; ++i) {
            int type = txt[i].getRunType();
            if (type != 6 && type != 0) continue;
            String title = txt[i].getText();
            return title;
        }
        return null;
    }

    public TextRun[] getTextRuns() {
        return this._runs;
    }

    public int getSlideNumber() {
        return this._slideNo;
    }

    public org.apache.poi.hslf.record.Slide getSlideRecord() {
        return (org.apache.poi.hslf.record.Slide)this.getSheetContainer();
    }

    public Notes getNotesSheet() {
        return this._notes;
    }

    protected SlideListWithText.SlideAtomsSet getSlideAtomsSet() {
        return this._atomSet;
    }

    public MasterSheet getMasterSheet() {
        TitleMaster[] titleMaster;
        SlideMaster[] master = this.getSlideShow().getSlidesMasters();
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        int masterId = sa.getMasterID();
        MasterSheet sheet = null;
        for (int i = 0; i < master.length; ++i) {
            if (masterId != master[i]._getSheetNumber()) continue;
            sheet = master[i];
            break;
        }
        if (sheet == null && (titleMaster = this.getSlideShow().getTitleMasters()) != null) {
            for (int i = 0; i < titleMaster.length; ++i) {
                if (masterId != titleMaster[i]._getSheetNumber()) continue;
                sheet = titleMaster[i];
                break;
            }
        }
        return sheet;
    }

    public void setMasterSheet(MasterSheet master) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        int sheetNo = master._getSheetNumber();
        sa.setMasterID(sheetNo);
    }

    public void setFollowMasterBackground(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterBackground(flag);
    }

    public boolean getFollowMasterBackground() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterBackground();
    }

    public void setFollowMasterObjects(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterObjects(flag);
    }

    public boolean getFollowMasterScheme() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterScheme();
    }

    public void setFollowMasterScheme(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterScheme(flag);
    }

    public boolean getFollowMasterObjects() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterObjects();
    }

    public Background getBackground() {
        if (this.getFollowMasterBackground()) {
            return this.getMasterSheet().getBackground();
        }
        return super.getBackground();
    }

    public ColorSchemeAtom getColorScheme() {
        if (this.getFollowMasterScheme()) {
            return this.getMasterSheet().getColorScheme();
        }
        return super.getColorScheme();
    }

    public void draw(Graphics2D graphics) {
        int i;
        Shape[] sh;
        MasterSheet master = this.getMasterSheet();
        if (this.getFollowMasterBackground()) {
            master.getBackground().draw(graphics);
        }
        if (this.getFollowMasterObjects()) {
            sh = master.getShapes();
            for (i = 0; i < sh.length; ++i) {
                if (MasterSheet.isPlaceholder(sh[i])) continue;
                sh[i].draw(graphics);
            }
        }
        sh = this.getShapes();
        for (i = 0; i < sh.length; ++i) {
            sh[i].draw(graphics);
        }
    }
}

