/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ProgramClass
implements Clazz {
    public int u4magic;
    public int u4version;
    public int u2constantPoolCount;
    public Constant[] constantPool;
    public int u2accessFlags;
    public int u2thisClass;
    public int u2superClass;
    public int u2interfacesCount;
    public int[] u2interfaces;
    public int u2fieldsCount;
    public ProgramField[] fields;
    public int u2methodsCount;
    public ProgramMethod[] methods;
    public int u2attributesCount;
    public Attribute[] attributes;
    public Clazz[] subClasses;
    public Object visitorInfo;

    public Constant getConstant(int n) {
        return this.constantPool[n];
    }

    @Override
    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    @Override
    public String getName() {
        return this.getClassName(this.u2thisClass);
    }

    @Override
    public String getSuperName() {
        return this.u2superClass == 0 ? null : this.getClassName(this.u2superClass);
    }

    @Override
    public int getInterfaceCount() {
        return this.u2interfacesCount;
    }

    @Override
    public String getInterfaceName(int n) {
        return this.getClassName(this.u2interfaces[n]);
    }

    @Override
    public int getTag(int n) {
        return this.constantPool[n].getTag();
    }

    @Override
    public String getString(int n) {
        try {
            return ((Utf8Constant)this.constantPool[n]).getString();
        }
        catch (ClassCastException classCastException) {
            new ClassPrinter().visitProgramClass(this);
            throw new ClassCastException("Expected Utf8Constant at index [" + n + "] in class [" + this.getName() + "], found [" + classCastException.getMessage() + "]");
        }
    }

    @Override
    public String getStringString(int n) {
        try {
            return ((StringConstant)this.constantPool[n]).getString(this);
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Expected StringConstant at index [" + n + "] in class [" + this.getName() + "], found [" + classCastException.getMessage() + "]");
        }
    }

    @Override
    public String getClassName(int n) {
        try {
            return ((ClassConstant)this.constantPool[n]).getName(this);
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Expected ClassConstant at index [" + n + "] in class [" + this.getName() + "], found [" + classCastException.getMessage() + "]");
        }
    }

    @Override
    public String getName(int n) {
        try {
            return ((NameAndTypeConstant)this.constantPool[n]).getName(this);
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Expected NameAndTypeConstant at index [" + n + "] in class [" + this.getName() + "], found [" + classCastException.getMessage() + "]");
        }
    }

    @Override
    public String getType(int n) {
        try {
            return ((NameAndTypeConstant)this.constantPool[n]).getType(this);
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Expected NameAndTypeConstant at index [" + n + "] in class [" + this.getName() + "], found [" + classCastException.getMessage() + "]");
        }
    }

    @Override
    public void addSubClass(Clazz clazz) {
        if (this.subClasses == null) {
            this.subClasses = new Clazz[1];
        } else {
            Clazz[] clazzArray = new Clazz[this.subClasses.length + 1];
            System.arraycopy(this.subClasses, 0, clazzArray, 0, this.subClasses.length);
            this.subClasses = clazzArray;
        }
        this.subClasses[this.subClasses.length - 1] = clazz;
    }

    @Override
    public Clazz getSuperClass() {
        return this.u2superClass != 0 ? ((ClassConstant)this.constantPool[this.u2superClass]).referencedClass : null;
    }

    @Override
    public Clazz getInterface(int n) {
        return ((ClassConstant)this.constantPool[this.u2interfaces[n]]).referencedClass;
    }

    @Override
    public boolean extends_(Clazz clazz) {
        if (this.equals(clazz)) {
            return true;
        }
        Clazz clazz2 = this.getSuperClass();
        return clazz2 != null && clazz2.extends_(clazz);
    }

    @Override
    public boolean extendsOrImplements(Clazz clazz) {
        if (this.equals(clazz)) {
            return true;
        }
        Clazz clazz2 = this.getSuperClass();
        if (clazz2 != null && clazz2.extendsOrImplements(clazz)) {
            return true;
        }
        for (int i = 0; i < this.u2interfacesCount; ++i) {
            Clazz clazz3 = this.getInterface(i);
            if (clazz3 == null || !clazz3.extendsOrImplements(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Field findField(String string, String string2) {
        for (int i = 0; i < this.u2fieldsCount; ++i) {
            ProgramField programField = this.fields[i];
            if (string != null && !programField.getName(this).equals(string) || string2 != null && !programField.getDescriptor(this).equals(string2)) continue;
            return programField;
        }
        return null;
    }

    @Override
    public Method findMethod(String string, String string2) {
        for (int i = 0; i < this.u2methodsCount; ++i) {
            ProgramMethod programMethod = this.methods[i];
            if (string != null && !programMethod.getName(this).equals(string) || string2 != null && !programMethod.getDescriptor(this).equals(string2)) continue;
            return programMethod;
        }
        return null;
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitProgramClass(this);
    }

    @Override
    public void hierarchyAccept(boolean bl, boolean bl2, boolean bl3, boolean bl4, ClassVisitor classVisitor) {
        Clazz clazz;
        Clazz clazz2;
        if (bl) {
            this.accept(classVisitor);
        }
        if (bl2 && (clazz2 = this.getSuperClass()) != null) {
            clazz2.hierarchyAccept(true, true, bl3, false, classVisitor);
        }
        if (bl3) {
            if (!bl2 && (clazz2 = this.getSuperClass()) != null) {
                clazz2.hierarchyAccept(false, false, true, false, classVisitor);
            }
            for (int i = 0; i < this.u2interfacesCount; ++i) {
                clazz = this.getInterface(i);
                if (clazz == null) continue;
                clazz.hierarchyAccept(true, false, true, false, classVisitor);
            }
        }
        if (bl4 && this.subClasses != null) {
            for (int i = 0; i < this.subClasses.length; ++i) {
                clazz = this.subClasses[i];
                clazz.hierarchyAccept(true, false, false, true, classVisitor);
            }
        }
    }

    @Override
    public void subclassesAccept(ClassVisitor classVisitor) {
        if (this.subClasses != null) {
            for (int i = 0; i < this.subClasses.length; ++i) {
                this.subClasses[i].accept(classVisitor);
            }
        }
    }

    @Override
    public void constantPoolEntriesAccept(ConstantVisitor constantVisitor) {
        for (int i = 1; i < this.u2constantPoolCount; ++i) {
            if (this.constantPool[i] == null) continue;
            this.constantPool[i].accept(this, constantVisitor);
        }
    }

    @Override
    public void constantPoolEntryAccept(int n, ConstantVisitor constantVisitor) {
        this.constantPool[n].accept(this, constantVisitor);
    }

    @Override
    public void thisClassConstantAccept(ConstantVisitor constantVisitor) {
        this.constantPool[this.u2thisClass].accept(this, constantVisitor);
    }

    @Override
    public void superClassConstantAccept(ConstantVisitor constantVisitor) {
        if (this.u2superClass != 0) {
            this.constantPool[this.u2superClass].accept(this, constantVisitor);
        }
    }

    @Override
    public void interfaceConstantsAccept(ConstantVisitor constantVisitor) {
        for (int i = 0; i < this.u2interfacesCount; ++i) {
            this.constantPool[this.u2interfaces[i]].accept(this, constantVisitor);
        }
    }

    @Override
    public void fieldsAccept(MemberVisitor memberVisitor) {
        for (int i = 0; i < this.u2fieldsCount; ++i) {
            this.fields[i].accept(this, memberVisitor);
        }
    }

    @Override
    public void fieldAccept(String string, String string2, MemberVisitor memberVisitor) {
        Field field = this.findField(string, string2);
        if (field != null) {
            field.accept(this, memberVisitor);
        }
    }

    @Override
    public void methodsAccept(MemberVisitor memberVisitor) {
        for (int i = 0; i < this.u2methodsCount; ++i) {
            this.methods[i].accept(this, memberVisitor);
        }
    }

    @Override
    public void methodAccept(String string, String string2, MemberVisitor memberVisitor) {
        Method method = this.findMethod(string, string2);
        if (method != null) {
            method.accept(this, memberVisitor);
        }
    }

    @Override
    public boolean mayHaveImplementations(Method method) {
        return (this.u2accessFlags & 0x10) == 0 && (method == null || (method.getAccessFlags() & 0x1A) == 0 && !method.getName(this).equals("<init>"));
    }

    @Override
    public void attributesAccept(AttributeVisitor attributeVisitor) {
        for (int i = 0; i < this.u2attributesCount; ++i) {
            this.attributes[i].accept(this, attributeVisitor);
        }
    }

    @Override
    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    @Override
    public void setVisitorInfo(Object object) {
        this.visitorInfo = object;
    }

    public String toString() {
        return "ProgramClass(" + this.getName() + ")";
    }
}

