/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.editor.AnnotationsAttributeEditor;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ElementValueAdder;
import proguard.classfile.util.SimplifiedVisitor;

public class AnnotationAdder
extends SimplifiedVisitor
implements AnnotationVisitor {
    private static final ElementValue[] EMPTY_ELEMENT_VALUES = new ElementValue[0];
    private final ProgramClass targetClass;
    private final AnnotationElementValue targetAnnotationElementValue;
    private final ConstantAdder constantAdder;
    private final AnnotationsAttributeEditor annotationsAttributeEditor;

    public AnnotationAdder(ProgramClass programClass, AnnotationElementValue annotationElementValue) {
        this.targetClass = programClass;
        this.targetAnnotationElementValue = annotationElementValue;
        this.constantAdder = new ConstantAdder(programClass);
        this.annotationsAttributeEditor = null;
    }

    public AnnotationAdder(ProgramClass programClass, AnnotationsAttribute annotationsAttribute) {
        this.targetClass = programClass;
        this.targetAnnotationElementValue = null;
        this.constantAdder = new ConstantAdder(programClass);
        this.annotationsAttributeEditor = new AnnotationsAttributeEditor(annotationsAttribute);
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        Annotation annotation2 = new Annotation(this.constantAdder.addConstant(clazz, annotation.u2typeIndex), 0, annotation.u2elementValuesCount > 0 ? new ElementValue[annotation.u2elementValuesCount] : EMPTY_ELEMENT_VALUES);
        annotation2.referencedClasses = annotation.referencedClasses;
        annotation.elementValuesAccept(clazz, new ElementValueAdder(this.targetClass, annotation2, false));
        if (this.targetAnnotationElementValue != null) {
            this.targetAnnotationElementValue.annotationValue = annotation2;
        } else {
            this.annotationsAttributeEditor.addAnnotation(annotation2);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, int n, Annotation annotation) {
    }
}

