/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class KeepMarker
implements ClassVisitor,
MemberVisitor {
    private static final Object KEPT = new Object();

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        KeepMarker.markAsKept(programClass);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        KeepMarker.markAsKept(libraryClass);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        KeepMarker.markAsKept(programField);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        KeepMarker.markAsKept(MethodLinker.lastMember(programMethod));
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        KeepMarker.markAsKept(libraryField);
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        KeepMarker.markAsKept(MethodLinker.lastMember(libraryMethod));
    }

    private static void markAsKept(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(KEPT);
    }

    public static boolean isKept(VisitorAccepter visitorAccepter) {
        return MethodLinker.lastVisitorAccepter(visitorAccepter).getVisitorInfo() == KEPT;
    }
}

