/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class ReachableCodeMarker
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor {
    private boolean[] isReachable = new boolean[1024];
    private boolean next;
    private boolean evaluateExceptions;

    public boolean isReachable(int n) {
        return this.isReachable[n];
    }

    public boolean isReachable(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.isReachable[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int n = codeAttribute.u4codeLength;
        if (this.isReachable.length < n) {
            this.isReachable = new boolean[n];
        } else {
            for (int i = 0; i < n; ++i) {
                this.isReachable[i] = false;
            }
        }
        this.markCode(clazz, method, codeAttribute, 0);
        do {
            this.evaluateExceptions = false;
            codeAttribute.exceptionsAccept(clazz, method, this);
        } while (this.evaluateExceptions);
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        byte by = simpleInstruction.opcode;
        if (by == -84 || by == -83 || by == -82 || by == -81 || by == -80 || by == -79 || by == -65) {
            this.next = false;
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        if (variableInstruction.opcode == -87) {
            this.next = false;
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        this.markBranchTarget(clazz, method, codeAttribute, n + branchInstruction.branchOffset);
        byte by = branchInstruction.opcode;
        if (by == -89 || by == -56) {
            this.next = false;
        }
    }

    @Override
    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
        this.markBranchTarget(clazz, method, codeAttribute, n + switchInstruction.defaultOffset);
        this.markBranchTargets(clazz, method, codeAttribute, n, switchInstruction.jumpOffsets);
        this.next = false;
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        if (!this.isReachable(exceptionInfo.u2handlerPC) && this.isReachable(exceptionInfo.u2startPC, exceptionInfo.u2endPC)) {
            this.markCode(clazz, method, codeAttribute, exceptionInfo.u2handlerPC);
            this.evaluateExceptions = true;
        }
    }

    private void markBranchTargets(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.markCode(clazz, method, codeAttribute, n + nArray[i]);
        }
    }

    private void markBranchTarget(Clazz clazz, Method method, CodeAttribute codeAttribute, int n) {
        boolean bl = this.next;
        this.markCode(clazz, method, codeAttribute, n);
        this.next = bl;
    }

    private void markCode(Clazz clazz, Method method, CodeAttribute codeAttribute, int n) {
        boolean bl = this.next;
        byte[] byArray = codeAttribute.code;
        while (!this.isReachable[n]) {
            Instruction instruction = InstructionFactory.create(byArray, n);
            this.isReachable[n] = true;
            this.next = true;
            instruction.accept(clazz, method, codeAttribute, n, this);
            if (!this.next) break;
            n += instruction.length(n);
        }
        this.next = bl;
    }
}

