/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.jdbc;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.jdbc.AbstractJdbcAction;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;

public class SqlQueryAction
extends AbstractJdbcAction {
    private String sqlQuery = "";
    private boolean firstOnly = false;
    private boolean failIfNotFound = false;
    private String variableName = "";

    public String getSqlQuery() {
        return SqlQueryAction.replaceVariables(this.sqlQuery);
    }

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public boolean isFirstOnly() {
        return this.firstOnly;
    }

    public void setFirstOnly(boolean firstOnly) {
        this.firstOnly = firstOnly;
    }

    public boolean isFailIfNotFound() {
        return this.failIfNotFound;
    }

    public void setFailIfNotFound(boolean failIfNotFound) {
        this.failIfNotFound = failIfNotFound;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    @Override
    protected boolean executeJdbcCall(final Context context) throws UserCanceledException {
        return this.withResultSet(this.getSqlQuery(), new AbstractJdbcAction.ResultSetConsumer(){

            @Override
            public boolean run(ResultSet rs) throws SQLException {
                if (!rs.next()) {
                    if (SqlQueryAction.this.isFailIfNotFound()) {
                        SqlQueryAction.this.logError("Query returned no results");
                        return false;
                    }
                    SqlQueryAction.this.logSuccess("Query returned no results");
                    context.setVariable(SqlQueryAction.this.getVariableName(), SqlQueryAction.this.isFirstOnly() ? null : Collections.emptyList());
                    return true;
                }
                if (SqlQueryAction.this.isFirstOnly()) {
                    context.setVariable(SqlQueryAction.this.getVariableName(), SqlQueryAction.this.createRowObject(rs));
                } else {
                    ArrayList<Object> rowObjects = new ArrayList<Object>();
                    do {
                        rowObjects.add(SqlQueryAction.this.createRowObject(rs));
                    } while (rs.next());
                    context.setVariable(SqlQueryAction.this.getVariableName(), rowObjects);
                }
                return true;
            }
        });
    }

    private Object createRowObject(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        if (columnCount == 1) {
            return rs.getObject(1);
        }
        ArrayList<Object> cellValues = new ArrayList<Object>();
        for (int i = 1; i <= columnCount; ++i) {
            cellValues.add(rs.getObject(i));
        }
        return cellValues;
    }
}

