/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.registry.PreferenceWriteType;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.PreferencesUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public abstract class PreferencesWriteAction
extends PreferencesAction {
    private PreferenceWriteType preferenceWriteType = PreferenceWriteType.USER;

    public PreferenceWriteType getPreferenceWriteType() {
        return this.preferenceWriteType;
    }

    public void setPreferenceWriteType(PreferenceWriteType preferenceWriteType) {
        this.preferenceWriteType = preferenceWriteType;
    }

    protected static void writeValue(PreferencesAction.PackageNodeProvider packageNodeProvider, String key, String value, List<PreferencesAction.PreferencesRollbackAction> rollbackActions) {
        Preferences packageNode = packageNodeProvider.getPackageNode();
        String oldValue = packageNode.get(key, null);
        packageNode.put(key, value);
        rollbackActions.add(new PerformedAction(packageNodeProvider, key, oldValue));
    }

    protected boolean executePreferencesWriter(PreferencesWriter preferencesWriter, Context context) {
        ArrayList<PreferencesAction.PreferencesRollbackAction> rollbackActions = new ArrayList<PreferencesAction.PreferencesRollbackAction>();
        try {
            boolean userSpecific = this.preferenceWriteType == PreferenceWriteType.USER;
            return this.handleRollbackActions(PreferencesWriteAction.executePreferencesWriter(preferencesWriter, this.getPackageName(), userSpecific, context, rollbackActions));
        }
        catch (BackingStoreException e1) {
            Logger.getInstance().log(e1);
            if (this.preferenceWriteType == PreferenceWriteType.SYSTEM_FALLBACK) {
                try {
                    return this.handleRollbackActions(PreferencesWriteAction.executePreferencesWriter(preferencesWriter, this.getPackageName(), true, context, rollbackActions));
                }
                catch (BackingStoreException e2) {
                    Logger.getInstance().log(e2);
                    return false;
                }
            }
            return false;
        }
    }

    private static List<PreferencesAction.PreferencesRollbackAction> executePreferencesWriter(final PreferencesWriter preferencesWriter, final String packageName, boolean userSpecific, Context context, final List<PreferencesAction.PreferencesRollbackAction> rollbackActions) throws BackingStoreException {
        if (HelperCommunication.getInstance().isElevatedHelper() && userSpecific) {
            return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<List<PreferencesAction.PreferencesRollbackAction>>(){

                @Override
                protected List<PreferencesAction.PreferencesRollbackAction> fetchValue(Context context) throws Exception {
                    return PreferencesWriteAction.executePreferencesWriter(preferencesWriter, packageName, true, context, rollbackActions);
                }
            });
        }
        PreferencesAction.PackageNodeProvider packageNodeProvider = new PreferencesAction.PackageNodeProvider(packageName, userSpecific, true);
        Preferences packageNode = packageNodeProvider.getPackageNode();
        boolean success = preferencesWriter.writeToPreferences(packageNodeProvider, context, rollbackActions);
        packageNode.flush();
        return success ? rollbackActions : null;
    }

    protected static interface PreferencesWriter
    extends Serializable {
        public boolean writeToPreferences(PreferencesAction.PackageNodeProvider var1, Context var2, List<PreferencesAction.PreferencesRollbackAction> var3) throws BackingStoreException;
    }

    private static class PerformedAction
    extends PreferencesAction.PreferencesRollbackAction {
        private PreferencesAction.PackageNodeProvider packageNodeProvider;
        private String key;
        private String oldValue;

        public PerformedAction(PreferencesAction.PackageNodeProvider packageNodeProvider, String key, String oldValue) {
            this.packageNodeProvider = packageNodeProvider;
            this.key = key;
            this.oldValue = oldValue;
        }

        @Override
        protected void rollbackDirectly(Context context) {
            Preferences packageNode = this.packageNodeProvider.getPackageNode();
            Preferences newNode = PreferencesUtil.getPackageNode(packageNode.absolutePath(), packageNode.isUserNode());
            if (this.oldValue == null) {
                newNode.remove(this.key);
            } else {
                newNode.put(this.key, this.oldValue);
                Logger.getInstance().info(this, "put '" + this.oldValue + "' in '" + this.key + "'.");
            }
            try {
                newNode.flush();
                Logger.getInstance().info(this, "flushed " + newNode.absolutePath());
            }
            catch (BackingStoreException e) {
                Logger.getInstance().log(e);
            }
        }
    }
}

