/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.SpinnerComponent;
import java.util.Objects;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;

public class ListSpinnerComponent
extends SpinnerComponent {
    private String[] listEntries;
    private int initiallySelectedIndex = 0;

    public String[] getListEntries() {
        return this.listEntries;
    }

    public void setListEntries(String[] listEntries) {
        this.listEntries = listEntries;
    }

    public int getInitiallySelectedIndex() {
        return this.initiallySelectedIndex;
    }

    public void setInitiallySelectedIndex(int initiallySelectedIndex) {
        this.initiallySelectedIndex = initiallySelectedIndex;
    }

    @Override
    protected SpinnerModel createSpinnerModel() {
        SpinnerListModel model = new SpinnerListModel(this.listEntries);
        this.initValue(model);
        return model;
    }

    @Override
    protected void initValue(SpinnerModel model) {
        Context context = this.getContext();
        Object variableValue = context == null ? null : context.getVariable(this.getVariableName());
        int initValue = this.getInitiallySelectedIndex();
        if (variableValue instanceof String) {
            for (int i = 0; i < this.listEntries.length; ++i) {
                if (!Objects.equals(variableValue, this.listEntries[i])) continue;
                initValue = i;
                break;
            }
        }
        if (initValue < this.listEntries.length && initValue > 0) {
            model.setValue(this.listEntries[initValue]);
        }
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        JSpinner spinner = this.getSpinner();
        SpinnerListModel model = (SpinnerListModel)spinner.getModel();
        String[] descriptions = new String[model.getList().size()];
        int defaultValue = -1;
        for (int i = 0; i < model.getList().size(); ++i) {
            descriptions[i] = (String)model.getList().get(i);
            if (!Objects.equals(model.getValue(), descriptions[i])) continue;
            defaultValue = i;
        }
        int newValue = console.askOption(this.getConsoleLabelText(false), descriptions, null, defaultValue, false, false);
        spinner.getModel().setValue(model.getList().get(newValue));
        return true;
    }
}

