/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.api.Util;
import com.install4j.api.launcher.StartupNotification;
import com.install4j.runtime.installer.helper.versionspecific.MacApiHelper;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelperInterface;
import com.install4j.runtime.launcher.util.LauncherUtil;
import com.install4j.runtime.util.internal.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javafx.collections.ObservableList;
import javafx.stage.Stage;

public class NoHelper
implements VersionSpecificHelperInterface {
    @Override
    public boolean isJavaFxWindowShown() {
        try {
            Class<?> stageHelperClass = Class.forName("com.sun.javafx.stage.StageHelper");
            try {
                Field field = stageHelperClass.getDeclaredField("stageAccessor");
                if (field != null) {
                    ReflectionUtil.setAccessible(field);
                    if (field.get(null) == null) {
                        return false;
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            Method getStagesMethod = stageHelperClass.getDeclaredMethod("getStages", new Class[0]);
            ReflectionUtil.setAccessible(getStagesMethod);
            ObservableList stages = (ObservableList)getStagesMethod.invoke(null, new Object[0]);
            for (Stage stage : stages) {
                if (!stage.isShowing()) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void requestForeground() {
        if (Util.isMacOS()) {
            MacApiHelper.requestForeground();
        }
    }

    @Override
    public void setMacStartupListener(StartupNotification.Listener startupListener) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacStartupListener(startupListener);
        }
    }

    @Override
    public void setMacHandleQuit(boolean handleQuit) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacHandleQuit(handleQuit);
        }
    }

    @Override
    public void setMacQuitHandler(Runnable runnable) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacQuitHandler(runnable);
        }
    }

    @Override
    public void setMacAboutHandler(Runnable runnable) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacAboutHandler(runnable);
        }
    }

    @Override
    public void setMacPreferencesHandler(Runnable runnable) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacPreferencesHandler(runnable);
        }
    }

    @Override
    public void addReads(String moduleName) {
    }

    @Override
    public long getPid() {
        return LauncherUtil.getPidFromMBean();
    }

    @Override
    public int waitForOrTerminate(Process process, int timeoutSeconds) throws InterruptedException {
        if (timeoutSeconds == 0) {
            return process.waitFor();
        }
        long end = System.currentTimeMillis() + (long)(timeoutSeconds * 1000);
        while (true) {
            try {
                return process.exitValue();
            }
            catch (IllegalThreadStateException ex) {
                Thread.sleep(100L);
                if (end > System.currentTimeMillis()) continue;
                process.destroy();
                return -10000;
            }
            break;
        }
    }
}

