/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuBar;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.FrameWaiter;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.FrameDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;

public class FrameOperator
extends WindowOperator
implements Outputable {
    public static final String TITLE_DPROP = "Title";
    public static final String STATE_DPROP = "State";
    public static final String STATE_NORMAL_DPROP_VALUE = "NORMAL";
    public static final String STATE_ICONIFIED_DPROP_VALUE = "ICONIFIED";
    public static final String IS_RESIZABLE_DPROP = "Resizable";
    TestOut output;
    FrameDriver driver = DriverManager.getFrameDriver(this.getClass());
    static /* synthetic */ Class class$java$awt$Frame;

    public FrameOperator(Frame w) {
        super(w);
    }

    public FrameOperator(ComponentChooser chooser, int index, Operator env) {
        this(FrameOperator.waitFrame(new FrameFinder(chooser), index, env.getTimeouts(), env.getOutput()));
        this.copyEnvironment(env);
    }

    public FrameOperator(ComponentChooser chooser, int index) {
        this(chooser, index, Operator.getEnvironmentOperator());
    }

    public FrameOperator(ComponentChooser chooser) {
        this(chooser, 0);
    }

    public FrameOperator(String title, int index, Operator env) {
        this(FrameOperator.waitFrame(new FrameByTitleFinder(title, env.getComparator()), index, env.getTimeouts(), env.getOutput()));
        this.copyEnvironment(env);
    }

    public FrameOperator(String title, int index) {
        this(title, index, ComponentOperator.getEnvironmentOperator());
    }

    public FrameOperator(String title) {
        this(title, 0);
    }

    public FrameOperator(int index) {
        this(FrameOperator.waitFrame(new FrameFinder(), index, ComponentOperator.getEnvironmentOperator().getTimeouts(), ComponentOperator.getEnvironmentOperator().getOutput()));
        this.copyEnvironment(ComponentOperator.getEnvironmentOperator());
    }

    public FrameOperator() {
        this(0);
    }

    public void setOutput(TestOut out) {
        super.setOutput(out);
        this.output = out;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (FrameDriver)DriverManager.getDriver("drivers.frame", this.getClass(), anotherOperator.getProperties());
    }

    public void waitTitle(String title) {
        this.getOutput().printLine("Wait \"" + title + "\" title of frame \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + title + "\" title");
        this.waitState(new FrameByTitleFinder(title, this.getComparator()));
    }

    public void iconify() {
        this.output.printLine("Iconifying frame\n    " + this.toStringSource());
        this.output.printGolden("Iconifying frame");
        this.driver.iconify(this);
        if (this.getVerification()) {
            this.waitState(1);
        }
    }

    public void deiconify() {
        this.output.printLine("Deiconifying frame\n    " + this.toStringSource());
        this.output.printGolden("Deiconifying frame");
        this.driver.deiconify(this);
        if (this.getVerification()) {
            this.waitState(0);
        }
    }

    public void maximize() {
        this.output.printLine("Maximizing frame\n    " + this.toStringSource());
        this.output.printGolden("Maximizing frame");
        this.driver.maximize(this);
        if (this.getVerification()) {
            this.waitState(0);
        }
    }

    public void demaximize() {
        this.output.printLine("Demaximizing frame\n    " + this.toStringSource());
        this.output.printGolden("Demaximizing frame");
        this.driver.demaximize(this);
        if (this.getVerification()) {
            this.waitState(0);
        }
    }

    public void waitState(final int state) {
        this.getOutput().printLine("Wait frame to have " + Integer.toString(state) + " state \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait frame to have " + Integer.toString(state) + " state");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return ((Frame)comp).getState() == state;
            }

            public String getDescription() {
                return Integer.toString(state) + " state";
            }
        });
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        if (((Frame)this.getSource()).getTitle() != null) {
            result.put(TITLE_DPROP, ((Frame)this.getSource()).getTitle());
        }
        result.put(STATE_DPROP, ((Frame)this.getSource()).getState() == 1 ? STATE_ICONIFIED_DPROP_VALUE : STATE_NORMAL_DPROP_VALUE);
        result.put(IS_RESIZABLE_DPROP, ((Frame)this.getSource()).isResizable() ? "true" : "false");
        return result;
    }

    public Image getIconImage() {
        return (Image)this.runMapping(new Operator.MapAction("getIconImage"){

            public Object map() {
                return ((Frame)FrameOperator.this.getSource()).getIconImage();
            }
        });
    }

    public MenuBar getMenuBar() {
        return (MenuBar)this.runMapping(new Operator.MapAction("getMenuBar"){

            public Object map() {
                return ((Frame)FrameOperator.this.getSource()).getMenuBar();
            }
        });
    }

    public int getState() {
        return this.runMapping(new Operator.MapIntegerAction("getState"){

            public int map() {
                return ((Frame)FrameOperator.this.getSource()).getState();
            }
        });
    }

    public String getTitle() {
        return (String)this.runMapping(new Operator.MapAction("getTitle"){

            public Object map() {
                return ((Frame)FrameOperator.this.getSource()).getTitle();
            }
        });
    }

    public boolean isResizable() {
        return this.runMapping(new Operator.MapBooleanAction("isResizable"){

            public boolean map() {
                return ((Frame)FrameOperator.this.getSource()).isResizable();
            }
        });
    }

    public void setIconImage(final Image image) {
        this.runMapping(new Operator.MapVoidAction("setIconImage"){

            public void map() {
                ((Frame)FrameOperator.this.getSource()).setIconImage(image);
            }
        });
    }

    public void setMenuBar(final MenuBar menuBar) {
        this.runMapping(new Operator.MapVoidAction("setMenuBar"){

            public void map() {
                ((Frame)FrameOperator.this.getSource()).setMenuBar(menuBar);
            }
        });
    }

    public void setResizable(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setResizable"){

            public void map() {
                ((Frame)FrameOperator.this.getSource()).setResizable(b);
            }
        });
    }

    public void setState(final int i) {
        this.runMapping(new Operator.MapVoidAction("setState"){

            public void map() {
                ((Frame)FrameOperator.this.getSource()).setState(i);
            }
        });
    }

    public void setTitle(final String string) {
        this.runMapping(new Operator.MapVoidAction("setTitle"){

            public void map() {
                ((Frame)FrameOperator.this.getSource()).setTitle(string);
            }
        });
    }

    protected static Frame waitFrame(ComponentChooser chooser, int index, Timeouts timeouts, TestOut output) {
        try {
            FrameWaiter waiter = new FrameWaiter();
            waiter.setTimeouts(timeouts);
            waiter.setOutput(output);
            return waiter.waitFrame(new FrameFinder(chooser), index);
        }
        catch (InterruptedException e) {
            output.printStackTrace(e);
            return null;
        }
    }

    public static class FrameByTitleFinder
    implements ComponentChooser {
        String title;
        Operator.StringComparator comparator;

        public FrameByTitleFinder(String t, Operator.StringComparator comparator) {
            this.title = t;
            this.comparator = comparator;
        }

        public FrameByTitleFinder(String t) {
            this(t, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof Frame && ((Frame)comp).isShowing() && ((Frame)comp).getTitle() != null) {
                return this.comparator.equals(((Frame)comp).getTitle(), this.title);
            }
            return false;
        }

        public String getDescription() {
            return "Frame with title \"" + this.title + "\"";
        }
    }

    public static class FrameFinder
    extends Operator.Finder {
        public FrameFinder(ComponentChooser sf) {
            super(class$java$awt$Frame == null ? (class$java$awt$Frame = FrameOperator.class$("java.awt.Frame")) : class$java$awt$Frame, sf);
        }

        public FrameFinder() {
            super(class$java$awt$Frame == null ? (class$java$awt$Frame = FrameOperator.class$("java.awt.Frame")) : class$java$awt$Frame);
        }
    }
}

