/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.eso.fits.FitsException;

public class FitsKeyword {
    public static final int NONE = 0;
    public static final int COMMENT = 1;
    public static final int STRING = 2;
    public static final int BOOLEAN = 3;
    public static final int INTEGER = 4;
    public static final int REAL = 5;
    public static final int DATE = 6;
    private final byte NULL = 0;
    private final byte SPACE = (byte)32;
    private final byte COMMA = (byte)44;
    private final byte QUOTE = (byte)39;
    private final byte SLASH = (byte)47;
    private final byte EQUAL = (byte)61;
    private final byte MINUS = (byte)45;
    private final byte UNDERSCORE = (byte)95;
    private final byte A = (byte)65;
    private final byte Z = (byte)90;
    private String name;
    private int type = 0;
    private String kwCard;
    private boolean validCard = false;
    private Object value;
    private String comment;
    private boolean valueTruncated = false;
    private static final SimpleDateFormat ISOLONG = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final SimpleDateFormat ISOSHORT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat FITSDATE = new SimpleDateFormat("dd/MM/yy");
    private static final TimeZone TIMEZONE = TimeZone.getTimeZone("UTC");

    public FitsKeyword(byte[] byArray) throws FitsException {
        int n;
        int n2;
        int n3;
        Object object;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (byArray == null || byArray.length < 80) {
            object = new byte[80];
            for (n3 = 0; n3 < byArray.length; ++n3) {
                object[n3] = byArray[n3];
            }
            while (n3 < 80) {
                object[n3++] = 32;
            }
            byArray = object;
        }
        if (byArray[0] != 32 && byArray[0] != 45 && byArray[0] != 95 && (byArray[0] < 65 || 90 < byArray[0])) {
            throw new FitsException("Illegal character", 2);
        }
        this.kwCard = new String(byArray, 0, 80);
        this.validCard = true;
        this.name = this.kwCard.substring(0, 8);
        object = null;
        this.comment = null;
        if (this.name.startsWith("END     ")) {
            throw new FitsException("END card", 3);
        }
        if (this.name.startsWith("HISTORY ") || this.name.startsWith("COMMENT ") || this.name.startsWith("        ")) {
            this.type = 1;
            n6 = 8;
        } else if (this.name.startsWith("HIERARCH")) {
            StringBuffer stringBuffer = new StringBuffer(80);
            n2 = 0;
            n = 0;
            n4 = 8;
            while (n4 < 80 && byArray[n4] != 61) {
                if (byArray[n4] != 32) {
                    if (n == 32 && n2 != 0) {
                        stringBuffer.append('.');
                    }
                    n2 = 1;
                    stringBuffer.append((char)byArray[n4]);
                }
                n = byArray[n4++];
            }
            if (80 <= n4) {
                throw new FitsException("No equal-sign in HIERARCH keyword", 2);
            }
            this.name = stringBuffer.toString();
        } else if (byArray[8] == 61) {
            n4 = 8;
        } else {
            this.type = 1;
            n6 = 8;
        }
        this.name = this.name.trim().toUpperCase();
        if (byArray[n4] == 61) {
            ++n4;
            while (n4 < 80 && byArray[n4] == 32) {
                ++n4;
            }
            if (byArray[n4] == 39) {
                for (n5 = ++n4; n5 < 79 && (byArray[n5] != 39 || byArray[n5] == 39 && byArray[n5 + 1] == 39); ++n5) {
                    if (byArray[n5] != 39) continue;
                    ++n5;
                }
                n2 = n4;
                n = 1;
                for (n3 = n4; n3 < n5; ++n3) {
                    byArray[n2] = byArray[n3];
                    if (byArray[n3] == 39) {
                        int n7 = n = n == 0 ? 1 : 0;
                    }
                    if (n == 0) continue;
                    ++n2;
                }
                object = n3 == n2 ? this.kwCard.substring(n4, n2) : new String(byArray, n4, n2 - n4);
                this.type = 2;
                n3 = this.name.lastIndexOf(46) + 1;
                if (this.name.regionMatches(n3, "DATE", 0, 4)) {
                    SimpleDateFormat simpleDateFormat = FITSDATE;
                    if (0 < ((String)object).indexOf(45)) {
                        simpleDateFormat = 0 < ((String)object).indexOf(84) ? ISOLONG : ISOSHORT;
                    }
                    simpleDateFormat.setTimeZone(TIMEZONE);
                    this.value = simpleDateFormat.parse((String)object, new ParsePosition(0));
                    this.type = 6;
                } else {
                    this.value = ((String)object).trim();
                    this.type = 2;
                }
            } else {
                for (n5 = n4; n5 < 80 && byArray[n5] != 32 && byArray[n5] != 47 && byArray[n5] != 44; ++n5) {
                }
                object = this.kwCard.substring(n4, n5);
                try {
                    if (0 <= ((String)object).indexOf(46)) {
                        this.value = new Double((String)object);
                        this.type = 5;
                    } else {
                        this.value = new Integer((String)object);
                        this.type = 4;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.value = new Boolean(((String)object).regionMatches(true, 0, "T", 0, 1));
                    this.type = 3;
                }
            }
            while (n5 < 80 && byArray[n5] != 47) {
                ++n5;
            }
            if (n5 < 80 && byArray[n5] == 47) {
                n6 = n5 + 1;
            }
        }
        if (0 < n6) {
            this.comment = this.kwCard.substring(n6, 80);
            this.comment = this.comment.trim();
        } else {
            this.comment = new String("");
        }
    }

    public FitsKeyword(String string) throws FitsException {
        this(string.getBytes());
    }

    public FitsKeyword(String string, String string2) {
        this.setName(string);
        this.comment = string2;
        this.type = 1;
        this.validCard = false;
    }

    public FitsKeyword(String string, String string2, String string3) {
        this.setName(string);
        this.value = string2;
        this.comment = string3;
        this.type = 2;
        this.validCard = false;
    }

    public FitsKeyword(String string, boolean bl, String string2) {
        this.setName(string);
        this.value = new Boolean(bl);
        this.comment = string2;
        this.type = 3;
        this.validCard = false;
    }

    public FitsKeyword(String string, int n, String string2) {
        this.setName(string);
        this.value = new Integer(n);
        this.comment = string2;
        this.type = 4;
        this.validCard = false;
    }

    public FitsKeyword(String string, double d, String string2) {
        this.setName(string);
        this.value = new Double(d);
        this.comment = string2;
        this.type = 5;
        this.validCard = false;
    }

    public FitsKeyword(String string, Date date, String string2) {
        this.setName(string);
        this.value = date;
        this.comment = string2;
        this.type = 6;
        this.validCard = false;
    }

    public final boolean getBool() {
        if (this.type == 3) {
            return (Boolean)this.value;
        }
        if (this.type == 4) {
            return (Integer)this.value != 0;
        }
        if (this.type == 5) {
            return ((Double)this.value).intValue() != 0;
        }
        return false;
    }

    public final int getInt() {
        if (this.type == 4) {
            return (Integer)this.value;
        }
        if (this.type == 5) {
            return ((Double)this.value).intValue();
        }
        return 0;
    }

    public final double getReal() {
        if (this.type == 5) {
            return (Double)this.value;
        }
        if (this.type == 4) {
            return ((Integer)this.value).doubleValue();
        }
        return 0.0;
    }

    public final Date getDate() {
        if (this.value == null) {
            return null;
        }
        if (this.type == 6) {
            return (Date)this.value;
        }
        if (this.type == 2) {
            String string = (String)this.value;
            SimpleDateFormat simpleDateFormat = FITSDATE;
            if (0 < string.indexOf(45)) {
                simpleDateFormat = 0 < string.indexOf(84) ? ISOLONG : ISOSHORT;
            }
            simpleDateFormat.setTimeZone(TIMEZONE);
            return simpleDateFormat.parse(string, new ParsePosition(0));
        }
        return null;
    }

    public final String getString() {
        if (this.value == null) {
            return null;
        }
        if (this.type == 6) {
            SimpleDateFormat simpleDateFormat = ISOLONG;
            simpleDateFormat.setTimeZone(TIMEZONE);
            return simpleDateFormat.format((Date)this.value, new StringBuffer(), new FieldPosition(0)).toString();
        }
        return this.value.toString();
    }

    public final void setValue(String string) {
        this.value = string;
        this.type = 2;
        this.validCard = false;
    }

    public final void setValue(boolean bl) {
        this.value = new Boolean(bl);
        this.type = 3;
        this.validCard = false;
    }

    public final void setValue(int n) {
        this.value = new Integer(n);
        this.type = 4;
        this.validCard = false;
    }

    public final void setValue(double d) {
        this.value = new Double(d);
        this.type = 5;
        this.validCard = false;
    }

    public final void setValue(Date date) {
        this.value = date;
        this.type = 6;
        this.validCard = false;
    }

    public String toString() {
        Object object;
        int n;
        if (this.validCard) {
            return this.kwCard;
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        if (this.name.length() < 9 && this.name.indexOf(46) < 0) {
            stringBuffer.append(this.name);
            n = stringBuffer.length();
            while (n++ < 8) {
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append("HIERARCH ");
            object = new StringTokenizer(this.name, ".");
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringBuffer.append(((StringTokenizer)object).nextToken() + " ");
            }
        }
        object = "'        '";
        switch (this.type) {
            case 2: {
                Object object2;
                StringBuffer stringBuffer2 = new StringBuffer((String)this.value);
                if (0 <= ((String)this.value).indexOf(39)) {
                    object2 = ((String)this.value).toCharArray();
                    stringBuffer2 = new StringBuffer(80);
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        stringBuffer2.append((char)object2[i]);
                        if (object2[i] != 39) continue;
                        stringBuffer2.append('\'');
                    }
                }
                while (stringBuffer2.length() < 8) {
                    stringBuffer2.append(" ");
                }
                stringBuffer2.insert(0, '\'');
                stringBuffer2.append('\'');
                object = stringBuffer2.toString();
                break;
            }
            case 4: {
                object = ((Integer)this.value).toString();
                break;
            }
            case 5: {
                object = ((Double)this.value).toString();
                break;
            }
            case 3: {
                if (((Boolean)this.value).booleanValue()) {
                    object = "T";
                    break;
                }
                object = "F";
                break;
            }
            case 6: {
                Object object2 = ISOLONG;
                ((DateFormat)object2).setTimeZone(TIMEZONE);
                StringBuffer stringBuffer3 = new StringBuffer("'" + ((SimpleDateFormat)object2).format((Date)this.value, new StringBuffer(), new FieldPosition(0)) + "'");
                object = stringBuffer3.toString();
                break;
            }
            case 1: {
                stringBuffer.append(this.comment);
            }
        }
        if (this.type != 1) {
            stringBuffer.append("= ");
            n = ((String)object).length();
            if (stringBuffer.length() < 11 && this.type != 2) {
                while (n++ < 20) {
                    stringBuffer.append(" ");
                }
            }
            stringBuffer.append((String)object);
            this.valueTruncated = false;
            n = stringBuffer.length();
            if (80 < n) {
                stringBuffer.setCharAt(79, '\'');
                this.valueTruncated = true;
            }
            while (n++ < 30) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(" / " + this.comment);
        }
        if (80 < (n = stringBuffer.length())) {
            stringBuffer.setLength(80);
        } else {
            while (n++ < 80) {
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    public boolean isValueTruncated() {
        return this.valueTruncated;
    }

    public boolean isEmpty() {
        return this.name.length() < 1 && this.comment.length() < 1 && this.value == null;
    }

    public boolean isModified() {
        return !this.validCard;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string == null ? "" : string.toUpperCase();
    }

    public int getType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string == null ? "" : string;
    }
}

