/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.File;
import java.util.StringTokenizer;
import org.eso.fits.FitsFile;
import org.eso.fits.FitsHDUnit;
import org.eso.fits.FitsHeader;
import org.eso.fits.FitsKeyword;

public class ListFits {
    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 1) {
            System.out.println("Error: must be called with one argument");
            System.exit(1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], ",");
        String[] stringArray2 = new String[]{};
        if (stringArray.length > 1) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringArray[1], ",");
            stringArray2 = new String[stringTokenizer2.countTokens()];
            n = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                stringArray2[n++] = stringTokenizer2.nextToken().toUpperCase();
            }
            stringTokenizer2 = null;
        }
        int n2 = 0;
        n = 0;
        long l = System.currentTimeMillis();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            File file = new File(string);
            String[] stringArray3 = new String[1];
            if (file.isDirectory()) {
                stringArray3 = file.list();
            } else {
                stringArray3[0] = string;
            }
            for (int i = 0; i < stringArray3.length; ++i) {
                if (!FitsFile.isFitsFile(stringArray3[i])) continue;
                FitsFile fitsFile = null;
                try {
                    fitsFile = new FitsFile(stringArray3[i]);
                }
                catch (Exception exception) {
                    continue;
                }
                ++n2;
                int n3 = fitsFile.getNoHDUnits();
                FitsHDUnit fitsHDUnit = fitsFile.getHDUnit(0);
                FitsHeader fitsHeader = fitsHDUnit.getHeader();
                n += fitsHeader.getNoKeywords();
                System.out.print(stringArray3[i]);
                block12: for (int j = 0; j < stringArray2.length; ++j) {
                    FitsKeyword fitsKeyword = fitsHeader.getKeyword(stringArray2[j]);
                    if (fitsKeyword == null) continue;
                    switch (fitsKeyword.getType()) {
                        case 2: {
                            System.out.print("   " + fitsKeyword.getString());
                            continue block12;
                        }
                        case 3: {
                            System.out.print("   " + fitsKeyword.getBool());
                            continue block12;
                        }
                        case 4: {
                            System.out.print("   " + fitsKeyword.getInt());
                            continue block12;
                        }
                        case 5: {
                            System.out.print("   " + fitsKeyword.getReal());
                            continue block12;
                        }
                        case 6: {
                            System.out.print("   " + fitsKeyword.getString());
                            continue block12;
                        }
                    }
                }
                System.out.print("\n");
            }
        }
        if (0 < n2) {
            float f = (float)(0.001 * (double)(System.currentTimeMillis() - l));
            float f2 = f / (float)n2;
            float f3 = (float)n / f;
            System.out.println("  Time: " + f2 + " S/file, Rate: " + f3 + " kw/S, Keywords: " + n);
        }
        System.exit(0);
    }
}

