/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import [Ljava.lang.String;;
import [Lorg.python.core.PyObject;;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Properties;
import org.python.compiler.Module;
import org.python.core.BytecodeLoader;
import org.python.core.CompilerFlags;
import org.python.core.FixedFileWrapper;
import org.python.core.IdImpl;
import org.python.core.JavaCode;
import org.python.core.JavaFunc;
import org.python.core.Options;
import org.python.core.PyClass;
import org.python.core.PyCode;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFrame;
import org.python.core.PyFunctionTable;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyMetaClass;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyRunnable;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTableCode;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.StdoutWrapper;
import org.python.core.ThreadState;
import org.python.core.ThreadStateMapping;
import org.python.core.__builtin__;
import org.python.core.adapter.ClassicPyObjectAdapter;
import org.python.core.adapter.ExtensiblePyObjectAdapter;
import org.python.core.imp;
import org.python.core.parser;
import org.python.parser.ast.modType;

public final class Py {
    static boolean frozen;
    static String frozenPackage;
    private static final Object PRESENT;
    static Hashtable frozenModules;
    static boolean initialized;
    public static PyObject None;
    public static PyObject Ellipsis;
    public static PyObject NotImplemented;
    public static String[] NoKeywords;
    public static PyObject[] EmptyObjects;
    public static PyTuple EmptyTuple;
    public static PyInteger Zero;
    public static PyInteger One;
    public static PyString EmptyString;
    public static PyString Newline;
    public static PyString Space;
    public static Object NoConversion;
    public static PyObject OSError;
    public static PyObject NotImplementedError;
    public static PyObject EnvironmentError;
    public static PyObject OverflowError;
    public static PyObject RuntimeError;
    public static PyObject KeyboardInterrupt;
    public static PyObject FloatingPointError;
    public static PyObject SyntaxError;
    public static PyObject IndentationError;
    public static PyObject TabError;
    public static PyObject AttributeError;
    public static PyObject IOError;
    public static PyObject KeyError;
    public static PyObject AssertionError;
    public static PyObject TypeError;
    public static PyObject ReferenceError;
    public static PyObject SystemError;
    public static PyObject IndexError;
    public static PyObject ZeroDivisionError;
    public static PyObject NameError;
    public static PyObject UnboundLocalError;
    public static PyObject SystemExit;
    public static PyObject StopIteration;
    public static PyObject ImportError;
    public static PyObject ValueError;
    public static PyObject UnicodeError;
    public static PyObject EOFError;
    public static PyObject MemoryError;
    public static PyObject ArithmeticError;
    public static PyObject LookupError;
    public static PyObject StandardError;
    public static PyObject Exception;
    public static PyObject Warning;
    public static PyObject UserWarning;
    public static PyObject DeprecationWarning;
    public static PyObject SyntaxWarning;
    public static PyObject OverflowWarning;
    public static PyObject RuntimeWarning;
    private static PyObject warnings_mod;
    public static PyObject JavaError;
    private static PyInteger[] integerCache;
    public static PySystemState defaultSystemState;
    private static boolean secEnv;
    private static boolean propertiesInitialized;
    private static ThreadStateMapping threadStateMapping;
    public static StdoutWrapper stderr;
    static StdoutWrapper stdout;
    private static PyString[] letters;
    private static ExtensiblePyObjectAdapter adapter;
    private static Class[] pyClassCtrSignature;
    private static final PyType CLASS_TYPE;
    private static int nameindex;
    private static IdImpl idimpl;
    public static final int ERROR = -1;
    public static final int WARNING = 0;
    public static final int MESSAGE = 1;
    public static final int COMMENT = 2;
    public static final int DEBUG = 3;

    public static PyException OverflowError(String message) {
        return new PyException(OverflowError, message);
    }

    public static PyException RuntimeError(String message) {
        return new PyException(RuntimeError, message);
    }

    public static PyException FloatingPointError(String message) {
        return new PyException(FloatingPointError, message);
    }

    public static PyException SyntaxError(String message) {
        return new PyException(SyntaxError, message);
    }

    public static PyException AttributeError(String message) {
        return new PyException(AttributeError, message);
    }

    public static PyException IOError(IOException ioe) {
        String message = ioe.getMessage();
        if (ioe instanceof FileNotFoundException) {
            message = "File not found - " + message;
        }
        return new PyException(IOError, message);
    }

    public static PyException IOError(String message) {
        return new PyException(IOError, message);
    }

    public static PyException KeyError(String message) {
        return new PyException(KeyError, message);
    }

    public static PyException AssertionError(String message) {
        return new PyException(AssertionError, message);
    }

    public static PyException TypeError(String message) {
        return new PyException(TypeError, message);
    }

    public static PyException ReferenceError(String message) {
        return new PyException(ReferenceError, message);
    }

    public static PyException SystemError(String message) {
        return new PyException(SystemError, message);
    }

    public static PyException IndexError(String message) {
        return new PyException(IndexError, message);
    }

    public static PyException ZeroDivisionError(String message) {
        return new PyException(ZeroDivisionError, message);
    }

    public static PyException NameError(String message) {
        return new PyException(NameError, message);
    }

    public static PyException UnboundLocalError(String message) {
        return new PyException(UnboundLocalError, message);
    }

    static void maybeSystemExit(PyException exc) {
        if (Py.matchException(exc, SystemExit)) {
            PyObject tmp;
            PyObject value = exc.value;
            if (value instanceof PyInstance && (tmp = value.__findattr__("code")) != null) {
                value = tmp;
            }
            Py.getSystemState().callExitFunc();
            if (value instanceof PyInteger) {
                System.exit(((PyInteger)value).getValue());
            } else {
                if (value != None) {
                    try {
                        Py.println(value);
                        System.exit(1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                System.exit(0);
            }
        }
    }

    public static PyException StopIteration(String message) {
        return new PyException(StopIteration, message);
    }

    public static PyException ImportError(String message) {
        return new PyException(ImportError, message);
    }

    public static PyException ValueError(String message) {
        return new PyException(ValueError, message);
    }

    public static PyException UnicodeError(String message) {
        return new PyException(UnicodeError, message);
    }

    public static PyException EOFError(String message) {
        return new PyException(EOFError, message);
    }

    public static void memory_error(OutOfMemoryError t) {
        if (Options.showJavaExceptions) {
            t.printStackTrace();
        }
    }

    public static PyException MemoryError(String message) {
        return new PyException(MemoryError, message);
    }

    public static void Warning(String message) {
        Py.warning(Warning, message);
    }

    public static void UserWarning(String message) {
        Py.warning(UserWarning, message);
    }

    public static void DeprecationWarning(String message) {
        Py.warning(DeprecationWarning, message);
    }

    public static void SyntaxWarning(String message) {
        Py.warning(SyntaxWarning, message);
    }

    public static void OverflowWarning(String message) {
        Py.warning(OverflowWarning, message);
    }

    public static void RuntimeWarning(String message) {
        Py.warning(RuntimeWarning, message);
    }

    private static PyObject importWarnings() {
        PyObject mod;
        if (warnings_mod != null) {
            return warnings_mod;
        }
        try {
            mod = __builtin__.__import__("warnings");
        }
        catch (PyException e) {
            if (Py.matchException(e, ImportError)) {
                return null;
            }
            throw e;
        }
        warnings_mod = mod;
        return mod;
    }

    private static String warn_hcategory(PyObject category) {
        PyObject name = category.__findattr__("__name__");
        if (name != null) {
            return "[" + name + "]";
        }
        return "[warning]";
    }

    public static void warning(PyObject category, String message) {
        PyObject func = null;
        PyObject mod = Py.importWarnings();
        if (mod != null) {
            func = mod.__getattr__("warn");
        }
        if (func == null) {
            System.err.println(Py.warn_hcategory(category) + ": " + message);
            return;
        }
        func.__call__(Py.newString(message), category);
    }

    public static void warning(PyObject category, String message, String filename, int lineno, String module, PyObject registry) {
        PyObject func = null;
        PyObject mod = Py.importWarnings();
        if (mod != null) {
            func = mod.__getattr__("warn_explicit");
        }
        if (func == null) {
            System.err.println(filename + ":" + lineno + ":" + Py.warn_hcategory(category) + ": " + message);
            return;
        }
        func.__call__(new PyObject[]{Py.newString(message), category, Py.newString(filename), Py.newInteger(lineno), module == null ? None : Py.newString(module), registry}, NoKeywords);
    }

    public static PyException JavaError(Throwable t) {
        if (t instanceof PyException) {
            return (PyException)t;
        }
        if (t instanceof InvocationTargetException) {
            return Py.JavaError(((InvocationTargetException)t).getTargetException());
        }
        if (t instanceof OutOfMemoryError) {
            Py.memory_error((OutOfMemoryError)t);
        }
        PyJavaInstance exc = new PyJavaInstance(t);
        return new PyException((PyObject)exc.instclass, exc);
    }

    private Py() {
    }

    public static Object tojava(PyObject o, Class c) {
        Object obj = o.__tojava__(c);
        if (obj == NoConversion) {
            throw Py.TypeError("can't convert " + o.__repr__() + " to " + c.getName());
        }
        return obj;
    }

    public static Object tojava(PyObject o, String s) {
        Class c = Py.findClass(s);
        if (c == null) {
            throw Py.TypeError("can't convert to: " + s);
        }
        return Py.tojava(o, c);
    }

    public static PyObject jfindattr(PyProxy proxy, String name) {
        PyObject ret;
        PyInstance o = proxy._getPyInstance();
        if (o == null) {
            proxy.__initProxy__(new Object[0]);
            o = proxy._getPyInstance();
        }
        if ((ret = o.__jfindattr__(name)) == null) {
            return null;
        }
        Py.setSystemState(proxy._getPySystemState());
        return ret;
    }

    public static PyObject jgetattr(PyProxy proxy, String name) {
        PyObject ret;
        PyInstance o = proxy._getPyInstance();
        if (o == null) {
            proxy.__initProxy__(new Object[0]);
            o = proxy._getPyInstance();
        }
        if ((ret = o.__jfindattr__(name)) == null) {
            throw Py.AttributeError("abstract method \"" + name + "\" not implemented");
        }
        Py.setSystemState(proxy._getPySystemState());
        return ret;
    }

    public static final PyInteger newInteger(int i) {
        if (integerCache == null) {
            integerCache = new PyInteger[1000];
            for (int j = -100; j < 900; ++j) {
                Py.integerCache[j + 100] = new PyInteger(j);
            }
        }
        if (i >= -100 && i < 900) {
            return integerCache[i + 100];
        }
        return new PyInteger(i);
    }

    public static PyObject newInteger(long i) {
        if (i < Integer.MIN_VALUE || i > Integer.MAX_VALUE) {
            return new PyLong(i);
        }
        return Py.newInteger((int)i);
    }

    public static PyLong newLong(String s) {
        return new PyLong(s);
    }

    public static PyLong newLong(BigInteger i) {
        return new PyLong(i);
    }

    public static PyLong newLong(int i) {
        return new PyLong(i);
    }

    public static PyComplex newImaginary(double v) {
        return new PyComplex(0.0, v);
    }

    public static PyFloat newFloat(float v) {
        return new PyFloat((double)v);
    }

    public static PyFloat newFloat(double v) {
        return new PyFloat(v);
    }

    public static PyString newString(char c) {
        return Py.makeCharacter(c);
    }

    public static PyString newString(String s) {
        return new PyString(s);
    }

    public static PyUnicode newUnicode(char c) {
        return (PyUnicode)Py.makeCharacter(c, true);
    }

    public static PyUnicode newUnicode(String s) {
        return new PyUnicode(s);
    }

    public static PyInteger newBoolean(boolean t) {
        return t ? One : Zero;
    }

    public static PyCode newCode(int argcount, String[] varnames, String filename, String name, boolean args, boolean keywords, PyFunctionTable funcs, int func_id, String[] cellvars, String[] freevars, int npurecell, int moreflags) {
        return new PyTableCode(argcount, varnames, filename, name, 0, args, keywords, funcs, func_id, cellvars, freevars, npurecell, moreflags);
    }

    public static PyCode newCode(int argcount, String[] varnames, String filename, String name, int firstlineno, boolean args, boolean keywords, PyFunctionTable funcs, int func_id, String[] cellvars, String[] freevars, int npurecell, int moreflags) {
        return new PyTableCode(argcount, varnames, filename, name, firstlineno, args, keywords, funcs, func_id, cellvars, freevars, npurecell, moreflags);
    }

    public static PyCode newCode(int argcount, String[] varnames, String filename, String name, boolean args, boolean keywords, PyFunctionTable funcs, int func_id) {
        return new PyTableCode(argcount, varnames, filename, name, 0, args, keywords, funcs, func_id);
    }

    public static PyCode newCode(int argcount, String[] varnames, String filename, String name, int firstlineno, boolean args, boolean keywords, PyFunctionTable funcs, int func_id) {
        return new PyTableCode(argcount, varnames, filename, name, firstlineno, args, keywords, funcs, func_id);
    }

    public static PyCode newJavaCode(Class cls, String name) {
        return new JavaCode(Py.newJavaFunc(cls, name));
    }

    public static PyObject newJavaFunc(Class cls, String name) {
        try {
            Method m = cls.getMethod(name, PyObject;.class, String;.class);
            return new JavaFunc(m);
        }
        catch (NoSuchMethodException e) {
            throw Py.JavaError(e);
        }
    }

    private static PyObject initExc(String name, PyObject exceptions2, PyObject dict) {
        PyObject tmp = exceptions2.__getattr__(name);
        dict.__setitem__(name, tmp);
        return tmp;
    }

    static void initClassExceptions(PyObject dict) {
        PyObject exc = imp.load("exceptions");
        Exception = Py.initExc("Exception", exc, dict);
        SystemExit = Py.initExc("SystemExit", exc, dict);
        StopIteration = Py.initExc("StopIteration", exc, dict);
        StandardError = Py.initExc("StandardError", exc, dict);
        KeyboardInterrupt = Py.initExc("KeyboardInterrupt", exc, dict);
        ImportError = Py.initExc("ImportError", exc, dict);
        EnvironmentError = Py.initExc("EnvironmentError", exc, dict);
        IOError = Py.initExc("IOError", exc, dict);
        OSError = Py.initExc("OSError", exc, dict);
        EOFError = Py.initExc("EOFError", exc, dict);
        RuntimeError = Py.initExc("RuntimeError", exc, dict);
        NotImplementedError = Py.initExc("NotImplementedError", exc, dict);
        NameError = Py.initExc("NameError", exc, dict);
        UnboundLocalError = Py.initExc("UnboundLocalError", exc, dict);
        AttributeError = Py.initExc("AttributeError", exc, dict);
        SyntaxError = Py.initExc("SyntaxError", exc, dict);
        IndentationError = Py.initExc("IndentationError", exc, dict);
        TabError = Py.initExc("TabError", exc, dict);
        TypeError = Py.initExc("TypeError", exc, dict);
        AssertionError = Py.initExc("AssertionError", exc, dict);
        LookupError = Py.initExc("LookupError", exc, dict);
        IndexError = Py.initExc("IndexError", exc, dict);
        KeyError = Py.initExc("KeyError", exc, dict);
        ArithmeticError = Py.initExc("ArithmeticError", exc, dict);
        OverflowError = Py.initExc("OverflowError", exc, dict);
        ZeroDivisionError = Py.initExc("ZeroDivisionError", exc, dict);
        FloatingPointError = Py.initExc("FloatingPointError", exc, dict);
        ValueError = Py.initExc("ValueError", exc, dict);
        UnicodeError = Py.initExc("UnicodeError", exc, dict);
        ReferenceError = Py.initExc("ReferenceError", exc, dict);
        SystemError = Py.initExc("SystemError", exc, dict);
        MemoryError = Py.initExc("MemoryError", exc, dict);
        Warning = Py.initExc("Warning", exc, dict);
        UserWarning = Py.initExc("UserWarning", exc, dict);
        DeprecationWarning = Py.initExc("DeprecationWarning", exc, dict);
        SyntaxWarning = Py.initExc("SyntaxWarning", exc, dict);
        OverflowWarning = Py.initExc("OverflowWarning", exc, dict);
        RuntimeWarning = Py.initExc("RuntimeWarning", exc, dict);
        PyJavaClass.lookup(OutOfMemoryError.class);
    }

    public static synchronized boolean initPython() {
        PySystemState.initialize();
        return true;
    }

    public static Class relFindClass(Class home, String name) {
        try {
            ClassLoader loader = home.getClassLoader();
            if (loader != null) {
                return loader.loadClass(name);
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException exc) {
            return null;
        }
        catch (Throwable t) {
            throw Py.JavaError(t);
        }
    }

    public static Class findClass(String name) {
        try {
            ClassLoader classLoader = Py.getSystemState().getClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(name);
            }
            if (!secEnv) {
                try {
                    classLoader = imp.getSyspathJavaLoader();
                }
                catch (SecurityException e) {
                    secEnv = true;
                }
                if (classLoader != null) {
                    return classLoader.loadClass(name);
                }
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    public static Class findClassEx(String name, String reason) {
        try {
            ClassLoader classLoader = Py.getSystemState().getClassLoader();
            if (classLoader != null) {
                Py.writeDebug("import", "trying " + name + " as " + reason + " in classLoader");
                return classLoader.loadClass(name);
            }
            if (!secEnv) {
                try {
                    classLoader = imp.getSyspathJavaLoader();
                }
                catch (SecurityException e) {
                    secEnv = true;
                }
                if (classLoader != null) {
                    Py.writeDebug("import", "trying " + name + " as " + reason + " in syspath loader");
                    return classLoader.loadClass(name);
                }
            }
            Py.writeDebug("import", "trying " + name + " as " + reason + " in Class.forName");
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            throw Py.JavaError(e);
        }
        catch (LinkageError e) {
            throw Py.JavaError(e);
        }
    }

    private static void setArgv(String arg0, String[] args) {
        PyObject[] argv = new PyObject[args.length + 1];
        argv[0] = new PyString(arg0);
        for (int i = 1; i < argv.length; ++i) {
            argv[i] = new PyString(args[i - 1]);
        }
        Py.getSystemState().argv = new PyList(argv);
    }

    private static synchronized void initProperties(String[] args, String[] packages, String[] props, String frozenPackage, String[] modules, ClassLoader classLoader) {
        if (!propertiesInitialized) {
            Properties sprops;
            propertiesInitialized = true;
            if (frozenPackage != null) {
                frozen = true;
                if (frozenPackage.length() > 0) {
                    Py.frozenPackage = frozenPackage;
                }
            }
            try {
                sprops = new Properties(System.getProperties());
            }
            catch (Throwable t) {
                sprops = new Properties();
            }
            if (props != null) {
                for (int i = 0; i < props.length; i += 2) {
                    sprops.put(props[i], props[i + 1]);
                }
            }
            if (args == null) {
                args = new String[]{};
            }
            PySystemState.initialize(sprops, null, args, classLoader);
        }
        if (modules != null) {
            if (frozenModules == null) {
                frozenModules = new Hashtable();
            }
            for (int i = 0; i < modules.length; ++i) {
                String modname = modules[i];
                frozenModules.put(modname, PRESENT);
                if (!modname.endsWith(".__init__")) continue;
                String jpkg = modname.substring(0, modname.length() - 9);
                PySystemState.add_package(jpkg);
            }
        }
        if (packages != null) {
            for (int i = 0; i < packages.length; i += 2) {
                PySystemState.add_package(packages[i], packages[i + 1]);
            }
        }
    }

    public static void initProxy(PyProxy proxy, String module, String pyclass, Object[] args, String[] packages, String[] props, boolean frozen) {
        Py.initProxy(proxy, module, pyclass, args, packages, props, null, null);
    }

    public static void initProxy(PyProxy proxy, String module, String pyclass, Object[] args, String[] packages, String[] props, String frozenPackage, String[] modules) {
        PyObject[] pargs;
        PyObject mod;
        Py.initProperties(null, packages, props, frozenPackage, modules, proxy.getClass().getClassLoader());
        if (proxy._getPyInstance() != null) {
            return;
        }
        ThreadState ts = Py.getThreadState();
        PyInstance instance = ts.getInitializingProxy();
        if (instance != null) {
            if (instance.javaProxy != null) {
                throw Py.TypeError("Proxy instance reused");
            }
            instance.javaProxy = proxy;
            proxy._setPyInstance(instance);
            proxy._setPySystemState(ts.systemState);
            return;
        }
        Class modClass = Py.findClass(module + "$_PyInner");
        if (modClass != null) {
            PyCode code = null;
            try {
                code = ((PyRunnable)modClass.newInstance()).getMain();
            }
            catch (Throwable t) {
                throw Py.JavaError(t);
            }
            mod = imp.createFromCode(module, code);
        } else {
            mod = imp.importName(module.intern(), false);
        }
        PyClass pyc = (PyClass)mod.__getattr__(pyclass.intern());
        instance = new PyInstance(pyc);
        instance.javaProxy = proxy;
        proxy._setPyInstance(instance);
        proxy._setPySystemState(ts.systemState);
        if (args == null || args.length == 0) {
            pargs = EmptyObjects;
        } else {
            pargs = new PyObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                pargs[i] = Py.java2py(args[i]);
            }
        }
        instance.__init__(pargs, NoKeywords);
    }

    public static void initRunnable(String module, PyObject dict) {
        Class<?> mainClass = null;
        try {
            mainClass = Class.forName(module);
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Error running main.  Can't find: " + module);
            System.exit(-1);
        }
        PyCode code = null;
        try {
            code = ((PyRunnable)mainClass.newInstance()).getMain();
        }
        catch (Throwable t) {
            System.err.println("Invalid class (runnable): " + module + "$py");
            System.exit(-1);
        }
        Py.runCode(code, dict, dict);
    }

    public static void runMain(PyRunnable main, String[] args) throws Exception {
        Py.initProperties(args, null, null, null, null, main.getClass().getClassLoader());
        try {
            imp.createFromCode("__main__", main.getMain());
        }
        catch (PyException e) {
            Py.getSystemState().callExitFunc();
            if (Py.matchException(e, SystemExit)) {
                return;
            }
            throw e;
        }
        Py.getSystemState().callExitFunc();
    }

    public static void runMain(Class mainClass, String[] args, String[] packages, String[] props, String frozenPackage, String[] modules) throws Exception {
        Py.initProperties(args, packages, props, frozenPackage, modules, mainClass.getClassLoader());
        try {
            PyCode code = null;
            try {
                code = ((PyRunnable)mainClass.newInstance()).getMain();
            }
            catch (Throwable t) {
                System.err.println("Invalid class: " + mainClass.getName() + "$py");
                System.exit(-1);
            }
            PyObject mod = imp.createFromCode("__main__", code);
        }
        catch (PyException e) {
            Py.getSystemState().callExitFunc();
            if (Py.matchException(e, SystemExit)) {
                return;
            }
            throw e;
        }
        Py.getSystemState().callExitFunc();
    }

    private static String getStackTrace(Throwable javaError) {
        int index0;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        javaError.printStackTrace(new PrintStream(buf));
        String str = buf.toString();
        int index = -1;
        if (index == -1) {
            index = str.indexOf("at org.python.core.PyReflectedConstructor.__call__");
        }
        if (index == -1) {
            index = str.indexOf("at org.python.core.PyReflectedFunction.__call__");
        }
        if (index == -1) {
            index = str.indexOf("at org/python/core/PyReflectedConstructor.__call__");
        }
        if (index == -1) {
            index = str.indexOf("at org/python/core/PyReflectedFunction.__call__");
        }
        if (index != -1) {
            index = str.lastIndexOf("\n", index);
        }
        if (index >= (index0 = str.indexOf("\n"))) {
            str = str.substring(index0 + 1, index + 1);
        }
        return str;
    }

    public static void printException(Throwable t) {
        Py.printException(t, null, null);
    }

    public static void printException(Throwable t, PyFrame f) {
        Py.printException(t, f, null);
    }

    public static synchronized void printException(Throwable t, PyFrame f, PyObject file) {
        StdoutWrapper stderr = Py.stderr;
        if (file != null) {
            stderr = new FixedFileWrapper(file);
        }
        if (Options.showJavaExceptions) {
            stderr.println("Java Traceback:");
            CharArrayWriter buf = new CharArrayWriter();
            if (t instanceof PyException) {
                ((PyException)t).super__printStackTrace(new PrintWriter(buf));
            } else {
                t.printStackTrace(new PrintWriter(buf));
            }
            stderr.print(buf.toString());
        }
        PyException exc = Py.JavaError(t);
        Py.maybeSystemExit(exc);
        Py.setException(exc, f);
        ThreadState ts = Py.getThreadState();
        ts.systemState.last_value = exc.value;
        ts.systemState.last_type = exc.type;
        ts.systemState.last_traceback = exc.traceback;
        PyObject exceptHook = ts.systemState.__findattr__("excepthook");
        if (exceptHook != null) {
            try {
                exceptHook.__call__(exc.type, exc.value, exc.traceback);
            }
            catch (PyException exc2) {
                stderr.println("Error in sys.excepthook:");
                Py.displayException(exc2.type, exc2.value, exc2.traceback, file);
                stderr.println();
                stderr.println("Original exception was:");
                Py.displayException(exc.type, exc.value, exc.traceback, file);
            }
        } else {
            stderr.println("sys.excepthook is missing");
            Py.displayException(exc.type, exc.value, exc.traceback, file);
        }
        ts.exception = null;
    }

    public static void displayException(PyObject type, PyObject value, PyObject tb, PyObject file) {
        Object javaError;
        StdoutWrapper stderr = Py.stderr;
        if (file != null) {
            stderr = new FixedFileWrapper(file);
        }
        if (tb instanceof PyTraceback) {
            stderr.print(((PyTraceback)tb).dumpStack());
        }
        if (__builtin__.isinstance(value, (PyClass)SyntaxError)) {
            stderr.println("  File \"" + value.__findattr__("filename") + "\", line " + value.__findattr__("lineno"));
            PyObject text = value.__findattr__("text");
            if (text != None && text.__len__() != 0) {
                stderr.println("\t" + text);
                String space = "\t";
                int col = ((PyInteger)value.__findattr__("offset").__int__()).getValue();
                for (int j = 1; j < col; ++j) {
                    space = space + " ";
                }
                stderr.println(space + "^");
            }
        }
        if (value instanceof PyJavaInstance && (javaError = value.__tojava__(Throwable.class)) != null && javaError != NoConversion) {
            stderr.println(Py.getStackTrace((Throwable)javaError));
        }
        stderr.println(Py.formatException(type, value, tb));
    }

    static String formatException(PyObject type, PyObject value, PyObject tb) {
        StringBuffer buf = new StringBuffer();
        if (type instanceof PyClass) {
            buf.append(((PyClass)type).__name__);
        } else {
            buf.append(type.__str__());
        }
        if (value != None) {
            buf.append(": ");
            if (__builtin__.isinstance(value, (PyClass)SyntaxError)) {
                buf.append(value.__getitem__(0).__str__());
            } else {
                buf.append(value.__str__());
            }
        }
        return buf.toString();
    }

    public static void assert_(PyObject test, PyObject message) {
        if (!test.__nonzero__()) {
            throw new PyException(AssertionError, message);
        }
    }

    public static void assert_(PyObject test) {
        Py.assert_(test, None);
    }

    public static void addTraceback(Throwable t, PyFrame frame) {
        PyException e = Py.JavaError(t);
        if (e.traceback.tb_frame != frame) {
            e.traceback = new PyTraceback(e.traceback);
        }
    }

    public static PyException setException(Throwable t, PyFrame frame) {
        PyException pye = Py.JavaError(t);
        pye.instantiate();
        if (frame != null && pye.traceback.tb_frame != frame) {
            pye.traceback = new PyTraceback(pye.traceback);
        }
        ThreadState ts = Py.getThreadState();
        ts.exception = pye;
        return pye;
    }

    public static boolean matchException(PyException pye, PyObject e) {
        pye.instantiate();
        if (e == IOError && __builtin__.isinstance(pye.value, PyJavaClass.lookup(IOException.class))) {
            return true;
        }
        if (e == MemoryError && __builtin__.isinstance(pye.value, PyJavaClass.lookup(OutOfMemoryError.class))) {
            return true;
        }
        if (e instanceof PyClass) {
            return __builtin__.isinstance(pye.value, (PyClass)e);
        }
        if (e == pye.type) {
            return true;
        }
        if (e instanceof PyTuple) {
            PyObject[] l = ((PyTuple)e).getArray();
            for (int i = 0; i < l.length; ++i) {
                if (!Py.matchException(pye, l[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static PyException makeException() {
        ThreadState ts = Py.getThreadState();
        if (ts.exception == null) {
            throw Py.ValueError("no exception to reraise");
        }
        return ts.exception;
    }

    public static PyException makeException(PyObject type) {
        if (type instanceof PyInstance) {
            return new PyException(type.fastGetClass(), type);
        }
        return Py.makeException(type, None);
    }

    public static PyException makeException(PyObject type, PyObject value) {
        if (type instanceof PyInstance) {
            if (value != None) {
                throw Py.TypeError("instance exceptions may not have a separate value");
            }
            return new PyException(type.fastGetClass(), type);
        }
        PyException exc = new PyException(type, value);
        exc.instantiate();
        return exc;
    }

    public static PyException makeException(PyObject type, PyObject value, PyObject traceback) {
        if (type instanceof PyInstance) {
            if (value != None) {
                throw Py.TypeError("instance exceptions may not have a separate value");
            }
            type = type.fastGetClass();
        }
        if (traceback == None) {
            return new PyException(type, value);
        }
        if (!(traceback instanceof PyTraceback)) {
            throw Py.TypeError("raise 3rd arg must be traceback or None");
        }
        return new PyException(type, value, (PyTraceback)traceback);
    }

    public static PyObject runCode(PyCode code, PyObject locals, PyObject globals) {
        if (locals == null) {
            locals = globals != null ? globals : Py.getFrame().getf_locals();
        }
        if (globals == null) {
            globals = Py.getFrame().f_globals;
        }
        PyTableCode tc = null;
        if (code instanceof PyTableCode) {
            tc = (PyTableCode)code;
        }
        PySystemState cfr_ignored_0 = Py.getThreadState().systemState;
        PyFrame f = new PyFrame(tc, locals, globals, PySystemState.builtins);
        return code.call(f);
    }

    public static void exec(PyObject o, PyObject globals, PyObject locals) {
        PyCode code;
        if (o instanceof PyCode) {
            code = (PyCode)o;
            if (locals == null && o instanceof PyTableCode && ((PyTableCode)o).hasFreevars()) {
                throw Py.TypeError("code object passed to exec may not contain free variables");
            }
        } else {
            String contents = null;
            if (o instanceof PyString) {
                contents = o.toString();
            } else if (o instanceof PyFile) {
                PyFile fp = (PyFile)o;
                if (fp.closed) {
                    return;
                }
                contents = fp.read().toString();
            } else {
                throw Py.TypeError("exec: argument 1 must be string, code or file object");
            }
            code = Py.compile_flags(contents, "<string>", "exec", Py.getCompilerFlags());
        }
        Py.runCode(code, locals, globals);
    }

    public static final ThreadState getThreadState() {
        return Py.getThreadState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ThreadState getThreadState(PySystemState newSystemState) {
        if (threadStateMapping == null) {
            Class clazz = Py.class;
            synchronized (clazz) {
                if (threadStateMapping == null) {
                    threadStateMapping = ThreadStateMapping.makeMapping();
                }
            }
        }
        return threadStateMapping.getThreadState(newSystemState);
    }

    public static final PySystemState setSystemState(PySystemState newSystemState) {
        ThreadState ts = Py.getThreadState(newSystemState);
        PySystemState oldSystemState = ts.systemState;
        if (oldSystemState != newSystemState) {
            ts.systemState = newSystemState;
        }
        return oldSystemState;
    }

    public static final PySystemState getSystemState() {
        return Py.getThreadState().systemState;
    }

    public static PyFrame getFrame() {
        ThreadState ts = Py.getThreadState();
        if (ts == null) {
            return null;
        }
        return ts.frame;
    }

    public static void setFrame(PyFrame f) {
        Py.getThreadState().frame = f;
    }

    public static void print(PyObject file, PyObject o) {
        if (file == None) {
            Py.print(o);
        } else {
            new FixedFileWrapper(file).print(o);
        }
    }

    public static void printComma(PyObject file, PyObject o) {
        if (file == None) {
            Py.printComma(o);
        } else {
            new FixedFileWrapper(file).printComma(o);
        }
    }

    public static void println(PyObject file, PyObject o) {
        if (file == None) {
            Py.println(o);
        } else {
            new FixedFileWrapper(file).println(o);
        }
    }

    public static void printlnv(PyObject file) {
        if (file == None) {
            Py.println();
        } else {
            new FixedFileWrapper(file).println();
        }
    }

    public static void print(PyObject o) {
        stdout.print(o);
    }

    public static void printComma(PyObject o) {
        stdout.printComma(o);
    }

    public static void println(PyObject o) {
        stdout.println(o);
    }

    public static void println() {
        stdout.println();
    }

    public static boolean py2boolean(PyObject o) {
        return o.__nonzero__();
    }

    public static byte py2byte(PyObject o) {
        if (o instanceof PyInteger) {
            return (byte)((PyInteger)o).getValue();
        }
        Object i = o.__tojava__(Byte.TYPE);
        if (i == null || i == NoConversion) {
            throw Py.TypeError("integer required");
        }
        return (Byte)i;
    }

    public static short py2short(PyObject o) {
        if (o instanceof PyInteger) {
            return (short)((PyInteger)o).getValue();
        }
        Object i = o.__tojava__(Short.TYPE);
        if (i == null || i == NoConversion) {
            throw Py.TypeError("integer required");
        }
        return (Short)i;
    }

    public static int py2int(PyObject o) {
        return Py.py2int(o, "integer required");
    }

    public static int py2int(PyObject o, String msg) {
        if (o instanceof PyInteger) {
            return ((PyInteger)o).getValue();
        }
        Object obj = o.__tojava__(Integer.TYPE);
        if (obj == NoConversion) {
            throw Py.TypeError(msg);
        }
        return (Integer)obj;
    }

    public static long py2long(PyObject o) {
        if (o instanceof PyInteger) {
            return ((PyInteger)o).getValue();
        }
        Object i = o.__tojava__(Long.TYPE);
        if (i == null || i == NoConversion) {
            throw Py.TypeError("integer required");
        }
        return (Long)i;
    }

    public static float py2float(PyObject o) {
        if (o instanceof PyFloat) {
            return (float)((PyFloat)o).getValue();
        }
        if (o instanceof PyInteger) {
            return ((PyInteger)o).getValue();
        }
        Object i = o.__tojava__(Float.TYPE);
        if (i == null || i == NoConversion) {
            throw Py.TypeError("float required");
        }
        return ((Float)i).floatValue();
    }

    public static double py2double(PyObject o) {
        if (o instanceof PyFloat) {
            return ((PyFloat)o).getValue();
        }
        if (o instanceof PyInteger) {
            return ((PyInteger)o).getValue();
        }
        Object i = o.__tojava__(Double.TYPE);
        if (i == null || i == NoConversion) {
            throw Py.TypeError("float required");
        }
        return (Double)i;
    }

    public static char py2char(PyObject o) {
        return Py.py2char(o, "char required");
    }

    public static char py2char(PyObject o, String msg) {
        if (o instanceof PyString) {
            PyString s = (PyString)o;
            if (s.__len__() != 1) {
                throw Py.TypeError(msg);
            }
            return s.toString().charAt(0);
        }
        if (o instanceof PyInteger) {
            return (char)((PyInteger)o).getValue();
        }
        Object i = o.__tojava__(Character.TYPE);
        if (i == null || i == NoConversion) {
            throw Py.TypeError(msg);
        }
        return ((Character)i).charValue();
    }

    public static void py2void(PyObject o) {
        if (o != None) {
            throw Py.TypeError("None required for void return");
        }
    }

    public static final PyString makeCharacter(Character o) {
        return Py.makeCharacter(o.charValue());
    }

    static final PyString makeCharacter(char c) {
        return Py.makeCharacter(c, false);
    }

    static final PyString makeCharacter(char c, boolean explicitUnicode) {
        if (explicitUnicode || c > '\u00ff') {
            return new PyUnicode(new Character(c).toString());
        }
        if (letters == null) {
            letters = new PyString[256];
            for (char j = '\u0000'; j < '\u0100'; j = (char)(j + '\u0001')) {
                Py.letters[j] = new PyString(new Character(j).toString());
            }
        }
        return letters[c];
    }

    public static PyObject java2py(Object o) {
        return Py.getAdapter().adapt(o);
    }

    public static ExtensiblePyObjectAdapter getAdapter() {
        if (adapter == null) {
            adapter = new ClassicPyObjectAdapter();
        }
        return adapter;
    }

    protected static void setAdapter(ExtensiblePyObjectAdapter adapter) {
        Py.adapter = adapter;
    }

    public static PyObject makeClass(String name, PyObject[] bases, PyCode code, PyObject doc) {
        return Py.makeClass(name, bases, code, doc, null, null);
    }

    public static PyObject makeClass(String name, PyObject[] bases, PyCode code, PyObject doc, PyObject[] closure_cells) {
        return Py.makeClass(name, bases, code, doc, null, closure_cells);
    }

    public static PyObject makeClass(String name, PyObject[] bases, PyCode code, PyObject doc, Class proxyClass) {
        return Py.makeClass(name, bases, code, doc, proxyClass, null);
    }

    public static PyObject makeClass(String name, PyObject[] bases, PyCode code, PyObject doc, Class proxyClass, PyObject[] closure_cells) {
        PyObject metaclass;
        PyFrame frame = Py.getFrame();
        PyObject globals = frame.f_globals;
        PyObject dict = code.call(EmptyObjects, NoKeywords, globals, EmptyObjects, (PyObject)new PyTuple(closure_cells));
        if (doc != null) {
            dict.__setitem__("__doc__", doc);
        }
        if ((metaclass = dict.__finditem__("__metaclass__")) == null) {
            if (bases.length != 0) {
                PyObject base = bases[0];
                if (base instanceof PyMetaClass) {
                    try {
                        Constructor<?> ctor = base.getClass().getConstructor(pyClassCtrSignature);
                        return (PyObject)ctor.newInstance(name, new PyTuple(bases), dict, proxyClass);
                    }
                    catch (Exception e) {
                        throw Py.TypeError("meta-class fails to supply proper ctr: " + base.safeRepr());
                    }
                }
                metaclass = base.__findattr__("__class__");
                if (metaclass == null) {
                    metaclass = base.getType();
                }
            } else if (globals != null) {
                metaclass = globals.__finditem__("__metaclass__");
            }
        }
        if (metaclass == null || metaclass == CLASS_TYPE || metaclass instanceof PyJavaClass && ((PyJavaClass)metaclass).proxyClass == Class.class) {
            boolean more_general = false;
            for (int i = 0; i < bases.length; ++i) {
                if (bases[i] instanceof PyClass) continue;
                metaclass = bases[i].getType();
                more_general = true;
                break;
            }
            if (!more_general) {
                return new PyClass(name, new PyTuple(bases), dict, proxyClass);
            }
        }
        if (proxyClass != null) {
            throw Py.TypeError("the meta-class cannot handle java subclassing");
        }
        return metaclass.__call__((PyObject)new PyString(name), new PyTuple(bases), dict);
    }

    public static synchronized String getName() {
        String name = "org.python.pycode._pyx" + nameindex;
        ++nameindex;
        return name;
    }

    public static CompilerFlags getCompilerFlags() {
        return Py.getCompilerFlags(0, false);
    }

    public static CompilerFlags getCompilerFlags(int flags, boolean dont_inherit) {
        CompilerFlags cflags = null;
        if (dont_inherit) {
            cflags = new CompilerFlags(flags);
        } else {
            PyFrame frame = Py.getFrame();
            if (frame != null && frame.f_code != null) {
                cflags = new CompilerFlags(frame.f_code.co_flags | flags);
            }
        }
        return cflags;
    }

    public static PyCode compile(modType node, String filename) {
        return Py.compile(node, Py.getName(), filename);
    }

    public static PyCode compile(modType node, String name, String filename) {
        return Py.compile(node, name, filename, true, false);
    }

    public static PyCode compile(modType node, String name, String filename, boolean linenumbers, boolean printResults) {
        return Py.compile_flags(node, name, filename, linenumbers, printResults, null);
    }

    public static PyCode compile(InputStream istream, String filename, String type) {
        return Py.compile_flags(istream, filename, type, null);
    }

    public static PyCode compile_flags(modType node, String name, String filename, boolean linenumbers, boolean printResults, CompilerFlags cflags) {
        try {
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            Module.compile(node, ostream, name, filename, linenumbers, printResults, false, cflags);
            Py.saveClassFile(name, ostream);
            return BytecodeLoader.makeCode(name, ostream.toByteArray(), filename);
        }
        catch (Throwable t) {
            throw parser.fixParseError(null, t, filename);
        }
    }

    public static PyCode compile_flags(InputStream istream, String filename, String type, CompilerFlags cflags) {
        modType node = parser.parse(istream, type, filename, cflags);
        boolean printResults = false;
        if (type.equals("single")) {
            printResults = true;
        }
        return Py.compile_flags(node, Py.getName(), filename, true, printResults, cflags);
    }

    public static PyCode compile_flags(String data, String filename, String type, CompilerFlags cflags) {
        return Py.compile_flags(new ByteArrayInputStream(PyString.to_bytes(data + "\n\n")), filename, type, cflags);
    }

    public static PyObject compile_command_flags(String string, String filename, String kind, CompilerFlags cflags, boolean stdprompt) {
        modType node = parser.partialParse(string + "\n", kind, filename, cflags, stdprompt);
        if (node == null) {
            return None;
        }
        return Py.compile_flags(node, Py.getName(), filename, true, true, cflags);
    }

    public static PyObject[] unpackSequence(PyObject o, int length) {
        if (o instanceof PyTuple) {
            PyTuple tup = (PyTuple)o;
            if (tup.__len__() == length) {
                return tup.getArray();
            }
            throw Py.ValueError("unpack tuple of wrong size");
        }
        PyObject[] ret = new PyObject[length];
        PyObject iter = o.__iter__();
        try {
            for (int i = 0; i < length; ++i) {
                PyObject tmp = iter.__iternext__();
                if (tmp == null) {
                    throw Py.ValueError("unpack sequence too short");
                }
                ret[i] = tmp;
            }
        }
        catch (PyException exc) {
            if (Py.matchException(exc, AttributeError)) {
                throw Py.TypeError("unpack non-sequence");
            }
            throw exc;
        }
        if (iter.__iternext__() != null) {
            throw Py.ValueError("unpack sequence too long");
        }
        return ret;
    }

    public static PyObject iter(PyObject seq, String message) {
        try {
            return seq.__iter__();
        }
        catch (PyException exc) {
            if (Py.matchException(exc, TypeError)) {
                throw Py.TypeError(message);
            }
            throw exc;
        }
    }

    public static long id(PyObject o) {
        return idimpl.id(o);
    }

    public static String idstr(PyObject o) {
        return idimpl.idstr(o);
    }

    public static long java_obj_id(Object o) {
        return idimpl.java_obj_id(o);
    }

    public static String safeRepr(PyObject o) {
        return o.safeRepr();
    }

    public static void printResult(PyObject ret) {
        Py.getThreadState().systemState.invoke("displayhook", ret);
    }

    public static void maybeWrite(String type, String msg, int level) {
        if (level <= Options.verbose) {
            System.err.println(type + ": " + msg);
        }
    }

    public static void writeError(String type, String msg) {
        Py.maybeWrite(type, msg, -1);
    }

    public static void writeWarning(String type, String msg) {
        Py.maybeWrite(type, msg, 0);
    }

    public static void writeMessage(String type, String msg) {
        Py.maybeWrite(type, msg, 1);
    }

    public static void writeComment(String type, String msg) {
        Py.maybeWrite(type, msg, 2);
    }

    public static void writeDebug(String type, String msg) {
        Py.maybeWrite(type, msg, 3);
    }

    public static void saveClassFile(String name, ByteArrayOutputStream bytestream) {
        String dirname = Options.proxyDebugDirectory;
        if (dirname == null) {
            return;
        }
        byte[] bytes = bytestream.toByteArray();
        File dir = new File(dirname);
        File file = Py.makeFilename(name, dir);
        new File(file.getParent()).mkdirs();
        try {
            FileOutputStream o = new FileOutputStream(file);
            o.write(bytes);
            o.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static File makeFilename(String name, File dir) {
        int index = name.indexOf(".");
        if (index == -1) {
            return new File(dir, name + ".class");
        }
        return Py.makeFilename(name.substring(index + 1, name.length()), new File(dir, name.substring(0, index)));
    }

    private static boolean abstract_issubclass(PyObject derived, PyObject cls) {
        if (derived == cls) {
            return true;
        }
        PyObject bases = derived.__findattr__("__bases__");
        if (bases == null) {
            return false;
        }
        for (int i = 0; i < bases.__len__(); ++i) {
            if (!Py.abstract_issubclass(bases.__getitem__(i), cls)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstance(PyObject obj, PyObject cls) {
        if (cls instanceof PyType) {
            PyType objtype = obj.getType();
            if (objtype == cls) {
                return true;
            }
            return objtype.isSubType((PyType)cls);
        }
        if (cls instanceof PyClass) {
            if (!(obj instanceof PyInstance)) {
                return false;
            }
            return ((PyClass)obj.fastGetClass()).isSubClass((PyClass)cls);
        }
        if (cls.getClass() == PyTuple.class) {
            for (int i = 0; i < cls.__len__(); ++i) {
                if (!Py.isInstance(obj, cls.__getitem__(i))) continue;
                return true;
            }
            return false;
        }
        if (cls.__findattr__("__bases__") == null) {
            throw Py.TypeError("isinstance() arg 2 must be a class, type, or tuple of classes and types");
        }
        PyObject ocls = obj.__findattr__("__class__");
        if (ocls == null) {
            return false;
        }
        return Py.abstract_issubclass(ocls, cls);
    }

    public static boolean isSubClass(PyObject derived, PyObject cls) {
        if (derived instanceof PyType && cls instanceof PyType) {
            if (derived == cls) {
                return true;
            }
            return ((PyType)derived).isSubType((PyType)cls);
        }
        if (cls instanceof PyClass && derived instanceof PyClass) {
            return ((PyClass)derived).isSubClass((PyClass)cls);
        }
        if (cls.getClass() == PyTuple.class) {
            for (int i = 0; i < cls.__len__(); ++i) {
                if (!Py.isSubClass(derived, cls.__getitem__(i))) continue;
                return true;
            }
            return false;
        }
        if (derived.__findattr__("__bases__") == null) {
            throw Py.TypeError("issubclass() arg 1 must be a class");
        }
        if (cls.__findattr__("__bases__") == null) {
            throw Py.TypeError("issubclass() arg 2 must be a class, type, or tuple of classes and types");
        }
        return Py.abstract_issubclass(derived, cls);
    }

    static PyObject[] make_array(PyObject o) {
        PyObject item;
        if (o instanceof PyTuple) {
            return ((PyTuple)o).getArray();
        }
        PyObject iter = o.__iter__();
        int n = 10;
        try {
            n = o.__len__();
        }
        catch (PyException exc) {
            // empty catch block
        }
        PyObject[] objs = new PyObject[n];
        int i = 0;
        while ((item = iter.__iternext__()) != null) {
            if (i >= n) {
                n = n < 500 ? (n += 10) : (n += 100);
                PyObject[] newobjs = new PyObject[n];
                System.arraycopy(objs, 0, newobjs, 0, objs.length);
                objs = newobjs;
            }
            objs[i] = item;
            ++i;
        }
        if (i < n) {
            PyObject[] newobjs = new PyObject[i];
            System.arraycopy(objs, 0, newobjs, 0, i);
            objs = newobjs;
        }
        return objs;
    }

    static {
        frozenPackage = null;
        PRESENT = new Object();
        integerCache = null;
        secEnv = false;
        propertiesInitialized = false;
        threadStateMapping = null;
        letters = null;
        pyClassCtrSignature = new Class[]{String.class, PyTuple.class, PyObject.class, Class.class};
        CLASS_TYPE = PyType.fromClass(PyClass.class);
        nameindex = 0;
        idimpl = IdImpl.getInstance();
    }

    static class SingletonResolver
    implements Serializable {
        private String which;

        SingletonResolver(String which) {
            this.which = which;
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.which.equals("None")) {
                return None;
            }
            if (this.which.equals("Ellipsis")) {
                return Ellipsis;
            }
            if (this.which.equals("NotImplemented")) {
                return NotImplemented;
            }
            throw new StreamCorruptedException("unknown singleton: " + this.which);
        }
    }
}

