/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.math.BigInteger;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.__builtin__;

public class struct {
    public static PyString error = new PyString("struct.error");
    public static String __doc__ = "Functions to convert between Python values and C structs.\nPython strings are used to hold the data representing the C\nstruct and also as format strings to describe the layout of\ndata in the C struct.\n\nThe optional first format char indicates byte ordering and\nalignment:\n @: native w/native alignment(default)\n =: native w/standard alignment\n <: little-endian, std. alignment\n >: big-endian, std. alignment\n !: network, std (same as >)\n\nThe remaining chars indicate types of args and must match\nexactly; these can be preceded by a decimal repeat count:\n x: pad byte (no data); c:char; b:signed byte; B:unsigned byte;\n h:short; H:unsigned short; i:int; I:unsigned int;\n l:long; L:unsigned long; f:float; d:double.\nSpecial cases (preceding decimal count indicates length):\n s:string (array of char); p: pascal string (w. count byte).\nWhitespace between formats is ignored.\n\nThe variable struct.error is an exception raised on errors.";
    private static FormatDef[] lilendian_table = new FormatDef[]{new PadFormatDef().init('x', 1, 0), new ByteFormatDef().init('b', 1, 0), new UnsignedByteFormatDef().init('B', 1, 0), new CharFormatDef().init('c', 1, 0), new StringFormatDef().init('s', 1, 0), new PascalStringFormatDef().init('p', 1, 0), new LEShortFormatDef().init('h', 2, 0), new LEUnsignedShortFormatDef().init('H', 2, 0), new LEIntFormatDef().init('i', 4, 0), new LEUnsignedIntFormatDef().init('I', 4, 0), new LEIntFormatDef().init('l', 4, 0), new LEUnsignedIntFormatDef().init('L', 4, 0), new LELongFormatDef().init('q', 8, 8), new LEUnsignedLongFormatDef().init('Q', 8, 8), new LEFloatFormatDef().init('f', 4, 0), new LEDoubleFormatDef().init('d', 8, 0)};
    private static FormatDef[] bigendian_table = new FormatDef[]{new PadFormatDef().init('x', 1, 0), new ByteFormatDef().init('b', 1, 0), new UnsignedByteFormatDef().init('B', 1, 0), new CharFormatDef().init('c', 1, 0), new StringFormatDef().init('s', 1, 0), new PascalStringFormatDef().init('p', 1, 0), new BEShortFormatDef().init('h', 2, 0), new BEUnsignedShortFormatDef().init('H', 2, 0), new BEIntFormatDef().init('i', 4, 0), new BEUnsignedIntFormatDef().init('I', 4, 0), new BEIntFormatDef().init('l', 4, 0), new BEUnsignedIntFormatDef().init('L', 4, 0), new BELongFormatDef().init('q', 8, 8), new BEUnsignedLongFormatDef().init('Q', 8, 8), new BEFloatFormatDef().init('f', 4, 0), new BEDoubleFormatDef().init('d', 8, 0)};
    private static FormatDef[] native_table = new FormatDef[]{new PadFormatDef().init('x', 1, 0), new ByteFormatDef().init('b', 1, 0), new UnsignedByteFormatDef().init('B', 1, 0), new CharFormatDef().init('c', 1, 0), new StringFormatDef().init('s', 1, 0), new PascalStringFormatDef().init('p', 1, 0), new BEShortFormatDef().init('h', 2, 2), new BEUnsignedShortFormatDef().init('H', 2, 2), new BEIntFormatDef().init('i', 4, 4), new BEUnsignedIntFormatDef().init('I', 4, 4), new BEIntFormatDef().init('l', 4, 4), new BEUnsignedIntFormatDef().init('L', 4, 4), new BELongFormatDef().init('q', 8, 8), new BEUnsignedLongFormatDef().init('Q', 8, 8), new BEFloatFormatDef().init('f', 4, 4), new BEDoubleFormatDef().init('d', 8, 8)};
    static /* synthetic */ Class class$java$math$BigInteger;

    private static FormatDef[] whichtable(String pfmt) {
        char c = pfmt.charAt(0);
        switch (c) {
            case '<': {
                return lilendian_table;
            }
            case '!': 
            case '>': {
                return bigendian_table;
            }
            case '=': {
                return bigendian_table;
            }
        }
        return native_table;
    }

    private static FormatDef getentry(char c, FormatDef[] f) {
        for (int i = 0; i < f.length; ++i) {
            if (f[i].name != c) continue;
            return f[i];
        }
        throw struct.StructError("bad char in struct format");
    }

    private static int align(int size, FormatDef e) {
        if (e.alignment != 0) {
            size = (size + e.alignment - 1) / e.alignment * e.alignment;
        }
        return size;
    }

    private static int calcsize(String format, FormatDef[] f) {
        int size = 0;
        int len = format.length();
        for (int j = 0; j < len; ++j) {
            char c = format.charAt(j);
            if (j == 0 && (c == '@' || c == '<' || c == '>' || c == '=' || c == '!') || Character.isWhitespace(c)) continue;
            int num = 1;
            if (Character.isDigit(c)) {
                num = Character.digit(c, 10);
                while (++j < len && Character.isDigit(c = format.charAt(j))) {
                    int x = num * 10 + Character.digit(c, 10);
                    if (x / 10 != num) {
                        throw struct.StructError("overflow in item count");
                    }
                    num = x;
                }
                if (j >= len) break;
            }
            FormatDef e = struct.getentry(c, f);
            int itemsize = e.size;
            size = struct.align(size, e);
            int x = num * itemsize;
            if (x / itemsize == num && (size += x) >= 0) continue;
            throw struct.StructError("total struct size too long");
        }
        return size;
    }

    public static int calcsize(String format) {
        FormatDef[] f = struct.whichtable(format);
        return struct.calcsize(format, f);
    }

    public static String pack(PyObject[] args) {
        if (args.length < 1) {
            Py.TypeError("illegal argument type for built-in operation");
        }
        String format = args[0].toString();
        FormatDef[] f = struct.whichtable(format);
        int size = struct.calcsize(format, f);
        ByteStream res = new ByteStream();
        int i = 1;
        int len = format.length();
        for (int j = 0; j < len; ++j) {
            char c = format.charAt(j);
            if (j == 0 && (c == '@' || c == '<' || c == '>' || c == '=' || c == '!') || Character.isWhitespace(c)) continue;
            int num = 1;
            if (Character.isDigit(c)) {
                num = Character.digit(c, 10);
                while (++j < len && Character.isDigit(c = format.charAt(j))) {
                    num = num * 10 + Character.digit(c, 10);
                }
                if (j >= len) break;
            }
            FormatDef e = struct.getentry(c, f);
            int nres = struct.align(res.size(), e) - res.size();
            while (nres-- > 0) {
                res.writeByte(0);
            }
            i += e.doPack(res, num, i, args);
        }
        if (i < args.length) {
            throw struct.StructError("too many arguments for pack format");
        }
        return res.toString();
    }

    public static PyTuple unpack(String format, String string) {
        int len = string.length();
        FormatDef[] f = struct.whichtable(format);
        int size = struct.calcsize(format, f);
        if (size != len) {
            throw struct.StructError("unpack str size does not match format");
        }
        PyList res = new PyList();
        ByteStream str = new ByteStream(string);
        int flen = format.length();
        for (int j = 0; j < flen; ++j) {
            char c = format.charAt(j);
            if (j == 0 && (c == '@' || c == '<' || c == '>' || c == '=' || c == '!') || Character.isWhitespace(c)) continue;
            int num = 1;
            if (Character.isDigit(c)) {
                num = Character.digit(c, 10);
                while (++j < flen && Character.isDigit(c = format.charAt(j))) {
                    num = num * 10 + Character.digit(c, 10);
                }
                if (j > flen) break;
            }
            FormatDef e = struct.getentry(c, f);
            str.skip(struct.align(str.size(), e) - str.size());
            e.doUnpack(str, num, res);
        }
        return __builtin__.tuple(res);
    }

    private static PyException StructError(String explanation) {
        return new PyException((PyObject)error, explanation);
    }

    static class BEDoubleFormatDef
    extends FormatDef {
        BEDoubleFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            long bits = Double.doubleToLongBits(this.get_float(value));
            this.BEwriteInt(buf, (int)(bits >>> 32));
            this.BEwriteInt(buf, (int)(bits & 0xFFFFFFFFFFFFFFFFL));
        }

        Object unpack(ByteStream buf) {
            long bits = ((long)this.BEreadInt(buf) << 32) + ((long)this.BEreadInt(buf) & 0xFFFFFFFFL);
            return Py.newFloat(Double.longBitsToDouble(bits));
        }
    }

    static class BEFloatFormatDef
    extends FormatDef {
        BEFloatFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            int bits = Float.floatToIntBits((float)this.get_float(value));
            this.BEwriteInt(buf, bits);
        }

        Object unpack(ByteStream buf) {
            int v = this.BEreadInt(buf);
            return Py.newFloat(Float.intBitsToFloat(v));
        }
    }

    static class LEDoubleFormatDef
    extends FormatDef {
        LEDoubleFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            long bits = Double.doubleToLongBits(this.get_float(value));
            this.LEwriteInt(buf, (int)(bits & 0xFFFFFFFFFFFFFFFFL));
            this.LEwriteInt(buf, (int)(bits >>> 32));
        }

        Object unpack(ByteStream buf) {
            long bits = ((long)this.LEreadInt(buf) & 0xFFFFFFFFL) + ((long)this.LEreadInt(buf) << 32);
            return Py.newFloat(Double.longBitsToDouble(bits));
        }
    }

    static class LEFloatFormatDef
    extends FormatDef {
        LEFloatFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            int bits = Float.floatToIntBits((float)this.get_float(value));
            this.LEwriteInt(buf, bits);
        }

        Object unpack(ByteStream buf) {
            int v = this.LEreadInt(buf);
            return Py.newFloat(Float.intBitsToFloat(v));
        }
    }

    static class BELongFormatDef
    extends FormatDef {
        BELongFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            long lvalue = this.get_long(value);
            int high = (int)((lvalue & 0xFFFFFFFF00000000L) >> 32);
            int low = (int)(lvalue & 0xFFFFFFFFL);
            this.BEwriteInt(buf, high);
            this.BEwriteInt(buf, low);
        }

        Object unpack(ByteStream buf) {
            long high = (long)this.BEreadInt(buf) << 32 & 0xFFFFFFFF00000000L;
            long low = (long)this.BEreadInt(buf) & 0xFFFFFFFFL;
            long result = high | low;
            return new PyLong(result);
        }
    }

    static class LELongFormatDef
    extends FormatDef {
        LELongFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            long lvalue = this.get_long(value);
            int high = (int)((lvalue & 0xFFFFFFFF00000000L) >> 32);
            int low = (int)(lvalue & 0xFFFFFFFFL);
            this.LEwriteInt(buf, low);
            this.LEwriteInt(buf, high);
        }

        Object unpack(ByteStream buf) {
            long low = (long)this.LEreadInt(buf) & 0xFFFFFFFFL;
            long high = (long)this.LEreadInt(buf) << 32 & 0xFFFFFFFF00000000L;
            long result = high | low;
            return new PyLong(result);
        }
    }

    static class BEUnsignedLongFormatDef
    extends FormatDef {
        BEUnsignedLongFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            BigInteger bi = this.get_ulong(value);
            if (bi.compareTo(BigInteger.valueOf(0L)) < 0) {
                throw struct.StructError("can't convert negative long to unsigned");
            }
            long lvalue = bi.longValue();
            int high = (int)((lvalue & 0xFFFFFFFF00000000L) >> 32);
            int low = (int)(lvalue & 0xFFFFFFFFL);
            this.BEwriteInt(buf, high);
            this.BEwriteInt(buf, low);
        }

        Object unpack(ByteStream buf) {
            long high = (long)this.BEreadInt(buf) & 0xFFFFFFFFL;
            long low = (long)this.BEreadInt(buf) & 0xFFFFFFFFL;
            BigInteger result = BigInteger.valueOf(high);
            result = result.multiply(BigInteger.valueOf(0x100000000L));
            result = result.add(BigInteger.valueOf(low));
            return new PyLong(result);
        }
    }

    static class LEUnsignedLongFormatDef
    extends FormatDef {
        LEUnsignedLongFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            BigInteger bi = this.get_ulong(value);
            if (bi.compareTo(BigInteger.valueOf(0L)) < 0) {
                throw struct.StructError("can't convert negative long to unsigned");
            }
            long lvalue = bi.longValue();
            int high = (int)((lvalue & 0xFFFFFFFF00000000L) >> 32);
            int low = (int)(lvalue & 0xFFFFFFFFL);
            this.LEwriteInt(buf, low);
            this.LEwriteInt(buf, high);
        }

        Object unpack(ByteStream buf) {
            long low = (long)this.LEreadInt(buf) & 0xFFFFFFFFL;
            long high = (long)this.LEreadInt(buf) & 0xFFFFFFFFL;
            BigInteger result = BigInteger.valueOf(high);
            result = result.multiply(BigInteger.valueOf(0x100000000L));
            result = result.add(BigInteger.valueOf(low));
            return new PyLong(result);
        }
    }

    static class BEUnsignedIntFormatDef
    extends FormatDef {
        BEUnsignedIntFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            this.BEwriteInt(buf, (int)(this.get_long(value) & 0xFFFFFFFFFFFFFFFFL));
        }

        Object unpack(ByteStream buf) {
            long v = this.BEreadInt(buf);
            if (v < 0L) {
                v += 0x100000000L;
            }
            return new PyLong(v);
        }
    }

    static class BEIntFormatDef
    extends FormatDef {
        BEIntFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            this.BEwriteInt(buf, this.get_int(value));
        }

        Object unpack(ByteStream buf) {
            return Py.newInteger(this.BEreadInt(buf));
        }
    }

    static class LEUnsignedIntFormatDef
    extends FormatDef {
        LEUnsignedIntFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            this.LEwriteInt(buf, (int)(this.get_long(value) & 0xFFFFFFFFFFFFFFFFL));
        }

        Object unpack(ByteStream buf) {
            long v = this.LEreadInt(buf);
            if (v < 0L) {
                v += 0x100000000L;
            }
            return new PyLong(v);
        }
    }

    static class LEIntFormatDef
    extends FormatDef {
        LEIntFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            this.LEwriteInt(buf, this.get_int(value));
        }

        Object unpack(ByteStream buf) {
            int v = this.LEreadInt(buf);
            return Py.newInteger(v);
        }
    }

    static class BEUnsignedShortFormatDef
    extends BEShortFormatDef {
        BEUnsignedShortFormatDef() {
        }

        Object unpack(ByteStream buf) {
            int v = buf.readByte() << 8 | buf.readByte();
            return Py.newInteger(v);
        }
    }

    static class BEShortFormatDef
    extends FormatDef {
        BEShortFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            int v = this.get_int(value);
            buf.writeByte(v >> 8 & 0xFF);
            buf.writeByte(v & 0xFF);
        }

        Object unpack(ByteStream buf) {
            int v = buf.readByte() << 8 | buf.readByte();
            if (v > Short.MAX_VALUE) {
                v -= 65536;
            }
            return Py.newInteger(v);
        }
    }

    static class LEUnsignedShortFormatDef
    extends LEShortFormatDef {
        LEUnsignedShortFormatDef() {
        }

        Object unpack(ByteStream buf) {
            int v = buf.readByte() | buf.readByte() << 8;
            return Py.newInteger(v);
        }
    }

    static class LEShortFormatDef
    extends FormatDef {
        LEShortFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            int v = this.get_int(value);
            buf.writeByte(v & 0xFF);
            buf.writeByte(v >> 8 & 0xFF);
        }

        Object unpack(ByteStream buf) {
            int v = buf.readByte() | buf.readByte() << 8;
            if (v > Short.MAX_VALUE) {
                v -= 65536;
            }
            return Py.newInteger(v);
        }
    }

    static class UnsignedByteFormatDef
    extends ByteFormatDef {
        UnsignedByteFormatDef() {
        }

        Object unpack(ByteStream buf) {
            return Py.newInteger(buf.readByte());
        }
    }

    static class ByteFormatDef
    extends FormatDef {
        ByteFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            buf.writeByte(this.get_int(value));
        }

        Object unpack(ByteStream buf) {
            int b = buf.readByte();
            if (b > 127) {
                b -= 256;
            }
            return Py.newInteger(b);
        }
    }

    static class CharFormatDef
    extends FormatDef {
        CharFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            if (!(value instanceof PyString) || value.__len__() != 1) {
                throw struct.StructError("char format require string of length 1");
            }
            buf.writeByte(value.toString().charAt(0));
        }

        Object unpack(ByteStream buf) {
            return Py.newString((char)buf.readByte());
        }
    }

    static class PascalStringFormatDef
    extends StringFormatDef {
        PascalStringFormatDef() {
        }

        int doPack(ByteStream buf, int count, int pos, PyObject[] args) {
            PyObject value = args[pos];
            if (!(value instanceof PyString)) {
                throw struct.StructError("argument for 'p' must be a string");
            }
            buf.writeByte(Math.min(255, Math.min(value.toString().length(), count - 1)));
            return super.doPack(buf, count - 1, pos, args);
        }

        void doUnpack(ByteStream buf, int count, PyList list) {
            int n = buf.readByte();
            if (n >= count) {
                n = count - 1;
            }
            super.doUnpack(buf, n, list);
            buf.skip(Math.max(count - n - 1, 0));
        }
    }

    static class StringFormatDef
    extends FormatDef {
        StringFormatDef() {
        }

        int doPack(ByteStream buf, int count, int pos, PyObject[] args) {
            PyObject value = args[pos];
            if (!(value instanceof PyString)) {
                throw struct.StructError("argument for 's' must be a string");
            }
            String s = value.toString();
            int len = s.length();
            buf.writeString(s, 0, Math.min(count, len));
            if (len < count) {
                count -= len;
                for (int i = 0; i < count; ++i) {
                    buf.writeByte(0);
                }
            }
            return 1;
        }

        void doUnpack(ByteStream buf, int count, PyList list) {
            list.append(Py.newString(buf.readString(count)));
        }
    }

    static class PadFormatDef
    extends FormatDef {
        PadFormatDef() {
        }

        int doPack(ByteStream buf, int count, int pos, PyObject[] args) {
            while (count-- > 0) {
                buf.writeByte(0);
            }
            return 0;
        }

        void doUnpack(ByteStream buf, int count, PyList list) {
            while (count-- > 0) {
                buf.readByte();
            }
        }
    }

    static class ByteStream {
        char[] data;
        int len;
        int pos;

        ByteStream() {
            this.data = new char[10];
            this.len = 0;
            this.pos = 0;
        }

        ByteStream(String s) {
            int l = s.length();
            this.data = new char[l];
            s.getChars(0, l, this.data, 0);
            this.len = l;
            this.pos = 0;
        }

        int readByte() {
            return this.data[this.pos++] & 0xFF;
        }

        void read(char[] buf, int pos, int len) {
            System.arraycopy(this.data, this.pos, buf, pos, len);
            this.pos += len;
        }

        String readString(int l) {
            char[] data = new char[l];
            this.read(data, 0, l);
            return new String(data);
        }

        private void ensureCapacity(int l) {
            if (this.pos + l >= this.data.length) {
                char[] b = new char[(this.pos + l) * 2];
                System.arraycopy(this.data, 0, b, 0, this.pos);
                this.data = b;
            }
        }

        void writeByte(int b) {
            this.ensureCapacity(1);
            this.data[this.pos++] = (char)(b & 0xFF);
        }

        void write(char[] buf, int pos, int len) {
            this.ensureCapacity(len);
            System.arraycopy(buf, pos, this.data, this.pos, len);
            this.pos += len;
        }

        void writeString(String s, int pos, int len) {
            char[] data = new char[len];
            s.getChars(pos, len, data, 0);
            this.write(data, 0, len);
        }

        int skip(int l) {
            this.pos += l;
            return this.pos;
        }

        int size() {
            return this.pos;
        }

        public String toString() {
            return new String(this.data, 0, this.pos);
        }
    }

    static class FormatDef {
        char name;
        int size;
        int alignment;

        FormatDef() {
        }

        FormatDef init(char name, int size, int alignment) {
            this.name = name;
            this.size = size;
            this.alignment = alignment;
            return this;
        }

        void pack(ByteStream buf, PyObject value) {
        }

        Object unpack(ByteStream buf) {
            return null;
        }

        int doPack(ByteStream buf, int count, int pos, PyObject[] args) {
            if (pos + count > args.length) {
                throw struct.StructError("insufficient arguments to pack");
            }
            int cnt = count;
            while (count-- > 0) {
                this.pack(buf, args[pos++]);
            }
            return cnt;
        }

        void doUnpack(ByteStream buf, int count, PyList list) {
            while (count-- > 0) {
                list.append(Py.java2py(this.unpack(buf)));
            }
        }

        int get_int(PyObject value) {
            try {
                return ((PyInteger)value.__int__()).getValue();
            }
            catch (PyException ex) {
                throw struct.StructError("required argument is not an integer");
            }
        }

        long get_long(PyObject value) {
            if (value instanceof PyLong) {
                Object v = value.__tojava__(Long.TYPE);
                if (v == Py.NoConversion) {
                    throw Py.OverflowError("long int too long to convert");
                }
                return (Long)v;
            }
            return this.get_int(value);
        }

        BigInteger get_ulong(PyObject value) {
            if (value instanceof PyLong) {
                BigInteger v = (BigInteger)value.__tojava__(class$java$math$BigInteger == null ? (class$java$math$BigInteger = struct.class$("java.math.BigInteger")) : class$java$math$BigInteger);
                if (v.compareTo(PyLong.maxULong) > 0) {
                    throw Py.OverflowError("unsigned long int too long to convert");
                }
                return v;
            }
            return BigInteger.valueOf(this.get_int(value));
        }

        double get_float(PyObject value) {
            if (!(value instanceof PyFloat)) {
                throw struct.StructError("required argument is not an float");
            }
            return value.__float__().getValue();
        }

        void BEwriteInt(ByteStream buf, int v) {
            buf.writeByte(v >>> 24 & 0xFF);
            buf.writeByte(v >>> 16 & 0xFF);
            buf.writeByte(v >>> 8 & 0xFF);
            buf.writeByte(v >>> 0 & 0xFF);
        }

        void LEwriteInt(ByteStream buf, int v) {
            buf.writeByte(v >>> 0 & 0xFF);
            buf.writeByte(v >>> 8 & 0xFF);
            buf.writeByte(v >>> 16 & 0xFF);
            buf.writeByte(v >>> 24 & 0xFF);
        }

        int BEreadInt(ByteStream buf) {
            int b1 = buf.readByte();
            int b2 = buf.readByte();
            int b3 = buf.readByte();
            int b4 = buf.readByte();
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
        }

        int LEreadInt(ByteStream buf) {
            int b1 = buf.readByte();
            int b2 = buf.readByte();
            int b3 = buf.readByte();
            int b4 = buf.readByte();
            return (b1 << 0) + (b2 << 8) + (b3 << 16) + (b4 << 24);
        }
    }
}

