/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.exif.CanonMakernoteDirectory;
import com.drew.metadata.exif.CasioType1MakernoteDirectory;
import com.drew.metadata.exif.CasioType2MakernoteDirectory;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifInteropDirectory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import com.drew.metadata.exif.FujifilmMakernoteDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.exif.KodakMakernoteDirectory;
import com.drew.metadata.exif.KyoceraMakernoteDirectory;
import com.drew.metadata.exif.NikonType1MakernoteDirectory;
import com.drew.metadata.exif.NikonType2MakernoteDirectory;
import com.drew.metadata.exif.OlympusMakernoteDirectory;
import com.drew.metadata.exif.PanasonicMakernoteDirectory;
import com.drew.metadata.exif.PentaxMakernoteDirectory;
import com.drew.metadata.exif.SigmaMakernoteDirectory;
import com.drew.metadata.exif.SonyType1MakernoteDirectory;
import com.drew.metadata.exif.SonyType6MakernoteDirectory;
import java.util.HashSet;
import java.util.Set;

public class ExifReader
implements MetadataReader {
    @NotNull
    private static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int MAX_FORMAT_CODE = 12;
    private static final int FMT_BYTE = 1;
    private static final int FMT_STRING = 2;
    private static final int FMT_USHORT = 3;
    private static final int FMT_ULONG = 4;
    private static final int FMT_URATIONAL = 5;
    private static final int FMT_SBYTE = 6;
    private static final int FMT_UNDEFINED = 7;
    private static final int FMT_SSHORT = 8;
    private static final int FMT_SLONG = 9;
    private static final int FMT_SRATIONAL = 10;
    private static final int FMT_SINGLE = 11;
    private static final int FMT_DOUBLE = 12;
    public static final int TAG_EXIF_SUB_IFD_OFFSET = 34665;
    public static final int TAG_INTEROP_OFFSET = 40965;
    public static final int TAG_GPS_INFO_OFFSET = 34853;
    public static final int TAG_MAKER_NOTE_OFFSET = 37500;
    public static final int TIFF_HEADER_START_OFFSET = 6;

    @Override
    public void extract(@NotNull BufferReader bufferReader, @NotNull Metadata metadata) {
        ExifSubIFDDirectory exifSubIFDDirectory = metadata.getOrCreateDirectory(ExifSubIFDDirectory.class);
        if (bufferReader.getLength() <= 14L) {
            exifSubIFDDirectory.addError("Exif data segment must contain at least 14 bytes");
            return;
        }
        try {
            if (!bufferReader.getString(0, 6).equals("Exif\u0000\u0000")) {
                exifSubIFDDirectory.addError("Exif data segment doesn't begin with 'Exif'");
                return;
            }
            this.extractIFD(metadata, metadata.getOrCreateDirectory(ExifIFD0Directory.class), 6, bufferReader);
        }
        catch (BufferBoundsException bufferBoundsException) {
            exifSubIFDDirectory.addError("Exif data segment ended prematurely");
        }
    }

    public void extractTiff(@NotNull BufferReader bufferReader, @NotNull Metadata metadata) {
        ExifIFD0Directory exifIFD0Directory = metadata.getOrCreateDirectory(ExifIFD0Directory.class);
        try {
            this.extractIFD(metadata, exifIFD0Directory, 0, bufferReader);
        }
        catch (BufferBoundsException bufferBoundsException) {
            exifIFD0Directory.addError("Exif data segment ended prematurely");
        }
    }

    private void extractIFD(@NotNull Metadata metadata, @NotNull ExifIFD0Directory exifIFD0Directory, int n, @NotNull BufferReader bufferReader) throws BufferBoundsException {
        String string = bufferReader.getString(n, 2);
        if ("MM".equals(string)) {
            bufferReader.setMotorolaByteOrder(true);
        } else if ("II".equals(string)) {
            bufferReader.setMotorolaByteOrder(false);
        } else {
            exifIFD0Directory.addError("Unclear distinction between Motorola/Intel byte ordering: " + string);
            return;
        }
        int n2 = bufferReader.getUInt16(2 + n);
        if (n2 != 42 && n2 != 20306 && n2 != 85) {
            exifIFD0Directory.addError("Unexpected TIFF marker after byte order identifier: 0x" + Integer.toHexString(n2));
            return;
        }
        int n3 = bufferReader.getInt32(4 + n) + n;
        if ((long)n3 >= bufferReader.getLength() - 1L) {
            exifIFD0Directory.addError("First exif directory offset is beyond end of Exif data segment");
            n3 = 14;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        this.processDirectory(exifIFD0Directory, hashSet, n3, n, metadata, bufferReader);
        ExifThumbnailDirectory exifThumbnailDirectory = metadata.getDirectory(ExifThumbnailDirectory.class);
        if (exifThumbnailDirectory != null && exifThumbnailDirectory.containsTag(259)) {
            Integer n4 = exifThumbnailDirectory.getInteger(513);
            Integer n5 = exifThumbnailDirectory.getInteger(514);
            if (n4 != null && n5 != null) {
                try {
                    byte[] byArray = bufferReader.getBytes(n + n4, n5);
                    exifThumbnailDirectory.setThumbnailData(byArray);
                }
                catch (BufferBoundsException bufferBoundsException) {
                    exifIFD0Directory.addError("Invalid thumbnail data specification: " + bufferBoundsException.getMessage());
                }
            }
        }
    }

    private void processDirectory(@NotNull Directory directory, @NotNull Set<Integer> set, int n, int n2, @NotNull Metadata metadata, @NotNull BufferReader bufferReader) throws BufferBoundsException {
        int n3;
        int n4;
        if (set.contains(n)) {
            return;
        }
        set.add(n);
        if ((long)n >= bufferReader.getLength() || n < 0) {
            directory.addError("Ignored directory marked to start outside data segment");
            return;
        }
        int n5 = bufferReader.getUInt16(n);
        int n6 = 2 + 12 * n5 + 4;
        if ((long)(n6 + n) > bufferReader.getLength()) {
            directory.addError("Illegally sized directory");
            return;
        }
        block6: for (n4 = 0; n4 < n5; ++n4) {
            int n7;
            int n8;
            n3 = this.calculateTagOffset(n, n4);
            int n9 = bufferReader.getUInt16(n3);
            int n10 = bufferReader.getUInt16(n3 + 2);
            if (n10 < 1 || n10 > 12) {
                directory.addError("Invalid TIFF tag format code: " + n10);
                return;
            }
            int n11 = bufferReader.getInt32(n3 + 4);
            if (n11 < 0) {
                directory.addError("Negative TIFF tag component count");
                continue;
            }
            int n12 = n11 * BYTES_PER_FORMAT[n10];
            if (n12 > 4) {
                n8 = bufferReader.getInt32(n3 + 8);
                if ((long)(n8 + n12) > bufferReader.getLength()) {
                    directory.addError("Illegal TIFF tag pointer offset");
                    continue;
                }
                n7 = n2 + n8;
            } else {
                n7 = n3 + 8;
            }
            if (n7 < 0 || (long)n7 > bufferReader.getLength()) {
                directory.addError("Illegal TIFF tag pointer offset");
                continue;
            }
            if (n12 < 0 || (long)(n7 + n12) > bufferReader.getLength()) {
                directory.addError("Illegal number of bytes: " + n12);
                continue;
            }
            switch (n9) {
                case 34665: {
                    n8 = n2 + bufferReader.getInt32(n7);
                    this.processDirectory(metadata.getOrCreateDirectory(ExifSubIFDDirectory.class), set, n8, n2, metadata, bufferReader);
                    continue block6;
                }
                case 40965: {
                    n8 = n2 + bufferReader.getInt32(n7);
                    this.processDirectory(metadata.getOrCreateDirectory(ExifInteropDirectory.class), set, n8, n2, metadata, bufferReader);
                    continue block6;
                }
                case 34853: {
                    n8 = n2 + bufferReader.getInt32(n7);
                    this.processDirectory(metadata.getOrCreateDirectory(GpsDirectory.class), set, n8, n2, metadata, bufferReader);
                    continue block6;
                }
                case 37500: {
                    this.processMakerNote(n7, set, n2, metadata, bufferReader);
                    continue block6;
                }
                default: {
                    this.processTag(directory, n9, n7, n11, n10, bufferReader);
                }
            }
        }
        n4 = this.calculateTagOffset(n, n5);
        n3 = bufferReader.getInt32(n4);
        if (n3 != 0) {
            if ((long)(n3 += n2) >= bufferReader.getLength()) {
                return;
            }
            if (n3 < n) {
                return;
            }
            ExifThumbnailDirectory exifThumbnailDirectory = metadata.getOrCreateDirectory(ExifThumbnailDirectory.class);
            this.processDirectory(exifThumbnailDirectory, set, n3, n2, metadata, bufferReader);
        }
    }

    private void processMakerNote(int n, @NotNull Set<Integer> set, int n2, @NotNull Metadata metadata, @NotNull BufferReader bufferReader) throws BufferBoundsException {
        ExifIFD0Directory exifIFD0Directory = metadata.getDirectory(ExifIFD0Directory.class);
        if (exifIFD0Directory == null) {
            return;
        }
        String string = exifIFD0Directory.getString(271);
        String string2 = bufferReader.getString(n, 3);
        String string3 = bufferReader.getString(n, 4);
        String string4 = bufferReader.getString(n, 5);
        String string5 = bufferReader.getString(n, 6);
        String string6 = bufferReader.getString(n, 7);
        String string7 = bufferReader.getString(n, 8);
        String string8 = bufferReader.getString(n, 12);
        if ("OLYMP".equals(string4) || "EPSON".equals(string4) || "AGFA".equals(string3)) {
            this.processDirectory(metadata.getOrCreateDirectory(OlympusMakernoteDirectory.class), set, n + 8, n2, metadata, bufferReader);
        } else if (string != null && string.trim().toUpperCase().startsWith("NIKON")) {
            if ("Nikon".equals(string4)) {
                switch (bufferReader.getUInt8(n + 6)) {
                    case 1: {
                        this.processDirectory(metadata.getOrCreateDirectory(NikonType1MakernoteDirectory.class), set, n + 8, n2, metadata, bufferReader);
                        break;
                    }
                    case 2: {
                        this.processDirectory(metadata.getOrCreateDirectory(NikonType2MakernoteDirectory.class), set, n + 18, n + 10, metadata, bufferReader);
                        break;
                    }
                    default: {
                        exifIFD0Directory.addError("Unsupported Nikon makernote data ignored.");
                        break;
                    }
                }
            } else {
                this.processDirectory(metadata.getOrCreateDirectory(NikonType2MakernoteDirectory.class), set, n, n2, metadata, bufferReader);
            }
        } else if ("SONY CAM".equals(string7) || "SONY DSC".equals(string7)) {
            this.processDirectory(metadata.getOrCreateDirectory(SonyType1MakernoteDirectory.class), set, n + 12, n2, metadata, bufferReader);
        } else if ("SIGMA\u0000\u0000\u0000".equals(string7) || "FOVEON\u0000\u0000".equals(string7)) {
            this.processDirectory(metadata.getOrCreateDirectory(SigmaMakernoteDirectory.class), set, n + 10, n2, metadata, bufferReader);
        } else if ("SEMC MS\u0000\u0000\u0000\u0000\u0000".equals(string8)) {
            boolean bl = bufferReader.isMotorolaByteOrder();
            bufferReader.setMotorolaByteOrder(true);
            this.processDirectory(metadata.getOrCreateDirectory(SonyType6MakernoteDirectory.class), set, n + 20, n2, metadata, bufferReader);
            bufferReader.setMotorolaByteOrder(bl);
        } else if ("KDK".equals(string2)) {
            this.processDirectory(metadata.getOrCreateDirectory(KodakMakernoteDirectory.class), set, n + 20, n2, metadata, bufferReader);
        } else if ("Canon".equalsIgnoreCase(string)) {
            this.processDirectory(metadata.getOrCreateDirectory(CanonMakernoteDirectory.class), set, n, n2, metadata, bufferReader);
        } else if (string != null && string.toUpperCase().startsWith("CASIO")) {
            if ("QVC\u0000\u0000\u0000".equals(string5)) {
                this.processDirectory(metadata.getOrCreateDirectory(CasioType2MakernoteDirectory.class), set, n + 6, n2, metadata, bufferReader);
            } else {
                this.processDirectory(metadata.getOrCreateDirectory(CasioType1MakernoteDirectory.class), set, n, n2, metadata, bufferReader);
            }
        } else if ("FUJIFILM".equals(string7) || "Fujifilm".equalsIgnoreCase(string)) {
            boolean bl = bufferReader.isMotorolaByteOrder();
            bufferReader.setMotorolaByteOrder(false);
            int n3 = n + bufferReader.getInt32(n + 8);
            this.processDirectory(metadata.getOrCreateDirectory(FujifilmMakernoteDirectory.class), set, n3, n2, metadata, bufferReader);
            bufferReader.setMotorolaByteOrder(bl);
        } else if (string != null && string.toUpperCase().startsWith("MINOLTA")) {
            this.processDirectory(metadata.getOrCreateDirectory(OlympusMakernoteDirectory.class), set, n, n2, metadata, bufferReader);
        } else if ("KYOCERA".equals(string6)) {
            this.processDirectory(metadata.getOrCreateDirectory(KyoceraMakernoteDirectory.class), set, n + 22, n2, metadata, bufferReader);
        } else if ("Panasonic\u0000\u0000\u0000".equals(bufferReader.getString(n, 12))) {
            this.processDirectory(metadata.getOrCreateDirectory(PanasonicMakernoteDirectory.class), set, n + 12, n2, metadata, bufferReader);
        } else if ("AOC\u0000".equals(string3)) {
            this.processDirectory(metadata.getOrCreateDirectory(CasioType2MakernoteDirectory.class), set, n + 6, n, metadata, bufferReader);
        } else if (string != null && (string.toUpperCase().startsWith("PENTAX") || string.toUpperCase().startsWith("ASAHI"))) {
            this.processDirectory(metadata.getOrCreateDirectory(PentaxMakernoteDirectory.class), set, n, n, metadata, bufferReader);
        }
    }

    private void processTag(@NotNull Directory directory, int n, int n2, int n3, int n4, @NotNull BufferReader bufferReader) throws BufferBoundsException {
        switch (n4) {
            case 7: {
                directory.setByteArray(n, bufferReader.getBytes(n2, n3));
                break;
            }
            case 2: {
                String string = bufferReader.getNullTerminatedString(n2, n3);
                directory.setString(n, string);
                break;
            }
            case 10: {
                if (n3 == 1) {
                    directory.setRational(n, new Rational(bufferReader.getInt32(n2), bufferReader.getInt32(n2 + 4)));
                    break;
                }
                if (n3 <= 1) break;
                Rational[] rationalArray = new Rational[n3];
                for (int i = 0; i < n3; ++i) {
                    rationalArray[i] = new Rational(bufferReader.getInt32(n2 + 8 * i), bufferReader.getInt32(n2 + 4 + 8 * i));
                }
                directory.setRationalArray(n, rationalArray);
                break;
            }
            case 5: {
                if (n3 == 1) {
                    directory.setRational(n, new Rational(bufferReader.getUInt32(n2), bufferReader.getUInt32(n2 + 4)));
                    break;
                }
                if (n3 <= 1) break;
                Rational[] rationalArray = new Rational[n3];
                for (int i = 0; i < n3; ++i) {
                    rationalArray[i] = new Rational(bufferReader.getUInt32(n2 + 8 * i), bufferReader.getUInt32(n2 + 4 + 8 * i));
                }
                directory.setRationalArray(n, rationalArray);
                break;
            }
            case 11: {
                if (n3 == 1) {
                    directory.setFloat(n, bufferReader.getFloat32(n2));
                    break;
                }
                float[] fArray = new float[n3];
                for (int i = 0; i < n3; ++i) {
                    fArray[i] = bufferReader.getFloat32(n2 + i * 4);
                }
                directory.setFloatArray(n, fArray);
                break;
            }
            case 12: {
                if (n3 == 1) {
                    directory.setDouble(n, bufferReader.getDouble64(n2));
                    break;
                }
                double[] dArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    dArray[i] = bufferReader.getDouble64(n2 + i * 4);
                }
                directory.setDoubleArray(n, dArray);
                break;
            }
            case 6: {
                if (n3 == 1) {
                    directory.setInt(n, bufferReader.getInt8(n2));
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = bufferReader.getInt8(n2 + i);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 1: {
                if (n3 == 1) {
                    directory.setInt(n, bufferReader.getUInt8(n2));
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = bufferReader.getUInt8(n2 + i);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 3: {
                if (n3 == 1) {
                    int n5 = bufferReader.getUInt16(n2);
                    directory.setInt(n, n5);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = bufferReader.getUInt16(n2 + i * 2);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 8: {
                if (n3 == 1) {
                    short s = bufferReader.getInt16(n2);
                    directory.setInt(n, s);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = bufferReader.getInt16(n2 + i * 2);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 4: 
            case 9: {
                if (n3 == 1) {
                    int n6 = bufferReader.getInt32(n2);
                    directory.setInt(n, n6);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = bufferReader.getInt32(n2 + i * 4);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            default: {
                directory.addError("Unknown format code " + n4 + " for tag " + n);
            }
        }
    }

    private int calculateTagOffset(int n, int n2) {
        return n + 2 + 12 * n2;
    }
}

