/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.util.Map;
import java.util.ServiceLoader;
import ucar.nc2.filter.Filter;
import ucar.nc2.filter.FilterProvider;
import ucar.nc2.filter.UnknownFilterException;

public class Filters {
    private static NullFilter nullFilter = new NullFilter();

    public static Filter getFilterByName(Map<String, Object> properties) throws UnknownFilterException {
        if (properties == null) {
            return nullFilter;
        }
        String name = (String)properties.get("id");
        if (name == null || name.isEmpty()) {
            return nullFilter;
        }
        for (FilterProvider fp : ServiceLoader.load(FilterProvider.class)) {
            if (!fp.canProvide(name)) continue;
            return fp.create(properties);
        }
        throw new UnknownFilterException(name);
    }

    private static class NullFilter
    extends Filter {
        private NullFilter() {
        }

        @Override
        public byte[] encode(byte[] dataIn) {
            return dataIn;
        }

        @Override
        public byte[] decode(byte[] dataIn) {
            return dataIn;
        }
    }
}

