/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.grib.coord.Coordinate;

public class CoordinateSharerBest {
    private Map<Coordinate, Coordinate> runtimeBuilders = new HashMap<Coordinate, Coordinate>();
    private Map<Coordinate, Coordinate> timeBuilders = new HashMap<Coordinate, Coordinate>();
    private Map<Coordinate, Coordinate> timeIntvBuilders = new HashMap<Coordinate, Coordinate>();
    private Map<Coordinate, Coordinate> vertBuilders = new HashMap<Coordinate, Coordinate>();
    private Map<Coordinate, Coordinate> ensBuilders = new HashMap<Coordinate, Coordinate>();
    private Map<Coordinate, Coordinate> time2DBuilders = new HashMap<Coordinate, Coordinate>();
    private Map<Coordinate, Coordinate> swap = new HashMap<Coordinate, Coordinate>();
    private Map<Coordinate, Integer> indexMap;

    public void addCoordinates(List<Coordinate> coords) {
        for (Coordinate coord : coords) {
            this.addCoordinate(coord);
        }
    }

    public void addCoordinate(Coordinate coord) {
        switch (coord.getType()) {
            case runtime: {
                Coordinate already = this.runtimeBuilders.get(coord);
                if (already == null) {
                    this.runtimeBuilders.put(coord, coord);
                    break;
                }
                this.swap.put(coord, already);
                break;
            }
            case time: {
                Coordinate already = this.timeBuilders.get(coord);
                if (already == null) {
                    this.timeBuilders.put(coord, coord);
                    break;
                }
                this.swap.put(coord, already);
                break;
            }
            case timeIntv: {
                Coordinate already = this.timeIntvBuilders.get(coord);
                if (already == null) {
                    this.timeIntvBuilders.put(coord, coord);
                    break;
                }
                this.swap.put(coord, already);
                break;
            }
            case time2D: {
                Coordinate already = this.time2DBuilders.get(coord);
                if (already == null) {
                    this.time2DBuilders.put(coord, coord);
                    break;
                }
                this.swap.put(coord, already);
                break;
            }
            case vert: {
                Coordinate already = this.vertBuilders.get(coord);
                if (already == null) {
                    this.vertBuilders.put(coord, coord);
                    break;
                }
                this.swap.put(coord, already);
                break;
            }
            case ens: {
                Coordinate already = this.ensBuilders.get(coord);
                if (already == null) {
                    this.ensBuilders.put(coord, coord);
                    break;
                }
                this.swap.put(coord, already);
            }
        }
    }

    public List<Coordinate> finish() {
        ArrayList<Coordinate> unionCoords = new ArrayList<Coordinate>(20);
        unionCoords.addAll(this.runtimeBuilders.keySet());
        unionCoords.addAll(this.time2DBuilders.keySet());
        unionCoords.addAll(this.timeBuilders.keySet());
        unionCoords.addAll(this.timeIntvBuilders.keySet());
        unionCoords.addAll(this.vertBuilders.keySet());
        unionCoords.addAll(this.ensBuilders.keySet());
        this.indexMap = new HashMap<Coordinate, Integer>();
        for (int i = 0; i < unionCoords.size(); ++i) {
            this.indexMap.put((Coordinate)unionCoords.get(i), i);
        }
        return unionCoords;
    }

    public List<Integer> reindex(List<Coordinate> coords) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Coordinate coord : coords) {
            Coordinate sub = this.swap.get(coord);
            Coordinate use = sub == null ? coord : sub;
            Integer idx = this.indexMap.get(use);
            if (idx == null) {
                throw new IllegalStateException();
            }
            result.add(idx);
        }
        return result;
    }
}

