/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateBuilderImpl;
import ucar.nc2.grib.coord.CoordinateRuntime;
import ucar.nc2.grib.coord.CoordinateTime;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.nc2.grib.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.coord.CoordinateTimeIntv;
import ucar.nc2.grib.coord.TimeCoordIntvValue;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;

class CoordinateTime2DUnionizer<T>
extends CoordinateBuilderImpl<T> {
    private boolean isTimeInterval;
    private boolean makeVals;
    private CalendarPeriod timeUnit;
    private int code;
    Logger logger;
    private SortedMap<Long, CoordinateTimeAbstract> timeMap = new TreeMap<Long, CoordinateTimeAbstract>();

    CoordinateTime2DUnionizer(boolean isTimeInterval, CalendarPeriod timeUnit, int code, boolean makeVals, Logger logger) {
        this.isTimeInterval = isTimeInterval;
        this.timeUnit = timeUnit;
        this.code = code;
        this.makeVals = makeVals;
        this.logger = logger != null ? logger : LoggerFactory.getLogger(CoordinateTime2DUnionizer.class);
    }

    @Override
    public void addAll(Coordinate coord) {
        CoordinateTime2D coordT2D = (CoordinateTime2D)coord;
        for (int runIdx = 0; runIdx < coordT2D.getNruns(); ++runIdx) {
            CoordinateTimeAbstract times = coordT2D.getTimeCoordinate(runIdx);
            long runtime = coordT2D.getRuntime(runIdx);
            this.timeMap.put(runtime, times);
        }
    }

    @Override
    public Object extract(T gr) {
        throw new RuntimeException();
    }

    void setRuntimeCoords(CoordinateRuntime runtimes) {
        for (int idx = 0; idx < runtimes.getSize(); ++idx) {
            CalendarDate cd2 = runtimes.getRuntimeDate(idx);
            long runtime = runtimes.getRuntime(idx);
            CoordinateTimeAbstract time = (CoordinateTimeAbstract)this.timeMap.get(runtime);
            if (time != null) continue;
            time = this.isTimeInterval ? new CoordinateTimeIntv(this.code, this.timeUnit, cd2, new ArrayList<TimeCoordIntvValue>(0), null) : new CoordinateTime(this.code, this.timeUnit, cd2, new ArrayList<Integer>(0), null);
            this.timeMap.put(runtime, time);
        }
    }

    @Override
    public Coordinate makeCoordinate(List<Object> values) {
        ArrayList<Long> runtimes = new ArrayList<Long>();
        ArrayList<Coordinate> times = new ArrayList<Coordinate>();
        ArrayList<CoordinateTime2D.Time2D> allVals = new ArrayList<CoordinateTime2D.Time2D>();
        for (long runtime : this.timeMap.keySet()) {
            runtimes.add(runtime);
            CoordinateTimeAbstract time = (CoordinateTimeAbstract)this.timeMap.get(runtime);
            times.add(time);
            if (!this.makeVals) continue;
            CalendarDate cd2 = CalendarDate.of(runtime);
            for (Object timeVal : time.getValues()) {
                allVals.add(this.isTimeInterval ? new CoordinateTime2D.Time2D(cd2, null, (TimeCoordIntvValue)timeVal) : new CoordinateTime2D.Time2D(cd2, (Integer)timeVal, null));
            }
        }
        Collections.sort(allVals);
        CoordinateRuntime runtime = new CoordinateRuntime(runtimes, this.timeUnit);
        CoordinateTimeAbstract maxCoord = CoordinateTime2DUnionizer.testOrthogonal(this.timeMap.values());
        if (maxCoord != null) {
            return new CoordinateTime2D(this.code, this.timeUnit, allVals, runtime, maxCoord, times, null);
        }
        List<Coordinate> regCoords = this.testIsRegular();
        if (!regCoords.isEmpty()) {
            return new CoordinateTime2D(this.code, this.timeUnit, allVals, runtime, regCoords, times, null);
        }
        return new CoordinateTime2D(this.code, this.timeUnit, allVals, runtime, times, null);
    }

    private List<Coordinate> testIsRegular() {
        TreeMap<Integer, List> hourMap = new TreeMap<Integer, List>();
        for (CoordinateTimeAbstract coord : this.timeMap.values()) {
            CalendarDate runDate = coord.getRefDate();
            int hour = runDate.getHourOfDay();
            List hg = hourMap.computeIfAbsent(hour, k -> new ArrayList());
            hg.add(coord);
        }
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        Iterator iterator = hourMap.keySet().iterator();
        while (iterator.hasNext()) {
            int hour = (Integer)iterator.next();
            List hg = (List)hourMap.get(hour);
            CoordinateTimeAbstract maxCoord = CoordinateTime2DUnionizer.testOrthogonal(hg);
            if (maxCoord == null) {
                return ImmutableList.of();
            }
            result.add(maxCoord);
        }
        return result;
    }

    @Nullable
    static CoordinateTimeAbstract testOrthogonal(Collection<CoordinateTimeAbstract> times) {
        CoordinateTimeAbstract maxCoord = null;
        HashSet result = new HashSet(100);
        int max = 0;
        for (CoordinateTimeAbstract coord : times) {
            if (max < coord.getSize()) {
                maxCoord = coord;
                max = coord.getSize();
            }
            result.addAll(coord.getValues());
        }
        int totalMax = result.size();
        return totalMax == max ? maxCoord : null;
    }
}

