/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import ucar.nc2.grib.grib1.Grib1Gds;

public class Grib1GdsPredefined {
    public static Grib1Gds factory(int center, int gridNumber) {
        if (center == 7) {
            return Grib1GdsPredefined.factoryNCEP(gridNumber);
        }
        throw new IllegalArgumentException("Dont have predefined GDS " + gridNumber + " from " + center);
    }

    private static Grib1Gds factoryNCEP(int gridNumber) {
        switch (gridNumber) {
            case 21: {
                return new NcepLatLon(gridNumber, 37, 36, 0.0f, 0.0f, 90.0f, 180.0f, 5.0f, 2.5f, -120, 64);
            }
            case 22: {
                return new NcepLatLon(gridNumber, 37, 36, 0.0f, -180.0f, 90.0f, 0.0f, 5.0f, 2.5f, -120, 64);
            }
            case 23: {
                return new NcepLatLon(gridNumber, 37, 36, -90.0f, 0.0f, 180.0f, 0.0f, 5.0f, 2.5f, -120, 64);
            }
            case 24: {
                return new NcepLatLon(gridNumber, 37, 36, -90.0f, -180.0f, 0.0f, 0.0f, 5.0f, 2.5f, -120, 64);
            }
            case 25: {
                return new NcepLatLon(gridNumber, 72, 18, 0.0f, 0.0f, 90.0f, 355.0f, 5.0f, 5.0f, -120, 64);
            }
            case 26: {
                return new NcepLatLon(gridNumber, 72, 18, -90.0f, 0.0f, 0.0f, 355.0f, 5.0f, 5.0f, -120, 64);
            }
            case 61: {
                return new NcepLatLon(gridNumber, 91, 45, 0.0f, 0.0f, 90.0f, 180.0f, 2.0f, 2.0f, -120, 64);
            }
            case 62: 
            case 63: {
                return new NcepLatLon(gridNumber, 91, 45, -90.0f, 0.0f, 0.0f, 180.0f, 2.0f, 2.0f, -120, 64);
            }
            case 64: {
                return new NcepLatLon(gridNumber, 91, 45, -90.0f, -180.0f, 0.0f, 0.0f, 2.0f, 2.0f, -120, 64);
            }
            case 87: {
                return new NcepPS(gridNumber, 81, 62, 22.8756f, 239.5089f, 255.0f, 68153.0f, 68153.0f, 8, 64);
            }
        }
        throw new IllegalArgumentException("Dont have predefined GDS " + gridNumber + " from NCEP (center 7)");
    }

    private static class NcepPS
    extends Grib1Gds.PolarStereographic {
        final int gridNumber;

        NcepPS(int gridNumber, int nx, int ny, float la1, float lo1, float lov, float dX, float dY, byte resolution, byte scan) {
            super(1000 * gridNumber);
            this.gridNumber = gridNumber;
            this.nx = nx;
            this.ny = ny;
            this.la1 = la1;
            this.lo1 = lo1;
            this.lov = lov;
            this.dX = dX;
            this.dY = dY;
            this.resolution = resolution;
            this.scanMode = scan;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NcepPS that = (NcepPS)o;
            return this.gridNumber == that.gridNumber;
        }

        @Override
        public int hashCode() {
            return this.gridNumber;
        }
    }

    private static class NcepLatLon
    extends Grib1Gds.LatLon {
        final int gridNumber;

        NcepLatLon(int gridNumber, int nx, int ny, float la1, float lo1, float la2, float lo2, float deltaLon, float deltaLat, byte resolution, byte scan) {
            super(1000 * gridNumber);
            this.gridNumber = gridNumber;
            this.nx = nx;
            this.ny = ny;
            this.la1 = la1;
            this.lo1 = lo1;
            this.la2 = la2;
            this.lo2 = lo2;
            this.deltaLon = deltaLon;
            this.deltaLat = deltaLat;
            this.resolution = resolution;
            this.scanMode = scan;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NcepLatLon that = (NcepLatLon)o;
            return this.gridNumber == that.gridNumber;
        }

        @Override
        public int hashCode() {
            return this.gridNumber;
        }
    }
}

