/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import java.util.Formatter;
import ucar.nc2.grib.GribData;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.QuasiRegular;
import ucar.nc2.grib.grib1.Grib1DataReader;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1SectionBinaryData;
import ucar.nc2.grib.grib1.Grib1SectionBitMap;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionIndicator;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Record {
    private final Grib1SectionIndicator is;
    private final Grib1SectionGridDefinition gdss;
    private final Grib1SectionProductDefinition pdss;
    private final Grib1SectionBitMap bitmap;
    private final Grib1SectionBinaryData dataSection;
    private final byte[] header;
    private int file;
    private Grib1ParamTime ptime;
    public static Grib1Record lastRecordRead;

    public Grib1Record(byte[] header, Grib1SectionIndicator is, Grib1SectionGridDefinition gdss, Grib1SectionProductDefinition pdss, Grib1SectionBitMap bitmap, Grib1SectionBinaryData dataSection) {
        this.header = header;
        this.is = is;
        this.gdss = gdss;
        this.pdss = pdss;
        this.bitmap = bitmap;
        this.dataSection = dataSection;
    }

    public Grib1Record(RandomAccessFile raf) throws IOException {
        this.header = null;
        this.is = new Grib1SectionIndicator(raf);
        this.pdss = new Grib1SectionProductDefinition(raf);
        this.gdss = this.pdss.gdsExists() ? new Grib1SectionGridDefinition(raf) : new Grib1SectionGridDefinition(this.pdss);
        this.bitmap = this.pdss.bmsExists() ? new Grib1SectionBitMap(raf) : null;
        this.dataSection = new Grib1SectionBinaryData(raf);
    }

    Grib1Record(Grib1Record from) {
        this.header = from.header;
        this.is = from.is;
        this.gdss = from.gdss;
        this.pdss = from.pdss;
        this.bitmap = from.bitmap;
        this.dataSection = from.dataSection;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public Grib1SectionIndicator getIs() {
        return this.is;
    }

    public Grib1SectionGridDefinition getGDSsection() {
        return this.gdss;
    }

    public Grib1Gds getGDS() {
        return this.gdss.getGDS();
    }

    public Grib1SectionProductDefinition getPDSsection() {
        return this.pdss;
    }

    public Grib1SectionBitMap getBitMapSection() {
        return this.bitmap;
    }

    public Grib1SectionBinaryData getDataSection() {
        return this.dataSection;
    }

    public CalendarDate getReferenceDate() {
        return this.pdss.getReferenceDate();
    }

    public int getFile() {
        return this.file;
    }

    public void setFile(int file) {
        this.file = file;
    }

    public Grib1ParamTime getParamTime(Grib1Customizer cust) {
        if (this.ptime == null) {
            this.ptime = cust.getParamTime(this.pdss);
        }
        return this.ptime;
    }

    public float[] readData(RandomAccessFile raf) throws IOException {
        return this.readData(raf, GribData.getInterpolationMethod());
    }

    public float[] readDataRaw(RandomAccessFile raf) throws IOException {
        return this.readData(raf, GribData.InterpolationMethod.none);
    }

    public float[] readData(RandomAccessFile raf, GribData.InterpolationMethod method) throws IOException {
        Grib1Gds gds = this.getGDS();
        Grib1DataReader reader = new Grib1DataReader(this.pdss.getDecimalScale(), gds.getScanMode(), gds.getNxRaw(), gds.getNyRaw(), gds.getNpts(), this.dataSection.getStartingPosition());
        byte[] bm = this.bitmap == null ? null : this.bitmap.getBitmap(raf);
        float[] data = reader.getData(raf, bm);
        if (this.gdss.isThin()) {
            data = QuasiRegular.convertQuasiGrid(data, gds.getNptsInLine(), gds.getNxRaw(), gds.getNyRaw(), method);
        }
        lastRecordRead = this;
        return data;
    }

    public void showDataInfo(RandomAccessFile raf, Formatter f) throws IOException {
        Grib1Gds gds = this.getGDS();
        f.format(" decimal scale = %d%n", this.pdss.getDecimalScale());
        f.format("     scan mode = %d%n", gds.getScanMode());
        f.format("            nx = %d%n", gds.getNx());
        f.format("            ny = %d%n", gds.getNy());
        f.format("         nxRaw = %d%n", gds.getNxRaw());
        f.format("         nyRaw = %d%n", gds.getNyRaw());
        f.format("          Npts = %d%n", gds.getNpts());
        f.format("        isThin = %s%n", this.gdss.isThin());
        GribData.Info info = this.getBinaryDataInfo(raf);
        f.format("   dataLength = %d%n", info.dataLength);
        f.format("    ----flag = %s%n", Long.toBinaryString(info.flag));
        f.format("        data = %s%n", info.getGridPointS());
        f.format("     packing = %s%n", info.getPackingS());
        f.format("        type = %s%n", info.getDataTypeS());
        f.format(" moreOctet14 = %s%n", info.hasOctet14());
        f.format("    binscale = %d%n", info.binaryScaleFactor);
        f.format("    decscale = %d%n", info.decimalScaleFactor);
        f.format("reference value = %f%n", Float.valueOf(info.referenceValue));
        f.format("      nbits = %d%n", info.numberOfBits);
        Grib1DataReader.showComplexPackingInfo(f, raf, this.dataSection.getStartingPosition());
    }

    public static float[] readData(RandomAccessFile raf, long startPos) throws IOException {
        raf.seek(startPos);
        Grib1Record gr = new Grib1Record(raf);
        return gr.readData(raf);
    }

    public GribData.Info getBinaryDataInfo(RandomAccessFile raf) throws IOException {
        byte[] bm;
        GribData.Info info = this.dataSection.getBinaryDataInfo(raf);
        info.decimalScaleFactor = this.pdss.getDecimalScale();
        info.bitmapLength = this.bitmap == null ? 0 : this.bitmap.getLength(raf);
        info.nPoints = this.getGDS().getNpts();
        info.msgLength = this.is.getMessageLength();
        info.ndataPoints = this.bitmap == null ? info.nPoints : ((bm = this.bitmap.getBitmap(raf)) == null ? info.nPoints : GribNumbers.countBits(bm));
        return info;
    }

    public int[] readRawData(RandomAccessFile raf) throws IOException {
        Grib1Gds gds = this.getGDS();
        Grib1DataReader reader = new Grib1DataReader(this.pdss.getDecimalScale(), gds.getScanMode(), gds.getNxRaw(), gds.getNyRaw(), gds.getNpts(), this.dataSection.getStartingPosition());
        byte[] bm = this.bitmap == null ? null : this.bitmap.getBitmap(raf);
        return reader.getDataRaw(raf, bm);
    }
}

