/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.dmsp;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.unidata.io.RandomAccessFile;

public class DMSPHeader {
    private String[] header;
    private Map<String, String> headerInfo = new HashMap<String, String>();
    private int headerSizeInBytes;
    private int headerSizeInBytesGuess = 5000;
    private RandomAccessFile raFile;
    private NetcdfFile ncFile;
    private long actualSize;
    private String fileIdAttName = "fileId";
    private Attribute fileIdAtt;
    private String datasetIdAttName = "datasetId";
    private Attribute datasetIdAtt;
    private int recordSizeInBytes;
    private int numHeaderRecords;
    private int numDataRecords;
    private String numDataRecordsDimName = "numScans";
    private Dimension numDataRecordsDim;
    private int numArtificialDataRecords;
    private int numRecords;
    private String suborbitHistoryAttName = "suborbitHistory";
    private Attribute suborbitHistoryAtt;
    private String processingSystemAttName = "processingSystem";
    private Attribute processingSystemAtt;
    private Date processingDate;
    private String processingDateAttName = "processingDate";
    private Attribute processingDateAtt;
    private String spacecraftIdAttName = "spacecraftId";
    private Attribute spacecraftIdAtt;
    private String noradIdAttName = "noradId";
    private Attribute noradIdAtt;
    private String startDateAttName = "startDate";
    private Attribute startDateAtt;
    private Date startDate;
    private String endDateAttName = "endDate";
    private Attribute endDateAtt;
    private Date endDate;
    private String startDateLocalAttName = "startDateLocal";
    private Attribute startDateLocalAtt;
    private String startTimeLocalAttName = "startTimeLocal";
    private Attribute startTimeLocalAtt;
    private String startLatitudeAttName = "startLatitude";
    private Attribute startLatitudeAtt;
    private String startLongitudeAttName = "startLongitude";
    private Attribute startLongitudeAtt;
    private String endLatitudeAttName = "endLatitude";
    private Attribute endLatitudeAtt;
    private String endLongitudeAttName = "endLongitude";
    private Attribute endLongitudeAtt;
    private String startSubsolarCoordsAttName = "startSubsolarCoords";
    private Attribute startSubsolarCoordsAtt;
    private String endSubsolarCoordsAttName = "endSubsolarCoords";
    private Attribute endSubsolarCoordsAtt;
    private String startLunarCoordsAttName = "startLunarCoords";
    private Attribute startLunarCoordsAtt;
    private String endLunarCoordsAttName = "endLunarCoords";
    private Attribute endLunarCoordsAtt;
    private String ascendingNodeAttName = "ascendingNode";
    private Attribute ascendingNodeAtt;
    private String nodeHeadingAttName = "nodeHeading";
    private Attribute nodeHeadingAtt;
    private int numSamplesPerBand;
    private String numSamplesPerBandDimName = "numSamplesPerScan";
    private Dimension numSamplesPerBandDim;
    private String nominalResolutionAttName = "nominalResolution";
    private Attribute nominalResolutionAtt;
    private String bandsPerScanlineAttName = "bandsPerScanline";
    private Attribute bandsPerScanlineAtt;
    private String bytesPerSampleAttName = "bytesPerSample";
    private Attribute bytesPerSampleAtt;
    private String byteOffsetBand1AttName = "byteOffsetBand1";
    private Attribute byteOffsetBand1Att;
    private String byteOffsetBand2AttName = "byteOffsetBand2";
    private Attribute byteOffsetBand2Att;
    private String band1AttName = "band1";
    private Attribute band1Att;
    private String band2AttName = "band2";
    private Attribute band2Att;
    private String bandOrganizationAttName = "bandOrganization";
    private Attribute bandOrganizationAtt;
    private String thermalOffsetAttName = "thermalOffset";
    private Attribute thermalOffsetAtt;
    private String thermalScaleAttName = "thermalScale";
    private Attribute thermalScaleAtt;
    private String percentDaylightAttName = "percentDaylight";
    private Attribute percentDaylightAtt;
    private String percentFullMoonAttName = "percentFullMoon";
    private Attribute percentFullMoonAtt;
    private String percentTerminatorEvidentAttName = "percentTerminatorEvident";
    private Attribute percentTerminatorEvidentAtt;
    private String qcFlagsAttName = "qcFlags";
    private Attribute qcFlagsAtt;

    public Attribute getFileIdAtt() {
        return this.fileIdAtt;
    }

    public Attribute getDatasetIdAtt() {
        return this.datasetIdAtt;
    }

    public int getNumHeaderRecords() {
        return this.numHeaderRecords;
    }

    public int getNumDataRecords() {
        return this.numDataRecords;
    }

    public Dimension getNumDataRecordsDim() {
        return this.numDataRecordsDim;
    }

    public Dimension getNumSamplesPerBandDim() {
        return this.numSamplesPerBandDim;
    }

    public int getRecordSizeInBytes() {
        return this.recordSizeInBytes;
    }

    public Attribute getSuborbitHistoryAtt() {
        return this.suborbitHistoryAtt;
    }

    public Attribute getProcessingSystemAtt() {
        return this.processingSystemAtt;
    }

    public Attribute getProcessingDateAtt() {
        return this.processingDateAtt;
    }

    public Attribute getStartDateAtt() {
        return this.startDateAtt;
    }

    boolean isValidFile(RandomAccessFile raFile) {
        this.raFile = raFile;
        try {
            this.actualSize = raFile.length();
        }
        catch (IOException e) {
            return false;
        }
        try {
            this.readHeaderFromFile(raFile);
            this.handleFileInformation();
            this.handleProcessingInformation();
            this.handleSatelliteInformation();
            this.handleSensorInformation();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    void read(RandomAccessFile raFile, NetcdfFile ncFile) throws IOException {
        this.raFile = raFile;
        this.ncFile = ncFile;
        this.actualSize = this.raFile.length();
        this.readHeaderFromFile(raFile);
        this.handleFileInformation();
        this.ncFile.addAttribute(null, this.fileIdAtt);
        this.ncFile.addAttribute(null, this.datasetIdAtt);
        this.ncFile.addDimension(null, this.numDataRecordsDim);
        this.handleProcessingInformation();
        this.ncFile.addAttribute(null, this.suborbitHistoryAtt);
        this.ncFile.addAttribute(null, this.processingSystemAtt);
        this.ncFile.addAttribute(null, this.processingDateAtt);
        this.handleSatelliteInformation();
        this.ncFile.addAttribute(null, this.spacecraftIdAtt);
        this.ncFile.addAttribute(null, this.noradIdAtt);
        this.handleOrbitInformation();
        this.ncFile.addAttribute(null, this.startDateAtt);
        this.ncFile.addAttribute(null, this.endDateAtt);
        this.ncFile.addAttribute(null, this.startDateLocalAtt);
        this.ncFile.addAttribute(null, this.startTimeLocalAtt);
        this.ncFile.addAttribute(null, this.startLatitudeAtt);
        this.ncFile.addAttribute(null, this.startLongitudeAtt);
        this.ncFile.addAttribute(null, this.endLatitudeAtt);
        this.ncFile.addAttribute(null, this.endLongitudeAtt);
        this.ncFile.addAttribute(null, this.startSubsolarCoordsAtt);
        this.ncFile.addAttribute(null, this.endSubsolarCoordsAtt);
        this.ncFile.addAttribute(null, this.startLunarCoordsAtt);
        this.ncFile.addAttribute(null, this.endLunarCoordsAtt);
        this.ncFile.addAttribute(null, this.ascendingNodeAtt);
        this.ncFile.addAttribute(null, this.nodeHeadingAtt);
        this.handleSensorInformation();
        this.ncFile.addDimension(null, this.numSamplesPerBandDim);
        this.ncFile.addAttribute(null, this.nominalResolutionAtt);
        this.ncFile.addAttribute(null, this.bandsPerScanlineAtt);
        this.ncFile.addAttribute(null, this.bytesPerSampleAtt);
        this.ncFile.addAttribute(null, this.byteOffsetBand1Att);
        this.ncFile.addAttribute(null, this.byteOffsetBand2Att);
        this.ncFile.addAttribute(null, this.band1Att);
        this.ncFile.addAttribute(null, this.band2Att);
        this.ncFile.addAttribute(null, this.bandOrganizationAtt);
        this.ncFile.addAttribute(null, this.thermalOffsetAtt);
        this.ncFile.addAttribute(null, this.thermalScaleAtt);
        this.ncFile.addAttribute(null, this.percentDaylightAtt);
        this.ncFile.addAttribute(null, this.percentFullMoonAtt);
        this.ncFile.addAttribute(null, this.percentTerminatorEvidentAtt);
        this.handleQCInformation();
        this.ncFile.addAttribute(null, this.qcFlagsAtt);
        this.ncFile.addAttribute(null, new Attribute("title", "NGDC archived " + this.datasetIdAtt.getStringValue() + " data with start time " + this.startDateAtt.getStringValue()));
        this.ncFile.addAttribute(null, new Attribute("Convention", "_Coordinates"));
        this.ncFile.addAttribute(null, new Attribute("thredds_creator", "DOD/USAF/SMC > Space and Missile Systems Center (SMC), U.S. Air Force, U.S. Department of Defense"));
        this.ncFile.addAttribute(null, new Attribute("thredds_contributor", "DOC/NOAA/NESDIS/NGDC > National Geophysical Data Center, NESDIS, NOAA, U.S. Department of Commerce"));
        this.ncFile.addAttribute(null, new Attribute("thredds_contributor_role", "archive"));
        this.ncFile.addAttribute(null, new Attribute("thredds_publisher", "DOC/NOAA/NESDIS/NGDC > National Geophysical Data Center, NESDIS, NOAA, U.S. Department of Commerce"));
        this.ncFile.addAttribute(null, new Attribute("thredds_publisher_url", "http://dmsp.ngdc.noaa.gov/"));
        this.ncFile.addAttribute(null, new Attribute("thredds_publisher_email", "ngdc.dmsp@noaa.gov"));
        this.ncFile.addAttribute(null, new Attribute("thredds_summary", "This dataset contains data from the DMSP " + this.spacecraftIdAtt.getStringValue() + " satellite OLS instrument and includes both visible smooth and thermal smooth imagery with 2.7km resolution. The start time for this data is " + this.startDateAtt.getStringValue() + " and the northerly equatorial crossing longitude is " + this.startLongitudeAtt.getNumericValue() + ".  The DMSP satellite is a polar-orbiting satellite crossing the equator, depending on the satellite, at either dawn/dusk or noon/midnight. This data is in the NOAA/NGDC DMSP archive format."));
        this.ncFile.addAttribute(null, new Attribute("thredds_history", ""));
        this.ncFile.addAttribute(null, new Attribute("thredds_timeCoverage_start", this.startDateAtt.getStringValue()));
        this.ncFile.addAttribute(null, new Attribute("thredds_timeCoverage_end", this.endDateAtt.getStringValue()));
        this.ncFile.addAttribute(null, new Attribute("thredds_geospatialCoverage", "Polar orbit with northerly equatorial crossing at longitude " + this.ascendingNodeAtt.getNumericValue() + "."));
        this.raFile.seek(this.headerSizeInBytes);
    }

    private void readHeaderFromFile(RandomAccessFile raFile) throws IOException {
        long pos = 0L;
        raFile.seek(pos);
        this.headerSizeInBytes = raFile.length() > (long)this.headerSizeInBytesGuess ? this.headerSizeInBytesGuess : (int)raFile.length();
        byte[] b = new byte[this.headerSizeInBytes];
        if (raFile.read(b) != this.headerSizeInBytes) {
            throw new IOException("Invalid DMSP file: could not read first " + this.headerSizeInBytes + " bytes.");
        }
        String fullHeader = new String(b, StandardCharsets.UTF_8);
        if (!fullHeader.startsWith(HeaderInfoTitle.FILE_ID.toString())) {
            throw new IOException("Invalid DMSP file: header does not start with \"" + HeaderInfoTitle.FILE_ID + "\".");
        }
        int endOfHeaderIndex = fullHeader.indexOf(HeaderInfoTitle.END_HEADER.toString());
        if (endOfHeaderIndex == -1) {
            throw new IOException("Invalid DMSP file: header does not end with \"" + HeaderInfoTitle.END_HEADER + "\".");
        }
        for (String aHeader : this.header = fullHeader.substring(0, endOfHeaderIndex - 1).split("\n")) {
            String curHeaderLine = aHeader.trim();
            int lineSeperatorIndex = curHeaderLine.indexOf(58);
            if (lineSeperatorIndex == -1) {
                throw new IOException("Invalid DMSP file: header line <" + curHeaderLine + "> contains no seperator <:>.");
            }
            if (lineSeperatorIndex == 0) {
                throw new IOException("Invalid DMSP file: header line <" + curHeaderLine + "> contains no title.");
            }
            if (lineSeperatorIndex == curHeaderLine.length() - 1) {
                throw new IOException("Invalid DMSP file: header line <" + curHeaderLine + "> contains no value.");
            }
            String curHeaderTitle = curHeaderLine.substring(0, lineSeperatorIndex).trim();
            String curHeaderValue = curHeaderLine.substring(lineSeperatorIndex + 1).trim();
            if (curHeaderValue.equals("")) {
                throw new IOException("Invalid DMSP file: header line <" + curHeaderLine + "> contains no value.");
            }
            this.headerInfo.put(curHeaderTitle, curHeaderValue);
        }
    }

    private void handleFileInformation() throws IOException {
        this.fileIdAtt = new Attribute(this.fileIdAttName, this.headerInfo.get(HeaderInfoTitle.FILE_ID.toString()));
        this.datasetIdAtt = new Attribute(this.datasetIdAttName, this.headerInfo.get(HeaderInfoTitle.DATA_SET_ID.toString()));
        this.recordSizeInBytes = Integer.parseInt(this.headerInfo.get(HeaderInfoTitle.RECORD_BYTES.toString()));
        this.numRecords = Integer.parseInt(this.headerInfo.get(HeaderInfoTitle.NUM_RECORDS.toString()));
        this.numHeaderRecords = Integer.parseInt(this.headerInfo.get(HeaderInfoTitle.NUM_HEADER_RECORDS.toString()));
        this.numDataRecords = Integer.parseInt(this.headerInfo.get(HeaderInfoTitle.NUM_DATA_RECORDS.toString()));
        this.numDataRecordsDim = new Dimension(this.numDataRecordsDimName, this.numDataRecords, true, true, false);
        this.numArtificialDataRecords = Integer.parseInt(this.headerInfo.get(HeaderInfoTitle.NUM_ARTIFICIAL_DATA_RECORDS.toString()));
        this.headerSizeInBytes = this.numHeaderRecords * this.recordSizeInBytes;
        if ((long)this.numRecords * (long)this.recordSizeInBytes != this.actualSize) {
            throw new IOException("Invalid DMSP file: the number of records <" + this.numRecords + "> times the record size <" + this.recordSizeInBytes + "> does not equal the size of the file <" + this.actualSize + ">.");
        }
    }

    private void handleProcessingInformation() throws IOException {
        this.suborbitHistoryAtt = new Attribute(this.suborbitHistoryAttName, this.headerInfo.get(HeaderInfoTitle.SUBORBIT_HISTORY.toString()));
        this.processingSystemAtt = new Attribute(this.processingSystemAttName, this.headerInfo.get(HeaderInfoTitle.PROCESSING_SYSTEM.toString()));
        String processingDateString = this.headerInfo.get(HeaderInfoTitle.PROCESSING_DATE.toString());
        try {
            this.processingDate = DateFormatHandler.ALT_DATE_TIME.getDateFromDateTimeString(processingDateString);
        }
        catch (ParseException e) {
            throw new IOException("Invalid DMSP file: processing date string <" + processingDateString + "> not parseable: " + e.getMessage());
        }
        this.processingDateAtt = new Attribute(this.processingDateAttName, DateFormatHandler.ISO_DATE_TIME.getDateTimeStringFromDate(this.processingDate));
    }

    private void handleSatelliteInformation() {
        this.spacecraftIdAtt = new Attribute(this.spacecraftIdAttName, this.headerInfo.get(HeaderInfoTitle.SPACECRAFT_ID.toString()));
        this.noradIdAtt = new Attribute(this.noradIdAttName, this.headerInfo.get(HeaderInfoTitle.NORAD_ID.toString()));
    }

    private void handleOrbitInformation() throws IOException {
        Double lon;
        Double lat;
        String time = this.headerInfo.get(HeaderInfoTitle.START_TIME_UTC.toString());
        String startDateTimeUTC = this.headerInfo.get(HeaderInfoTitle.START_DATE_UTC.toString()) + "T" + time.substring(0, time.indexOf(46) + 4) + "Z";
        try {
            this.startDate = DateFormatHandler.ISO_DATE_TIME.getDateFromDateTimeString(startDateTimeUTC);
        }
        catch (ParseException e) {
            throw new IOException("Invalid DMSP file: start date/time string <" + startDateTimeUTC + "> not parseable: " + e.getMessage());
        }
        this.startDateAtt = new Attribute(this.startDateAttName, DateFormatHandler.ISO_DATE_TIME.getDateTimeStringFromDate(this.startDate));
        time = this.headerInfo.get(HeaderInfoTitle.END_TIME_UTC.toString());
        String endDateTimeUTC = this.headerInfo.get(HeaderInfoTitle.END_DATE_UTC.toString()) + "T" + time.substring(0, time.indexOf(46) + 4) + "Z";
        try {
            this.endDate = DateFormatHandler.ISO_DATE_TIME.getDateFromDateTimeString(endDateTimeUTC);
        }
        catch (ParseException e) {
            throw new IOException("Invalid DMSP file: end date/time string <" + endDateTimeUTC + "> not parseable: " + e.getMessage());
        }
        this.endDateAtt = new Attribute(this.endDateAttName, DateFormatHandler.ISO_DATE_TIME.getDateTimeStringFromDate(this.endDate));
        this.startDateLocalAtt = new Attribute(this.startDateLocalAttName, HeaderInfoTitle.START_DATE_LOCAL.toString());
        this.startTimeLocalAtt = new Attribute(this.startTimeLocalAttName, HeaderInfoTitle.START_TIME_LOCAL.toString());
        String startLatLon = this.headerInfo.get(HeaderInfoTitle.START_LAT_LON.toString());
        String[] latLon = startLatLon.split(" ");
        if (latLon.length != 2) {
            throw new IOException("Invalid DMSP file: start lat/lon <" + startLatLon + "> invalid.");
        }
        try {
            lat = Double.valueOf(latLon[0]);
            lon = Double.valueOf(latLon[1]);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid DMSP file: start lat/lon string <" + startLatLon + "> not parseable: " + e.getMessage());
        }
        this.startLatitudeAtt = new Attribute(this.startLatitudeAttName, lat);
        this.startLongitudeAtt = new Attribute(this.startLongitudeAttName, lon);
        String endLatLon = this.headerInfo.get(HeaderInfoTitle.END_LAT_LON.toString());
        latLon = endLatLon.split(" ");
        if (latLon.length != 2) {
            throw new IOException("Invalid DMSP file: end lat/lon <" + endLatLon + "> invalid.");
        }
        try {
            lat = Double.valueOf(latLon[0]);
            lon = Double.valueOf(latLon[1]);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid DMSP file: end lat/lon string <" + endLatLon + "> not parseable: " + e.getMessage());
        }
        this.endLatitudeAtt = new Attribute(this.endLatitudeAttName, lat);
        this.endLongitudeAtt = new Attribute(this.endLongitudeAttName, lon);
        this.startSubsolarCoordsAtt = new Attribute(this.startSubsolarCoordsAttName, this.headerInfo.get(HeaderInfoTitle.START_SUBSOLAR_COORD.toString()));
        this.endSubsolarCoordsAtt = new Attribute(this.endSubsolarCoordsAttName, this.headerInfo.get(HeaderInfoTitle.END_SUBSOLAR_COORD.toString()));
        this.startLunarCoordsAtt = new Attribute(this.startLunarCoordsAttName, this.headerInfo.get(HeaderInfoTitle.START_LUNAR_COORD.toString()));
        this.endLunarCoordsAtt = new Attribute(this.endLunarCoordsAttName, this.headerInfo.get(HeaderInfoTitle.END_LUNAR_COORD.toString()));
        Double ascendingNode = Double.valueOf(this.headerInfo.get(HeaderInfoTitle.ASCENDING_NODE.toString()));
        this.ascendingNodeAtt = new Attribute(this.ascendingNodeAttName, ascendingNode);
        Double nodeHeading = Double.valueOf(this.headerInfo.get(HeaderInfoTitle.NODE_HEADING.toString()));
        this.nodeHeadingAtt = new Attribute(this.nodeHeadingAttName, nodeHeading);
    }

    private void handleSensorInformation() {
        this.numSamplesPerBand = Integer.parseInt(this.headerInfo.get(HeaderInfoTitle.SAMPLES_PER_BAND.toString()));
        this.numSamplesPerBandDim = new Dimension(this.numSamplesPerBandDimName, this.numSamplesPerBand);
        this.nominalResolutionAtt = new Attribute(this.nominalResolutionAttName, this.headerInfo.get(HeaderInfoTitle.NOMINAL_RESOLUTION.toString()));
        this.bandsPerScanlineAtt = new Attribute(this.bandsPerScanlineAttName, Integer.valueOf(this.headerInfo.get(HeaderInfoTitle.BANDS_PER_SCANLINE.toString())));
        this.bytesPerSampleAtt = new Attribute(this.bytesPerSampleAttName, Integer.valueOf(this.headerInfo.get(HeaderInfoTitle.BYTES_PER_SAMPLE.toString())));
        this.byteOffsetBand1Att = new Attribute(this.byteOffsetBand1AttName, Integer.valueOf(this.headerInfo.get(HeaderInfoTitle.BYTE_OFFSET_BAND_1.toString())));
        this.byteOffsetBand2Att = new Attribute(this.byteOffsetBand2AttName, Integer.valueOf(this.headerInfo.get(HeaderInfoTitle.BYTE_OFFSET_BAND_2.toString())));
        this.band1Att = new Attribute(this.band1AttName, this.headerInfo.get(HeaderInfoTitle.BAND_1.toString()));
        this.band2Att = new Attribute(this.band2AttName, this.headerInfo.get(HeaderInfoTitle.BAND_2.toString()));
        this.bandOrganizationAtt = new Attribute(this.bandOrganizationAttName, this.headerInfo.get(HeaderInfoTitle.ORGANIZATION.toString()));
        this.thermalOffsetAtt = new Attribute(this.thermalOffsetAttName, this.headerInfo.get(HeaderInfoTitle.THERMAL_OFFSET.toString()));
        this.thermalScaleAtt = new Attribute(this.thermalScaleAttName, this.headerInfo.get(HeaderInfoTitle.THERMAL_SCALE.toString()));
        this.percentDaylightAtt = new Attribute(this.percentDaylightAttName, Double.valueOf(this.headerInfo.get(HeaderInfoTitle.PERCENT_DAYLIGHT.toString())));
        this.percentFullMoonAtt = new Attribute(this.percentFullMoonAttName, Double.valueOf(this.headerInfo.get(HeaderInfoTitle.PERCENT_FULL_MOON.toString())));
        this.percentTerminatorEvidentAtt = new Attribute(this.percentTerminatorEvidentAttName, Double.valueOf(this.headerInfo.get(HeaderInfoTitle.PERCENT_TERMINATOR_EVIDENT.toString())));
    }

    private void handleQCInformation() {
        this.qcFlagsAtt = new Attribute(this.qcFlagsAttName, this.headerInfo.get(HeaderInfoTitle.QC_FLAGS.toString()));
    }

    protected String headerInfoDump() {
        StringBuilder retVal = new StringBuilder();
        for (String curHeaderTitle : this.headerInfo.keySet()) {
            String curHeaderValue = this.headerInfo.get(curHeaderTitle);
            retVal.append(curHeaderTitle);
            retVal.append(":::::");
            retVal.append(curHeaderValue);
            retVal.append(":::::\n");
        }
        return retVal.toString();
    }

    public String toString() {
        String retVal = HeaderInfoTitle.FILE_ID + ": " + this.fileIdAtt.getStringValue() + "\n" + HeaderInfoTitle.DATA_SET_ID + ": " + this.datasetIdAtt.getStringValue() + "\n" + HeaderInfoTitle.RECORD_BYTES + ": " + this.recordSizeInBytes + "\n" + HeaderInfoTitle.NUM_HEADER_RECORDS + ": " + this.numHeaderRecords + "\n" + HeaderInfoTitle.NUM_RECORDS + ": " + this.numRecords + "\n" + HeaderInfoTitle.SUBORBIT_HISTORY + ": " + this.suborbitHistoryAtt.getStringValue() + "\n" + HeaderInfoTitle.PROCESSING_SYSTEM + ": " + this.processingSystemAtt.getStringValue() + "\n" + HeaderInfoTitle.PROCESSING_DATE + ": " + DateFormatHandler.ALT_DATE_TIME.getDateTimeStringFromDate(this.processingDate) + "\n" + HeaderInfoTitle.SPACECRAFT_ID + ": " + this.spacecraftIdAtt.getStringValue() + "\n" + HeaderInfoTitle.NORAD_ID + ": " + this.noradIdAtt.getStringValue() + "\n";
        return retVal;
    }

    static class HeaderInfoTitle {
        private static Map<String, HeaderInfoTitle> hash = new HashMap<String, HeaderInfoTitle>(20);
        public static final HeaderInfoTitle FILE_ID = new HeaderInfoTitle("file ID");
        public static final HeaderInfoTitle DATA_SET_ID = new HeaderInfoTitle("data set ID");
        public static final HeaderInfoTitle RECORD_BYTES = new HeaderInfoTitle("record bytes");
        public static final HeaderInfoTitle NUM_HEADER_RECORDS = new HeaderInfoTitle("number of header records");
        public static final HeaderInfoTitle NUM_RECORDS = new HeaderInfoTitle("number of records");
        public static final HeaderInfoTitle SUBORBIT_HISTORY = new HeaderInfoTitle("suborbit history");
        public static final HeaderInfoTitle PROCESSING_SYSTEM = new HeaderInfoTitle("processing system");
        public static final HeaderInfoTitle PROCESSING_DATE = new HeaderInfoTitle("processing date");
        public static final HeaderInfoTitle SPACECRAFT_ID = new HeaderInfoTitle("spacecraft ID");
        public static final HeaderInfoTitle NORAD_ID = new HeaderInfoTitle("NORAD ID");
        public static final HeaderInfoTitle START_DATE_UTC = new HeaderInfoTitle("start date UTC");
        public static final HeaderInfoTitle START_TIME_UTC = new HeaderInfoTitle("start time UTC");
        public static final HeaderInfoTitle END_DATE_UTC = new HeaderInfoTitle("end date UTC");
        public static final HeaderInfoTitle END_TIME_UTC = new HeaderInfoTitle("end time UTC");
        public static final HeaderInfoTitle START_DATE_LOCAL = new HeaderInfoTitle("start date local");
        public static final HeaderInfoTitle START_TIME_LOCAL = new HeaderInfoTitle("start time local");
        public static final HeaderInfoTitle START_LAT_LON = new HeaderInfoTitle("start lat,lon");
        public static final HeaderInfoTitle END_LAT_LON = new HeaderInfoTitle("end lat,lon");
        public static final HeaderInfoTitle START_SUBSOLAR_COORD = new HeaderInfoTitle("start sub-solar coord");
        public static final HeaderInfoTitle END_SUBSOLAR_COORD = new HeaderInfoTitle("end sub-solar coord");
        public static final HeaderInfoTitle START_LUNAR_COORD = new HeaderInfoTitle("start lunar coord");
        public static final HeaderInfoTitle END_LUNAR_COORD = new HeaderInfoTitle("end lunar coord");
        public static final HeaderInfoTitle START_DIRECTION = new HeaderInfoTitle("start direction");
        public static final HeaderInfoTitle QA_1_8 = new HeaderInfoTitle("QA 1/8");
        public static final HeaderInfoTitle QA_2_8 = new HeaderInfoTitle("QA 2/8");
        public static final HeaderInfoTitle QA_3_8 = new HeaderInfoTitle("QA 3/8");
        public static final HeaderInfoTitle QA_4_8 = new HeaderInfoTitle("QA 4/8");
        public static final HeaderInfoTitle QA_5_8 = new HeaderInfoTitle("QA 5/8");
        public static final HeaderInfoTitle QA_6_8 = new HeaderInfoTitle("QA 6/8");
        public static final HeaderInfoTitle QA_7_8 = new HeaderInfoTitle("QA 7/8");
        public static final HeaderInfoTitle QA_8_8 = new HeaderInfoTitle("QA 8/8");
        public static final HeaderInfoTitle DELTA_T = new HeaderInfoTitle("delta-t");
        public static final HeaderInfoTitle ASCENDING_NODE = new HeaderInfoTitle("ascending node");
        public static final HeaderInfoTitle NODE_HEADING = new HeaderInfoTitle("node heading");
        public static final HeaderInfoTitle EPHEMERIS_SOURCE = new HeaderInfoTitle("ephemeris source");
        public static final HeaderInfoTitle NUM_DATA_RECORDS = new HeaderInfoTitle("number of data records");
        public static final HeaderInfoTitle NUM_ARTIFICIAL_DATA_RECORDS = new HeaderInfoTitle("number of artificial data records");
        public static final HeaderInfoTitle NOMINAL_RESOLUTION = new HeaderInfoTitle("nominal resolution");
        public static final HeaderInfoTitle BANDS_PER_SCANLINE = new HeaderInfoTitle("bands per scanline");
        public static final HeaderInfoTitle SAMPLES_PER_BAND = new HeaderInfoTitle("samples per band");
        public static final HeaderInfoTitle BYTES_PER_SAMPLE = new HeaderInfoTitle("bytes per sample");
        public static final HeaderInfoTitle BYTE_OFFSET_BAND_1 = new HeaderInfoTitle("byte offset band 1");
        public static final HeaderInfoTitle BYTE_OFFSET_BAND_2 = new HeaderInfoTitle("byte offset band 2");
        public static final HeaderInfoTitle BAND_1 = new HeaderInfoTitle("band 1");
        public static final HeaderInfoTitle BAND_2 = new HeaderInfoTitle("band 2");
        public static final HeaderInfoTitle ORGANIZATION = new HeaderInfoTitle("organization");
        public static final HeaderInfoTitle THERMAL_OFFSET = new HeaderInfoTitle("thermal offset");
        public static final HeaderInfoTitle THERMAL_SCALE = new HeaderInfoTitle("thermal scale");
        public static final HeaderInfoTitle QC_FLAGS = new HeaderInfoTitle("QC flags");
        public static final HeaderInfoTitle PERCENT_DAYLIGHT = new HeaderInfoTitle("% daylight");
        public static final HeaderInfoTitle PERCENT_FULL_MOON = new HeaderInfoTitle("% full moon");
        public static final HeaderInfoTitle PERCENT_TERMINATOR_EVIDENT = new HeaderInfoTitle("% terminator evident");
        public static final HeaderInfoTitle END_HEADER = new HeaderInfoTitle("end header");
        private String HeaderInfoTitle;

        private HeaderInfoTitle(String title) {
            this.HeaderInfoTitle = title;
            hash.put(title, this);
        }

        public static HeaderInfoTitle getTitle(String title) {
            if (title == null) {
                return null;
            }
            return hash.get(title);
        }

        public String toString() {
            return this.HeaderInfoTitle;
        }
    }

    static class DateFormatHandler {
        public static final DateFormatHandler ISO_DATE = new DateFormatHandler("yyyy-MM-dd");
        public static final DateFormatHandler ISO_TIME = new DateFormatHandler("HH:mm:ss.SSSz");
        public static final DateFormatHandler ISO_DATE_TIME = new DateFormatHandler("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        public static final DateFormatHandler ALT_DATE_TIME = new DateFormatHandler("EEE MMM dd HH:mm:ss yyyy");
        private String dateTimeFormatString;

        private DateFormatHandler(String dateTimeFormatString) {
            this.dateTimeFormatString = dateTimeFormatString;
        }

        public String getDateTimeFormatString() {
            return this.dateTimeFormatString;
        }

        public Date getDateFromDateTimeString(String dateTimeString) throws ParseException {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateTimeFormatString, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            Date theDate = dateFormat.parse(dateTimeString);
            return theDate;
        }

        public String getDateTimeStringFromDate(Date date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateTimeFormatString, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            String dateString = dateFormat.format(date);
            return dateString;
        }
    }
}

